/*
 * Decompiled with CFR 0.152.
 */
package zombie.input;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjglx.LWJGLException;
import org.lwjglx.input.Cursor;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.input.MouseState;
import zombie.input.MouseStateCache;

public final class Mouse {
    protected static int x;
    protected static int y;
    public static boolean bLeftDown;
    public static boolean bLeftWasDown;
    public static boolean bRightDown;
    public static boolean bRightWasDown;
    public static boolean bMiddleDown;
    public static boolean bMiddleWasDown;
    public static boolean[] m_buttonDownStates;
    public static long lastActivity;
    public static int wheelDelta;
    private static final MouseStateCache s_mouseStateCache;
    public static boolean[] UICaptured;
    static Cursor blankCursor;
    static Cursor defaultCursor;
    private static boolean isCursorVisible;
    private static Texture mouseCursorTexture;

    public static int getWheelState() {
        return wheelDelta;
    }

    public static synchronized int getXA() {
        return x;
    }

    public static synchronized int getYA() {
        return y;
    }

    public static synchronized int getX() {
        return (int)((float)x * Core.getInstance().getZoom(0));
    }

    public static synchronized int getY() {
        return (int)((float)y * Core.getInstance().getZoom(0));
    }

    public static boolean isButtonDown(int n) {
        if (m_buttonDownStates != null) {
            return m_buttonDownStates[n];
        }
        return false;
    }

    public static void UIBlockButtonDown(int n) {
        Mouse.UICaptured[n] = true;
    }

    public static boolean isButtonDownUICheck(int n) {
        if (m_buttonDownStates != null) {
            boolean bl = m_buttonDownStates[n];
            if (!bl) {
                Mouse.UICaptured[n] = false;
            } else if (UICaptured[n]) {
                return false;
            }
            return bl;
        }
        return false;
    }

    public static boolean isLeftDown() {
        return bLeftDown;
    }

    public static boolean isLeftPressed() {
        return !bLeftWasDown && bLeftDown;
    }

    public static boolean isLeftReleased() {
        return bLeftWasDown && !bLeftDown;
    }

    public static boolean isLeftUp() {
        return !bLeftDown;
    }

    public static boolean isMiddleDown() {
        return bMiddleDown;
    }

    public static boolean isMiddlePressed() {
        return !bMiddleWasDown && bMiddleDown;
    }

    public static boolean isMiddleReleased() {
        return bMiddleWasDown && !bMiddleDown;
    }

    public static boolean isMiddleUp() {
        return !bMiddleDown;
    }

    public static boolean isRightDown() {
        return bRightDown;
    }

    public static boolean isRightPressed() {
        return !bRightWasDown && bRightDown;
    }

    public static boolean isRightReleased() {
        return bRightWasDown && !bRightDown;
    }

    public static boolean isRightUp() {
        return !bRightDown;
    }

    public static synchronized void update() {
        MouseState mouseState = s_mouseStateCache.getState();
        if (!mouseState.isCreated()) {
            s_mouseStateCache.swap();
            try {
                org.lwjglx.input.Mouse.create();
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
            return;
        }
        bLeftWasDown = bLeftDown;
        bRightWasDown = bRightDown;
        bMiddleWasDown = bMiddleDown;
        int n = x;
        int n2 = y;
        x = mouseState.getX();
        y = Core.getInstance().getScreenHeight() - mouseState.getY() - 1;
        bLeftDown = mouseState.isButtonDown(0);
        bRightDown = mouseState.isButtonDown(1);
        bMiddleDown = mouseState.isButtonDown(2);
        wheelDelta = mouseState.getDWheel();
        mouseState.resetDWheel();
        if (m_buttonDownStates == null) {
            m_buttonDownStates = new boolean[mouseState.getButtonCount()];
        }
        for (int i = 0; i < m_buttonDownStates.length; ++i) {
            Mouse.m_buttonDownStates[i] = mouseState.isButtonDown(i);
        }
        if (n != x || n2 != y || wheelDelta != 0 || bLeftWasDown != bLeftDown || bRightWasDown != bRightDown || bMiddleWasDown != bMiddleDown) {
            lastActivity = System.currentTimeMillis();
        }
        s_mouseStateCache.swap();
    }

    public static void poll() {
        s_mouseStateCache.poll();
    }

    public static synchronized void setXY(int n, int n2) {
        s_mouseStateCache.getState().setCursorPosition(n, Core.getInstance().getOffscreenHeight(0) - 1 - n2);
    }

    public static Cursor loadCursor(String string) throws LWJGLException {
        File file = ZomboidFileSystem.instance.getMediaFile("ui/" + string);
        BufferedImage bufferedImage = null;
        try {
            int n;
            int n2;
            bufferedImage = ImageIO.read(file);
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            int[] nArray = new int[n3 * n4];
            for (int i = 0; i < nArray.length; ++i) {
                n2 = i % n3;
                n = n4 - 1 - i / n3;
                nArray[i] = bufferedImage.getRGB(n2, n);
            }
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)(n3 * n4));
            intBuffer.put(nArray);
            intBuffer.rewind();
            n2 = 1;
            n = 1;
            Cursor cursor = new Cursor(n3, n4, n2, n, 1, intBuffer, null);
            return cursor;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void initCustomCursor() {
        if (blankCursor == null) {
            try {
                blankCursor = Mouse.loadCursor("cursor_blank.png");
                defaultCursor = Mouse.loadCursor("cursor_white.png");
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
        }
        if (defaultCursor == null) {
            return;
        }
        try {
            org.lwjglx.input.Mouse.setNativeCursor(defaultCursor);
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
        }
    }

    public static void setCursorVisible(boolean bl) {
        isCursorVisible = bl;
    }

    public static boolean isCursorVisible() {
        return isCursorVisible;
    }

    public static void renderCursorTexture() {
        if (!Mouse.isCursorVisible()) {
            return;
        }
        if (mouseCursorTexture == null) {
            mouseCursorTexture = Texture.getSharedTexture("media/ui/cursor_white.png");
        }
        if (mouseCursorTexture == null || !mouseCursorTexture.isReady()) {
            return;
        }
        int n = Mouse.getXA();
        int n2 = Mouse.getYA();
        int n3 = 1;
        int n4 = 1;
        SpriteRenderer.instance.render(mouseCursorTexture, n - n3, n2 - n4, mouseCursorTexture.getWidth(), mouseCursorTexture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, null);
    }

    static {
        s_mouseStateCache = new MouseStateCache();
        UICaptured = new boolean[10];
        isCursorVisible = true;
        mouseCursorTexture = null;
    }
}

