/*
 * Decompiled with CFR 0.152.
 */
package zombie.input;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.lwjglx.input.Controller;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.iso.Vector2;

public final class JoypadManager {
    public static final JoypadManager instance = new JoypadManager();
    public final Joypad[] Joypads = new Joypad[4];
    public final Joypad[] JoypadsController = new Joypad[16];
    public final ArrayList<Joypad> JoypadList = new ArrayList();
    public final HashSet<String> ActiveControllerGUIDs = new HashSet();
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_LATEST = 2;

    public Joypad addJoypad(int n, String string, String string2) {
        Joypad joypad = new Joypad();
        joypad.ID = n;
        joypad.guid = string;
        joypad.name = string2;
        this.JoypadsController[n] = joypad;
        this.doControllerFile(joypad);
        if (!joypad.isDisabled() && this.ActiveControllerGUIDs.contains(string)) {
            this.JoypadList.add(joypad);
        }
        return joypad;
    }

    private Joypad checkJoypad(int n) {
        if (this.JoypadsController[n] == null) {
            Controller controller = GameWindow.GameInput.getController(n);
            this.addJoypad(n, controller.getGUID(), controller.getGamepadName());
        }
        return this.JoypadsController[n];
    }

    private void doControllerFile(Joypad joypad) {
        File file = new File(ZomboidFileSystem.instance.getCacheDirSub("joypads"));
        if (!file.exists()) {
            file.mkdir();
        }
        file = new File(ZomboidFileSystem.instance.getCacheDirSub("joypads" + File.separator + joypad.guid + ".config"));
        try (FileReader fileReader = new FileReader(file.getAbsolutePath());
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            System.out.println("reloading " + file.getAbsolutePath());
            int n = -1;
            try {
                String string = "";
                while (string != null) {
                    String[] stringArray;
                    string = bufferedReader.readLine();
                    if (string == null || string.trim().length() == 0 || string.trim().startsWith("//") || (stringArray = string.split("=")).length != 2) continue;
                    stringArray[0] = stringArray[0].trim();
                    stringArray[1] = stringArray[1].trim();
                    if (stringArray[0].equals("Version")) {
                        n = Integer.parseInt(stringArray[1]);
                        if (n < 1 || n > 2) {
                            DebugLog.General.warn("Unknown version %d in %s", n, file.getAbsolutePath());
                            break;
                        }
                        if (n == 1) {
                            DebugLog.General.warn("Obsolete version %d in %s.  Using default values.", n, file.getAbsolutePath());
                            break;
                        }
                    }
                    if (n == -1) {
                        DebugLog.General.warn("Ignoring %s=%s because Version is missing", stringArray[0], stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("MovementAxisX")) {
                        joypad.MovementAxisX = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("MovementAxisXFlipped")) {
                        joypad.MovementAxisXFlipped = stringArray[1].equals("true");
                        continue;
                    }
                    if (stringArray[0].equals("MovementAxisY")) {
                        joypad.MovementAxisY = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("MovementAxisYFlipped")) {
                        joypad.MovementAxisYFlipped = stringArray[1].equals("true");
                        continue;
                    }
                    if (stringArray[0].equals("MovementAxisDeadZone")) {
                        joypad.MovementAxisDeadZone = Float.parseFloat(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("AimingAxisX")) {
                        joypad.AimingAxisX = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("AimingAxisXFlipped")) {
                        joypad.AimingAxisXFlipped = stringArray[1].equals("true");
                        continue;
                    }
                    if (stringArray[0].equals("AimingAxisY")) {
                        joypad.AimingAxisY = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("AimingAxisYFlipped")) {
                        joypad.AimingAxisYFlipped = stringArray[1].equals("true");
                        continue;
                    }
                    if (stringArray[0].equals("AimingAxisDeadZone")) {
                        joypad.AimingAxisDeadZone = Float.parseFloat(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("AButton")) {
                        joypad.AButton = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("BButton")) {
                        joypad.BButton = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("XButton")) {
                        joypad.XButton = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("YButton")) {
                        joypad.YButton = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("LBumper")) {
                        joypad.BumperLeft = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("RBumper")) {
                        joypad.BumperRight = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("L3")) {
                        joypad.LeftStickButton = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("R3")) {
                        joypad.RightStickButton = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("Back")) {
                        joypad.Back = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("Start")) {
                        joypad.Start = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("DPadUp")) {
                        joypad.DPadUp = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("DPadDown")) {
                        joypad.DPadDown = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("DPadLeft")) {
                        joypad.DPadLeft = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("DPadRight")) {
                        joypad.DPadRight = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("TriggersFlipped")) {
                        joypad.TriggersFlipped = stringArray[1].equals("true");
                        continue;
                    }
                    if (stringArray[0].equals("TriggerLeft")) {
                        joypad.TriggerLeft = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("TriggerRight")) {
                        joypad.TriggerRight = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (stringArray[0].equals("Disabled")) {
                        joypad.Disabled = stringArray[1].equals("true");
                        continue;
                    }
                    if (!stringArray[0].equals("Sensitivity")) continue;
                    joypad.setDeadZone(Float.parseFloat(stringArray[1]));
                }
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!this.ActiveControllerGUIDs.contains(joypad.guid)) {
                this.ActiveControllerGUIDs.add(joypad.guid);
                try {
                    Core.getInstance().saveOptions();
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
        }
        catch (IOException iOException) {
            ExceptionLogger.logException(iOException);
        }
        this.saveFile(joypad);
    }

    private void saveFile(Joypad joypad) {
        File file = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "joypads");
        if (!file.exists()) {
            file.mkdir();
        }
        file = new File(ZomboidFileSystem.instance.getCacheDirSub("joypads" + File.separator + joypad.guid + ".config"));
        try (FileWriter fileWriter = new FileWriter(file.getAbsolutePath());
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            String string = System.getProperty("line.separator");
            bufferedWriter.write("Version=2" + string);
            bufferedWriter.write("Name=" + joypad.name + string);
            bufferedWriter.write("MovementAxisX=" + joypad.MovementAxisX + string);
            bufferedWriter.write("MovementAxisXFlipped=" + joypad.MovementAxisXFlipped + string);
            bufferedWriter.write("MovementAxisY=" + joypad.MovementAxisY + string);
            bufferedWriter.write("MovementAxisYFlipped=" + joypad.MovementAxisYFlipped + string);
            bufferedWriter.write("// Set the dead zone to the smallest number between 0.0 and 1.0." + string);
            bufferedWriter.write("// This is to fix \"loose sticks\"." + string);
            bufferedWriter.write("MovementAxisDeadZone=" + joypad.MovementAxisDeadZone + string);
            bufferedWriter.write("AimingAxisX=" + joypad.AimingAxisX + string);
            bufferedWriter.write("AimingAxisXFlipped=" + joypad.AimingAxisXFlipped + string);
            bufferedWriter.write("AimingAxisY=" + joypad.AimingAxisY + string);
            bufferedWriter.write("AimingAxisYFlipped=" + joypad.AimingAxisYFlipped + string);
            bufferedWriter.write("AimingAxisDeadZone=" + joypad.AimingAxisDeadZone + string);
            bufferedWriter.write("AButton=" + joypad.AButton + string);
            bufferedWriter.write("BButton=" + joypad.BButton + string);
            bufferedWriter.write("XButton=" + joypad.XButton + string);
            bufferedWriter.write("YButton=" + joypad.YButton + string);
            bufferedWriter.write("LBumper=" + joypad.BumperLeft + string);
            bufferedWriter.write("RBumper=" + joypad.BumperRight + string);
            bufferedWriter.write("L3=" + joypad.LeftStickButton + string);
            bufferedWriter.write("R3=" + joypad.RightStickButton + string);
            bufferedWriter.write("Back=" + joypad.Back + string);
            bufferedWriter.write("Start=" + joypad.Start + string);
            bufferedWriter.write("// Normally the D-pad is treated as a single axis (the POV Hat), and these should be -1." + string);
            bufferedWriter.write("// If your D-pad is actually 4 separate buttons, set the button numbers here." + string);
            bufferedWriter.write("DPadUp=" + joypad.DPadUp + string);
            bufferedWriter.write("DPadDown=" + joypad.DPadDown + string);
            bufferedWriter.write("DPadLeft=" + joypad.DPadLeft + string);
            bufferedWriter.write("DPadRight=" + joypad.DPadRight + string);
            bufferedWriter.write("TriggersFlipped=" + joypad.TriggersFlipped + string);
            bufferedWriter.write("// If your triggers are buttons, set the button numbers here." + string);
            bufferedWriter.write("// If these are set to something other than -1, then Triggers= is ignored." + string);
            bufferedWriter.write("TriggerLeft=" + joypad.TriggerLeft + string);
            bufferedWriter.write("TriggerRight=" + joypad.TriggerRight + string);
            bufferedWriter.write("Disabled=" + joypad.Disabled + string);
            bufferedWriter.write("Sensitivity=" + joypad.getDeadZone(0) + string);
        }
        catch (IOException iOException) {
            ExceptionLogger.logException(iOException);
        }
    }

    public void reloadControllerFiles() {
        for (int i = 0; i < GameWindow.GameInput.getControllerCount(); ++i) {
            Controller controller = GameWindow.GameInput.getController(i);
            if (controller == null) continue;
            if (this.JoypadsController[i] == null) {
                this.addJoypad(i, controller.getGUID(), controller.getGamepadName());
                continue;
            }
            this.doControllerFile(this.JoypadsController[i]);
        }
    }

    public void assignJoypad(int n, int n2) {
        this.checkJoypad(n);
        this.Joypads[n2] = this.JoypadsController[n];
        this.Joypads[n2].player = n2;
    }

    public Joypad getFromPlayer(int n) {
        return this.Joypads[n];
    }

    public Joypad getFromControllerID(int n) {
        return this.JoypadsController[n];
    }

    public void onPressed(int n, int n2) {
        this.checkJoypad(n);
        this.JoypadsController[n].onPressed(n2);
    }

    public boolean isDownPressed(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].isDownPressed();
    }

    public boolean isUpPressed(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].isUpPressed();
    }

    public boolean isRightPressed(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].isRightPressed();
    }

    public boolean isLeftPressed(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].isLeftPressed();
    }

    public boolean isLBPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isLBPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isLBPressed();
    }

    public boolean isRBPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isRBPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isRBPressed();
    }

    public boolean isL3Pressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isL3Pressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isL3Pressed();
    }

    public boolean isR3Pressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isR3Pressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isR3Pressed();
    }

    public boolean isRTPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isRTPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isRTPressed();
    }

    public boolean isLTPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isLTPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isLTPressed();
    }

    public boolean isAPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isAPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isAPressed();
    }

    public boolean isBPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isBPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isBPressed();
    }

    public boolean isXPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isXPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isXPressed();
    }

    public boolean isYPressed(int n) {
        if (n < 0) {
            for (int i = 0; i < this.JoypadList.size(); ++i) {
                if (!this.JoypadList.get(i).isYPressed()) continue;
                return true;
            }
            return false;
        }
        this.checkJoypad(n);
        return this.JoypadsController[n].isYPressed();
    }

    public boolean isButtonStartPress(int n, int n2) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonStartPress(n2);
    }

    public boolean isButtonReleasePress(int n, int n2) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonReleasePress(n2);
    }

    public boolean isAButtonStartPress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return this.isButtonStartPress(n, joypad.getAButton());
    }

    public boolean isBButtonStartPress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonStartPress(joypad.getBButton());
    }

    public boolean isXButtonStartPress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonStartPress(joypad.getXButton());
    }

    public boolean isYButtonStartPress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonStartPress(joypad.getYButton());
    }

    public boolean isAButtonReleasePress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonReleasePress(joypad.getAButton());
    }

    public boolean isBButtonReleasePress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonReleasePress(joypad.getBButton());
    }

    public boolean isXButtonReleasePress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonReleasePress(joypad.getXButton());
    }

    public boolean isYButtonReleasePress(int n) {
        Joypad joypad = this.checkJoypad(n);
        return joypad.isButtonReleasePress(joypad.getYButton());
    }

    public float getMovementAxisX(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].getMovementAxisX();
    }

    public float getMovementAxisY(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].getMovementAxisY();
    }

    public float getAimingAxisX(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].getAimingAxisX();
    }

    public float getAimingAxisY(int n) {
        this.checkJoypad(n);
        return this.JoypadsController[n].getAimingAxisY();
    }

    public void onPressedAxis(int n, int n2) {
        this.checkJoypad(n);
        this.JoypadsController[n].onPressedAxis(n2);
    }

    public void onPressedAxisNeg(int n, int n2) {
        this.checkJoypad(n);
        this.JoypadsController[n].onPressedAxisNeg(n2);
    }

    public void onPressedTrigger(int n, int n2) {
        this.checkJoypad(n);
        this.JoypadsController[n].onPressedTrigger(n2);
    }

    public void onPressedPov(int n) {
        this.checkJoypad(n);
        this.JoypadsController[n].onPressedPov();
    }

    public float getDeadZone(int n, int n2) {
        this.checkJoypad(n);
        return this.JoypadsController[n].getDeadZone(n2);
    }

    public void setDeadZone(int n, int n2, float f) {
        this.checkJoypad(n);
        this.JoypadsController[n].setDeadZone(n2, f);
    }

    public void saveControllerSettings(int n) {
        this.checkJoypad(n);
        this.saveFile(this.JoypadsController[n]);
    }

    public long getLastActivity(int n) {
        if (this.JoypadsController[n] == null) {
            return 0L;
        }
        return this.JoypadsController[n].lastActivity;
    }

    public void setControllerActive(String string, boolean bl) {
        if (bl) {
            this.ActiveControllerGUIDs.add(string);
        } else {
            this.ActiveControllerGUIDs.remove(string);
        }
        this.syncActiveControllers();
    }

    public void syncActiveControllers() {
        this.JoypadList.clear();
        for (int i = 0; i < this.JoypadsController.length; ++i) {
            Joypad joypad = this.JoypadsController[i];
            if (joypad == null || joypad.isDisabled() || !this.ActiveControllerGUIDs.contains(joypad.guid)) continue;
            this.JoypadList.add(joypad);
        }
    }

    public boolean isJoypadConnected(int n) {
        if (n < 0 || n >= 16) {
            return false;
        }
        assert (Thread.currentThread() == GameWindow.GameThread);
        return GameWindow.GameInput.getController(n) != null;
    }

    public void onControllerConnected(Controller controller) {
        Joypad joypad = this.JoypadsController[controller.getID()];
        if (joypad == null) {
            return;
        }
        LuaEventManager.triggerEvent("OnJoypadBeforeReactivate", BoxedStaticValues.toDouble(joypad.getID()));
        joypad.bConnected = true;
        LuaEventManager.triggerEvent("OnJoypadReactivate", BoxedStaticValues.toDouble(joypad.getID()));
    }

    public void onControllerDisconnected(Controller controller) {
        Joypad joypad = this.JoypadsController[controller.getID()];
        if (joypad == null) {
            return;
        }
        LuaEventManager.triggerEvent("OnJoypadBeforeDeactivate", BoxedStaticValues.toDouble(joypad.getID()));
        joypad.bConnected = false;
        LuaEventManager.triggerEvent("OnJoypadDeactivate", BoxedStaticValues.toDouble(joypad.getID()));
    }

    public void revertToKeyboardAndMouse() {
        for (int i = 0; i < this.JoypadList.size(); ++i) {
            IsoPlayer isoPlayer;
            Joypad joypad = this.JoypadList.get(i);
            if (joypad.player != 0) continue;
            if (GameWindow.ActivatedJoyPad == joypad) {
                GameWindow.ActivatedJoyPad = null;
            }
            if ((isoPlayer = IsoPlayer.players[0]) != null) {
                isoPlayer.JoypadBind = -1;
            }
            this.JoypadsController[joypad.getID()] = null;
            this.Joypads[0] = null;
            this.JoypadList.remove(i);
            break;
        }
    }

    public void renderUI() {
        assert (Thread.currentThread() == GameWindow.GameThread);
        if (!DebugOptions.instance.JoypadRenderUI.getValue()) {
            return;
        }
        if (GameWindow.DrawReloadingLua) {
            return;
        }
        LuaEventManager.triggerEvent("OnJoypadRenderUI");
    }

    public void Reset() {
        for (int i = 0; i < this.Joypads.length; ++i) {
            this.Joypads[i] = null;
        }
    }

    public static final class Joypad {
        String guid;
        String name;
        int ID;
        int player = -1;
        int MovementAxisX = 0;
        boolean MovementAxisXFlipped = false;
        int MovementAxisY = 1;
        boolean MovementAxisYFlipped = false;
        float MovementAxisDeadZone = 0.0f;
        int AimingAxisX = 2;
        boolean AimingAxisXFlipped = false;
        int AimingAxisY = 3;
        boolean AimingAxisYFlipped = false;
        float AimingAxisDeadZone = 0.0f;
        int AButton = 0;
        int BButton = 1;
        int XButton = 2;
        int YButton = 3;
        int DPadUp = -1;
        int DPadDown = -1;
        int DPadLeft = -1;
        int DPadRight = -1;
        int BumperLeft = 4;
        int BumperRight = 5;
        int Back = 6;
        int Start = 7;
        int LeftStickButton = 9;
        int RightStickButton = 10;
        boolean TriggersFlipped = false;
        int TriggerLeft = 4;
        int TriggerRight = 5;
        boolean Disabled = false;
        boolean bConnected = true;
        long lastActivity;
        private static final Vector2 tempVec2 = new Vector2();

        public boolean isDownPressed() {
            if (this.DPadDown != -1) {
                return GameWindow.GameInput.isButtonPressedD(this.DPadDown, this.ID);
            }
            return GameWindow.GameInput.isControllerDownD(this.ID);
        }

        public boolean isUpPressed() {
            if (this.DPadUp != -1) {
                return GameWindow.GameInput.isButtonPressedD(this.DPadUp, this.ID);
            }
            return GameWindow.GameInput.isControllerUpD(this.ID);
        }

        public boolean isRightPressed() {
            if (this.DPadRight != -1) {
                return GameWindow.GameInput.isButtonPressedD(this.DPadRight, this.ID);
            }
            return GameWindow.GameInput.isControllerRightD(this.ID);
        }

        public boolean isLeftPressed() {
            if (this.DPadLeft != -1) {
                return GameWindow.GameInput.isButtonPressedD(this.DPadLeft, this.ID);
            }
            return GameWindow.GameInput.isControllerLeftD(this.ID);
        }

        public boolean isLBPressed() {
            return GameWindow.GameInput.isButtonPressedD(this.BumperLeft, this.ID);
        }

        public boolean isRBPressed() {
            return GameWindow.GameInput.isButtonPressedD(this.BumperRight, this.ID);
        }

        public boolean isL3Pressed() {
            return GameWindow.GameInput.isButtonPressedD(this.LeftStickButton, this.ID);
        }

        public boolean isR3Pressed() {
            return GameWindow.GameInput.isButtonPressedD(this.RightStickButton, this.ID);
        }

        public boolean isRTPressed() {
            int n = this.TriggerRight;
            if (GameWindow.GameInput.getAxisCount(this.ID) <= n) {
                return this.isRBPressed();
            }
            if (this.TriggersFlipped) {
                return GameWindow.GameInput.getAxisValue(this.ID, n) < -0.7f;
            }
            return GameWindow.GameInput.getAxisValue(this.ID, n) > 0.7f;
        }

        public boolean isLTPressed() {
            int n = this.TriggerLeft;
            if (GameWindow.GameInput.getAxisCount(this.ID) <= n) {
                return this.isLBPressed();
            }
            if (this.TriggersFlipped) {
                return GameWindow.GameInput.getAxisValue(this.ID, n) < -0.7f;
            }
            return GameWindow.GameInput.getAxisValue(this.ID, n) > 0.7f;
        }

        public boolean isAPressed() {
            return GameWindow.GameInput.isButtonPressedD(this.AButton, this.ID);
        }

        public boolean isBPressed() {
            return GameWindow.GameInput.isButtonPressedD(this.BButton, this.ID);
        }

        public boolean isXPressed() {
            return GameWindow.GameInput.isButtonPressedD(this.XButton, this.ID);
        }

        public boolean isYPressed() {
            return GameWindow.GameInput.isButtonPressedD(this.YButton, this.ID);
        }

        public boolean isButtonPressed(int n) {
            return GameWindow.GameInput.isButtonPressedD(n, this.ID);
        }

        public boolean wasButtonPressed(int n) {
            return GameWindow.GameInput.wasButtonPressed(this.ID, n);
        }

        public boolean isButtonStartPress(int n) {
            return GameWindow.GameInput.isButtonStartPress(this.ID, n);
        }

        public boolean isButtonReleasePress(int n) {
            return GameWindow.GameInput.isButtonReleasePress(this.ID, n);
        }

        public float getMovementAxisX() {
            if (GameWindow.GameInput.getAxisCount(this.ID) <= this.MovementAxisX) {
                return 0.0f;
            }
            this.MovementAxisDeadZone = GameWindow.GameInput.getController(this.ID).getDeadZone(this.MovementAxisX);
            float f = this.MovementAxisDeadZone;
            if (f > 0.0f && f < 1.0f) {
                float f2;
                float f3 = GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisX);
                Vector2 vector22 = tempVec2.set(f3, f2 = GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisY));
                if (vector22.getLength() < f) {
                    vector22.set(0.0f, 0.0f);
                } else {
                    vector22.setLength((vector22.getLength() - f) / (1.0f - f));
                }
                return this.MovementAxisXFlipped ? -vector22.getX() : vector22.getX();
            }
            if (this.MovementAxisXFlipped) {
                return -GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisX);
            }
            return GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisX);
        }

        public float getMovementAxisY() {
            if (GameWindow.GameInput.getAxisCount(this.ID) <= this.MovementAxisY) {
                return 0.0f;
            }
            this.MovementAxisDeadZone = GameWindow.GameInput.getController(this.ID).getDeadZone(this.MovementAxisY);
            float f = this.MovementAxisDeadZone;
            if (f > 0.0f && f < 1.0f) {
                float f2;
                float f3 = GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisX);
                Vector2 vector22 = tempVec2.set(f3, f2 = GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisY));
                if (vector22.getLength() < f) {
                    vector22.set(0.0f, 0.0f);
                } else {
                    vector22.setLength((vector22.getLength() - f) / (1.0f - f));
                }
                return this.MovementAxisYFlipped ? -vector22.getY() : vector22.getY();
            }
            if (this.MovementAxisYFlipped) {
                return -GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisY);
            }
            return GameWindow.GameInput.getAxisValue(this.ID, this.MovementAxisY);
        }

        public float getAimingAxisX() {
            if (GameWindow.GameInput.getAxisCount(this.ID) <= this.AimingAxisX) {
                return 0.0f;
            }
            this.AimingAxisDeadZone = GameWindow.GameInput.getController(this.ID).getDeadZone(this.AimingAxisX);
            float f = this.AimingAxisDeadZone;
            if (f > 0.0f && f < 1.0f) {
                float f2;
                float f3 = GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisX);
                Vector2 vector22 = tempVec2.set(f3, f2 = GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisY));
                if (vector22.getLength() < f) {
                    vector22.set(0.0f, 0.0f);
                } else {
                    vector22.setLength((vector22.getLength() - f) / (1.0f - f));
                }
                return this.AimingAxisXFlipped ? -vector22.getX() : vector22.getX();
            }
            if (this.AimingAxisXFlipped) {
                return -GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisX);
            }
            return GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisX);
        }

        public float getAimingAxisY() {
            if (GameWindow.GameInput.getAxisCount(this.ID) <= this.AimingAxisY) {
                return 0.0f;
            }
            this.AimingAxisDeadZone = GameWindow.GameInput.getController(this.ID).getDeadZone(this.AimingAxisY);
            float f = this.AimingAxisDeadZone;
            if (f > 0.0f && f < 1.0f) {
                float f2;
                float f3 = GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisX);
                Vector2 vector22 = tempVec2.set(f3, f2 = GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisY));
                if (vector22.getLength() < f) {
                    vector22.set(0.0f, 0.0f);
                } else {
                    vector22.setLength((vector22.getLength() - f) / (1.0f - f));
                }
                return this.AimingAxisYFlipped ? -vector22.getY() : vector22.getY();
            }
            if (this.AimingAxisYFlipped) {
                return -GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisY);
            }
            return GameWindow.GameInput.getAxisValue(this.ID, this.AimingAxisY);
        }

        public void onPressed(int n) {
            this.lastActivity = System.currentTimeMillis();
        }

        public void onPressedAxis(int n) {
            this.lastActivity = System.currentTimeMillis();
        }

        public void onPressedAxisNeg(int n) {
            this.lastActivity = System.currentTimeMillis();
        }

        public void onPressedTrigger(int n) {
            this.lastActivity = System.currentTimeMillis();
        }

        public void onPressedPov() {
            this.lastActivity = System.currentTimeMillis();
        }

        public float getDeadZone(int n) {
            if (n < 0 || n >= GameWindow.GameInput.getAxisCount(this.ID)) {
                return 0.0f;
            }
            float f = GameWindow.GameInput.getController(this.ID).getDeadZone(n);
            float f2 = 0.0f;
            if ((n == this.MovementAxisX || n == this.MovementAxisY) && this.MovementAxisDeadZone > 0.0f && this.MovementAxisDeadZone < 1.0f) {
                f2 = this.MovementAxisDeadZone;
            }
            if ((n == this.AimingAxisX || n == this.AimingAxisY) && this.AimingAxisDeadZone > 0.0f && this.AimingAxisDeadZone < 1.0f) {
                f2 = this.AimingAxisDeadZone;
            }
            return Math.max(f, f2);
        }

        public void setDeadZone(int n, float f) {
            if (n < 0 || n >= GameWindow.GameInput.getAxisCount(this.ID)) {
                return;
            }
            GameWindow.GameInput.getController(this.ID).setDeadZone(n, f);
        }

        public void setDeadZone(float f) {
            for (int i = 0; i < GameWindow.GameInput.getAxisCount(this.ID); ++i) {
                GameWindow.GameInput.getController(this.ID).setDeadZone(i, f);
            }
        }

        public int getID() {
            return this.ID;
        }

        public boolean isDisabled() {
            return this.Disabled;
        }

        public int getAButton() {
            return this.AButton;
        }

        public int getBButton() {
            return this.BButton;
        }

        public int getXButton() {
            return this.XButton;
        }

        public int getYButton() {
            return this.YButton;
        }

        public int getLBumper() {
            return this.BumperLeft;
        }

        public int getRBumper() {
            return this.BumperRight;
        }

        public int getL3() {
            return this.LeftStickButton;
        }

        public int getR3() {
            return this.RightStickButton;
        }

        public int getBackButton() {
            return this.Back;
        }

        public int getStartButton() {
            return this.Start;
        }
    }
}

