/*
 * Decompiled with CFR 0.152.
 */
package zombie.input;

import org.lwjglx.input.KeyEventQueue;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.core.Core;
import zombie.core.opengl.RenderThread;
import zombie.input.KeyboardStateCache;
import zombie.ui.UIManager;

public final class GameKeyboard {
    private static boolean[] bDown;
    private static boolean[] bLastDown;
    private static boolean[] bEatKey;
    public static boolean bNoEventsWhileLoading;
    public static boolean doLuaKeyPressed;
    private static final KeyboardStateCache s_keyboardStateCache;

    public static void update() {
        if (!s_keyboardStateCache.getState().isCreated()) {
            s_keyboardStateCache.swap();
            return;
        }
        int n = s_keyboardStateCache.getState().getKeyCount();
        if (bDown == null) {
            bDown = new boolean[n];
            bLastDown = new boolean[n];
            bEatKey = new boolean[n];
        }
        boolean bl = Core.CurrentTextEntryBox != null && Core.CurrentTextEntryBox.DoingTextEntry;
        for (int i = 1; i < n; ++i) {
            GameKeyboard.bLastDown[i] = bDown[i];
            GameKeyboard.bDown[i] = s_keyboardStateCache.getState().isKeyDown(i);
            if (!bDown[i] && bLastDown[i]) {
                if (bEatKey[i]) {
                    GameKeyboard.bEatKey[i] = false;
                    continue;
                }
                if (bNoEventsWhileLoading || bl || LuaManager.thread == UIManager.defaultthread && UIManager.onKeyRelease(i)) continue;
                if (Core.bDebug && !doLuaKeyPressed) {
                    System.out.println("KEY RELEASED " + i + " doLuaKeyPressed=false");
                }
                if (LuaManager.thread == UIManager.defaultthread && doLuaKeyPressed) {
                    LuaEventManager.triggerEvent("OnKeyPressed", i);
                }
                if (LuaManager.thread == UIManager.defaultthread) {
                    LuaEventManager.triggerEvent("OnCustomUIKey", i);
                    LuaEventManager.triggerEvent("OnCustomUIKeyReleased", i);
                }
            }
            if (bDown[i] && bLastDown[i]) {
                if (bNoEventsWhileLoading || bl || LuaManager.thread == UIManager.defaultthread && UIManager.onKeyRepeat(i)) continue;
                if (LuaManager.thread == UIManager.defaultthread && doLuaKeyPressed) {
                    LuaEventManager.triggerEvent("OnKeyKeepPressed", i);
                }
            }
            if (!bDown[i] || bLastDown[i] || bNoEventsWhileLoading || bl || bEatKey[i] || LuaManager.thread == UIManager.defaultthread && UIManager.onKeyPress(i) || bEatKey[i]) continue;
            if (LuaManager.thread == UIManager.defaultthread && doLuaKeyPressed) {
                LuaEventManager.triggerEvent("OnKeyStartPressed", i);
            }
            if (LuaManager.thread != UIManager.defaultthread) continue;
            LuaEventManager.triggerEvent("OnCustomUIKeyPressed", i);
        }
        s_keyboardStateCache.swap();
    }

    public static void poll() {
        s_keyboardStateCache.poll();
    }

    public static boolean isKeyPressed(int n) {
        return GameKeyboard.isKeyDown(n) && !GameKeyboard.wasKeyDown(n);
    }

    public static boolean isKeyDown(int n) {
        if (Core.CurrentTextEntryBox != null && Core.CurrentTextEntryBox.DoingTextEntry) {
            return false;
        }
        if (bDown == null) {
            return false;
        }
        return bDown[n];
    }

    public static boolean wasKeyDown(int n) {
        if (Core.CurrentTextEntryBox != null && Core.CurrentTextEntryBox.DoingTextEntry) {
            return false;
        }
        if (bLastDown == null) {
            return false;
        }
        return bLastDown[n];
    }

    public static void eatKeyPress(int n) {
        if (n < 0 || n >= bEatKey.length) {
            return;
        }
        GameKeyboard.bEatKey[n] = true;
    }

    public static void setDoLuaKeyPressed(boolean bl) {
        doLuaKeyPressed = bl;
    }

    public static KeyEventQueue getEventQueue() {
        assert (Thread.currentThread() == GameWindow.GameThread);
        return s_keyboardStateCache.getState().getEventQueue();
    }

    public static KeyEventQueue getEventQueuePolling() {
        assert (Thread.currentThread() == RenderThread.RenderThread);
        return s_keyboardStateCache.getStatePolling().getEventQueue();
    }

    static {
        bNoEventsWhileLoading = false;
        doLuaKeyPressed = true;
        s_keyboardStateCache = new KeyboardStateCache();
    }
}

