/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.globalObjects.CGlobalObjects;
import zombie.globalObjects.GlobalObject;
import zombie.globalObjects.GlobalObjectLookup;
import zombie.globalObjects.SGlobalObjectSystem;
import zombie.iso.IsoObject;
import zombie.iso.SliceY;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.TableNetworkUtils;

public final class SGlobalObjects {
    protected static final ArrayList<SGlobalObjectSystem> systems = new ArrayList();

    public static void noise(String string) {
        if (Core.bDebug) {
            DebugLog.log("SGlobalObjects: " + string);
        }
    }

    public static SGlobalObjectSystem registerSystem(String string) {
        SGlobalObjectSystem sGlobalObjectSystem = SGlobalObjects.getSystemByName(string);
        if (sGlobalObjectSystem == null) {
            sGlobalObjectSystem = SGlobalObjects.newSystem(string);
            sGlobalObjectSystem.load();
        }
        return sGlobalObjectSystem;
    }

    public static SGlobalObjectSystem newSystem(String string) throws IllegalStateException {
        if (SGlobalObjects.getSystemByName(string) != null) {
            throw new IllegalStateException("system with that name already exists");
        }
        SGlobalObjects.noise("newSystem " + string);
        SGlobalObjectSystem sGlobalObjectSystem = new SGlobalObjectSystem(string);
        systems.add(sGlobalObjectSystem);
        return sGlobalObjectSystem;
    }

    public static int getSystemCount() {
        return systems.size();
    }

    public static SGlobalObjectSystem getSystemByIndex(int n) {
        if (n < 0 || n >= systems.size()) {
            return null;
        }
        return systems.get(n);
    }

    public static SGlobalObjectSystem getSystemByName(String string) {
        for (int i = 0; i < systems.size(); ++i) {
            SGlobalObjectSystem sGlobalObjectSystem = systems.get(i);
            if (!sGlobalObjectSystem.name.equals(string)) continue;
            return sGlobalObjectSystem;
        }
        return null;
    }

    public static void update() {
        for (int i = 0; i < systems.size(); ++i) {
            SGlobalObjectSystem sGlobalObjectSystem = systems.get(i);
            sGlobalObjectSystem.update();
        }
    }

    public static void chunkLoaded(int n, int n2) {
        for (int i = 0; i < systems.size(); ++i) {
            SGlobalObjectSystem sGlobalObjectSystem = systems.get(i);
            sGlobalObjectSystem.chunkLoaded(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSystems() {
        if (GameClient.bClient) {
            return;
        }
        LuaEventManager.triggerEvent("OnSGlobalObjectSystemInit");
        if (GameServer.bServer) {
            return;
        }
        try {
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                SGlobalObjects.saveInitialStateForClient(SliceY.SliceBuffer);
                SliceY.SliceBuffer.flip();
                CGlobalObjects.loadInitialState(SliceY.SliceBuffer);
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }

    public static void saveInitialStateForClient(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put((byte)systems.size());
        for (int i = 0; i < systems.size(); ++i) {
            SGlobalObjectSystem sGlobalObjectSystem = systems.get(i);
            GameWindow.WriteStringUTF(byteBuffer, sGlobalObjectSystem.name);
            KahluaTable kahluaTable = sGlobalObjectSystem.getInitialStateForClient();
            if (kahluaTable == null) {
                kahluaTable = LuaManager.platform.newTable();
            }
            KahluaTable kahluaTable2 = LuaManager.platform.newTable();
            kahluaTable.rawset("_objects", (Object)kahluaTable2);
            for (int j = 0; j < sGlobalObjectSystem.getObjectCount(); ++j) {
                GlobalObject globalObject = sGlobalObjectSystem.getObjectByIndex(j);
                KahluaTable kahluaTable3 = LuaManager.platform.newTable();
                kahluaTable3.rawset("x", (Object)BoxedStaticValues.toDouble(globalObject.getX()));
                kahluaTable3.rawset("y", (Object)BoxedStaticValues.toDouble(globalObject.getY()));
                kahluaTable3.rawset("z", (Object)BoxedStaticValues.toDouble(globalObject.getZ()));
                for (String string : sGlobalObjectSystem.objectSyncKeys) {
                    kahluaTable3.rawset(string, globalObject.getModData().rawget(string));
                }
                kahluaTable2.rawset(j + 1, (Object)kahluaTable3);
            }
            if (kahluaTable == null || kahluaTable.isEmpty()) {
                byteBuffer.put((byte)0);
                continue;
            }
            byteBuffer.put((byte)1);
            TableNetworkUtils.save(kahluaTable, byteBuffer);
        }
    }

    public static boolean receiveClientCommand(String string, String string2, IsoPlayer isoPlayer, KahluaTable kahluaTable) {
        SGlobalObjects.noise("receiveClientCommand " + string + " " + string2 + " OnlineID=" + isoPlayer.getOnlineID());
        SGlobalObjectSystem sGlobalObjectSystem = SGlobalObjects.getSystemByName(string);
        if (sGlobalObjectSystem == null) {
            throw new IllegalStateException("system '" + string + "' not found");
        }
        sGlobalObjectSystem.receiveClientCommand(string2, isoPlayer, kahluaTable);
        return true;
    }

    public static void load() {
    }

    public static void save() {
        for (int i = 0; i < systems.size(); ++i) {
            SGlobalObjectSystem sGlobalObjectSystem = systems.get(i);
            sGlobalObjectSystem.save();
        }
    }

    public static void OnIsoObjectChangedItself(String string, IsoObject isoObject) {
        if (GameClient.bClient) {
            return;
        }
        SGlobalObjectSystem sGlobalObjectSystem = SGlobalObjects.getSystemByName(string);
        if (sGlobalObjectSystem == null) {
            return;
        }
        sGlobalObjectSystem.OnIsoObjectChangedItself(isoObject);
    }

    public static void Reset() {
        for (int i = 0; i < systems.size(); ++i) {
            SGlobalObjectSystem sGlobalObjectSystem = systems.get(i);
            sGlobalObjectSystem.Reset();
        }
        systems.clear();
        GlobalObjectLookup.Reset();
    }
}

