/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.globalObjects.GlobalObject;
import zombie.globalObjects.GlobalObjectSystem;
import zombie.globalObjects.SGlobalObject;
import zombie.globalObjects.SGlobalObjectNetwork;
import zombie.iso.IsoObject;
import zombie.iso.SliceY;
import zombie.network.GameClient;
import zombie.util.Type;

public final class SGlobalObjectSystem
extends GlobalObjectSystem {
    private static KahluaTable tempTable;
    protected int loadedWorldVersion = -1;
    protected final HashSet<String> modDataKeys = new HashSet();
    protected final HashSet<String> objectModDataKeys = new HashSet();
    protected final HashSet<String> objectSyncKeys = new HashSet();

    public SGlobalObjectSystem(String string) {
        super(string);
    }

    @Override
    protected GlobalObject makeObject(int n, int n2, int n3) {
        return new SGlobalObject(this, n, n2, n3);
    }

    public void setModDataKeys(KahluaTable kahluaTable) {
        this.modDataKeys.clear();
        if (kahluaTable == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            Object object = kahluaTableIterator.getValue();
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("expected string but got \"" + object + "\"");
            }
            this.modDataKeys.add((String)object);
        }
    }

    public void setObjectModDataKeys(KahluaTable kahluaTable) {
        this.objectModDataKeys.clear();
        if (kahluaTable == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            Object object = kahluaTableIterator.getValue();
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("expected string but got \"" + object + "\"");
            }
            this.objectModDataKeys.add((String)object);
        }
    }

    public void setObjectSyncKeys(KahluaTable kahluaTable) {
        this.objectSyncKeys.clear();
        if (kahluaTable == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            Object object = kahluaTableIterator.getValue();
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("expected string but got \"" + object + "\"");
            }
            this.objectSyncKeys.add((String)object);
        }
    }

    public void update() {
    }

    public void chunkLoaded(int n, int n2) {
        if (!this.hasObjectsInChunk(n, n2)) {
            return;
        }
        Object object = this.modData.rawget("OnChunkLoaded");
        if (object == null) {
            throw new IllegalStateException("OnChunkLoaded method undefined for system '" + this.name + "'");
        }
        Double d = BoxedStaticValues.toDouble(n);
        Double d2 = BoxedStaticValues.toDouble(n2);
        LuaManager.caller.pcall(LuaManager.thread, object, this.modData, d, d2);
    }

    public void sendCommand(String string, KahluaTable kahluaTable) {
        SGlobalObjectNetwork.sendServerCommand(this.name, string, kahluaTable);
    }

    public void receiveClientCommand(String string, IsoPlayer isoPlayer, KahluaTable kahluaTable) {
        Object object = this.modData.rawget("OnClientCommand");
        if (object == null) {
            throw new IllegalStateException("OnClientCommand method undefined for system '" + this.name + "'");
        }
        LuaManager.caller.pcall(LuaManager.thread, object, this.modData, string, isoPlayer, kahluaTable);
    }

    public void addGlobalObjectOnClient(SGlobalObject sGlobalObject) throws IOException {
        if (sGlobalObject == null) {
            throw new IllegalArgumentException("globalObject is null");
        }
        if (sGlobalObject.system != this) {
            throw new IllegalArgumentException("object not in this system");
        }
        SGlobalObjectNetwork.addGlobalObjectOnClient(sGlobalObject);
    }

    public void removeGlobalObjectOnClient(SGlobalObject sGlobalObject) throws IOException {
        if (sGlobalObject == null) {
            throw new IllegalArgumentException("globalObject is null");
        }
        if (sGlobalObject.system != this) {
            throw new IllegalArgumentException("object not in this system");
        }
        SGlobalObjectNetwork.removeGlobalObjectOnClient(sGlobalObject);
    }

    public void updateGlobalObjectOnClient(SGlobalObject sGlobalObject) throws IOException {
        if (sGlobalObject == null) {
            throw new IllegalArgumentException("globalObject is null");
        }
        if (sGlobalObject.system != this) {
            throw new IllegalArgumentException("object not in this system");
        }
        SGlobalObjectNetwork.updateGlobalObjectOnClient(sGlobalObject);
    }

    private String getFileName() {
        return ZomboidFileSystem.instance.getFileNameInCurrentSave("gos_" + this.name + ".bin");
    }

    public KahluaTable getInitialStateForClient() {
        Object object = this.modData.rawget("getInitialStateForClient");
        if (object == null) {
            throw new IllegalStateException("getInitialStateForClient method undefined for system '" + this.name + "'");
        }
        Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, object, (Object)this.modData);
        if (objectArray != null && objectArray[0].equals(Boolean.TRUE) && objectArray[1] instanceof KahluaTable) {
            return (KahluaTable)objectArray[1];
        }
        return null;
    }

    public void OnIsoObjectChangedItself(IsoObject isoObject) {
        GlobalObject globalObject = this.getObjectAt(isoObject.getSquare().x, isoObject.getSquare().y, isoObject.getSquare().z);
        if (globalObject == null) {
            return;
        }
        Object object = this.modData.rawget("OnIsoObjectChangedItself");
        if (object == null) {
            throw new IllegalStateException("OnIsoObjectChangedItself method undefined for system '" + this.name + "'");
        }
        LuaManager.caller.pcall(LuaManager.thread, object, this.modData, isoObject);
    }

    public int loadedWorldVersion() {
        return this.loadedWorldVersion;
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        boolean bl;
        boolean bl2 = bl = byteBuffer.get() == 0;
        if (!bl) {
            this.modData.load(byteBuffer, n);
        }
        int n2 = byteBuffer.getInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            byte by = byteBuffer.get();
            SGlobalObject sGlobalObject = Type.tryCastTo(this.newObject(n3, n4, by), SGlobalObject.class);
            sGlobalObject.load(byteBuffer, n);
        }
        this.loadedWorldVersion = n;
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        if (tempTable == null) {
            tempTable = LuaManager.platform.newTable();
        }
        tempTable.wipe();
        KahluaTableIterator kahluaTableIterator = this.modData.iterator();
        while (kahluaTableIterator.advance()) {
            Object object = kahluaTableIterator.getKey();
            if (!this.modDataKeys.contains(object)) continue;
            tempTable.rawset(object, this.modData.rawget(object));
        }
        if (tempTable.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            tempTable.save(byteBuffer);
        }
        byteBuffer.putInt(this.objects.size());
        for (int i = 0; i < this.objects.size(); ++i) {
            SGlobalObject sGlobalObject = Type.tryCastTo((GlobalObject)this.objects.get(i), SGlobalObject.class);
            sGlobalObject.save(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file = new File(this.getFileName());
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                int n;
                ByteBuffer byteBuffer = SliceY.SliceBuffer;
                byteBuffer.clear();
                int n2 = bufferedInputStream.read(byteBuffer.array());
                byteBuffer.limit(n2);
                byte by = byteBuffer.get();
                byte by2 = byteBuffer.get();
                byte by3 = byteBuffer.get();
                byte by4 = byteBuffer.get();
                if (by == 71 && by2 == 76 && by3 == 79 && by4 == 83) {
                    n = byteBuffer.getInt();
                    if (n < 134) {
                        throw new IOException("invalid WorldVersion " + n + ": " + file.getAbsolutePath());
                    }
                    if (n > 195) {
                        throw new IOException("file is from a newer version " + n + " of the game: " + file.getAbsolutePath());
                    }
                } else {
                    throw new IOException("doesn't appear to be a GlobalObjectSystem file:" + file.getAbsolutePath());
                }
                this.load(byteBuffer, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        if (GameClient.bClient) {
            return;
        }
        File file = new File(this.getFileName());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                ByteBuffer byteBuffer = SliceY.SliceBuffer;
                byteBuffer.clear();
                byteBuffer.put((byte)71);
                byteBuffer.put((byte)76);
                byteBuffer.put((byte)79);
                byteBuffer.put((byte)83);
                byteBuffer.putInt(195);
                this.save(byteBuffer);
                bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }

    @Override
    public void Reset() {
        super.Reset();
        this.modDataKeys.clear();
        this.objectModDataKeys.clear();
        this.objectSyncKeys.clear();
    }
}

