/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.globalObjects.GlobalObject;
import zombie.globalObjects.SGlobalObject;
import zombie.globalObjects.SGlobalObjectSystem;
import zombie.globalObjects.SGlobalObjects;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.TableNetworkUtils;
import zombie.spnetwork.SinglePlayerServer;

public final class SGlobalObjectNetwork {
    public static final byte PACKET_ServerCommand = 1;
    public static final byte PACKET_ClientCommand = 2;
    public static final byte PACKET_NewLuaObjectAt = 3;
    public static final byte PACKET_RemoveLuaObjectAt = 4;
    public static final byte PACKET_UpdateLuaObjectAt = 5;
    private static final ByteBuffer BYTE_BUFFER = ByteBuffer.allocate(0x100000);
    private static final ByteBufferWriter BYTE_BUFFER_WRITER = new ByteBufferWriter(BYTE_BUFFER);

    public static void receive(ByteBuffer byteBuffer, IsoPlayer isoPlayer) {
        byte by = byteBuffer.get();
        switch (by) {
            case 2: {
                SGlobalObjectNetwork.receiveClientCommand(byteBuffer, isoPlayer);
            }
        }
    }

    private static void sendPacket(ByteBuffer byteBuffer) {
        if (GameServer.bServer) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                byteBuffer.flip();
                byteBufferWriter.bb.put(byteBuffer);
                udpConnection.endPacketImmediate();
            }
        } else {
            if (GameClient.bClient) {
                throw new IllegalStateException("can't call this method on the client");
            }
            for (int i = 0; i < SinglePlayerServer.udpEngine.connections.size(); ++i) {
                zombie.spnetwork.UdpConnection udpConnection = SinglePlayerServer.udpEngine.connections.get(i);
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                byteBuffer.flip();
                byteBufferWriter.bb.put(byteBuffer);
                udpConnection.endPacketImmediate();
            }
        }
    }

    private static void writeServerCommand(String string, String string2, KahluaTable kahluaTable, ByteBufferWriter byteBufferWriter) {
        PacketTypes.PacketType.GlobalObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putUTF(string);
        byteBufferWriter.putUTF(string2);
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
                while (kahluaTableIterator.advance()) {
                    if (TableNetworkUtils.canSave(kahluaTableIterator.getKey(), kahluaTableIterator.getValue())) continue;
                    DebugLog.log("ERROR: sendServerCommand: can't save key,value=" + kahluaTableIterator.getKey() + "," + kahluaTableIterator.getValue());
                }
                TableNetworkUtils.save(kahluaTable, byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
            }
        }
    }

    public static void sendServerCommand(String string, String string2, KahluaTable kahluaTable) {
        BYTE_BUFFER.clear();
        SGlobalObjectNetwork.writeServerCommand(string, string2, kahluaTable, BYTE_BUFFER_WRITER);
        SGlobalObjectNetwork.sendPacket(BYTE_BUFFER);
    }

    public static void addGlobalObjectOnClient(SGlobalObject sGlobalObject) throws IOException {
        BYTE_BUFFER.clear();
        ByteBufferWriter byteBufferWriter = BYTE_BUFFER_WRITER;
        PacketTypes.PacketType.GlobalObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)3);
        byteBufferWriter.putUTF(sGlobalObject.system.name);
        byteBufferWriter.putInt(sGlobalObject.getX());
        byteBufferWriter.putInt(sGlobalObject.getY());
        byteBufferWriter.putByte((byte)sGlobalObject.getZ());
        SGlobalObjectSystem sGlobalObjectSystem = (SGlobalObjectSystem)sGlobalObject.system;
        TableNetworkUtils.saveSome(sGlobalObject.getModData(), byteBufferWriter.bb, sGlobalObjectSystem.objectSyncKeys);
        SGlobalObjectNetwork.sendPacket(BYTE_BUFFER);
    }

    public static void removeGlobalObjectOnClient(GlobalObject globalObject) {
        BYTE_BUFFER.clear();
        ByteBufferWriter byteBufferWriter = BYTE_BUFFER_WRITER;
        PacketTypes.PacketType.GlobalObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)4);
        byteBufferWriter.putUTF(globalObject.system.name);
        byteBufferWriter.putInt(globalObject.getX());
        byteBufferWriter.putInt(globalObject.getY());
        byteBufferWriter.putByte((byte)globalObject.getZ());
        SGlobalObjectNetwork.sendPacket(BYTE_BUFFER);
    }

    public static void updateGlobalObjectOnClient(SGlobalObject sGlobalObject) throws IOException {
        BYTE_BUFFER.clear();
        ByteBufferWriter byteBufferWriter = BYTE_BUFFER_WRITER;
        PacketTypes.PacketType.GlobalObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)5);
        byteBufferWriter.putUTF(sGlobalObject.system.name);
        byteBufferWriter.putInt(sGlobalObject.getX());
        byteBufferWriter.putInt(sGlobalObject.getY());
        byteBufferWriter.putByte((byte)sGlobalObject.getZ());
        SGlobalObjectSystem sGlobalObjectSystem = (SGlobalObjectSystem)sGlobalObject.system;
        TableNetworkUtils.saveSome(sGlobalObject.getModData(), byteBufferWriter.bb, sGlobalObjectSystem.objectSyncKeys);
        SGlobalObjectNetwork.sendPacket(BYTE_BUFFER);
    }

    private static void receiveClientCommand(ByteBuffer byteBuffer, IsoPlayer isoPlayer) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        boolean bl = byteBuffer.get() == 1;
        KahluaTable kahluaTable = null;
        if (bl) {
            kahluaTable = LuaManager.platform.newTable();
            try {
                TableNetworkUtils.load(kahluaTable, byteBuffer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        SGlobalObjects.receiveClientCommand(string, string2, isoPlayer, kahluaTable);
    }
}

