/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import java.util.ArrayList;
import java.util.Arrays;
import zombie.debug.DebugLog;
import zombie.globalObjects.GlobalObject;
import zombie.globalObjects.GlobalObjectSystem;
import zombie.globalObjects.SGlobalObjectSystem;
import zombie.iso.IsoMetaGrid;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class GlobalObjectLookup {
    private static final int SQUARES_PER_CHUNK = 10;
    private static final int SQUARES_PER_CELL = 300;
    private static final int CHUNKS_PER_CELL = 30;
    private static IsoMetaGrid metaGrid;
    private static final Shared sharedServer;
    private static final Shared sharedClient;
    private final GlobalObjectSystem system;
    private final Shared shared;
    private final Cell[] cells;

    public GlobalObjectLookup(GlobalObjectSystem globalObjectSystem) {
        this.system = globalObjectSystem;
        this.shared = globalObjectSystem instanceof SGlobalObjectSystem ? sharedServer : sharedClient;
        this.cells = this.shared.cells;
    }

    private Cell getCellAt(int n, int n2, boolean bl) {
        int n3 = n - GlobalObjectLookup.metaGrid.minX * 300;
        int n4 = n2 - GlobalObjectLookup.metaGrid.minY * 300;
        if (n3 < 0 || n4 < 0 || n3 >= metaGrid.getWidth() * 300 || n4 >= metaGrid.getHeight() * 300) {
            DebugLog.log("ERROR: GlobalObjectLookup.getCellForObject object location invalid " + n + "," + n2);
            return null;
        }
        int n5 = n3 / 300;
        int n6 = n4 / 300;
        int n7 = n5 + n6 * metaGrid.getWidth();
        if (this.cells[n7] == null && bl) {
            this.cells[n7] = new Cell(GlobalObjectLookup.metaGrid.minX + n5, GlobalObjectLookup.metaGrid.minY + n6);
        }
        return this.cells[n7];
    }

    private Cell getCellForObject(GlobalObject globalObject, boolean bl) {
        return this.getCellAt(globalObject.x, globalObject.y, bl);
    }

    private Chunk getChunkForChunkPos(int n, int n2, boolean bl) {
        Cell cell = this.getCellAt(n * 10, n2 * 10, bl);
        if (cell == null) {
            return null;
        }
        return cell.getChunkAt(n * 10, n2 * 10, bl);
    }

    public void addObject(GlobalObject globalObject) {
        Cell cell = this.getCellForObject(globalObject, true);
        if (cell == null) {
            DebugLog.log("ERROR: GlobalObjectLookup.addObject object location invalid " + globalObject.x + "," + globalObject.y);
            return;
        }
        cell.addObject(globalObject);
    }

    public void removeObject(GlobalObject globalObject) {
        Cell cell = this.getCellForObject(globalObject, false);
        if (cell == null) {
            DebugLog.log("ERROR: GlobalObjectLookup.removeObject object location invalid " + globalObject.x + "," + globalObject.y);
            return;
        }
        cell.removeObject(globalObject);
    }

    public GlobalObject getObjectAt(int n, int n2, int n3) {
        Cell cell = this.getCellAt(n, n2, false);
        if (cell == null) {
            return null;
        }
        Chunk chunk = cell.getChunkAt(n, n2, false);
        if (chunk == null) {
            return null;
        }
        for (int i = 0; i < chunk.objects.size(); ++i) {
            GlobalObject globalObject = chunk.objects.get(i);
            if (globalObject.system != this.system || globalObject.x != n || globalObject.y != n2 || globalObject.z != n3) continue;
            return globalObject;
        }
        return null;
    }

    public boolean hasObjectsInChunk(int n, int n2) {
        Chunk chunk = this.getChunkForChunkPos(n, n2, false);
        if (chunk == null) {
            return false;
        }
        for (int i = 0; i < chunk.objects.size(); ++i) {
            GlobalObject globalObject = chunk.objects.get(i);
            if (globalObject.system != this.system) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GlobalObject> getObjectsInChunk(int n, int n2, ArrayList<GlobalObject> arrayList) {
        Chunk chunk = this.getChunkForChunkPos(n, n2, false);
        if (chunk == null) {
            return arrayList;
        }
        for (int i = 0; i < chunk.objects.size(); ++i) {
            GlobalObject globalObject = chunk.objects.get(i);
            if (globalObject.system != this.system) continue;
            arrayList.add(globalObject);
        }
        return arrayList;
    }

    public ArrayList<GlobalObject> getObjectsAdjacentTo(int n, int n2, int n3, ArrayList<GlobalObject> arrayList) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                GlobalObject globalObject = this.getObjectAt(n + j, n2 + i, n3);
                if (globalObject == null || globalObject.system != this.system) continue;
                arrayList.add(globalObject);
            }
        }
        return arrayList;
    }

    public static void init(IsoMetaGrid isoMetaGrid) {
        metaGrid = isoMetaGrid;
        if (GameServer.bServer) {
            sharedServer.init(isoMetaGrid);
        } else if (GameClient.bClient) {
            sharedClient.init(isoMetaGrid);
        } else {
            sharedServer.init(isoMetaGrid);
            sharedClient.init(isoMetaGrid);
        }
    }

    public static void Reset() {
        sharedServer.reset();
        sharedClient.reset();
    }

    static {
        sharedServer = new Shared();
        sharedClient = new Shared();
    }

    private static final class Shared {
        Cell[] cells;

        private Shared() {
        }

        void init(IsoMetaGrid isoMetaGrid) {
            this.cells = new Cell[isoMetaGrid.getWidth() * isoMetaGrid.getHeight()];
        }

        void reset() {
            if (this.cells == null) {
                return;
            }
            for (int i = 0; i < this.cells.length; ++i) {
                Cell cell = this.cells[i];
                if (cell == null) continue;
                cell.Reset();
            }
            this.cells = null;
        }
    }

    private static final class Cell {
        final int cx;
        final int cy;
        final Chunk[] chunks = new Chunk[900];

        Cell(int n, int n2) {
            this.cx = n;
            this.cy = n2;
        }

        Chunk getChunkAt(int n, int n2, boolean bl) {
            int n3 = (n - this.cx * 300) / 10;
            int n4 = (n2 - this.cy * 300) / 10;
            int n5 = n3 + n4 * 30;
            if (this.chunks[n5] == null && bl) {
                this.chunks[n5] = new Chunk();
            }
            return this.chunks[n5];
        }

        Chunk getChunkForObject(GlobalObject globalObject, boolean bl) {
            return this.getChunkAt(globalObject.x, globalObject.y, bl);
        }

        void addObject(GlobalObject globalObject) {
            Chunk chunk = this.getChunkForObject(globalObject, true);
            if (chunk.objects.contains(globalObject)) {
                throw new IllegalStateException("duplicate object");
            }
            chunk.objects.add(globalObject);
        }

        void removeObject(GlobalObject globalObject) {
            Chunk chunk = this.getChunkForObject(globalObject, false);
            if (chunk == null || !chunk.objects.contains(globalObject)) {
                throw new IllegalStateException("chunk doesn't contain object");
            }
            chunk.objects.remove(globalObject);
        }

        void Reset() {
            for (int i = 0; i < this.chunks.length; ++i) {
                Chunk chunk = this.chunks[i];
                if (chunk == null) continue;
                chunk.Reset();
            }
            Arrays.fill(this.chunks, null);
        }
    }

    private static final class Chunk {
        final ArrayList<GlobalObject> objects = new ArrayList();

        private Chunk() {
        }

        void Reset() {
            this.objects.clear();
        }
    }
}

