/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.globalObjects.CGlobalObject;
import zombie.globalObjects.CGlobalObjectNetwork;
import zombie.globalObjects.CGlobalObjectSystem;
import zombie.network.TableNetworkUtils;
import zombie.util.Type;

public final class CGlobalObjects {
    protected static final ArrayList<CGlobalObjectSystem> systems = new ArrayList();
    protected static final HashMap<String, KahluaTable> initialState = new HashMap();

    public static void noise(String string) {
        if (Core.bDebug) {
            DebugLog.log("CGlobalObjects: " + string);
        }
    }

    public static CGlobalObjectSystem registerSystem(String string) {
        CGlobalObjectSystem cGlobalObjectSystem = CGlobalObjects.getSystemByName(string);
        if (cGlobalObjectSystem == null) {
            cGlobalObjectSystem = CGlobalObjects.newSystem(string);
            KahluaTable kahluaTable = initialState.get(string);
            if (kahluaTable != null) {
                KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
                while (kahluaTableIterator.advance()) {
                    Object object = kahluaTableIterator.getKey();
                    Object object2 = kahluaTableIterator.getValue();
                    if ("_objects".equals(object)) {
                        KahluaTable kahluaTable2 = Type.tryCastTo(object2, KahluaTable.class);
                        int n = kahluaTable2.len();
                        for (int i = 1; i <= n; ++i) {
                            KahluaTable kahluaTable3 = Type.tryCastTo(kahluaTable2.rawget(i), KahluaTable.class);
                            int n2 = ((Double)kahluaTable3.rawget("x")).intValue();
                            int n3 = ((Double)kahluaTable3.rawget("y")).intValue();
                            int n4 = ((Double)kahluaTable3.rawget("z")).intValue();
                            kahluaTable3.rawset("x", null);
                            kahluaTable3.rawset("y", null);
                            kahluaTable3.rawset("z", null);
                            CGlobalObject cGlobalObject = Type.tryCastTo(cGlobalObjectSystem.newObject(n2, n3, n4), CGlobalObject.class);
                            KahluaTableIterator kahluaTableIterator2 = kahluaTable3.iterator();
                            while (kahluaTableIterator2.advance()) {
                                cGlobalObject.getModData().rawset(kahluaTableIterator2.getKey(), kahluaTableIterator2.getValue());
                            }
                        }
                        kahluaTable2.wipe();
                        continue;
                    }
                    cGlobalObjectSystem.modData.rawset(object, object2);
                }
            }
        }
        return cGlobalObjectSystem;
    }

    public static CGlobalObjectSystem newSystem(String string) throws IllegalStateException {
        if (CGlobalObjects.getSystemByName(string) != null) {
            throw new IllegalStateException("system with that name already exists");
        }
        CGlobalObjects.noise("newSystem " + string);
        CGlobalObjectSystem cGlobalObjectSystem = new CGlobalObjectSystem(string);
        systems.add(cGlobalObjectSystem);
        return cGlobalObjectSystem;
    }

    public static int getSystemCount() {
        return systems.size();
    }

    public static CGlobalObjectSystem getSystemByIndex(int n) {
        if (n < 0 || n >= systems.size()) {
            return null;
        }
        return systems.get(n);
    }

    public static CGlobalObjectSystem getSystemByName(String string) {
        for (int i = 0; i < systems.size(); ++i) {
            CGlobalObjectSystem cGlobalObjectSystem = systems.get(i);
            if (!cGlobalObjectSystem.name.equals(string)) continue;
            return cGlobalObjectSystem;
        }
        return null;
    }

    public static void initSystems() {
        LuaEventManager.triggerEvent("OnCGlobalObjectSystemInit");
    }

    public static void loadInitialState(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.get();
        for (int i = 0; i < n; ++i) {
            String string = GameWindow.ReadStringUTF(byteBuffer);
            if (byteBuffer.get() == 0) continue;
            KahluaTable kahluaTable = LuaManager.platform.newTable();
            initialState.put(string, kahluaTable);
            TableNetworkUtils.load(kahluaTable, byteBuffer);
        }
    }

    public static boolean receiveServerCommand(String string, String string2, KahluaTable kahluaTable) {
        CGlobalObjectSystem cGlobalObjectSystem = CGlobalObjects.getSystemByName(string);
        if (cGlobalObjectSystem == null) {
            throw new IllegalStateException("system '" + string + "' not found");
        }
        cGlobalObjectSystem.receiveServerCommand(string2, kahluaTable);
        return true;
    }

    public static void Reset() {
        for (int i = 0; i < systems.size(); ++i) {
            CGlobalObjectSystem cGlobalObjectSystem = systems.get(i);
            cGlobalObjectSystem.Reset();
        }
        systems.clear();
        initialState.clear();
        CGlobalObjectNetwork.Reset();
    }
}

