/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import zombie.Lua.LuaEventManager;
import zombie.core.Core;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.ui.UIManager;

public class TermsOfServiceState
extends GameState {
    private boolean bExit = false;
    private boolean bCreated = false;

    @Override
    public void enter() {
        LuaEventManager.triggerEvent("OnGameStateEnter", this);
        if (!this.bCreated) {
            this.bExit = true;
        }
    }

    @Override
    public void exit() {
        UIManager.clearArrays();
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (this.bExit) {
            return GameStateMachine.StateAction.Continue;
        }
        return GameStateMachine.StateAction.Remain;
    }

    @Override
    public void render() {
        Core.getInstance().StartFrame();
        Core.getInstance().EndFrame();
        if (Core.getInstance().StartFrameUI()) {
            UIManager.render();
        }
        Core.getInstance().EndFrameUI();
    }

    public Object fromLua0(String string) {
        switch (string) {
            case "created": {
                this.bCreated = true;
                return null;
            }
            case "exit": {
                this.bExit = true;
                return null;
            }
        }
        throw new IllegalArgumentException("unhandled \"" + string + "\"");
    }
}

