/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import zombie.GameWindow;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatElement;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.input.GameKeyboard;
import zombie.iso.IsoCamera;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSprite;
import zombie.ui.TextDrawObject;
import zombie.ui.TextManager;
import zombie.ui.TutorialManager;
import zombie.ui.UIFont;
import zombie.ui.UIManager;

public final class ServerDisconnectState
extends GameState {
    private boolean keyDown = false;
    private int gridX = -1;
    private int gridY = -1;

    @Override
    public void enter() {
        TutorialManager.instance.StealControl = false;
        UIManager.UI.clear();
        LuaEventManager.ResetCallbacks();
        LuaManager.call("ISServerDisconnectUI_OnServerDisconnectUI", GameWindow.kickReason);
    }

    @Override
    public void exit() {
        GameWindow.kickReason = null;
    }

    @Override
    public void render() {
        int n;
        boolean bl = true;
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (IsoPlayer.players[n] == null) {
                if (n != 0) continue;
                SpriteRenderer.instance.prePopulating();
                continue;
            }
            IsoPlayer.setInstance(IsoPlayer.players[n]);
            IsoCamera.CamCharacter = IsoPlayer.players[n];
            Core.getInstance().StartFrame(n, bl);
            IsoCamera.frameState.set(n);
            bl = false;
            IsoSprite.globalOffsetX = -1.0f;
            IsoWorld.instance.render();
            Core.getInstance().EndFrame(n);
        }
        Core.getInstance().RenderOffScreenBuffer();
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (IsoPlayer.players[n] == null) continue;
            Core.getInstance().StartFrameText(n);
            IndieGL.disableAlphaTest();
            IndieGL.glDisable(2929);
            TextDrawObject.RenderBatch(n);
            ChatElement.RenderBatch(n);
            try {
                Core.getInstance().EndFrameText(n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Core.getInstance().StartFrameUI()) {
            UIManager.render();
            String string = GameWindow.kickReason;
            if (string == null || string.isEmpty()) {
                string = "Connection to server lost";
            }
            TextManager.instance.DrawStringCentre(UIFont.Medium, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() / 2, string, 1.0, 1.0, 1.0, 1.0);
        }
        Core.getInstance().EndFrameUI();
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (Core.bExiting || GameKeyboard.isKeyDown(1)) {
            return GameStateMachine.StateAction.Continue;
        }
        UIManager.update();
        return GameStateMachine.StateAction.Remain;
    }
}

