/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import org.lwjglx.input.Keyboard;
import zombie.GameWindow;
import zombie.SoundManager;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.gameStates.GameLoadingState;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.gameStates.MainScreenState;
import zombie.modding.ActiveMods;
import zombie.network.GameClient;
import zombie.ui.LoadingQueueUI;
import zombie.ui.UIManager;

public class LoadingQueueState
extends GameState {
    private static boolean bCancel = false;
    private static boolean bDone = false;
    private static int placeInQueue = -1;
    private boolean bAButtonDown = false;
    private static final LoadingQueueUI ui = new LoadingQueueUI();

    @Override
    public void enter() {
        bCancel = false;
        bDone = false;
        placeInQueue = -1;
        this.bAButtonDown = GameWindow.ActivatedJoyPad != null && GameWindow.ActivatedJoyPad.isAPressed();
        SoundManager.instance.setMusicState("Loading");
        if (GameClient.bClient) {
            GameClient.instance.sendLoginQueueRequest2();
        }
    }

    @Override
    public GameState redirectState() {
        if (bCancel) {
            return new MainScreenState();
        }
        return new GameLoadingState();
    }

    @Override
    public void render() {
        Core.getInstance().StartFrame();
        Core.getInstance().EndFrame();
        boolean bl = UIManager.useUIFBO;
        UIManager.useUIFBO = false;
        Core.getInstance().StartFrameUI();
        SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), 0.0f, 0.0f, 0.0f, 1.0f, null);
        if (placeInQueue >= 0) {
            MainScreenState.instance.renderBackground();
            UIManager.render();
            ActiveMods.renderUI();
            ui.render();
        }
        Core.getInstance().EndFrameUI();
        UIManager.useUIFBO = bl;
    }

    @Override
    public GameStateMachine.StateAction update() {
        boolean bl;
        if (!GameClient.bClient) {
            return GameStateMachine.StateAction.Continue;
        }
        boolean bl2 = bl = GameWindow.ActivatedJoyPad != null && GameWindow.ActivatedJoyPad.isAPressed();
        if (bl) {
            if (this.bAButtonDown) {
                bl = false;
            }
        } else {
            this.bAButtonDown = false;
        }
        if (bl || Keyboard.isKeyDown(1) || !GameClient.instance.bConnected) {
            bCancel = true;
            SoundManager.instance.setMusicState("MainMenu");
            if (GameClient.connection != null) {
                GameClient.instance.bConnected = false;
                GameClient.bClient = false;
                GameClient.connection.forceDisconnect("loading-queue-canceled");
                GameClient.connection = null;
            }
            return GameStateMachine.StateAction.Continue;
        }
        if (bDone) {
            return GameStateMachine.StateAction.Continue;
        }
        return GameStateMachine.StateAction.Remain;
    }

    public static void onConnectionImmediate() {
        bDone = true;
    }

    public static void onPlaceInQueue(int n) {
        placeInQueue = n;
        ui.setPlaceInQueue(n);
    }
}

