/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import fmod.javafmod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.AmbientStreamManager;
import zombie.DebugFileWatcher;
import zombie.FliesSound;
import zombie.GameSounds;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.LootRespawn;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaHookManager;
import zombie.Lua.LuaManager;
import zombie.Lua.MapObjects;
import zombie.MapCollisionData;
import zombie.ReanimatedPlayers;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.VirtualZombieManager;
import zombie.WorldSoundManager;
import zombie.ZombieSpawnRecorder;
import zombie.ZomboidFileSystem;
import zombie.ZomboidGlobals;
import zombie.audio.ObjectAmbientEmitters;
import zombie.characters.AttachedItems.AttachedLocations;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorFactory;
import zombie.characters.WornItems.BodyLocations;
import zombie.characters.professions.ProfessionFactory;
import zombie.characters.skills.CustomPerks;
import zombie.characters.skills.PerkFactory;
import zombie.characters.traits.TraitFactory;
import zombie.chat.ChatElement;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.Languages;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.opengl.RenderSettings;
import zombie.core.opengl.RenderThread;
import zombie.core.physics.WorldSimulation;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.skinnedmodel.DeadBodyAtlas;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AdvancedAnimator;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.model.ModelOutlines;
import zombie.core.skinnedmodel.model.WorldItemAtlas;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingDecals;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.stash.StashSystem;
import zombie.core.textures.Texture;
import zombie.core.znet.SteamFriends;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.erosion.ErosionGlobals;
import zombie.gameStates.AnimationViewerState;
import zombie.gameStates.AttachmentEditorState;
import zombie.gameStates.ChooseGameInfo;
import zombie.gameStates.DebugChunkState;
import zombie.gameStates.DebugGlobalObjectState;
import zombie.gameStates.GameLoadingState;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.gameStates.MainScreenState;
import zombie.gameStates.ServerDisconnectState;
import zombie.globalObjects.CGlobalObjects;
import zombie.globalObjects.SGlobalObjects;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;
import zombie.input.Mouse;
import zombie.inventory.ItemSoundManager;
import zombie.iso.BentFences;
import zombie.iso.BrokenFences;
import zombie.iso.BuildingDef;
import zombie.iso.ContainerOverlays;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMarkers;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.LightingThread;
import zombie.iso.LotHeader;
import zombie.iso.SearchMode;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.TileOverlays;
import zombie.iso.WorldMarkers;
import zombie.iso.WorldStreamer;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.IsoWaveSignal;
import zombie.iso.objects.RainManager;
import zombie.iso.sprite.CorpseFlies;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.SkyBox;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.Temperature;
import zombie.iso.weather.fx.WeatherFxMask;
import zombie.meta.Meta;
import zombie.modding.ActiveMods;
import zombie.network.BodyDamageSync;
import zombie.network.ChunkChecksum;
import zombie.network.ClientServerMap;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ItemTransactionManager;
import zombie.network.MPStatistics;
import zombie.network.PassengerMap;
import zombie.network.ServerGUI;
import zombie.network.ServerOptions;
import zombie.popman.ZombiePopulationManager;
import zombie.radio.ZomboidRadio;
import zombie.sandbox.CustomSandboxOptions;
import zombie.savefile.ClientPlayerDB;
import zombie.savefile.PlayerDB;
import zombie.scripting.ScriptManager;
import zombie.spnetwork.SinglePlayerClient;
import zombie.spnetwork.SinglePlayerServer;
import zombie.text.templating.TemplateText;
import zombie.ui.ActionProgressBar;
import zombie.ui.FPSGraph;
import zombie.ui.TextDrawObject;
import zombie.ui.TextManager;
import zombie.ui.TutorialManager;
import zombie.ui.UIElement;
import zombie.ui.UIManager;
import zombie.util.StringUtils;
import zombie.vehicles.EditVehicleState;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehicleCache;
import zombie.vehicles.VehicleIDMap;
import zombie.vehicles.VehicleType;
import zombie.vehicles.VehiclesDB2;
import zombie.worldMap.WorldMap;
import zombie.worldMap.WorldMapVisited;
import zombie.worldMap.editor.WorldMapEditorState;

public final class IngameState
extends GameState {
    public static int WaitMul = 20;
    public static IngameState instance;
    public static float draww;
    public static float drawh;
    public static Long GameID;
    static int last;
    static float xPos;
    static float yPos;
    static float offx;
    static float offy;
    static float zoom;
    static HashMap<String, Integer> ContainerTypes;
    static int nSaveCycle;
    static boolean bDoChars;
    static boolean keySpacePreviousFrame;
    public long numberTicks = 0L;
    public boolean Paused = false;
    public float SaveDelay = 0.0f;
    boolean alt = false;
    int insanityScareCount = 5;
    int insanitypic = -1;
    int timesincelastinsanity = 10000000;
    GameState RedirectState = null;
    boolean bDidServerDisconnectState = false;
    boolean fpsKeyDown = false;
    private final ArrayList<Long> debugTimes = new ArrayList();
    private int tickCount = 0;
    private float SadisticMusicDirectorTime;
    public boolean showAnimationViewer = false;
    public boolean showAttachmentEditor = false;
    public boolean showChunkDebugger = false;
    public boolean showGlobalObjectDebugger = false;
    public String showVehicleEditor = null;
    public String showWorldMapEditor = null;

    public IngameState() {
        instance = this;
    }

    public static void renderDebugOverhead(IsoCell isoCell, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Mouse.update();
        int n7 = Mouse.getX();
        int n8 = Mouse.getY();
        n7 -= n3;
        n8 -= n4;
        SpriteRenderer.instance.renderi(null, n3, n4, n2 * isoCell.getWidthInTiles(), n2 * isoCell.getHeightInTiles(), 0.7f, 0.7f, 0.7f, 1.0f, null);
        IsoGridSquare isoGridSquare = isoCell.getGridSquare((n7 /= n2) + isoCell.ChunkMap[0].getWorldXMinTiles(), (n8 /= n2) + isoCell.ChunkMap[0].getWorldYMinTiles(), 0);
        if (isoGridSquare != null) {
            int n9;
            n6 = 48;
            n5 = 48;
            TextManager.instance.DrawString(n5, n6, "SQUARE FLAGS", 1.0, 1.0, 1.0, 1.0);
            n6 += 20;
            n5 += 8;
            for (n9 = 0; n9 < IsoFlagType.MAX.index(); ++n9) {
                if (!isoGridSquare.Is(IsoFlagType.fromIndex(n9))) continue;
                TextManager.instance.DrawString(n5, n6, IsoFlagType.fromIndex(n9).toString(), 0.6, 0.6, 0.8, 1.0);
                n6 += 18;
            }
            n5 = 48;
            TextManager.instance.DrawString(n5, n6 += 16, "SQUARE OBJECT TYPES", 1.0, 1.0, 1.0, 1.0);
            n6 += 20;
            n5 += 8;
            for (n9 = 0; n9 < 64; ++n9) {
                if (!isoGridSquare.getHasTypes().isSet(n9)) continue;
                TextManager.instance.DrawString(n5, n6, IsoObjectType.fromIndex(n9).toString(), 0.6, 0.6, 0.8, 1.0);
                n6 += 18;
            }
        }
        for (n6 = 0; n6 < isoCell.getWidthInTiles(); ++n6) {
            for (n5 = 0; n5 < isoCell.getHeightInTiles(); ++n5) {
                IsoGridSquare isoGridSquare2 = isoCell.getGridSquare(n6 + isoCell.ChunkMap[0].getWorldXMinTiles(), n5 + isoCell.ChunkMap[0].getWorldYMinTiles(), n);
                if (isoGridSquare2 == null) continue;
                if (isoGridSquare2.getProperties().Is(IsoFlagType.solid) || isoGridSquare2.getProperties().Is(IsoFlagType.solidtrans)) {
                    SpriteRenderer.instance.renderi(null, n3 + n6 * n2, n4 + n5 * n2, n2, n2, 0.5f, 0.5f, 0.5f, 255.0f, null);
                } else if (!isoGridSquare2.getProperties().Is(IsoFlagType.exterior)) {
                    SpriteRenderer.instance.renderi(null, n3 + n6 * n2, n4 + n5 * n2, n2, n2, 0.8f, 0.8f, 0.8f, 1.0f, null);
                }
                if (isoGridSquare2.Has(IsoObjectType.tree)) {
                    SpriteRenderer.instance.renderi(null, n3 + n6 * n2, n4 + n5 * n2, n2, n2, 0.4f, 0.8f, 0.4f, 1.0f, null);
                }
                if (isoGridSquare2.getProperties().Is(IsoFlagType.collideN)) {
                    SpriteRenderer.instance.renderi(null, n3 + n6 * n2, n4 + n5 * n2, n2, 1, 0.2f, 0.2f, 0.2f, 1.0f, null);
                }
                if (!isoGridSquare2.getProperties().Is(IsoFlagType.collideW)) continue;
                SpriteRenderer.instance.renderi(null, n3 + n6 * n2, n4 + n5 * n2, 1, n2, 0.2f, 0.2f, 0.2f, 1.0f, null);
            }
        }
    }

    public static float translatePointX(float f, float f2, float f3, float f4) {
        f -= f2;
        f *= f3;
        f += f4;
        return f += draww / 2.0f;
    }

    public static float invTranslatePointX(float f, float f2, float f3, float f4) {
        f -= draww / 2.0f;
        f -= f4;
        f /= f3;
        return f += f2;
    }

    public static float invTranslatePointY(float f, float f2, float f3, float f4) {
        f -= drawh / 2.0f;
        f -= f4;
        f /= f3;
        return f += f2;
    }

    public static float translatePointY(float f, float f2, float f3, float f4) {
        f -= f2;
        f *= f3;
        f += f4;
        return f += drawh / 2.0f;
    }

    public static void renderRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = IngameState.translatePointX(f, xPos, zoom, offx);
        float f10 = IngameState.translatePointY(f2, yPos, zoom, offy);
        float f11 = IngameState.translatePointX(f + f3, xPos, zoom, offx);
        float f12 = IngameState.translatePointY(f2 + f4, yPos, zoom, offy);
        f3 = f11 - f9;
        f4 = f12 - f10;
        if (f9 >= (float)Core.getInstance().getScreenWidth() || f11 < 0.0f || f10 >= (float)Core.getInstance().getScreenHeight() || f12 < 0.0f) {
            return;
        }
        SpriteRenderer.instance.render(null, f9, f10, f3, f4, f5, f6, f7, f8, null);
    }

    public static void renderLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = IngameState.translatePointX(f, xPos, zoom, offx);
        float f10 = IngameState.translatePointY(f2, yPos, zoom, offy);
        float f11 = IngameState.translatePointX(f3, xPos, zoom, offx);
        float f12 = IngameState.translatePointY(f4, yPos, zoom, offy);
        if (f9 >= (float)Core.getInstance().getScreenWidth() && f11 >= (float)Core.getInstance().getScreenWidth() || f10 >= (float)Core.getInstance().getScreenHeight() && f12 >= (float)Core.getInstance().getScreenHeight() || f9 < 0.0f && f11 < 0.0f || f10 < 0.0f && f12 < 0.0f) {
            return;
        }
        SpriteRenderer.instance.renderline(null, (int)f9, (int)f10, (int)f11, (int)f12, f5, f6, f7, f8);
    }

    public static void renderDebugOverhead2(IsoCell isoCell, int n, float f, int n2, int n3, float f2, float f3, int n4, int n5) {
        int n6;
        draww = n4;
        drawh = n5;
        xPos = f2;
        yPos = f3;
        offx = n2;
        offy = n3;
        zoom = f;
        float f4 = isoCell.ChunkMap[0].getWorldXMinTiles();
        float f5 = isoCell.ChunkMap[0].getWorldYMinTiles();
        float f6 = isoCell.ChunkMap[0].getWorldXMaxTiles();
        float f7 = isoCell.ChunkMap[0].getWorldYMaxTiles();
        IngameState.renderRect(f4, f5, isoCell.getWidthInTiles(), isoCell.getWidthInTiles(), 0.7f, 0.7f, 0.7f, 1.0f);
        for (int i = 0; i < isoCell.getWidthInTiles(); ++i) {
            for (n6 = 0; n6 < isoCell.getHeightInTiles(); ++n6) {
                IsoGridSquare isoGridSquare = isoCell.getGridSquare(i + isoCell.ChunkMap[0].getWorldXMinTiles(), n6 + isoCell.ChunkMap[0].getWorldYMinTiles(), n);
                float f8 = (float)i + f4;
                float f9 = (float)n6 + f5;
                if (isoGridSquare == null) continue;
                if (isoGridSquare.getProperties().Is(IsoFlagType.solid) || isoGridSquare.getProperties().Is(IsoFlagType.solidtrans)) {
                    IngameState.renderRect(f8, f9, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 1.0f);
                } else if (!isoGridSquare.getProperties().Is(IsoFlagType.exterior)) {
                    IngameState.renderRect(f8, f9, 1.0f, 1.0f, 0.8f, 0.8f, 0.8f, 1.0f);
                }
                if (isoGridSquare.Has(IsoObjectType.tree)) {
                    IngameState.renderRect(f8, f9, 1.0f, 1.0f, 0.4f, 0.8f, 0.4f, 1.0f);
                }
                if (isoGridSquare.getProperties().Is(IsoFlagType.collideN)) {
                    IngameState.renderRect(f8, f9, 1.0f, 0.2f, 0.2f, 0.2f, 0.2f, 1.0f);
                }
                if (!isoGridSquare.getProperties().Is(IsoFlagType.collideW)) continue;
                IngameState.renderRect(f8, f9, 0.2f, 1.0f, 0.2f, 0.2f, 0.2f, 1.0f);
            }
        }
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.MetaGrid;
        IngameState.renderRect(isoMetaGrid.minX * 300, isoMetaGrid.minY * 300, isoMetaGrid.getWidth() * 300, isoMetaGrid.getHeight() * 300, 1.0f, 1.0f, 1.0f, 0.05f);
        if ((double)f > 0.1) {
            for (n6 = isoMetaGrid.minY; n6 <= isoMetaGrid.maxY; ++n6) {
                IngameState.renderLine(isoMetaGrid.minX * 300, n6 * 300, (isoMetaGrid.maxX + 1) * 300, n6 * 300, 1.0f, 1.0f, 1.0f, 0.15f);
            }
            for (n6 = isoMetaGrid.minX; n6 <= isoMetaGrid.maxX; ++n6) {
                IngameState.renderLine(n6 * 300, isoMetaGrid.minY * 300, n6 * 300, (isoMetaGrid.maxY + 1) * 300, 1.0f, 1.0f, 1.0f, 0.15f);
            }
        }
        IsoMetaCell[][] isoMetaCellArray = IsoWorld.instance.MetaGrid.Grid;
        for (int i = 0; i < isoMetaCellArray.length; ++i) {
            for (int j = 0; j < isoMetaCellArray[0].length; ++j) {
                LotHeader lotHeader = isoMetaCellArray[i][j].info;
                if (lotHeader == null) {
                    IngameState.renderRect((isoMetaGrid.minX + i) * 300 + 1, (isoMetaGrid.minY + j) * 300 + 1, 298.0f, 298.0f, 0.2f, 0.0f, 0.0f, 0.3f);
                    continue;
                }
                for (int k = 0; k < lotHeader.Buildings.size(); ++k) {
                    BuildingDef buildingDef = lotHeader.Buildings.get(k);
                    if (buildingDef.bAlarmed) {
                        IngameState.renderRect(buildingDef.getX(), buildingDef.getY(), buildingDef.getW(), buildingDef.getH(), 0.8f, 0.8f, 0.5f, 0.3f);
                        continue;
                    }
                    IngameState.renderRect(buildingDef.getX(), buildingDef.getY(), buildingDef.getW(), buildingDef.getH(), 0.5f, 0.5f, 0.8f, 0.3f);
                }
            }
        }
    }

    public static void copyWorld(String string, String string2) {
        Object object = ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string + File.separator;
        object = ((String)object).replace("/", File.separator);
        object = ((String)object).replace("\\", File.separator);
        String string3 = ((String)object).substring(0, ((String)object).lastIndexOf(File.separator));
        string3 = string3.replace("\\", "/");
        File file = new File(string3);
        object = ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string2 + File.separator;
        object = ((String)object).replace("/", File.separator);
        object = ((String)object).replace("\\", File.separator);
        String string4 = ((String)object).substring(0, ((String)object).lastIndexOf(File.separator));
        string4 = string4.replace("\\", "/");
        File file2 = new File(string4);
        try {
            IngameState.copyDirectory(file, file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            boolean bl;
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            boolean bl2 = bl = GameLoadingState.convertingFileMax == -1;
            if (bl) {
                GameLoadingState.convertingFileMax = stringArray.length;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (bl) {
                    ++GameLoadingState.convertingFileCount;
                }
                IngameState.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.getChannel().transferFrom(fileInputStream.getChannel(), 0L, file.length());
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void createWorld(String string) {
        string = string.replace(" ", "_").trim();
        Object object = ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string + File.separator;
        object = ((String)object).replace("/", File.separator);
        object = ((String)object).replace("\\", File.separator);
        String string2 = ((String)object).substring(0, ((String)object).lastIndexOf(File.separator));
        File file = new File(string2 = string2.replace("\\", "/"));
        if (!file.exists()) {
            file.mkdirs();
        }
        Core.GameSaveWorld = string;
    }

    public void debugFullyStreamedIn(int n, int n2) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, 0);
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare.getBuilding() == null) {
            return;
        }
        BuildingDef buildingDef = isoGridSquare.getBuilding().getDef();
        if (buildingDef == null) {
            return;
        }
        boolean bl = buildingDef.isFullyStreamedIn();
        for (int i = 0; i < buildingDef.overlappedChunks.size(); i += 2) {
            short s = buildingDef.overlappedChunks.get(i);
            short s2 = buildingDef.overlappedChunks.get(i + 1);
            if (bl) {
                IngameState.renderRect(s * 10, s2 * 10, 10.0f, 10.0f, 0.0f, 1.0f, 0.0f, 0.5f);
                continue;
            }
            IngameState.renderRect(s * 10, s2 * 10, 10.0f, 10.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        }
    }

    public void UpdateStuff() {
        GameClient.bIngame = true;
        this.SaveDelay += GameTime.instance.getMultiplier();
        if (this.SaveDelay / 60.0f > 30.0f) {
            this.SaveDelay = 0.0f;
        }
        GameTime.instance.LastLastTimeOfDay = GameTime.instance.getLastTimeOfDay();
        GameTime.instance.setLastTimeOfDay(GameTime.getInstance().getTimeOfDay());
        boolean bl = false;
        if (!GameServer.bServer && IsoPlayer.getInstance() != null) {
            bl = IsoPlayer.allPlayersAsleep();
        }
        GameTime.getInstance().update(bl && UIManager.getFadeAlpha() == 1.0);
        if (!this.Paused) {
            ScriptManager.instance.update();
        }
        if (!this.Paused) {
            long l = System.nanoTime();
            try {
                WorldSoundManager.instance.update();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            try {
                IsoFireManager.Update();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            try {
                RainManager.Update();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            Meta.instance.update();
            try {
                VirtualZombieManager.instance.update();
                MapCollisionData.instance.updateMain();
                ZombiePopulationManager.instance.updateMain();
                PolygonalMap2.instance.updateMain();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            catch (Error error) {
                error.printStackTrace();
            }
            try {
                LootRespawn.update();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            if (GameServer.bServer) {
                try {
                    AmbientStreamManager.instance.update();
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            } else {
                ObjectAmbientEmitters.getInstance().update();
            }
            if (GameClient.bClient) {
                try {
                    BodyDamageSync.instance.update();
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
            if (!GameServer.bServer) {
                try {
                    ItemSoundManager.update();
                    FliesSound.instance.update();
                    CorpseFlies.update();
                    LuaManager.call("SadisticMusicDirectorTick", null);
                    WorldMapVisited.update();
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
            SearchMode.getInstance().update();
            RenderSettings.getInstance().update();
            long l2 = System.nanoTime();
        }
    }

    @Override
    public void enter() {
        boolean bl = UIManager.useUIFBO = Core.getInstance().supportsFBO() && Core.OptionUIFBO;
        if (!Core.getInstance().getUseShaders()) {
            Core.getInstance().RenderShader = null;
        }
        GameSounds.fix3DListenerPosition(false);
        IsoPlayer.getInstance().updateUsername();
        IsoPlayer.getInstance().setSceneCulled(false);
        IsoPlayer.getInstance().getInventory().addItemsToProcessItems();
        GameID = Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        GameID = GameID + (long)Rand.Next(10000000);
        ZombieSpawnRecorder.instance.init();
        if (!GameServer.bServer) {
            IsoWorld.instance.CurrentCell.ChunkMap[0].processAllLoadGridSquare();
            IsoWorld.instance.CurrentCell.ChunkMap[0].update();
            if (!GameClient.bClient) {
                LightingThread.instance.GameLoadingUpdate();
            }
        }
        try {
            MapCollisionData.instance.startGame();
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
        IsoWorld.instance.CurrentCell.putInVehicle(IsoPlayer.getInstance());
        SoundManager.instance.setMusicState("Tutorial".equals(Core.GameMode) ? "Tutorial" : "InGame");
        ClimateManager.getInstance().update();
        LuaEventManager.triggerEvent("OnGameStart");
        LuaEventManager.triggerEvent("OnLoad");
        if (GameClient.bClient) {
            GameClient.instance.sendPlayerConnect(IsoPlayer.getInstance());
            DebugLog.log("Waiting for player-connect response from server");
            while (IsoPlayer.getInstance().OnlineID == -1) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                GameClient.instance.update();
            }
            ClimateManager.getInstance().update();
            LightingThread.instance.GameLoadingUpdate();
        }
        if (GameClient.bClient && SteamUtils.isSteamModeEnabled()) {
            SteamFriends.UpdateRichPresenceConnectionInfo("In game", "+connect " + GameClient.ip + ":" + GameClient.port);
        }
    }

    @Override
    public void exit() {
        int n;
        int n2;
        DebugLog.log("EXITDEBUG: IngameState.exit 1");
        if (SteamUtils.isSteamModeEnabled()) {
            SteamFriends.UpdateRichPresenceConnectionInfo("", "");
        }
        UIManager.useUIFBO = false;
        if (FPSGraph.instance != null) {
            FPSGraph.instance.setVisible(false);
        }
        UIManager.updateBeforeFadeOut();
        SoundManager.instance.setMusicState("MainMenu");
        long l = System.currentTimeMillis();
        boolean bl = UIManager.useUIFBO;
        UIManager.useUIFBO = false;
        DebugLog.log("EXITDEBUG: IngameState.exit 2");
        while (true) {
            float f = Math.min(1.0f, (float)(System.currentTimeMillis() - l) / 500.0f);
            boolean bl2 = true;
            for (n2 = 0; n2 < IsoPlayer.numPlayers; ++n2) {
                if (IsoPlayer.players[n2] == null) continue;
                IsoPlayer.setInstance(IsoPlayer.players[n2]);
                IsoCamera.CamCharacter = IsoPlayer.players[n2];
                IsoSprite.globalOffsetX = -1.0f;
                Core.getInstance().StartFrame(n2, bl2);
                IsoCamera.frameState.set(n2);
                IsoWorld.instance.render();
                Core.getInstance().EndFrame(n2);
                bl2 = false;
            }
            Core.getInstance().RenderOffScreenBuffer();
            Core.getInstance().StartFrameUI();
            UIManager.render();
            UIManager.DrawTexture(UIManager.getBlack(), 0.0, 0.0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), f);
            Core.getInstance().EndFrameUI();
            DebugLog.log("EXITDEBUG: IngameState.exit 3 (alpha=" + f + ")");
            if (f >= 1.0f) break;
            try {
                Thread.sleep(33L);
            }
            catch (Exception exception) {}
        }
        UIManager.useUIFBO = bl;
        DebugLog.log("EXITDEBUG: IngameState.exit 4");
        RenderThread.setWaitForRenderState(false);
        SpriteRenderer.instance.notifyRenderStateQueue();
        while (WorldStreamer.instance.isBusy()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        DebugLog.log("EXITDEBUG: IngameState.exit 5");
        WorldStreamer.instance.stop();
        LightingThread.instance.stop();
        MapCollisionData.instance.stop();
        ZombiePopulationManager.instance.stop();
        PolygonalMap2.instance.stop();
        DebugLog.log("EXITDEBUG: IngameState.exit 6");
        for (n = 0; n < IsoWorld.instance.CurrentCell.ChunkMap.length; ++n) {
            IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[n];
            for (n2 = 0; n2 < IsoChunkMap.ChunkGridWidth * IsoChunkMap.ChunkGridWidth; ++n2) {
                IsoChunk object = isoChunkMap.getChunk(n2 % IsoChunkMap.ChunkGridWidth, n2 / IsoChunkMap.ChunkGridWidth);
                if (object == null || !object.refs.contains(isoChunkMap)) continue;
                object.refs.remove(isoChunkMap);
                if (!object.refs.isEmpty()) continue;
                object.removeFromWorld();
                object.doReuseGridsquares();
            }
        }
        ModelManager.instance.Reset();
        for (n = 0; n < 4; ++n) {
            IsoPlayer.players[n] = null;
        }
        IsoPlayer.Reset();
        ZombieSpawnRecorder.instance.quit();
        DebugLog.log("EXITDEBUG: IngameState.exit 7");
        IsoPlayer.numPlayers = 1;
        Core.getInstance().OffscreenBuffer.destroy();
        WeatherFxMask.destroy();
        IsoRegions.reset();
        Temperature.reset();
        WorldMarkers.instance.reset();
        IsoMarkers.instance.reset();
        SearchMode.reset();
        ZomboidRadio.getInstance().Reset();
        IsoWaveSignal.Reset();
        ErosionGlobals.Reset();
        IsoGenerator.Reset();
        StashSystem.Reset();
        LootRespawn.Reset();
        VehicleCache.Reset();
        VehicleIDMap.instance.Reset();
        IsoWorld.instance.KillCell();
        ItemSoundManager.Reset();
        IsoChunk.Reset();
        ChunkChecksum.Reset();
        ClientServerMap.Reset();
        SinglePlayerClient.Reset();
        SinglePlayerServer.Reset();
        PassengerMap.Reset();
        DeadBodyAtlas.instance.Reset();
        WorldItemAtlas.instance.Reset();
        CorpseFlies.Reset();
        if (PlayerDB.isAvailable()) {
            PlayerDB.getInstance().close();
        }
        VehiclesDB2.instance.Reset();
        WorldMap.Reset();
        WorldStreamer.instance = new WorldStreamer();
        WorldSimulation.instance.destroy();
        WorldSimulation.instance = new WorldSimulation();
        DebugLog.log("EXITDEBUG: IngameState.exit 8");
        VirtualZombieManager.instance.Reset();
        VirtualZombieManager.instance = new VirtualZombieManager();
        ReanimatedPlayers.instance = new ReanimatedPlayers();
        ScriptManager.instance.Reset();
        GameSounds.Reset();
        VehicleType.Reset();
        TemplateText.Reset();
        LuaEventManager.Reset();
        MapObjects.Reset();
        CGlobalObjects.Reset();
        SGlobalObjects.Reset();
        AmbientStreamManager.instance.stop();
        SoundManager.instance.stop();
        IsoPlayer.setInstance(null);
        IsoCamera.CamCharacter = null;
        TutorialManager.instance.StealControl = false;
        UIManager.init();
        ScriptManager.instance.Reset();
        ClothingDecals.Reset();
        BeardStyles.Reset();
        HairStyles.Reset();
        OutfitManager.Reset();
        AnimationSet.Reset();
        GameSounds.Reset();
        SurvivorFactory.Reset();
        ProfessionFactory.Reset();
        TraitFactory.Reset();
        ChooseGameInfo.Reset();
        AttachedLocations.Reset();
        BodyLocations.Reset();
        ContainerOverlays.instance.Reset();
        BentFences.getInstance().Reset();
        BrokenFences.getInstance().Reset();
        TileOverlays.instance.Reset();
        LuaHookManager.Reset();
        CustomPerks.Reset();
        PerkFactory.Reset();
        CustomSandboxOptions.Reset();
        SandboxOptions.Reset();
        LuaManager.init();
        JoypadManager.instance.Reset();
        GameKeyboard.doLuaKeyPressed = true;
        GameWindow.ActivatedJoyPad = null;
        GameWindow.OkToSaveOnExit = false;
        GameWindow.bLoadedAsClient = false;
        Core.bLastStand = false;
        Core.ChallengeID = null;
        Core.bTutorial = false;
        Core.getInstance().setChallenge(false);
        Core.getInstance().setForceSnow(false);
        Core.getInstance().setZombieGroupSound(true);
        Core.getInstance().setFlashIsoCursor(false);
        SystemDisabler.Reset();
        Texture.nullTextures.clear();
        DebugLog.log("EXITDEBUG: IngameState.exit 9");
        ZomboidFileSystem.instance.Reset();
        if (!Core.SoundDisabled && !GameServer.bServer) {
            javafmod.FMOD_System_Update();
        }
        try {
            ZomboidFileSystem.instance.init();
        }
        catch (IOException iOException) {
            ExceptionLogger.logException(iOException);
        }
        Core.OptionModsEnabled = true;
        DebugLog.log("EXITDEBUG: IngameState.exit 10");
        ZomboidFileSystem.instance.loadMods("default");
        ZomboidFileSystem.instance.loadModPackFiles();
        Languages.instance.init();
        Translator.loadFiles();
        DebugLog.log("EXITDEBUG: IngameState.exit 11");
        CustomPerks.instance.init();
        CustomPerks.instance.initLua();
        CustomSandboxOptions.instance.init();
        CustomSandboxOptions.instance.initInstance(SandboxOptions.instance);
        ScriptManager.instance.Load();
        ModelManager.instance.initAnimationMeshes(true);
        ModelManager.instance.loadModAnimations();
        ClothingDecals.init();
        BeardStyles.init();
        HairStyles.init();
        OutfitManager.init();
        DebugLog.log("EXITDEBUG: IngameState.exit 12");
        try {
            TextManager.instance.Init();
            LuaManager.LoadDirBase();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        ZomboidGlobals.Load();
        DebugLog.log("EXITDEBUG: IngameState.exit 13");
        LuaEventManager.triggerEvent("OnGameBoot");
        SoundManager.instance.resumeSoundAndMusic();
        for (IsoPlayer isoPlayer : IsoPlayer.players) {
            if (isoPlayer == null) continue;
            isoPlayer.dirtyRecalcGridStack = true;
        }
        RenderThread.setWaitForRenderState(true);
        DebugLog.log("EXITDEBUG: IngameState.exit 14");
    }

    @Override
    public void yield() {
        SoundManager.instance.setMusicState("PauseMenu");
    }

    @Override
    public GameState redirectState() {
        if (this.RedirectState != null) {
            GameState gameState = this.RedirectState;
            this.RedirectState = null;
            return gameState;
        }
        return new MainScreenState();
    }

    @Override
    public void reenter() {
        SoundManager.instance.setMusicState("InGame");
    }

    public void renderframetext(int n) {
        s_performance.renderFrameText.invokeAndMeasure(this, n, IngameState::renderFrameTextInternal);
    }

    private void renderFrameTextInternal(int n) {
        IndieGL.disableAlphaTest();
        IndieGL.glDisable(2929);
        ArrayList<UIElement> arrayList = UIManager.getUI();
        for (int i = 0; i < arrayList.size(); ++i) {
            UIElement uIElement = arrayList.get(i);
            if (uIElement instanceof ActionProgressBar || !uIElement.isVisible().booleanValue() || !uIElement.isFollowGameWorld().booleanValue() || uIElement.getRenderThisPlayerOnly() != -1 && uIElement.getRenderThisPlayerOnly() != n) continue;
            uIElement.render();
        }
        ActionProgressBar actionProgressBar = UIManager.getProgressBar(n);
        if (actionProgressBar != null && actionProgressBar.isVisible().booleanValue()) {
            actionProgressBar.render();
        }
        WorldMarkers.instance.render();
        IsoMarkers.instance.render();
        TextDrawObject.RenderBatch(n);
        ChatElement.RenderBatch(n);
        try {
            Core.getInstance().EndFrameText(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renderframe(int n) {
        s_performance.renderFrame.invokeAndMeasure(this, n, IngameState::renderFrameInternal);
    }

    private void renderFrameInternal(int n) {
        if (IsoPlayer.getInstance() == null) {
            IsoPlayer.setInstance(IsoPlayer.players[0]);
            IsoCamera.CamCharacter = IsoPlayer.getInstance();
        }
        RenderSettings.getInstance().applyRenderSettings(n);
        ActionProgressBar actionProgressBar = UIManager.getProgressBar(n);
        if (actionProgressBar != null) {
            actionProgressBar.update(n);
        }
        IndieGL.disableAlphaTest();
        IndieGL.glDisable(2929);
        if (IsoPlayer.getInstance() != null && !IsoPlayer.getInstance().isAsleep() || UIManager.getFadeAlpha(n) < 1.0f) {
            ModelOutlines.instance.startFrameMain(n);
            IsoWorld.instance.render();
            ModelOutlines.instance.endFrameMain(n);
            RenderSettings.getInstance().legacyPostRender(n);
            LuaEventManager.triggerEvent("OnPostRender");
        }
        LineDrawer.clear();
        if (Core.bDebug && GameKeyboard.isKeyPressed(Core.getInstance().getKey("ToggleAnimationText"))) {
            DebugOptions.instance.Animation.Debug.setValue(!DebugOptions.instance.Animation.Debug.getValue());
        }
        try {
            Core.getInstance().EndFrame(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renderframeui() {
        s_performance.renderFrameUI.invokeAndMeasure(this, IngameState::renderFrameUI);
    }

    private void renderFrameUI() {
        if (Core.getInstance().StartFrameUI()) {
            TextManager.instance.DrawTextFromGameWorld();
            SkyBox.getInstance().draw();
            UIManager.render();
            ZomboidRadio.getInstance().render();
            if (Core.bDebug && IsoPlayer.getInstance() != null && IsoPlayer.getInstance().isGhostMode()) {
                IsoWorld.instance.CurrentCell.ChunkMap[0].drawDebugChunkMap();
            }
            DeadBodyAtlas.instance.renderUI();
            WorldItemAtlas.instance.renderUI();
            if (Core.bDebug) {
                if (GameKeyboard.isKeyDown(Core.getInstance().getKey("Display FPS"))) {
                    if (!this.fpsKeyDown) {
                        this.fpsKeyDown = true;
                        if (FPSGraph.instance == null) {
                            FPSGraph.instance = new FPSGraph();
                        }
                        FPSGraph.instance.setVisible(FPSGraph.instance.isVisible() == false);
                    }
                } else {
                    this.fpsKeyDown = false;
                }
                if (FPSGraph.instance != null) {
                    FPSGraph.instance.render();
                }
            }
            if (!GameServer.bServer) {
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    IsoPlayer isoPlayer = IsoPlayer.players[i];
                    if (isoPlayer == null || isoPlayer.isDead() || !isoPlayer.isAsleep()) continue;
                    float f = GameClient.bFastForward ? GameTime.getInstance().ServerTimeOfDay : GameTime.getInstance().getTimeOfDay();
                    float f2 = (f - (float)((int)f)) * 60.0f;
                    String string = "media/ui/SleepClock" + (int)f2 / 10 + ".png";
                    Texture texture = Texture.getSharedTexture(string);
                    if (texture == null) break;
                    int n = IsoCamera.getScreenLeft(i);
                    int n2 = IsoCamera.getScreenTop(i);
                    int n3 = IsoCamera.getScreenWidth(i);
                    int n4 = IsoCamera.getScreenHeight(i);
                    SpriteRenderer.instance.renderi(texture, n + n3 / 2 - texture.getWidth() / 2, n2 + n4 / 2 - texture.getHeight() / 2, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, null);
                }
            }
            ActiveMods.renderUI();
            JoypadManager.instance.renderUI();
        }
        if (Core.bDebug && DebugOptions.instance.Animation.AnimRenderPicker.getValue() && IsoPlayer.players[0] != null) {
            IsoPlayer.players[0].advancedAnimator.render();
        }
        if (Core.bDebug) {
            ModelOutlines.instance.renderDebug();
        }
        Core.getInstance().EndFrameUI();
    }

    @Override
    public void render() {
        s_performance.render.invokeAndMeasure(this, IngameState::renderInternal);
    }

    private void renderInternal() {
        int n;
        boolean bl = true;
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (IsoPlayer.players[n] == null) {
                if (n != 0) continue;
                SpriteRenderer.instance.prePopulating();
                continue;
            }
            IsoPlayer.setInstance(IsoPlayer.players[n]);
            IsoCamera.CamCharacter = IsoPlayer.players[n];
            Core.getInstance().StartFrame(n, bl);
            IsoCamera.frameState.set(n);
            bl = false;
            IsoSprite.globalOffsetX = -1.0f;
            this.renderframe(n);
        }
        if (DebugOptions.instance.OffscreenBuffer.Render.getValue()) {
            Core.getInstance().RenderOffScreenBuffer();
        }
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (IsoPlayer.players[n] == null) continue;
            IsoPlayer.setInstance(IsoPlayer.players[n]);
            IsoCamera.CamCharacter = IsoPlayer.players[n];
            IsoCamera.frameState.set(n);
            Core.getInstance().StartFrameText(n);
            this.renderframetext(n);
        }
        UIManager.resize();
        this.renderframeui();
    }

    @Override
    public GameStateMachine.StateAction update() {
        try {
            s_performance.update.start();
            GameStateMachine.StateAction stateAction = this.updateInternal();
            return stateAction;
        }
        finally {
            s_performance.update.end();
        }
    }

    private GameStateMachine.StateAction updateInternal() {
        block61: {
            int n;
            ++this.tickCount;
            if (this.tickCount < 60) {
                for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                    if (IsoPlayer.players[n] == null) continue;
                    IsoPlayer.players[n].dirtyRecalcGridStackTime = 20.0f;
                }
            }
            LuaEventManager.triggerEvent("OnTickEvenPaused", BoxedStaticValues.toDouble(this.numberTicks));
            DebugFileWatcher.instance.update();
            AdvancedAnimator.checkModifiedFiles();
            if (Core.bDebug) {
                this.debugTimes.clear();
                this.debugTimes.add(System.nanoTime());
            }
            if (Core.bExiting) {
                DebugLog.log("EXITDEBUG: IngameState.updateInternal 1");
                Core.bExiting = false;
                if (GameClient.bClient) {
                    for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                        IsoPlayer isoPlayer = IsoPlayer.players[n];
                        if (isoPlayer == null) continue;
                        ClientPlayerDB.getInstance().clientSendNetworkPlayerInt(isoPlayer);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    WorldStreamer.instance.stop();
                    GameClient.instance.doDisconnect("exiting");
                }
                DebugLog.log("EXITDEBUG: IngameState.updateInternal 2");
                if (PlayerDB.isAllow()) {
                    PlayerDB.getInstance().saveLocalPlayersForce();
                    PlayerDB.getInstance().m_canSavePlayers = false;
                }
                if (ClientPlayerDB.isAllow()) {
                    ClientPlayerDB.getInstance().canSavePlayers = false;
                }
                try {
                    GameWindow.save(true);
                }
                catch (Throwable throwable) {
                    ExceptionLogger.logException(throwable);
                }
                DebugLog.log("EXITDEBUG: IngameState.updateInternal 3");
                try {
                    LuaEventManager.triggerEvent("OnPostSave");
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
                if (ClientPlayerDB.isAllow()) {
                    ClientPlayerDB.getInstance().close();
                }
                return GameStateMachine.StateAction.Continue;
            }
            if (GameWindow.bServerDisconnected) {
                TutorialManager.instance.StealControl = true;
                if (!this.bDidServerDisconnectState) {
                    this.bDidServerDisconnectState = true;
                    this.RedirectState = new ServerDisconnectState();
                    return GameStateMachine.StateAction.Yield;
                }
                GameClient.connection = null;
                GameClient.instance.bConnected = false;
                GameClient.bClient = false;
                GameWindow.bServerDisconnected = false;
                return GameStateMachine.StateAction.Continue;
            }
            if (Core.bDebug) {
                if (this.showGlobalObjectDebugger || GameKeyboard.isKeyPressed(60) && GameKeyboard.isKeyDown(29)) {
                    this.showGlobalObjectDebugger = false;
                    DebugLog.General.debugln("Activating DebugGlobalObjectState.");
                    this.RedirectState = new DebugGlobalObjectState();
                    return GameStateMachine.StateAction.Yield;
                }
                if (this.showChunkDebugger || GameKeyboard.isKeyPressed(60)) {
                    this.showChunkDebugger = false;
                    DebugLog.General.debugln("Activating DebugChunkState.");
                    this.RedirectState = DebugChunkState.checkInstance();
                    return GameStateMachine.StateAction.Yield;
                }
                if (this.showAnimationViewer || GameKeyboard.isKeyPressed(65) && GameKeyboard.isKeyDown(29)) {
                    this.showAnimationViewer = false;
                    DebugLog.General.debugln("Activating AnimationViewerState.");
                    AnimationViewerState animationViewerState = AnimationViewerState.checkInstance();
                    this.RedirectState = animationViewerState;
                    return GameStateMachine.StateAction.Yield;
                }
                if (this.showAttachmentEditor || GameKeyboard.isKeyPressed(65) && GameKeyboard.isKeyDown(42)) {
                    this.showAttachmentEditor = false;
                    DebugLog.General.debugln("Activating AttachmentEditorState.");
                    AttachmentEditorState attachmentEditorState = AttachmentEditorState.checkInstance();
                    this.RedirectState = attachmentEditorState;
                    return GameStateMachine.StateAction.Yield;
                }
                if (this.showVehicleEditor != null || GameKeyboard.isKeyPressed(65)) {
                    DebugLog.General.debugln("Activating EditVehicleState.");
                    EditVehicleState editVehicleState = EditVehicleState.checkInstance();
                    if (!StringUtils.isNullOrWhitespace(this.showVehicleEditor)) {
                        editVehicleState.setScript(this.showVehicleEditor);
                    }
                    this.showVehicleEditor = null;
                    this.RedirectState = editVehicleState;
                    return GameStateMachine.StateAction.Yield;
                }
                if (this.showWorldMapEditor != null || GameKeyboard.isKeyPressed(66)) {
                    WorldMapEditorState worldMapEditorState = WorldMapEditorState.checkInstance();
                    this.showWorldMapEditor = null;
                    this.RedirectState = worldMapEditorState;
                    return GameStateMachine.StateAction.Yield;
                }
            }
            if (Core.bDebug) {
                this.debugTimes.add(System.nanoTime());
            }
            ++this.timesincelastinsanity;
            if (Core.bDebug) {
                this.debugTimes.add(System.nanoTime());
            }
            try {
                if (!GameServer.bServer && IsoPlayer.getInstance() != null && IsoPlayer.allPlayersDead()) {
                    if (IsoPlayer.getInstance() != null) {
                        UIManager.getSpeedControls().SetCurrentGameSpeed(1);
                    }
                    IsoCamera.update();
                }
                boolean bl = this.alt = !this.alt;
                if (!GameServer.bServer) {
                    WaitMul = 1;
                    if (UIManager.getSpeedControls() != null) {
                        if (UIManager.getSpeedControls().getCurrentGameSpeed() == 2) {
                            WaitMul = 15;
                        }
                        if (UIManager.getSpeedControls().getCurrentGameSpeed() == 3) {
                            WaitMul = 30;
                        }
                    }
                }
                if (Core.bDebug) {
                    this.debugTimes.add(System.nanoTime());
                }
                if (GameServer.bServer) {
                    this.Paused = GameServer.Players.isEmpty() && ServerOptions.instance.PauseEmpty.getValue();
                }
                if (this.Paused && !GameClient.bClient) break block61;
                try {
                    if (IsoCamera.CamCharacter != null && IsoWorld.instance.bDoChunkMapUpdate) {
                        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                            if (IsoPlayer.players[n] == null || IsoWorld.instance.CurrentCell.ChunkMap[n].ignore) continue;
                            if (!GameServer.bServer) {
                                IsoCamera.CamCharacter = IsoPlayer.players[n];
                                IsoPlayer.setInstance(IsoPlayer.players[n]);
                            }
                            if (GameServer.bServer) continue;
                            IsoWorld.instance.CurrentCell.ChunkMap[n].ProcessChunkPos(IsoCamera.CamCharacter);
                        }
                    }
                    if (Core.bDebug) {
                        this.debugTimes.add(System.nanoTime());
                    }
                    IsoWorld.instance.update();
                    if (Core.bDebug) {
                        this.debugTimes.add(System.nanoTime());
                    }
                    ZomboidRadio.getInstance().update();
                    this.UpdateStuff();
                    LuaEventManager.triggerEvent("OnTick", this.numberTicks);
                    this.numberTicks = Math.max(this.numberTicks + 1L, 0L);
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                    if (!GameServer.bServer) {
                        if (GameClient.bClient) {
                            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                                IsoPlayer isoPlayer = IsoPlayer.players[i];
                                if (isoPlayer == null) continue;
                                ClientPlayerDB.getInstance().clientSendNetworkPlayerInt(isoPlayer);
                            }
                            WorldStreamer.instance.stop();
                        }
                        String string = Core.GameSaveWorld;
                        IngameState.createWorld(Core.GameSaveWorld + "_crash");
                        IngameState.copyWorld(string, Core.GameSaveWorld);
                        if (GameClient.bClient) {
                            if (PlayerDB.isAllow()) {
                                PlayerDB.getInstance().saveLocalPlayersForce();
                                PlayerDB.getInstance().m_canSavePlayers = false;
                            }
                            if (ClientPlayerDB.isAllow()) {
                                ClientPlayerDB.getInstance().canSavePlayers = false;
                            }
                        }
                        try {
                            GameWindow.save(true);
                        }
                        catch (Throwable throwable) {
                            ExceptionLogger.logException(throwable);
                        }
                        if (GameClient.bClient) {
                            try {
                                LuaEventManager.triggerEvent("OnPostSave");
                            }
                            catch (Exception exception2) {
                                ExceptionLogger.logException(exception2);
                            }
                            if (ClientPlayerDB.isAllow()) {
                                ClientPlayerDB.getInstance().close();
                            }
                        }
                    }
                    if (GameClient.bClient) {
                        GameClient.instance.doDisconnect("crash");
                    }
                    return GameStateMachine.StateAction.Continue;
                }
            }
            catch (Exception exception) {
                System.err.println("IngameState.update caught an exception.");
                ExceptionLogger.logException(exception);
            }
        }
        if (Core.bDebug) {
            this.debugTimes.add(System.nanoTime());
        }
        if (!GameServer.bServer || ServerGUI.isCreated()) {
            ModelManager.instance.update();
        }
        if (Core.bDebug && FPSGraph.instance != null) {
            FPSGraph.instance.addUpdate(System.currentTimeMillis());
            FPSGraph.instance.update();
        }
        if (GameClient.bClient || GameServer.bServer) {
            ItemTransactionManager.update();
            MPStatistics.Update();
        }
        return GameStateMachine.StateAction.Remain;
    }

    static {
        GameID = 0L;
        last = -1;
        ContainerTypes = new HashMap();
        nSaveCycle = 1800;
        bDoChars = false;
        keySpacePreviousFrame = false;
    }

    private static class s_performance {
        static final PerformanceProfileProbe render = new PerformanceProfileProbe("IngameState.render");
        static final PerformanceProfileProbe renderFrame = new PerformanceProfileProbe("IngameState.renderFrame");
        static final PerformanceProfileProbe renderFrameText = new PerformanceProfileProbe("IngameState.renderFrameText");
        static final PerformanceProfileProbe renderFrameUI = new PerformanceProfileProbe("IngameState.renderFrameUI");
        static final PerformanceProfileProbe update = new PerformanceProfileProbe("IngameState.update");

        private s_performance() {
        }
    }
}

