/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatElement;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.debug.LineDrawer;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.globalObjects.CGlobalObjectSystem;
import zombie.globalObjects.CGlobalObjects;
import zombie.globalObjects.GlobalObject;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSprite;
import zombie.ui.TextDrawObject;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UIManager;
import zombie.vehicles.EditVehicleState;

public final class DebugGlobalObjectState
extends GameState {
    public static DebugGlobalObjectState instance;
    private EditVehicleState.LuaEnvironment m_luaEnv;
    private boolean bExit = false;
    private final ArrayList<UIElement> m_gameUI = new ArrayList();
    private final ArrayList<UIElement> m_selfUI = new ArrayList();
    private boolean m_bSuspendUI;
    private KahluaTable m_table = null;
    private int m_playerIndex = 0;
    private int m_z = 0;
    private int gridX = -1;
    private int gridY = -1;
    private UIFont FONT = UIFont.DebugConsole;

    public DebugGlobalObjectState() {
        instance = this;
    }

    @Override
    public void enter() {
        instance = this;
        if (this.m_luaEnv == null) {
            this.m_luaEnv = new EditVehicleState.LuaEnvironment(LuaManager.platform, LuaManager.converterManager, LuaManager.env);
        }
        this.saveGameUI();
        if (this.m_selfUI.size() == 0) {
            IsoPlayer isoPlayer = IsoPlayer.players[this.m_playerIndex];
            this.m_z = isoPlayer == null ? 0 : (int)isoPlayer.z;
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_luaEnv.env.rawget("DebugGlobalObjectState_InitUI"), (Object)this);
        } else {
            UIManager.UI.addAll(this.m_selfUI);
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget("showUI"), (Object)this.m_table);
        }
        this.bExit = false;
    }

    @Override
    public void yield() {
        this.restoreGameUI();
    }

    @Override
    public void reenter() {
        this.saveGameUI();
    }

    @Override
    public void exit() {
        this.restoreGameUI();
        for (int i = 0; i < IsoCamera.cameras.length; ++i) {
            IsoCamera.cameras[i].DeferedY = 0.0f;
            IsoCamera.cameras[i].DeferedX = 0.0f;
        }
    }

    @Override
    public void render() {
        int n;
        IsoPlayer.setInstance(IsoPlayer.players[this.m_playerIndex]);
        IsoCamera.CamCharacter = IsoPlayer.players[this.m_playerIndex];
        boolean bl = true;
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (n == this.m_playerIndex || IsoPlayer.players[n] == null) continue;
            Core.getInstance().StartFrame(n, bl);
            Core.getInstance().EndFrame(n);
            bl = false;
        }
        Core.getInstance().StartFrame(this.m_playerIndex, bl);
        this.renderScene();
        Core.getInstance().EndFrame(this.m_playerIndex);
        Core.getInstance().RenderOffScreenBuffer();
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            TextDrawObject.NoRender(n);
            ChatElement.NoRender(n);
        }
        if (Core.getInstance().StartFrameUI()) {
            this.renderUI();
        }
        Core.getInstance().EndFrameUI();
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (this.bExit || GameKeyboard.isKeyPressed(60)) {
            return GameStateMachine.StateAction.Continue;
        }
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[this.m_playerIndex];
        isoChunkMap.ProcessChunkPos(IsoPlayer.players[this.m_playerIndex]);
        isoChunkMap.update();
        return this.updateScene();
    }

    public void renderScene() {
        IsoCamera.frameState.set(this.m_playerIndex);
        SpriteRenderer.instance.doCoreIntParam(0, IsoCamera.CamCharacter.x);
        SpriteRenderer.instance.doCoreIntParam(1, IsoCamera.CamCharacter.y);
        SpriteRenderer.instance.doCoreIntParam(2, IsoCamera.CamCharacter.z);
        IsoSprite.globalOffsetX = -1.0f;
        IsoWorld.instance.CurrentCell.render();
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[this.m_playerIndex];
        int n = isoChunkMap.getWorldXMin();
        int n2 = isoChunkMap.getWorldYMin();
        int n3 = n + IsoChunkMap.ChunkGridWidth;
        int n4 = n2 + IsoChunkMap.ChunkGridWidth;
        int n5 = CGlobalObjects.getSystemCount();
        for (int i = 0; i < n5; ++i) {
            CGlobalObjectSystem cGlobalObjectSystem = CGlobalObjects.getSystemByIndex(i);
            for (int j = n2; j < n4; ++j) {
                for (int k = n; k < n3; ++k) {
                    ArrayList<GlobalObject> arrayList = cGlobalObjectSystem.getObjectsInChunk(k, j);
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        GlobalObject globalObject = arrayList.get(i2);
                        float f = 1.0f;
                        float f2 = 1.0f;
                        float f3 = 1.0f;
                        if (globalObject.getZ() != this.m_z) {
                            f3 = 0.5f;
                            f2 = 0.5f;
                            f = 0.5f;
                        }
                        this.DrawIsoRect(globalObject.getX(), globalObject.getY(), globalObject.getZ(), 1.0f, 1.0f, f, f2, f3, 1.0f, 1);
                    }
                    cGlobalObjectSystem.finishedWithList(arrayList);
                }
            }
        }
        LineDrawer.render();
        LineDrawer.clear();
    }

    private void renderUI() {
        UIManager.render();
    }

    public void setTable(KahluaTable kahluaTable) {
        this.m_table = kahluaTable;
    }

    public GameStateMachine.StateAction updateScene() {
        IsoPlayer.setInstance(IsoPlayer.players[this.m_playerIndex]);
        IsoCamera.CamCharacter = IsoPlayer.players[this.m_playerIndex];
        UIManager.setPicked(IsoObjectPicker.Instance.ContextPick(Mouse.getXA(), Mouse.getYA()));
        IsoObject isoObject = UIManager.getPicked() == null ? null : UIManager.getPicked().tile;
        UIManager.setLastPicked(isoObject);
        IsoCamera.update();
        this.updateCursor();
        return GameStateMachine.StateAction.Remain;
    }

    private void updateCursor() {
        int n = this.m_playerIndex;
        float f = Mouse.getXA();
        float f2 = Mouse.getYA();
        f -= (float)IsoCamera.getScreenLeft(n);
        f2 -= (float)IsoCamera.getScreenTop(n);
        int n2 = this.m_z;
        this.gridX = (int)IsoUtils.XToIso(f *= Core.getInstance().getZoom(n), f2 *= Core.getInstance().getZoom(n), n2);
        this.gridY = (int)IsoUtils.YToIso(f, f2, n2);
    }

    private void saveGameUI() {
        this.m_gameUI.clear();
        this.m_gameUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        this.m_bSuspendUI = UIManager.bSuspend;
        UIManager.bSuspend = false;
        UIManager.setShowPausedMessage(false);
        UIManager.defaultthread = this.m_luaEnv.thread;
    }

    private void restoreGameUI() {
        this.m_selfUI.clear();
        this.m_selfUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        UIManager.UI.addAll(this.m_gameUI);
        UIManager.bSuspend = this.m_bSuspendUI;
        UIManager.setShowPausedMessage(true);
        UIManager.defaultthread = LuaManager.thread;
    }

    private void DrawIsoLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n) {
        float f11 = IsoUtils.XToScreenExact(f, f2, f3, 0);
        float f12 = IsoUtils.YToScreenExact(f, f2, f3, 0);
        float f13 = IsoUtils.XToScreenExact(f4, f5, f6, 0);
        float f14 = IsoUtils.YToScreenExact(f4, f5, f6, 0);
        LineDrawer.drawLine(f11, f12, f13, f14, f7, f8, f9, f10, n);
    }

    private void DrawIsoRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n) {
        this.DrawIsoLine(f, f2, f3, f + f4, f2, f3, f6, f7, f8, f9, n);
        this.DrawIsoLine(f + f4, f2, f3, f + f4, f2 + f5, f3, f6, f7, f8, f9, n);
        this.DrawIsoLine(f + f4, f2 + f5, f3, f, f2 + f5, f3, f6, f7, f8, f9, n);
        this.DrawIsoLine(f, f2 + f5, f3, f, f2, f3, f6, f7, f8, f9, n);
    }

    public Object fromLua0(String string) {
        switch (string) {
            case "exit": {
                this.bExit = true;
                return null;
            }
            case "getCameraDragX": {
                return BoxedStaticValues.toDouble(-IsoCamera.cameras[this.m_playerIndex].DeferedX);
            }
            case "getCameraDragY": {
                return BoxedStaticValues.toDouble(-IsoCamera.cameras[this.m_playerIndex].DeferedY);
            }
            case "getPlayerIndex": {
                return BoxedStaticValues.toDouble(this.m_playerIndex);
            }
            case "getZ": {
                return BoxedStaticValues.toDouble(this.m_z);
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\"", string));
    }

    public Object fromLua1(String string, Object object) {
        switch (string) {
            case "setPlayerIndex": {
                this.m_playerIndex = PZMath.clamp(((Double)object).intValue(), 0, 3);
                return null;
            }
            case "setZ": {
                this.m_z = PZMath.clamp(((Double)object).intValue(), 0, 7);
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\"", string, object));
    }

    public Object fromLua2(String string, Object object, Object object2) {
        switch (string) {
            case "dragCamera": {
                float f = ((Double)object).floatValue();
                float f2 = ((Double)object2).floatValue();
                IsoCamera.cameras[this.m_playerIndex].DeferedX = -f;
                IsoCamera.cameras[this.m_playerIndex].DeferedY = -f2;
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\" \\\"%s\\\"", string, object, object2));
    }
}

