/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import java.util.Vector;
import org.joml.Vector2f;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.AmbientStreamManager;
import zombie.FliesSound;
import zombie.Lua.LuaManager;
import zombie.VirtualZombieManager;
import zombie.ZomboidFileSystem;
import zombie.ai.astar.Mover;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatElement;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.properties.PropertyContainer;
import zombie.core.utils.BooleanGrid;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.erosion.ErosionData;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoRoomLight;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.NearestWalls;
import zombie.iso.ParticlesFire;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameClient;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.ui.TextDrawObject;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UIManager;
import zombie.util.Type;
import zombie.vehicles.ClipperOffset;
import zombie.vehicles.EditVehicleState;
import zombie.vehicles.PolygonalMap2;

public final class DebugChunkState
extends GameState {
    public static DebugChunkState instance;
    private EditVehicleState.LuaEnvironment m_luaEnv;
    private boolean bExit = false;
    private final ArrayList<UIElement> m_gameUI = new ArrayList();
    private final ArrayList<UIElement> m_selfUI = new ArrayList();
    private boolean m_bSuspendUI;
    private KahluaTable m_table = null;
    private int m_playerIndex = 0;
    private int m_z = 0;
    private int gridX = -1;
    private int gridY = -1;
    private UIFont FONT = UIFont.DebugConsole;
    private String m_vehicleStory = "Basic Car Crash";
    static boolean keyQpressed;
    private static ClipperOffset m_clipperOffset;
    private static ByteBuffer m_clipperBuffer;
    private static final int VERSION = 1;
    private final ArrayList<ConfigOption> options = new ArrayList();
    private BooleanDebugOption BuildingRect = new BooleanDebugOption("BuildingRect", true);
    private BooleanDebugOption ChunkGrid = new BooleanDebugOption("ChunkGrid", true);
    private BooleanDebugOption ClosestRoomSquare = new BooleanDebugOption("ClosestRoomSquare", true);
    private BooleanDebugOption EmptySquares = new BooleanDebugOption("EmptySquares", true);
    private BooleanDebugOption FlyBuzzEmitters = new BooleanDebugOption("FlyBuzzEmitters", true);
    private BooleanDebugOption LightSquares = new BooleanDebugOption("LightSquares", true);
    private BooleanDebugOption LineClearCollide = new BooleanDebugOption("LineClearCollide", true);
    private BooleanDebugOption NearestWallsOpt = new BooleanDebugOption("NearestWalls", true);
    private BooleanDebugOption ObjectPicker = new BooleanDebugOption("ObjectPicker", true);
    private BooleanDebugOption RoomLightRects = new BooleanDebugOption("RoomLightRects", true);
    private BooleanDebugOption VehicleStory = new BooleanDebugOption("VehicleStory", true);
    private BooleanDebugOption RandomSquareInZone = new BooleanDebugOption("RandomSquareInZone", true);
    private BooleanDebugOption ZoneRect = new BooleanDebugOption("ZoneRect", true);

    public DebugChunkState() {
        instance = this;
    }

    @Override
    public void enter() {
        instance = this;
        this.load();
        if (this.m_luaEnv == null) {
            this.m_luaEnv = new EditVehicleState.LuaEnvironment(LuaManager.platform, LuaManager.converterManager, LuaManager.env);
        }
        this.saveGameUI();
        if (this.m_selfUI.size() == 0) {
            IsoPlayer isoPlayer = IsoPlayer.players[this.m_playerIndex];
            this.m_z = isoPlayer == null ? 0 : (int)isoPlayer.z;
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_luaEnv.env.rawget("DebugChunkState_InitUI"), (Object)this);
            if (this.m_table != null && this.m_table.getMetatable() != null) {
                this.m_table.getMetatable().rawset("_LUA_RELOADED_CHECK", (Object)Boolean.FALSE);
            }
        } else {
            UIManager.UI.addAll(this.m_selfUI);
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget("showUI"), (Object)this.m_table);
        }
        this.bExit = false;
    }

    @Override
    public void yield() {
        this.restoreGameUI();
    }

    @Override
    public void reenter() {
        this.saveGameUI();
    }

    @Override
    public void exit() {
        this.save();
        this.restoreGameUI();
        for (int i = 0; i < IsoCamera.cameras.length; ++i) {
            IsoCamera.cameras[i].DeferedY = 0.0f;
            IsoCamera.cameras[i].DeferedX = 0.0f;
        }
    }

    @Override
    public void render() {
        int n;
        IsoPlayer.setInstance(IsoPlayer.players[this.m_playerIndex]);
        IsoCamera.CamCharacter = IsoPlayer.players[this.m_playerIndex];
        boolean bl = true;
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (n == this.m_playerIndex || IsoPlayer.players[n] == null) continue;
            Core.getInstance().StartFrame(n, bl);
            Core.getInstance().EndFrame(n);
            bl = false;
        }
        Core.getInstance().StartFrame(this.m_playerIndex, bl);
        this.renderScene();
        Core.getInstance().EndFrame(this.m_playerIndex);
        Core.getInstance().RenderOffScreenBuffer();
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            TextDrawObject.NoRender(n);
            ChatElement.NoRender(n);
        }
        if (Core.getInstance().StartFrameUI()) {
            this.renderUI();
        }
        Core.getInstance().EndFrameUI();
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (this.bExit || GameKeyboard.isKeyPressed(60)) {
            return GameStateMachine.StateAction.Continue;
        }
        return this.updateScene();
    }

    public static DebugChunkState checkInstance() {
        instance = null;
        if (instance != null) {
            if (DebugChunkState.instance.m_table == null || DebugChunkState.instance.m_table.getMetatable() == null) {
                instance = null;
            } else if (DebugChunkState.instance.m_table.getMetatable().rawget("_LUA_RELOADED_CHECK") == null) {
                instance = null;
            }
        }
        if (instance == null) {
            return new DebugChunkState();
        }
        return instance;
    }

    public void renderScene() {
        IsoGridSquare isoGridSquare;
        Object object;
        int n;
        Object object2;
        IsoCamera.frameState.set(this.m_playerIndex);
        SpriteRenderer.instance.doCoreIntParam(0, IsoCamera.CamCharacter.x);
        SpriteRenderer.instance.doCoreIntParam(1, IsoCamera.CamCharacter.y);
        SpriteRenderer.instance.doCoreIntParam(2, IsoCamera.CamCharacter.z);
        IsoSprite.globalOffsetX = -1.0f;
        IsoWorld.instance.CurrentCell.render();
        if (this.ChunkGrid.getValue()) {
            this.drawGrid();
        }
        this.drawCursor();
        if (this.LightSquares.getValue()) {
            object2 = IsoWorld.instance.getCell().getLamppostPositions();
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object = (IsoLightSource)((Vector)object2).get(n);
                if (((IsoLightSource)object).z != this.m_z) continue;
                this.paintSquare(((IsoLightSource)object).x, ((IsoLightSource)object).y, ((IsoLightSource)object).z, 1.0f, 1.0f, 0.0f, 0.5f);
            }
        }
        if (this.ZoneRect.getValue()) {
            this.drawZones();
        }
        if (this.BuildingRect.getValue() && (object2 = IsoWorld.instance.getCell().getGridSquare(this.gridX, this.gridY, this.m_z)) != null && ((IsoGridSquare)object2).getBuilding() != null) {
            BuildingDef buildingDef = ((IsoGridSquare)object2).getBuilding().getDef();
            this.DrawIsoLine(buildingDef.getX(), buildingDef.getY(), buildingDef.getX2(), buildingDef.getY(), 1.0f, 1.0f, 1.0f, 1.0f, 2);
            this.DrawIsoLine(buildingDef.getX2(), buildingDef.getY(), buildingDef.getX2(), buildingDef.getY2(), 1.0f, 1.0f, 1.0f, 1.0f, 2);
            this.DrawIsoLine(buildingDef.getX2(), buildingDef.getY2(), buildingDef.getX(), buildingDef.getY2(), 1.0f, 1.0f, 1.0f, 1.0f, 2);
            this.DrawIsoLine(buildingDef.getX(), buildingDef.getY2(), buildingDef.getX(), buildingDef.getY(), 1.0f, 1.0f, 1.0f, 1.0f, 2);
        }
        if (this.RoomLightRects.getValue()) {
            object2 = IsoWorld.instance.CurrentCell.roomLights;
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                object = (IsoRoomLight)((ArrayList)object2).get(n);
                if (((IsoRoomLight)object).z != this.m_z) continue;
                this.DrawIsoRect(((IsoRoomLight)object).x, ((IsoRoomLight)object).y, ((IsoRoomLight)object).width, ((IsoRoomLight)object).height, 0.0f, 1.0f, 1.0f, 1.0f, 1);
            }
        }
        if (this.FlyBuzzEmitters.getValue()) {
            FliesSound.instance.render();
        }
        if (this.ClosestRoomSquare.getValue()) {
            float f = IsoPlayer.players[this.m_playerIndex].getX();
            float f2 = IsoPlayer.players[this.m_playerIndex].getY();
            object = new Vector2f();
            BuildingDef buildingDef = ((AmbientStreamManager)AmbientStreamManager.getInstance()).getNearestBuilding(f, f2, (Vector2f)object);
            if (buildingDef != null) {
                this.DrawIsoLine(f, f2, ((Vector2f)object).x, ((Vector2f)object).y, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            }
        }
        if (this.m_table != null && this.m_table.rawget("selectedSquare") != null && (isoGridSquare = Type.tryCastTo(this.m_table.rawget("selectedSquare"), IsoGridSquare.class)) != null) {
            this.DrawIsoRect(isoGridSquare.x, isoGridSquare.y, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 2);
        }
        LineDrawer.render();
        LineDrawer.clear();
    }

    private void renderUI() {
        int n = this.m_playerIndex;
        Stack<IsoLightSource> stack = IsoWorld.instance.getCell().getLamppostPositions();
        int n2 = 0;
        for (int i = 0; i < stack.size(); ++i) {
            IsoLightSource isoLightSource = (IsoLightSource)stack.get(i);
            if (!isoLightSource.bActive) continue;
            ++n2;
        }
        UIManager.render();
    }

    public void setTable(KahluaTable kahluaTable) {
        this.m_table = kahluaTable;
    }

    public GameStateMachine.StateAction updateScene() {
        IsoPlayer.setInstance(IsoPlayer.players[this.m_playerIndex]);
        IsoCamera.CamCharacter = IsoPlayer.players[this.m_playerIndex];
        UIManager.setPicked(IsoObjectPicker.Instance.ContextPick(Mouse.getXA(), Mouse.getYA()));
        IsoObject isoObject = UIManager.getPicked() == null ? null : UIManager.getPicked().tile;
        UIManager.setLastPicked(isoObject);
        if (GameKeyboard.isKeyDown(16)) {
            if (!keyQpressed) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.getCell().getGridSquare(this.gridX, this.gridY, 0);
                if (isoGridSquare != null) {
                    GameClient.instance.worldObjectsSyncReq.putRequestSyncIsoChunk(isoGridSquare.chunk);
                    DebugLog.General.debugln("Requesting sync IsoChunk %s", isoGridSquare.chunk);
                }
                keyQpressed = true;
            }
        } else {
            keyQpressed = false;
        }
        if (GameKeyboard.isKeyDown(19)) {
            if (!keyQpressed) {
                DebugOptions.instance.Terrain.RenderTiles.NewRender.setValue(true);
                keyQpressed = true;
                DebugLog.General.debugln("IsoCell.newRender = %s", DebugOptions.instance.Terrain.RenderTiles.NewRender.getValue());
            }
        } else {
            keyQpressed = false;
        }
        if (GameKeyboard.isKeyDown(20)) {
            if (!keyQpressed) {
                DebugOptions.instance.Terrain.RenderTiles.NewRender.setValue(false);
                keyQpressed = true;
                DebugLog.General.debugln("IsoCell.newRender = %s", DebugOptions.instance.Terrain.RenderTiles.NewRender.getValue());
            }
        } else {
            keyQpressed = false;
        }
        if (GameKeyboard.isKeyDown(31)) {
            if (!keyQpressed) {
                ParticlesFire.getInstance().reloadShader();
                keyQpressed = true;
                DebugLog.General.debugln("ParticlesFire.reloadShader");
            }
        } else {
            keyQpressed = false;
        }
        IsoCamera.update();
        this.updateCursor();
        return GameStateMachine.StateAction.Remain;
    }

    private void saveGameUI() {
        this.m_gameUI.clear();
        this.m_gameUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        this.m_bSuspendUI = UIManager.bSuspend;
        UIManager.bSuspend = false;
        UIManager.setShowPausedMessage(false);
        UIManager.defaultthread = this.m_luaEnv.thread;
    }

    private void restoreGameUI() {
        this.m_selfUI.clear();
        this.m_selfUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        UIManager.UI.addAll(this.m_gameUI);
        UIManager.bSuspend = this.m_bSuspendUI;
        UIManager.setShowPausedMessage(true);
        UIManager.defaultthread = LuaManager.thread;
    }

    public Object fromLua0(String string) {
        switch (string) {
            case "exit": {
                this.bExit = true;
                return null;
            }
            case "getCameraDragX": {
                return BoxedStaticValues.toDouble(-IsoCamera.cameras[this.m_playerIndex].DeferedX);
            }
            case "getCameraDragY": {
                return BoxedStaticValues.toDouble(-IsoCamera.cameras[this.m_playerIndex].DeferedY);
            }
            case "getPlayerIndex": {
                return BoxedStaticValues.toDouble(this.m_playerIndex);
            }
            case "getVehicleStory": {
                return this.m_vehicleStory;
            }
            case "getZ": {
                return BoxedStaticValues.toDouble(this.m_z);
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\"", string));
    }

    public Object fromLua1(String string, Object object) {
        switch (string) {
            case "getCameraDragX": {
                return BoxedStaticValues.toDouble(-IsoCamera.cameras[this.m_playerIndex].DeferedX);
            }
            case "getCameraDragY": {
                return BoxedStaticValues.toDouble(-IsoCamera.cameras[this.m_playerIndex].DeferedY);
            }
            case "setPlayerIndex": {
                this.m_playerIndex = PZMath.clamp(((Double)object).intValue(), 0, 3);
                return null;
            }
            case "setVehicleStory": {
                this.m_vehicleStory = (String)object;
                return null;
            }
            case "setZ": {
                this.m_z = PZMath.clamp(((Double)object).intValue(), 0, 7);
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\"", string, object));
    }

    public Object fromLua2(String string, Object object, Object object2) {
        switch (string) {
            case "dragCamera": {
                float f = ((Double)object).floatValue();
                float f2 = ((Double)object2).floatValue();
                IsoCamera.cameras[this.m_playerIndex].DeferedX = -f;
                IsoCamera.cameras[this.m_playerIndex].DeferedY = -f2;
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\" \\\"%s\\\"", string, object, object2));
    }

    private void updateCursor() {
        int n = this.m_playerIndex;
        int n2 = Core.TileScale;
        float f = Mouse.getXA();
        float f2 = Mouse.getYA();
        f -= (float)IsoCamera.getScreenLeft(n);
        f2 -= (float)IsoCamera.getScreenTop(n);
        int n3 = this.m_z;
        this.gridX = (int)IsoUtils.XToIso(f *= Core.getInstance().getZoom(n), f2 *= Core.getInstance().getZoom(n), n3);
        this.gridY = (int)IsoUtils.YToIso(f, f2, n3);
    }

    private void DrawIsoLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        float f9 = this.m_z;
        float f10 = IsoUtils.XToScreenExact(f, f2, f9, 0);
        float f11 = IsoUtils.YToScreenExact(f, f2, f9, 0);
        float f12 = IsoUtils.XToScreenExact(f3, f4, f9, 0);
        float f13 = IsoUtils.YToScreenExact(f3, f4, f9, 0);
        LineDrawer.drawLine(f10, f11, f12, f13, f5, f6, f7, f8, n);
    }

    private void DrawIsoRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        this.DrawIsoLine(f, f2, f + f3, f2, f5, f6, f7, f8, n);
        this.DrawIsoLine(f + f3, f2, f + f3, f2 + f4, f5, f6, f7, f8, n);
        this.DrawIsoLine(f + f3, f2 + f4, f, f2 + f4, f5, f6, f7, f8, n);
        this.DrawIsoLine(f, f2 + f4, f, f2, f5, f6, f7, f8, n);
    }

    private void drawGrid() {
        int n;
        int n2 = this.m_playerIndex;
        float f = IsoUtils.XToIso(-128.0f, -256.0f, 0.0f);
        float f2 = IsoUtils.YToIso(Core.getInstance().getOffscreenWidth(n2) + 128, -256.0f, 0.0f);
        float f3 = IsoUtils.XToIso(Core.getInstance().getOffscreenWidth(n2) + 128, Core.getInstance().getOffscreenHeight(n2) + 256, 6.0f);
        float f4 = IsoUtils.YToIso(-128.0f, Core.getInstance().getOffscreenHeight(n2) + 256, 6.0f);
        int n3 = (int)f2;
        int n4 = (int)f4;
        int n5 = (int)f;
        int n6 = (int)f3;
        n5 -= 2;
        for (n = n3 -= 2; n <= n4; ++n) {
            if (n % 10 != 0) continue;
            this.DrawIsoLine(n5, n, n6, n, 1.0f, 1.0f, 1.0f, 0.5f, 1);
        }
        for (n = n5; n <= n6; ++n) {
            if (n % 10 != 0) continue;
            this.DrawIsoLine(n, n3, n, n4, 1.0f, 1.0f, 1.0f, 0.5f, 1);
        }
        for (n = n3; n <= n4; ++n) {
            if (n % 300 != 0) continue;
            this.DrawIsoLine(n5, n, n6, n, 0.0f, 1.0f, 0.0f, 0.5f, 1);
        }
        for (n = n5; n <= n6; ++n) {
            if (n % 300 != 0) continue;
            this.DrawIsoLine(n, n3, n, n4, 0.0f, 1.0f, 0.0f, 0.5f, 1);
        }
        if (GameClient.bClient) {
            for (n = n3; n <= n4; ++n) {
                if (n % 50 != 0) continue;
                this.DrawIsoLine(n5, n, n6, n, 1.0f, 0.0f, 0.0f, 0.5f, 1);
            }
            for (n = n5; n <= n6; ++n) {
                if (n % 50 != 0) continue;
                this.DrawIsoLine(n, n3, n, n4, 1.0f, 0.0f, 0.0f, 0.5f, 1);
            }
        }
    }

    private void drawCursor() {
        int n = this.m_playerIndex;
        int n2 = Core.TileScale;
        float f = this.m_z;
        int n3 = (int)IsoUtils.XToScreenExact(this.gridX, this.gridY + 1, f, 0);
        int n4 = (int)IsoUtils.YToScreenExact(this.gridX, this.gridY + 1, f, 0);
        SpriteRenderer.instance.renderPoly(n3, n4, n3 + 32 * n2, n4 - 16 * n2, n3 + 64 * n2, n4, n3 + 32 * n2, n4 + 16 * n2, 0.0f, 0.0f, 1.0f, 0.5f);
        IsoChunkMap isoChunkMap = IsoWorld.instance.getCell().ChunkMap[n];
        for (int i = isoChunkMap.getWorldYMinTiles(); i < isoChunkMap.getWorldYMaxTiles(); ++i) {
            for (int j = isoChunkMap.getWorldXMinTiles(); j < isoChunkMap.getWorldXMaxTiles(); ++j) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.getCell().getGridSquare((double)j, (double)i, f);
                if (isoGridSquare == null) continue;
                if (isoGridSquare != isoChunkMap.getGridSquare(j, i, (int)f)) {
                    n3 = (int)IsoUtils.XToScreenExact(j, i + 1, f, 0);
                    n4 = (int)IsoUtils.YToScreenExact(j, i + 1, f, 0);
                    SpriteRenderer.instance.renderPoly(n3, n4, n3 + 32, n4 - 16, n3 + 64, n4, n3 + 32, n4 + 16, 1.0f, 0.0f, 0.0f, 0.8f);
                }
                if (isoGridSquare == null || isoGridSquare.getX() != j || isoGridSquare.getY() != i || (float)isoGridSquare.getZ() != f || isoGridSquare.e != null && isoGridSquare.e.w != null && isoGridSquare.e.w != isoGridSquare || isoGridSquare.w != null && isoGridSquare.w.e != null && isoGridSquare.w.e != isoGridSquare || isoGridSquare.n != null && isoGridSquare.n.s != null && isoGridSquare.n.s != isoGridSquare || isoGridSquare.s != null && isoGridSquare.s.n != null && isoGridSquare.s.n != isoGridSquare || isoGridSquare.nw != null && isoGridSquare.nw.se != null && isoGridSquare.nw.se != isoGridSquare || isoGridSquare.se != null && isoGridSquare.se.nw != null && isoGridSquare.se.nw != isoGridSquare) {
                    n3 = (int)IsoUtils.XToScreenExact(j, i + 1, f, 0);
                    n4 = (int)IsoUtils.YToScreenExact(j, i + 1, f, 0);
                    SpriteRenderer.instance.renderPoly(n3, n4, n3 + 32, n4 - 16, n3 + 64, n4, n3 + 32, n4 + 16, 1.0f, 0.0f, 0.0f, 0.5f);
                }
                if (isoGridSquare != null) {
                    IsoGridSquare isoGridSquare2;
                    IsoGridSquare isoGridSquare3 = isoGridSquare.testPathFindAdjacent(null, -1, 0, 0) ? null : isoGridSquare.nav[IsoDirections.W.index()];
                    IsoGridSquare isoGridSquare4 = isoGridSquare.testPathFindAdjacent(null, 0, -1, 0) ? null : isoGridSquare.nav[IsoDirections.N.index()];
                    IsoGridSquare isoGridSquare5 = isoGridSquare.testPathFindAdjacent(null, 1, 0, 0) ? null : isoGridSquare.nav[IsoDirections.E.index()];
                    IsoGridSquare isoGridSquare6 = isoGridSquare.testPathFindAdjacent(null, 0, 1, 0) ? null : isoGridSquare.nav[IsoDirections.S.index()];
                    IsoGridSquare isoGridSquare7 = isoGridSquare.testPathFindAdjacent(null, -1, -1, 0) ? null : isoGridSquare.nav[IsoDirections.NW.index()];
                    IsoGridSquare isoGridSquare8 = isoGridSquare.testPathFindAdjacent(null, 1, -1, 0) ? null : isoGridSquare.nav[IsoDirections.NE.index()];
                    IsoGridSquare isoGridSquare9 = isoGridSquare.testPathFindAdjacent(null, -1, 1, 0) ? null : isoGridSquare.nav[IsoDirections.SW.index()];
                    IsoGridSquare isoGridSquare10 = isoGridSquare2 = isoGridSquare.testPathFindAdjacent(null, 1, 1, 0) ? null : isoGridSquare.nav[IsoDirections.SE.index()];
                    if (isoGridSquare3 != isoGridSquare.w || isoGridSquare4 != isoGridSquare.n || isoGridSquare5 != isoGridSquare.e || isoGridSquare6 != isoGridSquare.s || isoGridSquare7 != isoGridSquare.nw || isoGridSquare8 != isoGridSquare.ne || isoGridSquare9 != isoGridSquare.sw || isoGridSquare2 != isoGridSquare.se) {
                        this.paintSquare(j, i, (int)f, 1.0f, 0.0f, 0.0f, 0.5f);
                    }
                }
                if (isoGridSquare != null && (isoGridSquare.nav[IsoDirections.NW.index()] != null && isoGridSquare.nav[IsoDirections.NW.index()].nav[IsoDirections.SE.index()] != isoGridSquare || isoGridSquare.nav[IsoDirections.NE.index()] != null && isoGridSquare.nav[IsoDirections.NE.index()].nav[IsoDirections.SW.index()] != isoGridSquare || isoGridSquare.nav[IsoDirections.SW.index()] != null && isoGridSquare.nav[IsoDirections.SW.index()].nav[IsoDirections.NE.index()] != isoGridSquare || isoGridSquare.nav[IsoDirections.SE.index()] != null && isoGridSquare.nav[IsoDirections.SE.index()].nav[IsoDirections.NW.index()] != isoGridSquare || isoGridSquare.nav[IsoDirections.N.index()] != null && isoGridSquare.nav[IsoDirections.N.index()].nav[IsoDirections.S.index()] != isoGridSquare || isoGridSquare.nav[IsoDirections.S.index()] != null && isoGridSquare.nav[IsoDirections.S.index()].nav[IsoDirections.N.index()] != isoGridSquare || isoGridSquare.nav[IsoDirections.W.index()] != null && isoGridSquare.nav[IsoDirections.W.index()].nav[IsoDirections.E.index()] != isoGridSquare || isoGridSquare.nav[IsoDirections.E.index()] != null && isoGridSquare.nav[IsoDirections.E.index()].nav[IsoDirections.W.index()] != isoGridSquare)) {
                    n3 = (int)IsoUtils.XToScreenExact(j, i + 1, f, 0);
                    n4 = (int)IsoUtils.YToScreenExact(j, i + 1, f, 0);
                    SpriteRenderer.instance.renderPoly(n3, n4, n3 + 32, n4 - 16, n3 + 64, n4, n3 + 32, n4 + 16, 1.0f, 0.0f, 0.0f, 0.5f);
                }
                if (this.EmptySquares.getValue() && isoGridSquare.getObjects().isEmpty()) {
                    this.paintSquare(j, i, (int)f, 1.0f, 1.0f, 0.0f, 0.5f);
                }
                if (isoGridSquare.getRoom() != null && isoGridSquare.isFree(false) && !VirtualZombieManager.instance.canSpawnAt(j, i, (int)f)) {
                    this.paintSquare(j, i, (int)f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (isoGridSquare.roofHideBuilding == null) continue;
                this.paintSquare(j, i, (int)f, 0.0f, 0.0f, 1.0f, 0.25f);
            }
        }
        if (IsoCamera.CamCharacter.getCurrentSquare() != null && Math.abs(this.gridX - (int)IsoCamera.CamCharacter.x) <= 1 && Math.abs(this.gridY - (int)IsoCamera.CamCharacter.y) <= 1) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.gridX, this.gridY, this.m_z);
            IsoObject isoObject = IsoCamera.CamCharacter.getCurrentSquare().testCollideSpecialObjects(isoGridSquare);
            if (isoObject != null) {
                isoObject.getSprite().RenderGhostTileRed((int)isoObject.getX(), (int)isoObject.getY(), (int)isoObject.getZ());
            }
        }
        if (this.LineClearCollide.getValue()) {
            this.lineClearCached(IsoWorld.instance.CurrentCell, this.gridX, this.gridY, (int)f, (int)IsoCamera.CamCharacter.getX(), (int)IsoCamera.CamCharacter.getY(), this.m_z, false);
        }
        if (this.NearestWallsOpt.getValue()) {
            NearestWalls.render(this.gridX, this.gridY, this.m_z);
        }
        if (this.VehicleStory.getValue()) {
            this.drawVehicleStory();
        }
    }

    private void drawZones() {
        IsoGridSquare isoGridSquare;
        int n;
        int n2;
        Object object;
        ArrayList<IsoMetaGrid.Zone> arrayList = IsoWorld.instance.MetaGrid.getZonesAt(this.gridX, this.gridY, this.m_z, new ArrayList<IsoMetaGrid.Zone>());
        IsoMetaGrid.Zone zone = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            if (((IsoMetaGrid.Zone)object).isPreferredZoneForSquare) {
                zone = object;
            }
            if (((IsoMetaGrid.Zone)object).isPolyline()) continue;
            if (!((IsoMetaGrid.Zone)object).points.isEmpty()) {
                for (int j = 0; j < ((IsoMetaGrid.Zone)object).points.size(); j += 2) {
                    n2 = ((IsoMetaGrid.Zone)object).points.get(j);
                    int n3 = ((IsoMetaGrid.Zone)object).points.get(j + 1);
                    int n4 = ((IsoMetaGrid.Zone)object).points.get((j + 2) % ((IsoMetaGrid.Zone)object).points.size());
                    n = ((IsoMetaGrid.Zone)object).points.get((j + 3) % ((IsoMetaGrid.Zone)object).points.size());
                    this.DrawIsoLine(n2, n3, n4, n, 1.0f, 1.0f, 0.0f, 1.0f, 1);
                }
                continue;
            }
            this.DrawIsoLine(((IsoMetaGrid.Zone)object).x, ((IsoMetaGrid.Zone)object).y, ((IsoMetaGrid.Zone)object).x + ((IsoMetaGrid.Zone)object).w, ((IsoMetaGrid.Zone)object).y, 1.0f, 1.0f, 0.0f, 1.0f, 1);
            this.DrawIsoLine(((IsoMetaGrid.Zone)object).x, ((IsoMetaGrid.Zone)object).y + ((IsoMetaGrid.Zone)object).h, ((IsoMetaGrid.Zone)object).x + ((IsoMetaGrid.Zone)object).w, ((IsoMetaGrid.Zone)object).y + ((IsoMetaGrid.Zone)object).h, 1.0f, 1.0f, 0.0f, 1.0f, 1);
            this.DrawIsoLine(((IsoMetaGrid.Zone)object).x, ((IsoMetaGrid.Zone)object).y, ((IsoMetaGrid.Zone)object).x, ((IsoMetaGrid.Zone)object).y + ((IsoMetaGrid.Zone)object).h, 1.0f, 1.0f, 0.0f, 1.0f, 1);
            this.DrawIsoLine(((IsoMetaGrid.Zone)object).x + ((IsoMetaGrid.Zone)object).w, ((IsoMetaGrid.Zone)object).y, ((IsoMetaGrid.Zone)object).x + ((IsoMetaGrid.Zone)object).w, ((IsoMetaGrid.Zone)object).y + ((IsoMetaGrid.Zone)object).h, 1.0f, 1.0f, 0.0f, 1.0f, 1);
        }
        arrayList = IsoWorld.instance.MetaGrid.getZonesIntersecting(this.gridX - 1, this.gridY - 1, this.m_z, 3, 3, new ArrayList<IsoMetaGrid.Zone>());
        PolygonalMap2.LiangBarsky liangBarsky = new PolygonalMap2.LiangBarsky();
        object = new double[2];
        IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunkForGridSquare(this.gridX, this.gridY, this.m_z);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            float f;
            IsoMetaGrid.Zone zone2 = arrayList.get(n2);
            if (zone2 == null || !zone2.isPolyline() || zone2.points.isEmpty()) continue;
            for (int i = 0; i < zone2.points.size() - 2; i += 2) {
                n = zone2.points.get(i);
                int n5 = zone2.points.get(i + 1);
                int n6 = zone2.points.get(i + 2);
                int n7 = zone2.points.get(i + 3);
                this.DrawIsoLine(n, n5, n6, n7, 1.0f, 1.0f, 0.0f, 1.0f, 1);
                f = n6 - n;
                float f2 = n7 - n5;
                if (isoChunk == null || !liangBarsky.lineRectIntersect(n, n5, f, f2, isoChunk.wx * 10, isoChunk.wy * 10, isoChunk.wx * 10 + 10, isoChunk.wy * 10 + 10, (double[])object)) continue;
                this.DrawIsoLine((float)n + (float)object[0] * f, (float)n5 + (float)object[0] * f2, (float)n + (float)object[1] * f, (float)n5 + (float)object[1] * f2, 0.0f, 1.0f, 0.0f, 1.0f, 1);
            }
            if (zone2.polylineOutlinePoints == null) continue;
            float[] fArray = zone2.polylineOutlinePoints;
            for (n = 0; n < fArray.length; n += 2) {
                float f3 = fArray[n];
                float f4 = fArray[n + 1];
                float f5 = fArray[(n + 2) % fArray.length];
                f = fArray[(n + 3) % fArray.length];
                this.DrawIsoLine(f3, f4, f5, f, 1.0f, 1.0f, 0.0f, 1.0f, 1);
            }
        }
        IsoMetaGrid.VehicleZone vehicleZone = IsoWorld.instance.MetaGrid.getVehicleZoneAt(this.gridX, this.gridY, this.m_z);
        if (vehicleZone != null) {
            float f = 0.5f;
            float f6 = 1.0f;
            float f7 = 0.5f;
            float f8 = 1.0f;
            if (vehicleZone.isPolygon()) {
                for (int i = 0; i < vehicleZone.points.size(); i += 2) {
                    int n8 = vehicleZone.points.get(i);
                    int n9 = vehicleZone.points.get(i + 1);
                    int n10 = vehicleZone.points.get((i + 2) % vehicleZone.points.size());
                    int n11 = vehicleZone.points.get((i + 3) % vehicleZone.points.size());
                    this.DrawIsoLine(n8, n9, n10, n11, 1.0f, 1.0f, 0.0f, 1.0f, 1);
                }
            } else if (vehicleZone.isPolyline()) {
                for (int i = 0; i < vehicleZone.points.size() - 2; i += 2) {
                    int n12 = vehicleZone.points.get(i);
                    int n13 = vehicleZone.points.get(i + 1);
                    int n14 = vehicleZone.points.get(i + 2);
                    int n15 = vehicleZone.points.get(i + 3);
                    this.DrawIsoLine(n12, n13, n14, n15, 1.0f, 1.0f, 0.0f, 1.0f, 1);
                }
                if (vehicleZone.polylineOutlinePoints != null) {
                    float[] fArray = vehicleZone.polylineOutlinePoints;
                    for (int i = 0; i < fArray.length; i += 2) {
                        float f9 = fArray[i];
                        float f10 = fArray[i + 1];
                        float f11 = fArray[(i + 2) % fArray.length];
                        float f12 = fArray[(i + 3) % fArray.length];
                        this.DrawIsoLine(f9, f10, f11, f12, 1.0f, 1.0f, 0.0f, 1.0f, 1);
                    }
                }
            } else {
                this.DrawIsoLine(vehicleZone.x, vehicleZone.y, vehicleZone.x + vehicleZone.w, vehicleZone.y, f, f6, f7, f8, 1);
                this.DrawIsoLine(vehicleZone.x, vehicleZone.y + vehicleZone.h, vehicleZone.x + vehicleZone.w, vehicleZone.y + vehicleZone.h, f, f6, f7, f8, 1);
                this.DrawIsoLine(vehicleZone.x, vehicleZone.y, vehicleZone.x, vehicleZone.y + vehicleZone.h, f, f6, f7, f8, 1);
                this.DrawIsoLine(vehicleZone.x + vehicleZone.w, vehicleZone.y, vehicleZone.x + vehicleZone.w, vehicleZone.y + vehicleZone.h, f, f6, f7, f8, 1);
            }
        }
        if (this.RandomSquareInZone.getValue() && zone != null && (isoGridSquare = zone.getRandomSquareInZone()) != null) {
            this.paintSquare(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, 0.0f, 1.0f, 0.0f, 0.5f);
        }
    }

    private void drawVehicleStory() {
        ArrayList<IsoMetaGrid.Zone> arrayList = IsoWorld.instance.MetaGrid.getZonesIntersecting(this.gridX - 1, this.gridY - 1, this.m_z, 3, 3, new ArrayList<IsoMetaGrid.Zone>());
        if (arrayList.isEmpty()) {
            return;
        }
        IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunkForGridSquare(this.gridX, this.gridY, this.m_z);
        if (isoChunk == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoMetaGrid.Zone zone = arrayList.get(i);
            if (!"Nav".equals(zone.type)) continue;
            VehicleStorySpawner vehicleStorySpawner2 = VehicleStorySpawner.getInstance();
            RandomizedVehicleStoryBase randomizedVehicleStoryBase = IsoWorld.instance.getRandomizedVehicleStoryByName(this.m_vehicleStory);
            if (randomizedVehicleStoryBase == null || !randomizedVehicleStoryBase.isValid(zone, isoChunk, true) || !randomizedVehicleStoryBase.initVehicleStorySpawner(zone, isoChunk, true)) continue;
            int n = randomizedVehicleStoryBase.getMinZoneWidth();
            int n2 = randomizedVehicleStoryBase.getMinZoneHeight();
            float[] fArray = new float[3];
            if (!randomizedVehicleStoryBase.getSpawnPoint(zone, isoChunk, fArray)) continue;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2] + 1.5707964f;
            vehicleStorySpawner2.spawn(f, f2, 0.0f, f3, (vehicleStorySpawner, element) -> {});
            vehicleStorySpawner2.render(f, f2, 0.0f, n, n2, fArray[2]);
        }
    }

    private void DrawBehindStuff() {
        this.IsBehindStuff(IsoCamera.CamCharacter.getCurrentSquare());
    }

    private boolean IsBehindStuff(IsoGridSquare isoGridSquare) {
        for (int i = 1; i < 8 && isoGridSquare.getZ() + i < 8; ++i) {
            for (int j = -5; j <= 6; ++j) {
                for (int k = -5; k <= 6; ++k) {
                    int n = j;
                    if (k < n - 5 || k > n + 5) continue;
                    this.paintSquare(isoGridSquare.getX() + k + i * 3, isoGridSquare.getY() + j + i * 3, isoGridSquare.getZ() + i, 1.0f, 1.0f, 0.0f, 0.25f);
                }
            }
        }
        return true;
    }

    private boolean IsBehindStuffRecY(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (n3 >= 15) {
            return false;
        }
        this.paintSquare(n, n2, n3, 1.0f, 1.0f, 0.0f, 0.25f);
        return this.IsBehindStuffRecY(n, n2 + 1, n3 + 1);
    }

    private boolean IsBehindStuffRecXY(int n, int n2, int n3, int n4) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (n3 >= 15) {
            return false;
        }
        this.paintSquare(n, n2, n3, 1.0f, 1.0f, 0.0f, 0.25f);
        return this.IsBehindStuffRecXY(n + n4, n2 + n4, n3 + 1, n4);
    }

    private boolean IsBehindStuffRecX(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (n3 >= 15) {
            return false;
        }
        this.paintSquare(n, n2, n3, 1.0f, 1.0f, 0.0f, 0.25f);
        return this.IsBehindStuffRecX(n + 1, n2, n3 + 1);
    }

    private void paintSquare(int n, int n2, int n3, float f, float f2, float f3, float f4) {
        int n4 = Core.TileScale;
        int n5 = (int)IsoUtils.XToScreenExact(n, n2 + 1, n3, 0);
        int n6 = (int)IsoUtils.YToScreenExact(n, n2 + 1, n3, 0);
        SpriteRenderer.instance.renderPoly(n5, n6, n5 + 32 * n4, n6 - 16 * n4, n5 + 64 * n4, n6, n5 + 32 * n4, n6 + 16 * n4, f, f2, f3, f4);
    }

    void drawModData() {
        ArrayList<String> arrayList;
        Object object;
        int n = this.m_z;
        IsoGridSquare isoGridSquare = IsoWorld.instance.getCell().getGridSquare(this.gridX, this.gridY, n);
        int n2 = Core.getInstance().getScreenWidth() - 250;
        int n3 = 10;
        int n4 = TextManager.instance.getFontFromEnum(this.FONT).getLineHeight();
        if (isoGridSquare != null && isoGridSquare.getModData() != null) {
            object = isoGridSquare.getModData();
            this.DrawString(n2, n3 += n4, "MOD DATA x,y,z=" + isoGridSquare.getX() + "," + isoGridSquare.getY() + "," + isoGridSquare.getZ());
            arrayList = object.iterator();
            while (arrayList.advance()) {
                this.DrawString(n2, n3 += n4, arrayList.getKey().toString() + " = " + arrayList.getValue().toString());
                if (!(arrayList.getValue() instanceof KahluaTable)) continue;
                KahluaTableIterator kahluaTableIterator = ((KahluaTable)arrayList.getValue()).iterator();
                while (kahluaTableIterator.advance()) {
                    this.DrawString(n2 + 8, n3 += n4, kahluaTableIterator.getKey().toString() + " = " + kahluaTableIterator.getValue().toString());
                }
            }
            n3 += n4;
        }
        if (isoGridSquare != null) {
            object = isoGridSquare.getProperties();
            arrayList = ((PropertyContainer)object).getPropertyNames();
            if (!arrayList.isEmpty()) {
                this.DrawString(n2, n3 += n4, "PROPERTIES x,y,z=" + isoGridSquare.getX() + "," + isoGridSquare.getY() + "," + isoGridSquare.getZ());
                Collections.sort(arrayList);
                for (String string : arrayList) {
                    this.DrawString(n2, n3 += n4, string + " = \"" + ((PropertyContainer)object).Val(string) + "\"");
                }
            }
            for (IsoFlagType isoFlagType : IsoFlagType.values()) {
                if (!((PropertyContainer)object).Is(isoFlagType)) continue;
                this.DrawString(n2, n3 += n4, isoFlagType.toString());
            }
        }
        if (isoGridSquare != null && (object = isoGridSquare.getErosionData()) != null) {
            n3 += n4;
            this.DrawString(n2, n3 += n4, "EROSION x,y,z=" + isoGridSquare.getX() + "," + isoGridSquare.getY() + "," + isoGridSquare.getZ());
            this.DrawString(n2, n3 += n4, "init=" + ((ErosionData.Square)object).init);
            this.DrawString(n2, n3 += n4, "doNothing=" + ((ErosionData.Square)object).doNothing);
            this.DrawString(n2, n3 += n4, "chunk.init=" + isoGridSquare.chunk.getErosionData().init);
        }
    }

    void drawPlayerInfo() {
        int n = Core.getInstance().getScreenWidth() - 250;
        int n2 = Core.getInstance().getScreenHeight() / 2;
        int n3 = TextManager.instance.getFontFromEnum(this.FONT).getLineHeight();
        IsoGameCharacter isoGameCharacter = IsoCamera.CamCharacter;
        this.DrawString(n, n2 += n3, "bored = " + isoGameCharacter.getBodyDamage().getBoredomLevel());
        this.DrawString(n, n2 += n3, "endurance = " + isoGameCharacter.getStats().endurance);
        this.DrawString(n, n2 += n3, "fatigue = " + isoGameCharacter.getStats().fatigue);
        this.DrawString(n, n2 += n3, "hunger = " + isoGameCharacter.getStats().hunger);
        this.DrawString(n, n2 += n3, "pain = " + isoGameCharacter.getStats().Pain);
        this.DrawString(n, n2 += n3, "panic = " + isoGameCharacter.getStats().Panic);
        this.DrawString(n, n2 += n3, "stress = " + isoGameCharacter.getStats().getStress());
        this.DrawString(n, n2 += n3, "clothingTemp = " + ((IsoPlayer)isoGameCharacter).getPlayerClothingTemperature());
        this.DrawString(n, n2 += n3, "temperature = " + isoGameCharacter.getTemperature());
        this.DrawString(n, n2 += n3, "thirst = " + isoGameCharacter.getStats().thirst);
        this.DrawString(n, n2 += n3, "foodPoison = " + isoGameCharacter.getBodyDamage().getFoodSicknessLevel());
        this.DrawString(n, n2 += n3, "poison = " + isoGameCharacter.getBodyDamage().getPoisonLevel());
        this.DrawString(n, n2 += n3, "unhappy = " + isoGameCharacter.getBodyDamage().getUnhappynessLevel());
        this.DrawString(n, n2 += n3, "infected = " + isoGameCharacter.getBodyDamage().isInfected());
        this.DrawString(n, n2 += n3, "InfectionLevel = " + isoGameCharacter.getBodyDamage().getInfectionLevel());
        this.DrawString(n, n2 += n3, "FakeInfectionLevel = " + isoGameCharacter.getBodyDamage().getFakeInfectionLevel());
        n2 += n3;
        this.DrawString(n, n2 += n3, "WORLD");
        this.DrawString(n, n2 += n3, "globalTemperature = " + IsoWorld.instance.getGlobalTemperature());
    }

    public LosUtil.TestResults lineClearCached(IsoCell isoCell, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n4;
        int n8 = n5;
        int n9 = n6;
        int n10 = n2 - n5;
        int n11 = n - n4;
        int n12 = n3 - n6;
        int n13 = n11;
        int n14 = n10;
        int n15 = n12;
        if ((n13 += 100) < 0 || (n14 += 100) < 0 || (n15 += 16) < 0 || n13 >= 200 || n14 >= 200) {
            return LosUtil.TestResults.Blocked;
        }
        LosUtil.TestResults testResults = LosUtil.TestResults.Clear;
        int n16 = 1;
        float f = 0.5f;
        float f2 = 0.5f;
        int n17 = n4;
        int n18 = n5;
        int n19 = n6;
        IsoGridSquare isoGridSquare = isoCell.getGridSquare(n17, n18, n19);
        if (Math.abs(n11) > Math.abs(n10) && Math.abs(n11) > Math.abs(n12)) {
            float f3 = (float)n10 / (float)n11;
            float f4 = (float)n12 / (float)n11;
            f += (float)n5;
            f2 += (float)n6;
            n11 = n11 < 0 ? -1 : 1;
            f3 *= (float)n11;
            f4 *= (float)n11;
            while (n4 != n) {
                IsoGridSquare isoGridSquare2 = isoCell.getGridSquare(n4 += n11, (int)(f += f3), (int)(f2 += f4));
                this.paintSquare(n4, (int)f, (int)f2, 1.0f, 1.0f, 1.0f, 0.5f);
                if (isoGridSquare2 != null && isoGridSquare != null && isoGridSquare2.testVisionAdjacent(isoGridSquare.getX() - isoGridSquare2.getX(), isoGridSquare.getY() - isoGridSquare2.getY(), isoGridSquare.getZ() - isoGridSquare2.getZ(), true, bl) == LosUtil.TestResults.Blocked) {
                    this.paintSquare(n4, (int)f, (int)f2, 1.0f, 0.0f, 0.0f, 0.5f);
                    this.paintSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), 1.0f, 0.0f, 0.0f, 0.5f);
                    n16 = 4;
                }
                isoGridSquare = isoGridSquare2;
                n17 = n4;
                n18 = (int)f;
                n19 = (int)f2;
            }
        } else if (Math.abs(n10) >= Math.abs(n11) && Math.abs(n10) > Math.abs(n12)) {
            float f5 = (float)n11 / (float)n10;
            float f6 = (float)n12 / (float)n10;
            f += (float)n4;
            f2 += (float)n6;
            n10 = n10 < 0 ? -1 : 1;
            f5 *= (float)n10;
            f6 *= (float)n10;
            while (n5 != n2) {
                IsoGridSquare isoGridSquare3 = isoCell.getGridSquare((int)(f += f5), n5 += n10, (int)(f2 += f6));
                this.paintSquare((int)f, n5, (int)f2, 1.0f, 1.0f, 1.0f, 0.5f);
                if (isoGridSquare3 != null && isoGridSquare != null && isoGridSquare3.testVisionAdjacent(isoGridSquare.getX() - isoGridSquare3.getX(), isoGridSquare.getY() - isoGridSquare3.getY(), isoGridSquare.getZ() - isoGridSquare3.getZ(), true, bl) == LosUtil.TestResults.Blocked) {
                    this.paintSquare((int)f, n5, (int)f2, 1.0f, 0.0f, 0.0f, 0.5f);
                    this.paintSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), 1.0f, 0.0f, 0.0f, 0.5f);
                    n16 = 4;
                }
                isoGridSquare = isoGridSquare3;
                n17 = (int)f;
                n18 = n5;
                n19 = (int)f2;
            }
        } else {
            float f7 = (float)n11 / (float)n12;
            float f8 = (float)n10 / (float)n12;
            f += (float)n4;
            f2 += (float)n5;
            n12 = n12 < 0 ? -1 : 1;
            f7 *= (float)n12;
            f8 *= (float)n12;
            while (n6 != n3) {
                IsoGridSquare isoGridSquare4 = isoCell.getGridSquare((int)(f += f7), (int)(f2 += f8), n6 += n12);
                this.paintSquare((int)f, (int)f2, n6, 1.0f, 1.0f, 1.0f, 0.5f);
                if (isoGridSquare4 != null && isoGridSquare != null && isoGridSquare4.testVisionAdjacent(isoGridSquare.getX() - isoGridSquare4.getX(), isoGridSquare.getY() - isoGridSquare4.getY(), isoGridSquare.getZ() - isoGridSquare4.getZ(), true, bl) == LosUtil.TestResults.Blocked) {
                    n16 = 4;
                }
                isoGridSquare = isoGridSquare4;
                n17 = (int)f;
                n18 = (int)f2;
                n19 = n6;
            }
        }
        if (n16 == 1) {
            return LosUtil.TestResults.Clear;
        }
        if (n16 == 2) {
            return LosUtil.TestResults.ClearThroughOpenDoor;
        }
        if (n16 == 3) {
            return LosUtil.TestResults.ClearThroughWindow;
        }
        if (n16 == 4) {
            return LosUtil.TestResults.Blocked;
        }
        return LosUtil.TestResults.Blocked;
    }

    private void DrawString(int n, int n2, String string) {
        int n3 = TextManager.instance.MeasureStringX(this.FONT, string);
        int n4 = TextManager.instance.getFontFromEnum(this.FONT).getLineHeight();
        SpriteRenderer.instance.renderi(null, n - 1, n2, n3 + 2, n4, 0.0f, 0.0f, 0.0f, 0.8f, null);
        TextManager.instance.DrawString(this.FONT, n, n2, string, 1.0, 1.0, 1.0, 1.0);
    }

    public ConfigOption getOptionByName(String string) {
        for (int i = 0; i < this.options.size(); ++i) {
            ConfigOption configOption = this.options.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public ConfigOption getOptionByIndex(int n) {
        return this.options.get(n);
    }

    public void setBoolean(String string, boolean bl) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            ((BooleanConfigOption)configOption).setValue(bl);
        }
    }

    public boolean getBoolean(String string) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            return ((BooleanConfigOption)configOption).getValue();
        }
        return false;
    }

    public void save() {
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "debugChunkState-options.ini";
        ConfigFile configFile = new ConfigFile();
        configFile.write(string, 1, this.options);
    }

    public void load() {
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "debugChunkState-options.ini";
        if (configFile.read(string)) {
            for (int i = 0; i < configFile.getOptions().size(); ++i) {
                ConfigOption configOption = configFile.getOptions().get(i);
                ConfigOption configOption2 = this.getOptionByName(configOption.getName());
                if (configOption2 == null) continue;
                configOption2.parse(configOption.getValueAsString());
            }
        }
    }

    static {
        keyQpressed = false;
        m_clipperOffset = null;
    }

    public class BooleanDebugOption
    extends BooleanConfigOption {
        public BooleanDebugOption(String string, boolean bl) {
            super(string, bl);
            DebugChunkState.this.options.add(this);
        }
    }

    private class FloodFill {
        private IsoGridSquare start = null;
        private final int FLOOD_SIZE = 11;
        private BooleanGrid visited = new BooleanGrid(11, 11);
        private Stack<IsoGridSquare> stack = new Stack();
        private IsoBuilding building = null;
        private Mover mover = null;

        private FloodFill() {
        }

        void calculate(Mover mover, IsoGridSquare isoGridSquare) {
            this.start = isoGridSquare;
            this.mover = mover;
            if (this.start.getRoom() != null) {
                this.building = this.start.getRoom().getBuilding();
            }
            boolean bl = false;
            boolean bl2 = false;
            if (!this.push(this.start.getX(), this.start.getY())) {
                return;
            }
            while ((isoGridSquare = this.pop()) != null) {
                int n = isoGridSquare.getX();
                int n2 = isoGridSquare.getY();
                while (this.shouldVisit(n, n2, n, n2 - 1)) {
                    --n2;
                }
                bl2 = false;
                bl = false;
                do {
                    this.visited.setValue(this.gridX(n), this.gridY(n2), true);
                    if (!bl && this.shouldVisit(n, n2, n - 1, n2)) {
                        if (!this.push(n - 1, n2)) {
                            return;
                        }
                        bl = true;
                    } else if (bl && !this.shouldVisit(n, n2, n - 1, n2)) {
                        bl = false;
                    } else if (bl && !this.shouldVisit(n - 1, n2, n - 1, n2 - 1) && !this.push(n - 1, n2)) {
                        return;
                    }
                    if (!bl2 && this.shouldVisit(n, n2, n + 1, n2)) {
                        if (!this.push(n + 1, n2)) {
                            return;
                        }
                        bl2 = true;
                        continue;
                    }
                    if (bl2 && !this.shouldVisit(n, n2, n + 1, n2)) {
                        bl2 = false;
                        continue;
                    }
                    if (!bl2 || this.shouldVisit(n + 1, n2, n + 1, n2 - 1) || this.push(n + 1, n2)) continue;
                    return;
                } while (this.shouldVisit(n, ++n2 - 1, n, n2));
            }
        }

        boolean shouldVisit(int n, int n2, int n3, int n4) {
            if (this.gridX(n3) >= 11 || this.gridX(n3) < 0) {
                return false;
            }
            if (this.gridY(n4) >= 11 || this.gridY(n4) < 0) {
                return false;
            }
            if (this.visited.getValue(this.gridX(n3), this.gridY(n4))) {
                return false;
            }
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3, n4, this.start.getZ());
            if (isoGridSquare == null) {
                return false;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBN) || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsTN)) {
                return false;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBW) || isoGridSquare.Has(IsoObjectType.stairsMW) || isoGridSquare.Has(IsoObjectType.stairsTW)) {
                return false;
            }
            if (isoGridSquare.getRoom() != null && this.building == null) {
                return false;
            }
            if (isoGridSquare.getRoom() == null && this.building != null) {
                return false;
            }
            return !IsoWorld.instance.CurrentCell.blocked(this.mover, n3, n4, this.start.getZ(), n, n2, this.start.getZ());
        }

        boolean push(int n, int n2) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, this.start.getZ());
            this.stack.push(isoGridSquare);
            return true;
        }

        IsoGridSquare pop() {
            return this.stack.isEmpty() ? null : this.stack.pop();
        }

        int gridX(int n) {
            return n - (this.start.getX() - 5);
        }

        int gridY(int n) {
            return n - (this.start.getY() - 5);
        }

        int gridX(IsoGridSquare isoGridSquare) {
            return isoGridSquare.getX() - (this.start.getX() - 5);
        }

        int gridY(IsoGridSquare isoGridSquare) {
            return isoGridSquare.getY() - (this.start.getY() - 5);
        }

        void draw() {
            int n = this.start.getX() - 5;
            int n2 = this.start.getY() - 5;
            for (int i = 0; i < 11; ++i) {
                for (int j = 0; j < 11; ++j) {
                    if (!this.visited.getValue(j, i)) continue;
                    int n3 = (int)IsoUtils.XToScreenExact(n + j, n2 + i + 1, this.start.getZ(), 0);
                    int n4 = (int)IsoUtils.YToScreenExact(n + j, n2 + i + 1, this.start.getZ(), 0);
                    SpriteRenderer.instance.renderPoly(n3, n4, n3 + 32, n4 - 16, n3 + 64, n4, n3 + 32, n4 + 16, 1.0f, 1.0f, 0.0f, 0.5f);
                }
            }
        }
    }
}

