/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.SystemDisabler;
import zombie.ZomboidFileSystem;
import zombie.commands.PlayerType;
import zombie.core.Core;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.znet.ISteamWorkshopCallback;
import zombie.core.znet.SteamUGCDetails;
import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshop;
import zombie.core.znet.SteamWorkshopItem;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.erosion.ErosionConfig;
import zombie.gameStates.ChooseGameInfo;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.globalObjects.CGlobalObjects;
import zombie.iso.IsoChunkMap;
import zombie.network.ConnectionManager;
import zombie.network.CoopMaster;
import zombie.network.GameClient;
import zombie.network.ServerOptions;
import zombie.savefile.ClientPlayerDB;
import zombie.world.WorldDictionary;

public final class ConnectToServerState
extends GameState {
    public static ConnectToServerState instance;
    private ByteBuffer connectionDetails;
    private State state;
    private ArrayList<WorkshopItem> workshopItems = new ArrayList();
    private ArrayList<WorkshopItem> confirmItems = new ArrayList();
    private ItemQuery query;

    private static void noise(String string) {
        DebugLog.log("ConnectToServerState: " + string);
    }

    public ConnectToServerState(ByteBuffer byteBuffer) {
        this.connectionDetails = ByteBuffer.allocate(byteBuffer.capacity());
        this.connectionDetails.put(byteBuffer);
        this.connectionDetails.rewind();
    }

    @Override
    public void enter() {
        instance = this;
        ConnectionManager.log("connect-state", State.Start.name().toLowerCase(), null);
        this.state = State.Start;
    }

    @Override
    public GameStateMachine.StateAction update() {
        switch (this.state) {
            case Start: {
                this.Start();
                break;
            }
            case TestTCP: {
                this.TestTCP();
                break;
            }
            case WorkshopInit: {
                this.WorkshopInit();
                break;
            }
            case WorkshopQuery: {
                this.WorkshopQuery();
                break;
            }
            case WorkshopConfirm: {
                this.WorkshopConfirm();
                break;
            }
            case ServerWorkshopItemScreen: {
                this.ServerWorkshopItemScreen();
                break;
            }
            case WorkshopUpdate: {
                this.WorkshopUpdate();
                break;
            }
            case CheckMods: {
                this.CheckMods();
                break;
            }
            case Finish: {
                this.Finish();
                break;
            }
            case Exit: {
                return GameStateMachine.StateAction.Continue;
            }
        }
        return GameStateMachine.StateAction.Remain;
    }

    private void receiveStartLocation(ByteBuffer byteBuffer) {
        LuaEventManager.triggerEvent("OnConnectionStateChanged", "Connected");
        IsoChunkMap.MPWorldXA = byteBuffer.getInt();
        IsoChunkMap.MPWorldYA = byteBuffer.getInt();
        IsoChunkMap.MPWorldZA = byteBuffer.getInt();
        GameClient.username = GameClient.username.trim();
        Core.GameMode = "Multiplayer";
        LuaManager.GlobalObject.createWorld(Core.GameSaveWorld);
        GameClient.instance.bConnected = true;
    }

    private void receiveServerOptions(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            String string = GameWindow.ReadString(byteBuffer);
            String string2 = GameWindow.ReadString(byteBuffer);
            ServerOptions.instance.putOption(string, string2);
        }
        Core.getInstance().ResetLua("client", "ConnectedToServer");
        Core.GameMode = "Multiplayer";
        GameClient.connection.ip = GameClient.ip;
    }

    private void receiveSandboxOptions(ByteBuffer byteBuffer) throws IOException {
        SandboxOptions.instance.load(byteBuffer);
        SandboxOptions.instance.applySettings();
        SandboxOptions.instance.toLua();
    }

    private void receiveGameTime(ByteBuffer byteBuffer) throws IOException {
        GameTime.getInstance().load(byteBuffer);
        GameTime.getInstance().save();
    }

    private void receiveErosionMain(ByteBuffer byteBuffer) {
        GameClient.instance.erosionConfig = new ErosionConfig();
        GameClient.instance.erosionConfig.load(byteBuffer);
    }

    private void receiveGlobalObjects(ByteBuffer byteBuffer) throws IOException {
        CGlobalObjects.loadInitialState(byteBuffer);
    }

    private void receiveResetID(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        GameClient.instance.setResetID(n);
    }

    private void receiveBerries(ByteBuffer byteBuffer) {
        Core.getInstance().setPoisonousBerry(GameWindow.ReadString(byteBuffer));
        GameClient.poisonousBerry = Core.getInstance().getPoisonousBerry();
        Core.getInstance().setPoisonousMushroom(GameWindow.ReadString(byteBuffer));
        GameClient.poisonousMushroom = Core.getInstance().getPoisonousMushroom();
    }

    private void receiveWorldDictionary(ByteBuffer byteBuffer) throws IOException {
        WorldDictionary.loadDataFromServer(byteBuffer);
        ClientPlayerDB.setAllow(true);
        LuaEventManager.triggerEvent("OnConnected");
    }

    private void Start() {
        ConnectToServerState.noise("Start");
        ByteBuffer byteBuffer = this.connectionDetails;
        GameClient.connection.isCoopHost = byteBuffer.get() == 1;
        GameClient.connection.maxPlayers = byteBuffer.getInt();
        if (byteBuffer.get() == 1) {
            long l = byteBuffer.getLong();
            String string = GameWindow.ReadStringUTF(byteBuffer);
            Core.GameSaveWorld = l + "_" + string + "_player";
        }
        GameClient.instance.ID = byteBuffer.get();
        ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.TestTCP.name().toLowerCase(), null);
        this.state = State.TestTCP;
    }

    private void TestTCP() {
        ConnectToServerState.noise("TestTCP");
        ByteBuffer byteBuffer = this.connectionDetails;
        GameClient.connection.accessLevel = PlayerType.fromString(GameWindow.ReadStringUTF(byteBuffer));
        if (!SystemDisabler.getAllowDebugConnections() && Core.bDebug && !SystemDisabler.getOverrideServerConnectDebugCheck() && GameClient.connection.accessLevel != 32 && !CoopMaster.instance.isRunning()) {
            LuaEventManager.triggerEvent("OnConnectFailed", Translator.getText("UI_OnConnectFailed_DebugNotAllowed"));
            GameClient.connection.forceDisconnect("connect-debug-used");
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.Exit.name().toLowerCase(), null);
            this.state = State.Exit;
            return;
        }
        GameClient.GameMap = GameWindow.ReadStringUTF(byteBuffer);
        if (GameClient.GameMap.contains(";")) {
            String[] stringArray = GameClient.GameMap.split(";");
            Core.GameMap = stringArray[0].trim();
        } else {
            Core.GameMap = GameClient.GameMap.trim();
        }
        if (SteamUtils.isSteamModeEnabled()) {
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.WorkshopInit.name().toLowerCase(), null);
            this.state = State.WorkshopInit;
        } else {
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.CheckMods.name().toLowerCase(), null);
            this.state = State.CheckMods;
        }
    }

    private void WorkshopInit() {
        ByteBuffer byteBuffer = this.connectionDetails;
        int n = byteBuffer.getShort();
        for (int i = 0; i < n; ++i) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            WorkshopItem workshopItem = new WorkshopItem(l, l2);
            this.workshopItems.add(workshopItem);
        }
        if (this.workshopItems.isEmpty()) {
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.WorkshopUpdate.name().toLowerCase(), null);
            this.state = State.WorkshopUpdate;
            return;
        }
        long[] lArray = new long[this.workshopItems.size()];
        for (int i = 0; i < this.workshopItems.size(); ++i) {
            WorkshopItem workshopItem = this.workshopItems.get(i);
            lArray[i] = workshopItem.ID;
        }
        this.query = new ItemQuery();
        this.query.handle = SteamWorkshop.instance.CreateQueryUGCDetailsRequest(lArray, this.query);
        if (this.query.handle != 0L) {
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.WorkshopQuery.name().toLowerCase(), null);
            this.state = State.WorkshopQuery;
        } else {
            this.query = null;
            LuaEventManager.triggerEvent("OnConnectFailed", Translator.getText("UI_OnConnectFailed_CreateQueryUGCDetailsRequest"));
            GameClient.connection.forceDisconnect("connect-workshop-query");
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.Exit.name().toLowerCase(), null);
            this.state = State.Exit;
        }
    }

    private void WorkshopConfirm() {
        this.confirmItems.clear();
        for (int i = 0; i < this.workshopItems.size(); ++i) {
            WorkshopItem workshopItem = this.workshopItems.get(i);
            long l = SteamWorkshop.instance.GetItemState(workshopItem.ID);
            ConnectToServerState.noise("WorkshopConfirm GetItemState()=" + SteamWorkshopItem.ItemState.toString(l) + " ID=" + workshopItem.ID);
            if (SteamWorkshopItem.ItemState.Installed.and(l) && SteamWorkshopItem.ItemState.NeedsUpdate.not(l) && workshopItem.details != null && workshopItem.details.getTimeCreated() != 0L && workshopItem.details.getTimeUpdated() != SteamWorkshop.instance.GetItemInstallTimeStamp(workshopItem.ID)) {
                ConnectToServerState.noise("Installed status but timeUpdated doesn't match!!!");
                l |= (long)SteamWorkshopItem.ItemState.NeedsUpdate.getValue();
            }
            if (l == (long)(SteamWorkshopItem.ItemState.Subscribed.getValue() | SteamWorkshopItem.ItemState.Installed.getValue())) continue;
            this.confirmItems.add(workshopItem);
        }
        if (this.confirmItems.isEmpty()) {
            this.query = null;
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.WorkshopUpdate.name().toLowerCase(), null);
            this.state = State.WorkshopUpdate;
        } else if (this.query == null) {
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.WorkshopUpdate.name().toLowerCase(), null);
            this.state = State.WorkshopUpdate;
        } else {
            assert (this.query.isCompleted());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.workshopItems.size(); ++i) {
                WorkshopItem workshopItem = this.workshopItems.get(i);
                arrayList.add(SteamUtils.convertSteamIDToString(workshopItem.ID));
            }
            LuaEventManager.triggerEvent("OnServerWorkshopItems", "Required", arrayList);
            ArrayList<SteamUGCDetails> arrayList2 = this.query.details;
            this.query = null;
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.ServerWorkshopItemScreen.name().toLowerCase(), null);
            this.state = State.ServerWorkshopItemScreen;
            LuaEventManager.triggerEvent("OnServerWorkshopItems", "Details", arrayList2);
        }
    }

    private void WorkshopQuery() {
        if (this.query.isCompleted()) {
            block0: for (SteamUGCDetails steamUGCDetails : this.query.details) {
                for (WorkshopItem workshopItem : this.workshopItems) {
                    if (workshopItem.ID != steamUGCDetails.getID()) continue;
                    workshopItem.details = steamUGCDetails;
                    continue block0;
                }
            }
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.WorkshopConfirm.name().toLowerCase(), null);
            this.state = State.WorkshopConfirm;
            return;
        }
        if (this.query.isNotCompleted()) {
            this.query = null;
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.ServerWorkshopItemScreen.name().toLowerCase(), null);
            this.state = State.ServerWorkshopItemScreen;
            LuaEventManager.triggerEvent("OnServerWorkshopItems", "Error", "ItemQueryNotCompleted");
            return;
        }
    }

    private void ServerWorkshopItemScreen() {
    }

    private void WorkshopUpdate() {
        for (int i = 0; i < this.workshopItems.size(); ++i) {
            WorkshopItem workshopItem = this.workshopItems.get(i);
            workshopItem.update();
            if (workshopItem.state == WorkshopItemState.Fail) {
                ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.ServerWorkshopItemScreen.name().toLowerCase(), null);
                this.state = State.ServerWorkshopItemScreen;
                LuaEventManager.triggerEvent("OnServerWorkshopItems", "Error", workshopItem.ID, workshopItem.error);
                return;
            }
            if (workshopItem.state == WorkshopItemState.Ready) continue;
            return;
        }
        ZomboidFileSystem.instance.resetModFolders();
        LuaEventManager.triggerEvent("OnServerWorkshopItems", "Success");
        ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.CheckMods.name().toLowerCase(), null);
        this.state = State.CheckMods;
    }

    private void CheckMods() {
        Object object;
        ByteBuffer byteBuffer = this.connectionDetails;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            object = new ChooseGameInfo.Mod(GameWindow.ReadStringUTF(byteBuffer));
            ((ChooseGameInfo.Mod)object).setUrl(GameWindow.ReadStringUTF(byteBuffer));
            ((ChooseGameInfo.Mod)object).setName(GameWindow.ReadStringUTF(byteBuffer));
            arrayList.add(((ChooseGameInfo.Mod)object).getDir());
            hashMap.put(((ChooseGameInfo.Mod)object).getDir(), object);
        }
        GameClient.instance.ServerMods.clear();
        GameClient.instance.ServerMods.addAll(arrayList);
        arrayList.clear();
        String string = ZomboidFileSystem.instance.loadModsAux(GameClient.instance.ServerMods, arrayList);
        if (string != null) {
            object = Translator.getText("UI_OnConnectFailed_ModRequired", string);
            if (hashMap.get(string) != null && !"".equals(((ChooseGameInfo.Mod)hashMap.get(string)).getUrl())) {
                object = (String)object + " MODURL=" + ((ChooseGameInfo.Mod)hashMap.get(string)).getUrl();
            }
            LuaEventManager.triggerEvent("OnConnectFailed", object);
            GameClient.connection.forceDisconnect("connect-mod-required");
            ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.Exit.name().toLowerCase(), null);
            this.state = State.Exit;
            return;
        }
        ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.Finish.name().toLowerCase(), null);
        this.state = State.Finish;
    }

    private void Finish() {
        ByteBuffer byteBuffer = this.connectionDetails;
        try {
            try {
                this.receiveStartLocation(byteBuffer);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "receiveStartLocation error", LogSeverity.Error);
                throw exception;
            }
            try {
                this.receiveServerOptions(byteBuffer);
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "receiveServerOptions error", LogSeverity.Error);
                throw iOException;
            }
            try {
                this.receiveSandboxOptions(byteBuffer);
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "receiveSandboxOptions error", LogSeverity.Error);
                throw iOException;
            }
            try {
                this.receiveGameTime(byteBuffer);
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "receiveGameTime error", LogSeverity.Error);
                throw iOException;
            }
            try {
                this.receiveErosionMain(byteBuffer);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "receiveErosionMain error", LogSeverity.Error);
                throw exception;
            }
            try {
                this.receiveGlobalObjects(byteBuffer);
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "receiveGlobalObjects error", LogSeverity.Error);
                throw iOException;
            }
            try {
                this.receiveResetID(byteBuffer);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "receiveResetID error", LogSeverity.Error);
                throw exception;
            }
            try {
                this.receiveBerries(byteBuffer);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "receiveBerries error", LogSeverity.Error);
                throw exception;
            }
            try {
                this.receiveWorldDictionary(byteBuffer);
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "receiveWorldDictionary error", LogSeverity.Error);
                throw iOException;
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            LuaEventManager.triggerEvent("OnConnectFailed", "WorldDictionary error");
            GameClient.connection.forceDisconnect("connection-details-error");
        }
        ConnectionManager.log("connect-state-" + this.state.name().toLowerCase(), State.Exit.name().toLowerCase(), null);
        this.state = State.Exit;
    }

    public void FromLua(String string) {
        if (this.state != State.ServerWorkshopItemScreen) {
            throw new IllegalStateException("state != ServerWorkshopItemScreen");
        }
        if ("install".equals(string)) {
            ConnectionManager.log("connect-state-lua-" + this.state.name().toLowerCase(), State.WorkshopUpdate.name().toLowerCase(), null);
            this.state = State.WorkshopUpdate;
            return;
        }
        if ("disconnect".equals(string)) {
            LuaEventManager.triggerEvent("OnConnectFailed", "ServerWorkshopItemsCancelled");
            if (GameClient.connection != null) {
                GameClient.connection.forceDisconnect("connect-workshop-canceled");
            }
            ConnectionManager.log("connect-state-lua-" + this.state.name().toLowerCase(), State.Exit.name().toLowerCase(), null);
            this.state = State.Exit;
            return;
        }
    }

    @Override
    public void exit() {
        instance = null;
    }

    private static enum State {
        Start,
        TestTCP,
        WorkshopInit,
        WorkshopQuery,
        WorkshopConfirm,
        ServerWorkshopItemScreen,
        WorkshopUpdate,
        CheckMods,
        Finish,
        Exit;

    }

    private static final class WorkshopItem
    implements ISteamWorkshopCallback {
        long ID;
        long serverTimeStamp;
        WorkshopItemState state = WorkshopItemState.CheckItemState;
        boolean subscribed;
        long downloadStartTime;
        long downloadQueryTime;
        String error;
        SteamUGCDetails details;

        WorkshopItem(long l, long l2) {
            this.ID = l;
            this.serverTimeStamp = l2;
        }

        void update() {
            switch (this.state) {
                case CheckItemState: {
                    this.CheckItemState();
                    break;
                }
                case SubscribePending: {
                    this.SubscribePending();
                    break;
                }
                case DownloadPending: {
                    this.DownloadPending();
                    break;
                }
            }
        }

        void setState(WorkshopItemState workshopItemState) {
            ConnectToServerState.noise("item state " + this.state + " -> " + workshopItemState + " ID=" + this.ID);
            this.state = workshopItemState;
        }

        void CheckItemState() {
            long l = SteamWorkshop.instance.GetItemState(this.ID);
            ConnectToServerState.noise("GetItemState()=" + SteamWorkshopItem.ItemState.toString(l) + " ID=" + this.ID);
            if (!SteamWorkshopItem.ItemState.Subscribed.and(l)) {
                if (SteamWorkshop.instance.SubscribeItem(this.ID, this)) {
                    this.setState(WorkshopItemState.SubscribePending);
                    return;
                }
                this.error = "SubscribeItemFalse";
                this.setState(WorkshopItemState.Fail);
                return;
            }
            if (SteamWorkshopItem.ItemState.Installed.and(l) && SteamWorkshopItem.ItemState.NeedsUpdate.not(l) && this.details != null && this.details.getTimeCreated() != 0L && this.details.getTimeUpdated() != SteamWorkshop.instance.GetItemInstallTimeStamp(this.ID)) {
                ConnectToServerState.noise("Installed status but timeUpdated doesn't match!!!");
                l |= (long)SteamWorkshopItem.ItemState.NeedsUpdate.getValue();
            }
            if (SteamWorkshopItem.ItemState.NeedsUpdate.and(l)) {
                if (SteamWorkshop.instance.DownloadItem(this.ID, true, this)) {
                    this.setState(WorkshopItemState.DownloadPending);
                    this.downloadStartTime = System.currentTimeMillis();
                    return;
                }
                this.error = "DownloadItemFalse";
                this.setState(WorkshopItemState.Fail);
                return;
            }
            if (SteamWorkshopItem.ItemState.Installed.and(l)) {
                long l2 = SteamWorkshop.instance.GetItemInstallTimeStamp(this.ID);
                if (l2 == 0L) {
                    this.error = "GetItemInstallTimeStamp";
                    this.setState(WorkshopItemState.Fail);
                    return;
                }
                if (l2 != this.serverTimeStamp) {
                    this.error = "VersionMismatch";
                    this.setState(WorkshopItemState.Fail);
                    return;
                }
                this.setState(WorkshopItemState.Ready);
                return;
            }
            this.error = "UnknownItemState";
            this.setState(WorkshopItemState.Fail);
        }

        void SubscribePending() {
            long l;
            if (this.subscribed && SteamWorkshopItem.ItemState.Subscribed.and(l = SteamWorkshop.instance.GetItemState(this.ID))) {
                this.setState(WorkshopItemState.CheckItemState);
            }
        }

        void DownloadPending() {
            long l = System.currentTimeMillis();
            if (this.downloadQueryTime + 100L > l) {
                return;
            }
            this.downloadQueryTime = l;
            long l2 = SteamWorkshop.instance.GetItemState(this.ID);
            if (SteamWorkshopItem.ItemState.NeedsUpdate.and(l2)) {
                long[] lArray = new long[2];
                if (SteamWorkshop.instance.GetItemDownloadInfo(this.ID, lArray)) {
                    ConnectToServerState.noise("download " + lArray[0] + "/" + lArray[1] + " ID=" + this.ID);
                    LuaEventManager.triggerEvent("OnServerWorkshopItems", "Progress", SteamUtils.convertSteamIDToString(this.ID), lArray[0], Math.max(lArray[1], 1L));
                }
                return;
            }
        }

        @Override
        public void onItemCreated(long l, boolean bl) {
        }

        @Override
        public void onItemNotCreated(int n) {
        }

        @Override
        public void onItemUpdated(boolean bl) {
        }

        @Override
        public void onItemNotUpdated(int n) {
        }

        @Override
        public void onItemSubscribed(long l) {
            ConnectToServerState.noise("onItemSubscribed itemID=" + l);
            if (l != this.ID) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            this.subscribed = true;
        }

        @Override
        public void onItemNotSubscribed(long l, int n) {
            ConnectToServerState.noise("onItemNotSubscribed itemID=" + l + " result=" + n);
            if (l != this.ID) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            this.error = "ItemNotSubscribed";
            this.setState(WorkshopItemState.Fail);
        }

        @Override
        public void onItemDownloaded(long l) {
            ConnectToServerState.noise("onItemDownloaded itemID=" + l + " time=" + (System.currentTimeMillis() - this.downloadStartTime) + " ms");
            if (l != this.ID) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            this.setState(WorkshopItemState.CheckItemState);
        }

        @Override
        public void onItemNotDownloaded(long l, int n) {
            ConnectToServerState.noise("onItemNotDownloaded itemID=" + l + " result=" + n);
            if (l != this.ID) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            this.error = "ItemNotDownloaded";
            this.setState(WorkshopItemState.Fail);
        }

        @Override
        public void onItemQueryCompleted(long l, int n) {
        }

        @Override
        public void onItemQueryNotCompleted(long l, int n) {
        }
    }

    private class ItemQuery
    implements ISteamWorkshopCallback {
        long handle;
        ArrayList<SteamUGCDetails> details;
        boolean bCompleted;
        boolean bNotCompleted;

        private ItemQuery() {
        }

        public boolean isCompleted() {
            return this.bCompleted;
        }

        public boolean isNotCompleted() {
            return this.bNotCompleted;
        }

        @Override
        public void onItemCreated(long l, boolean bl) {
        }

        @Override
        public void onItemNotCreated(int n) {
        }

        @Override
        public void onItemUpdated(boolean bl) {
        }

        @Override
        public void onItemNotUpdated(int n) {
        }

        @Override
        public void onItemSubscribed(long l) {
        }

        @Override
        public void onItemNotSubscribed(long l, int n) {
        }

        @Override
        public void onItemDownloaded(long l) {
        }

        @Override
        public void onItemNotDownloaded(long l, int n) {
        }

        @Override
        public void onItemQueryCompleted(long l, int n) {
            ConnectToServerState.noise("onItemQueryCompleted handle=" + l + " numResult=" + n);
            if (l != this.handle) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            ArrayList<SteamUGCDetails> arrayList = new ArrayList<SteamUGCDetails>();
            for (int i = 0; i < n; ++i) {
                SteamUGCDetails steamUGCDetails = SteamWorkshop.instance.GetQueryUGCResult(l, i);
                if (steamUGCDetails == null) continue;
                arrayList.add(steamUGCDetails);
            }
            this.details = arrayList;
            SteamWorkshop.instance.ReleaseQueryUGCRequest(l);
            this.bCompleted = true;
        }

        @Override
        public void onItemQueryNotCompleted(long l, int n) {
            ConnectToServerState.noise("onItemQueryNotCompleted handle=" + l + " result=" + n);
            if (l != this.handle) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            SteamWorkshop.instance.ReleaseQueryUGCRequest(l);
            this.bNotCompleted = true;
        }
    }

    private static enum WorkshopItemState {
        CheckItemState,
        SubscribePending,
        DownloadPending,
        Ready,
        Fail;

    }
}

