/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.GameVersion;
import zombie.core.Language;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.textures.Texture;
import zombie.core.znet.SteamWorkshop;
import zombie.debug.DebugLog;
import zombie.util.StringUtils;

public final class ChooseGameInfo {
    private static final HashMap<String, Map> Maps = new HashMap();
    private static final HashMap<String, Mod> Mods = new HashMap();
    private static final HashSet<String> MissingMods = new HashSet();
    private static final ArrayList<String> tempStrings = new ArrayList();

    private ChooseGameInfo() {
    }

    public static void Reset() {
        Maps.clear();
        Mods.clear();
        MissingMods.clear();
    }

    private static void readTitleDotTxt(Map map, String string, Language language) throws IOException {
        String string2 = "media/lua/shared/Translate/" + language.toString() + "/" + string + "/title.txt";
        File file = new File(ZomboidFileSystem.instance.getString(string2));
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName(language.charset()));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string3 = bufferedReader.readLine();
            string3 = StringUtils.stripBOM(string3);
            if (!StringUtils.isNullOrWhitespace(string3)) {
                map.title = string3.trim();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static void readDescriptionDotTxt(Map map, String string, Language language) throws IOException {
        String string2 = "media/lua/shared/Translate/" + language.toString() + "/" + string + "/description.txt";
        File file = new File(ZomboidFileSystem.instance.getString(string2));
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName(language.charset()));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string3;
            map.desc = "";
            boolean bl = true;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (bl) {
                    string3 = StringUtils.stripBOM(string3);
                    bl = false;
                }
                map.desc = map.desc + string3;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static Map getMapDetails(String string) {
        if (Maps.containsKey(string)) {
            return Maps.get(string);
        }
        File file = new File(ZomboidFileSystem.instance.getString("media/maps/" + string + "/map.info"));
        if (!file.exists()) {
            return null;
        }
        Map map = new Map();
        map.dir = new File(file.getParent()).getAbsolutePath();
        map.title = string;
        map.lotsDir = new ArrayList();
        try {
            FileReader fileReader = new FileReader(file.getAbsolutePath());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = null;
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).startsWith("title=")) {
                        map.title = string2.replace("title=", "");
                        continue;
                    }
                    if (string2.startsWith("lots=")) {
                        map.lotsDir.add(string2.replace("lots=", "").trim());
                        continue;
                    }
                    if (string2.startsWith("description=")) {
                        if (map.desc == null) {
                            map.desc = "";
                        }
                        map.desc = map.desc + string2.replace("description=", "");
                        continue;
                    }
                    if (!string2.startsWith("fixed2x=")) continue;
                    map.bFixed2x = Boolean.parseBoolean(string2.replace("fixed2x=", "").trim());
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ChooseGameInfo.class.getName()).log(Level.SEVERE, null, iOException);
            }
            bufferedReader.close();
            map.thumb = Texture.getSharedTexture(map.dir + "/thumb.png");
            ArrayList<Language> arrayList = new ArrayList<Language>();
            Translator.addLanguageToList(Translator.getLanguage(), arrayList);
            Translator.addLanguageToList(Translator.getDefaultLanguage(), arrayList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Language language = arrayList.get(i);
                ChooseGameInfo.readTitleDotTxt(map, string, language);
                ChooseGameInfo.readDescriptionDotTxt(map, string, language);
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return null;
        }
        Maps.put(string, map);
        return map;
    }

    public static Mod getModDetails(String string) {
        Object object;
        if (MissingMods.contains(string)) {
            return null;
        }
        if (Mods.containsKey(string)) {
            return Mods.get(string);
        }
        String string2 = ZomboidFileSystem.instance.getModDir(string);
        if (string2 == null) {
            object = tempStrings;
            ZomboidFileSystem.instance.getAllModFolders((List<String>)object);
            ArrayList<Mod> arrayList = new ArrayList<Mod>();
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                File file = new File((String)((ArrayList)object).get(i), "mod.info");
                arrayList.clear();
                Mod mod = ZomboidFileSystem.instance.searchForModInfo(file, string, arrayList);
                for (int j = 0; j < arrayList.size(); ++j) {
                    Mod mod2 = arrayList.get(j);
                    Mods.putIfAbsent(mod2.getId(), mod2);
                }
                if (mod == null) continue;
                return mod;
            }
        }
        if ((object = ChooseGameInfo.readModInfo(string2)) == null) {
            MissingMods.add(string);
        }
        return object;
    }

    public static Mod getAvailableModDetails(String string) {
        Mod mod = ChooseGameInfo.getModDetails(string);
        if (mod != null && mod.isAvailable()) {
            return mod;
        }
        return null;
    }

    public static Mod readModInfo(String string) {
        Mod mod = ChooseGameInfo.readModInfoAux(string);
        if (mod != null) {
            Mod mod2 = Mods.get(mod.getId());
            if (mod2 == null) {
                Mods.put(mod.getId(), mod);
            } else if (mod2 != mod) {
                ZomboidFileSystem.instance.getAllModFolders(tempStrings);
                int n = tempStrings.indexOf(mod.getDir());
                int n2 = tempStrings.indexOf(mod2.getDir());
                if (n < n2) {
                    Mods.put(mod.getId(), mod);
                }
            }
        }
        return mod;
    }

    /*
     * Exception decompiling
     */
    private static Mod readModInfoAux(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 43[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final class Map {
        private String dir;
        private Texture thumb;
        private String title;
        private ArrayList<String> lotsDir;
        private String desc;
        private boolean bFixed2x;

        public String getDirectory() {
            return this.dir;
        }

        public void setDirectory(String string) {
            this.dir = string;
        }

        public Texture getThumbnail() {
            return this.thumb;
        }

        public void setThumbnail(Texture texture) {
            this.thumb = texture;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public ArrayList<String> getLotDirectories() {
            return this.lotsDir;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String string) {
            this.desc = string;
        }

        public boolean isFixed2x() {
            return this.bFixed2x;
        }

        public void setFixed2x(boolean bl) {
            this.bFixed2x = bl;
        }
    }

    public static final class Mod {
        public String dir;
        public final File baseFile;
        public final File mediaFile;
        public final File actionGroupsFile;
        public final File animSetsFile;
        public final File animsXFile;
        private final ArrayList<String> posters = new ArrayList();
        public Texture tex;
        private ArrayList<String> require;
        private String name = "Unnamed Mod";
        private String desc = "";
        private String id;
        private String url;
        private String workshopID;
        private boolean bAvailableDone = false;
        private boolean available = true;
        private GameVersion versionMin;
        private GameVersion versionMax;
        private final ArrayList<PackFile> packs = new ArrayList();
        private final ArrayList<TileDef> tileDefs = new ArrayList();
        private boolean bRead = false;
        private boolean bValid = false;

        public Mod(String string) {
            this.dir = string;
            File file = new File(string).getAbsoluteFile();
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            this.baseFile = file;
            this.mediaFile = new File(file, "media");
            this.actionGroupsFile = new File(this.mediaFile, "actiongroups");
            this.animSetsFile = new File(this.mediaFile, "AnimSets");
            this.animsXFile = new File(this.mediaFile, "anims_X");
            File file2 = file.getParentFile();
            if (file2 != null && (file2 = file2.getParentFile()) != null) {
                this.workshopID = SteamWorkshop.instance.getIDFromItemInstallFolder(file2.getAbsolutePath());
            }
        }

        public Texture getTexture() {
            if (this.tex == null) {
                String string;
                String string2 = string = this.posters.isEmpty() ? null : this.posters.get(0);
                if (!StringUtils.isNullOrWhitespace(string)) {
                    this.tex = Texture.getSharedTexture(string);
                }
                if (this.tex == null || this.tex.isFailure()) {
                    if (Core.bDebug && this.tex == null) {
                        DebugLog.Mod.println("failed to load poster " + (string == null ? this.id : string));
                    }
                    this.tex = Texture.getWhite();
                }
            }
            return this.tex;
        }

        public void setTexture(Texture texture) {
            this.tex = texture;
        }

        public int getPosterCount() {
            return this.posters.size();
        }

        public String getPoster(int n) {
            if (n >= 0 && n < this.posters.size()) {
                return this.posters.get(n);
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDir() {
            return this.dir;
        }

        public String getDescription() {
            return this.desc;
        }

        public ArrayList<String> getRequire() {
            return this.require;
        }

        public void setRequire(ArrayList<String> arrayList) {
            this.require = arrayList;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public boolean isAvailable() {
            if (this.bAvailableDone) {
                return this.available;
            }
            this.bAvailableDone = true;
            if (!this.isAvailableSelf()) {
                this.available = false;
                return false;
            }
            tempStrings.clear();
            tempStrings.add(this.getId());
            if (!this.isAvailableRequired(tempStrings)) {
                this.available = false;
                return false;
            }
            this.available = true;
            return true;
        }

        private boolean isAvailableSelf() {
            GameVersion gameVersion = Core.getInstance().getGameVersion();
            if (this.versionMin != null && this.versionMin.isGreaterThan(gameVersion)) {
                return false;
            }
            return this.versionMax == null || !this.versionMax.isLessThan(gameVersion);
        }

        private boolean isAvailableRequired(ArrayList<String> arrayList) {
            if (this.require == null || this.require.isEmpty()) {
                return true;
            }
            for (int i = 0; i < this.require.size(); ++i) {
                String string = this.require.get(i).trim();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
                Mod mod = ChooseGameInfo.getModDetails(string);
                if (mod == null) {
                    return false;
                }
                if (!mod.isAvailableSelf()) {
                    return false;
                }
                if (mod.isAvailableRequired(arrayList)) continue;
                return false;
            }
            return true;
        }

        @Deprecated
        public void setAvailable(boolean bl) {
        }

        public String getUrl() {
            if (this.url == null) {
                return "";
            }
            return this.url;
        }

        public void setUrl(String string) {
            if (string.startsWith("http://theindiestone.com") || string.startsWith("http://www.theindiestone.com") || string.startsWith("http://pz-mods.net") || string.startsWith("http://www.pz-mods.net")) {
                this.url = string;
            }
        }

        public GameVersion getVersionMin() {
            return this.versionMin;
        }

        public GameVersion getVersionMax() {
            return this.versionMax;
        }

        public void addPack(String string, int n) {
            this.packs.add(new PackFile(string, n));
        }

        public void addTileDef(String string, int n) {
            this.tileDefs.add(new TileDef(string, n));
        }

        public ArrayList<PackFile> getPacks() {
            return this.packs;
        }

        public ArrayList<TileDef> getTileDefs() {
            return this.tileDefs;
        }

        public String getWorkshopID() {
            return this.workshopID;
        }
    }

    public static final class TileDef {
        public String name;
        public int fileNumber;

        public TileDef(String string, int n) {
            this.name = string;
            this.fileNumber = n;
        }
    }

    public static final class PackFile {
        public final String name;
        public final int flags;

        public PackFile(String string, int n) {
            this.name = string;
            this.flags = n;
        }
    }

    public static final class SpawnOrigin {
        public int x;
        public int y;
        public int w;
        public int h;

        public SpawnOrigin(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }
    }
}

