/*
 * Decompiled with CFR 0.152.
 */
package zombie.fileSystem;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import zombie.fileSystem.FileSeekMode;
import zombie.fileSystem.IFile;
import zombie.fileSystem.IFileDevice;

public final class MemoryFileDevice
implements IFileDevice {
    @Override
    public IFile createFile(IFile iFile) {
        return new MemoryFile(iFile, this);
    }

    @Override
    public void destroyFile(IFile iFile) {
    }

    @Override
    public InputStream createStream(String string, InputStream inputStream) throws IOException {
        return null;
    }

    @Override
    public void destroyStream(InputStream inputStream) {
    }

    @Override
    public String name() {
        return "memory";
    }

    private static class MemoryFile
    implements IFile {
        final MemoryFileDevice m_device;
        byte[] m_buffer;
        long m_size;
        long m_pos;
        IFile m_file;
        boolean m_write;

        MemoryFile(IFile iFile, MemoryFileDevice memoryFileDevice) {
            this.m_device = memoryFileDevice;
            this.m_buffer = null;
            this.m_size = 0L;
            this.m_pos = 0L;
            this.m_file = iFile;
            this.m_write = false;
        }

        @Override
        public boolean open(String string, int n) {
            assert (this.m_buffer == null);
            boolean bl = this.m_write = (n & 2) != 0;
            if (this.m_file != null) {
                if (this.m_file.open(string, n)) {
                    if ((n & 1) != 0) {
                        this.m_size = this.m_file.size();
                        this.m_buffer = new byte[(int)this.m_size];
                        this.m_file.read(this.m_buffer, this.m_size);
                        this.m_pos = 0L;
                    }
                    return true;
                }
            } else if ((n & 2) != 0) {
                return true;
            }
            return false;
        }

        @Override
        public void close() {
            if (this.m_file != null) {
                if (this.m_write) {
                    this.m_file.seek(FileSeekMode.BEGIN, 0L);
                    this.m_file.write(this.m_buffer, this.m_size);
                }
                this.m_file.close();
            }
            this.m_buffer = null;
        }

        @Override
        public boolean read(byte[] byArray, long l) {
            long l2 = this.m_pos + l < this.m_size ? l : this.m_size - this.m_pos;
            System.arraycopy(this.m_buffer, (int)this.m_pos, byArray, 0, (int)l2);
            this.m_pos += l2;
            return false;
        }

        @Override
        public boolean write(byte[] byArray, long l) {
            long l2 = this.m_pos;
            long l3 = this.m_buffer.length;
            long l4 = this.m_size;
            if (l2 + l > l3) {
                long l5 = Math.max(l3 * 2L, l2 + l);
                this.m_buffer = Arrays.copyOf(this.m_buffer, (int)l5);
            }
            System.arraycopy(byArray, 0, this.m_buffer, (int)l2, (int)l);
            this.m_pos += l;
            this.m_size = l2 + l > l4 ? l2 + l : l4;
            return true;
        }

        @Override
        public byte[] getBuffer() {
            return this.m_buffer;
        }

        @Override
        public long size() {
            return this.m_size;
        }

        @Override
        public boolean seek(FileSeekMode fileSeekMode, long l) {
            switch (fileSeekMode) {
                case BEGIN: {
                    assert (l <= this.m_size);
                    this.m_pos = l;
                    break;
                }
                case CURRENT: {
                    assert (0L <= this.m_pos + l && this.m_pos + l <= this.m_size);
                    this.m_pos += l;
                    break;
                }
                case END: {
                    assert (l <= this.m_size);
                    this.m_pos = this.m_size - l;
                }
            }
            boolean bl = this.m_pos <= this.m_size;
            this.m_pos = Math.min(this.m_pos, this.m_size);
            return bl;
        }

        @Override
        public long pos() {
            return this.m_pos;
        }

        @Override
        public InputStream getInputStream() {
            if (this.m_file != null) {
                return this.m_file.getInputStream();
            }
            return null;
        }

        @Override
        public IFileDevice getDevice() {
            return this.m_device;
        }

        @Override
        public void release() {
            this.m_buffer = null;
        }
    }
}

