/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.obj;

import java.util.ArrayList;
import zombie.erosion.ErosionMain;
import zombie.erosion.obj.ErosionObjSprites;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.objects.IsoTree;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.util.list.PZArrayList;

public final class ErosionObj {
    private final ErosionObjSprites sprites;
    public String name;
    public int stages;
    public boolean hasSnow;
    public boolean hasFlower;
    public boolean hasChildSprite;
    public float bloomStart;
    public float bloomEnd;
    public boolean noSeasonBase;
    public int cycleTime = 1;

    public ErosionObj(ErosionObjSprites erosionObjSprites, int n, float f, float f2, boolean bl) {
        this.sprites = erosionObjSprites;
        this.name = erosionObjSprites.name;
        this.stages = erosionObjSprites.stages;
        this.hasSnow = erosionObjSprites.hasSnow;
        this.hasFlower = erosionObjSprites.hasFlower;
        this.hasChildSprite = erosionObjSprites.hasChildSprite;
        this.bloomStart = f;
        this.bloomEnd = f2;
        this.noSeasonBase = bl;
        this.cycleTime = n;
    }

    public IsoObject getObject(IsoGridSquare isoGridSquare, boolean bl) {
        PZArrayList<IsoObject> pZArrayList = isoGridSquare.getObjects();
        for (int i = pZArrayList.size() - 1; i >= 0; --i) {
            IsoObject isoObject = pZArrayList.get(i);
            if (!this.name.equals(isoObject.getName())) continue;
            if (bl) {
                pZArrayList.remove(i);
            }
            isoObject.doNotSync = true;
            return isoObject;
        }
        return null;
    }

    public IsoObject createObject(IsoGridSquare isoGridSquare, int n, boolean bl, int n2) {
        IsoObject isoObject;
        String string = this.sprites.getBase(n, this.noSeasonBase ? 0 : n2);
        if (string == null) {
            string = "";
        }
        if (bl) {
            isoObject = IsoTree.getNew();
            isoObject.sprite = IsoSpriteManager.instance.NamedMap.get(string);
            isoObject.square = isoGridSquare;
            isoObject.sx = 0.0f;
            ((IsoTree)isoObject).initTree();
        } else {
            isoObject = IsoObject.getNew(isoGridSquare, string, this.name, false);
        }
        isoObject.setName(this.name);
        isoObject.doNotSync = true;
        return isoObject;
    }

    public boolean placeObject(IsoGridSquare isoGridSquare, int n, boolean bl, int n2, boolean bl2) {
        IsoObject isoObject = this.createObject(isoGridSquare, n, bl, n2);
        if (isoObject != null && this.setStageObject(n, isoObject, n2, bl2)) {
            isoObject.doNotSync = true;
            if (!bl) {
                isoGridSquare.getObjects().add(isoObject);
                isoObject.addToWorld();
            } else {
                isoGridSquare.AddTileObject(isoObject);
            }
            return true;
        }
        return false;
    }

    public boolean setStageObject(int n, IsoObject isoObject, int n2, boolean bl) {
        IsoObject isoObject2 = isoObject;
        isoObject2.doNotSync = true;
        if (n >= 0 && n < this.stages && isoObject2 != null) {
            String string = this.sprites.getBase(n, this.noSeasonBase ? 0 : n2);
            if (string == null) {
                isoObject2.setSprite(this.getSprite(""));
                if (isoObject2.AttachedAnimSprite != null) {
                    isoObject2.AttachedAnimSprite.clear();
                }
                return true;
            }
            IsoSprite isoSprite = this.getSprite(string);
            isoObject2.setSprite(isoSprite);
            if (this.hasChildSprite || this.hasFlower) {
                if (isoObject2.AttachedAnimSprite == null) {
                    isoObject2.AttachedAnimSprite = new ArrayList();
                }
                isoObject2.AttachedAnimSprite.clear();
                if (this.hasChildSprite && n2 != 0 && (string = this.sprites.getChildSprite(n, n2)) != null) {
                    isoSprite = this.getSprite(string);
                    isoObject2.AttachedAnimSprite.add(isoSprite.newInstance());
                }
                if (this.hasFlower && bl && (string = this.sprites.getFlower(n)) != null) {
                    isoSprite = this.getSprite(string);
                    isoObject2.AttachedAnimSprite.add(isoSprite.newInstance());
                }
            }
            return true;
        }
        return false;
    }

    public boolean setStage(IsoGridSquare isoGridSquare, int n, int n2, boolean bl) {
        IsoObject isoObject = this.getObject(isoGridSquare, false);
        if (isoObject != null) {
            return this.setStageObject(n, isoObject, n2, bl);
        }
        return false;
    }

    public IsoObject removeObject(IsoGridSquare isoGridSquare) {
        return this.getObject(isoGridSquare, true);
    }

    private IsoSprite getSprite(String string) {
        return ErosionMain.getInstance().getSpriteManager().getSprite(string);
    }
}

