/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.erosion.ErosionData;
import zombie.erosion.ErosionMain;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObjOverlay;
import zombie.erosion.obj.ErosionObjOverlaySprites;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSprite;

public final class WallVines
extends ErosionCategory {
    private ArrayList<ErosionObjOverlay> objs = new ArrayList();
    private static final int DIRNW = 0;
    private static final int DIRN = 1;
    private static final int DIRW = 2;
    private int[][] objsRef = new int[3][2];
    private HashMap<String, Integer> spriteToObj = new HashMap();
    private HashMap<String, Integer> spriteToStage = new HashMap();
    private int[] spawnChance = new int[100];

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        int n = isoGridSquare.getObjects().size();
        for (int i = n - 1; i >= 1; --i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (isoObject.AttachedAnimSprite == null) continue;
            for (int j = 0; j < isoObject.AttachedAnimSprite.size(); ++j) {
                int n2;
                IsoSprite isoSprite = isoObject.AttachedAnimSprite.get((int)j).parentSprite;
                if (isoSprite == null || isoSprite.getName() == null || !isoSprite.getName().startsWith("f_wallvines_1_") || !this.spriteToObj.containsKey(isoSprite.getName())) continue;
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.gameObj = this.spriteToObj.get(isoSprite.getName());
                categoryData.stage = n2 = this.spriteToStage.get(isoSprite.getName()).intValue();
                categoryData.maxStage = 2;
                categoryData.spawnTime = 0;
                isoObject.AttachedAnimSprite.remove(j);
                if (isoObject.AttachedAnimSprite != null && j < isoObject.AttachedAnimSprite.size()) {
                    isoObject.AttachedAnimSprite.remove(j);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            return false;
        }
        int n = square.noiseMainInt;
        int n2 = this.spawnChance[n];
        if (n2 == 0) {
            return false;
        }
        if (square.rand(isoGridSquare.x, isoGridSquare.y, 101) >= n2) {
            return false;
        }
        int n3 = -1;
        IsoObject isoObject = this.validWall(isoGridSquare, true, true);
        IsoObject isoObject2 = this.validWall(isoGridSquare, false, true);
        if (isoObject != null && isoObject2 != null) {
            n3 = 0;
        } else if (isoObject != null) {
            n3 = 1;
        } else if (isoObject2 != null) {
            n3 = 2;
        } else {
            return false;
        }
        CategoryData categoryData = (CategoryData)this.setCatModData(square);
        categoryData.gameObj = this.objsRef[n3][square.rand(isoGridSquare.x, isoGridSquare.y, this.objsRef[n3].length)];
        categoryData.maxStage = n > 65 ? 3 : (n > 60 ? 2 : (n > 55 ? 1 : 0));
        categoryData.stage = 0;
        categoryData.spawnTime = 100 - n;
        if (categoryData.maxStage == 3) {
            IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() + 1);
            if (isoGridSquare2 != null) {
                IsoObject isoObject3 = this.validWall(isoGridSquare2, n3 == 1, true);
                ErosionObjOverlay erosionObjOverlay = this.objs.get(categoryData.gameObj);
                if (isoObject3 != null && erosionObjOverlay != null) {
                    CategoryData categoryData2 = new CategoryData();
                    categoryData2.gameObj = this.objsRef[n3][square.rand(isoGridSquare.x, isoGridSquare.y, this.objsRef[n3].length)];
                    categoryData2.maxStage = n > 75 ? 2 : (n > 70 ? 1 : 0);
                    categoryData2.stage = 0;
                    categoryData2.spawnTime = categoryData.spawnTime + (int)((float)erosionObjOverlay.cycleTime / ((float)categoryData.maxStage + 1.0f) * 4.0f);
                    categoryData.hasTop = categoryData2;
                } else {
                    categoryData.maxStage = 2;
                }
            } else {
                categoryData.maxStage = 2;
            }
        }
        return true;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (n < categoryData.spawnTime || categoryData.doNothing) {
            return;
        }
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.objs.size()) {
            ErosionObjOverlay erosionObjOverlay = this.objs.get(categoryData.gameObj);
            int n2 = categoryData.maxStage;
            int n3 = (int)Math.floor((float)(n - categoryData.spawnTime) / ((float)erosionObjOverlay.cycleTime / ((float)n2 + 1.0f)));
            if (n3 < categoryData.stage) {
                n3 = categoryData.stage;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            if (n3 > erosionObjOverlay.stages) {
                n3 = erosionObjOverlay.stages;
            }
            if (n3 == 3 && categoryData.hasTop != null && categoryData.hasTop.spawnTime > n) {
                n3 = 2;
            }
            int n4 = ErosionMain.getInstance().getSeasons().getSeason();
            if (n3 != categoryData.stage || categoryData.dispSeason != n4) {
                IsoGridSquare isoGridSquare2;
                IsoObject isoObject = null;
                IsoObject isoObject2 = this.validWall(isoGridSquare, true, true);
                IsoObject isoObject3 = this.validWall(isoGridSquare, false, true);
                if (isoObject2 != null && isoObject3 != null) {
                    isoObject = isoObject2;
                } else if (isoObject2 != null) {
                    isoObject = isoObject2;
                } else if (isoObject3 != null) {
                    isoObject = isoObject3;
                }
                categoryData.dispSeason = n4;
                if (isoObject != null) {
                    int n5 = categoryData.curID;
                    int n6 = erosionObjOverlay.setOverlay(isoObject, n5, n3, n4, 0.0f);
                    if (n6 >= 0) {
                        categoryData.curID = n6;
                    }
                } else {
                    categoryData.doNothing = true;
                }
                if (n3 == 3 && categoryData.hasTop != null && (isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() + 1)) != null) {
                    this.update(isoGridSquare2, square, categoryData.hasTop, chunk, n);
                }
            }
        } else {
            categoryData.doNothing = true;
        }
    }

    @Override
    public void init() {
        for (int i = 0; i < 100; ++i) {
            this.spawnChance[i] = i >= 50 ? 100 : 0;
        }
        this.seasonDisp[5].season1 = 5;
        this.seasonDisp[5].season2 = 0;
        this.seasonDisp[5].split = false;
        this.seasonDisp[1].season1 = 1;
        this.seasonDisp[1].season2 = 0;
        this.seasonDisp[1].split = false;
        this.seasonDisp[2].season1 = 2;
        this.seasonDisp[2].season2 = 4;
        this.seasonDisp[2].split = true;
        this.seasonDisp[4].season1 = 4;
        this.seasonDisp[4].season2 = 5;
        this.seasonDisp[4].split = true;
        String string = "f_wallvines_1_";
        int[] nArray = new int[]{5, 2, 4, 1};
        int[] nArray2 = new int[]{2, 2, 1, 1, 0, 0};
        int[] nArray3 = new int[3];
        for (int i = 0; i < nArray2.length; ++i) {
            ErosionObjOverlaySprites erosionObjOverlaySprites = new ErosionObjOverlaySprites(4, "WallVines");
            for (int j = 0; j <= 3; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    int n = k * 24 + j * 6 + i;
                    erosionObjOverlaySprites.setSprite(j, string + n, nArray[k]);
                    if (k == 2) {
                        erosionObjOverlaySprites.setSprite(j, string + n, nArray[k + 1]);
                    }
                    this.spriteToObj.put(string + n, this.objs.size());
                    this.spriteToStage.put(string + n, j);
                }
            }
            this.objs.add(new ErosionObjOverlay(erosionObjOverlaySprites, 60, false));
            int n = nArray2[i];
            int n2 = nArray3[n];
            nArray3[n] = n2 + 1;
            this.objsRef[nArray2[i]][n2] = this.objs.size() - 1;
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;
        public int maxStage;
        public int spawnTime;
        public int curID = -999999;
        public CategoryData hasTop;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
            byteBuffer.put((byte)this.maxStage);
            byteBuffer.putShort((short)this.spawnTime);
            byteBuffer.putInt(this.curID);
            if (this.hasTop != null) {
                byteBuffer.put((byte)1);
                byteBuffer.put((byte)this.hasTop.gameObj);
                byteBuffer.putShort((short)this.hasTop.spawnTime);
                byteBuffer.putInt(this.hasTop.curID);
            } else {
                byteBuffer.put((byte)0);
            }
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            boolean bl;
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
            this.maxStage = byteBuffer.get();
            this.spawnTime = byteBuffer.getShort();
            this.curID = byteBuffer.getInt();
            boolean bl2 = bl = byteBuffer.get() == 1;
            if (bl) {
                this.hasTop = new CategoryData();
                this.hasTop.gameObj = byteBuffer.get();
                this.hasTop.spawnTime = byteBuffer.getShort();
                this.hasTop.curID = byteBuffer.getInt();
            }
        }
    }
}

