/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.erosion.ErosionData;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObjOverlay;
import zombie.erosion.obj.ErosionObjOverlaySprites;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;

public final class WallCracks
extends ErosionCategory {
    private ArrayList<ErosionObjOverlay> objs = new ArrayList();
    private static final int DIRNW = 0;
    private static final int DIRN = 1;
    private static final int DIRW = 2;
    private ArrayList<ArrayList<Integer>> objsRef = new ArrayList();
    private ArrayList<ArrayList<Integer>> botRef = new ArrayList();
    private ArrayList<ArrayList<Integer>> topRef = new ArrayList();
    private int[] spawnChance = new int[100];

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        IsoObject isoObject;
        IsoGridSquare isoGridSquare2;
        IsoObject isoObject2;
        String string;
        if (!bl) {
            return false;
        }
        int n = square.noiseMainInt;
        int n2 = this.spawnChance[n];
        if (n2 == 0) {
            return false;
        }
        if (square.rand(isoGridSquare.x, isoGridSquare.y, 101) >= n2) {
            return false;
        }
        int n3 = -1;
        IsoObject isoObject3 = this.validWall(isoGridSquare, true, false);
        if (isoObject3 != null && (string = isoObject3.getSprite().getName()) != null && string.startsWith("fencing")) {
            isoObject3 = null;
        }
        if ((isoObject2 = this.validWall(isoGridSquare, false, false)) != null && (string = isoObject2.getSprite().getName()) != null && string.startsWith("fencing")) {
            isoObject2 = null;
        }
        if (isoObject3 != null && isoObject2 != null) {
            n3 = 0;
        } else if (isoObject3 != null) {
            n3 = 1;
        } else if (isoObject2 != null) {
            n3 = 2;
        } else {
            return false;
        }
        boolean bl4 = n < 35 && square.magicNum > 0.3f;
        CategoryData categoryData = (CategoryData)this.setCatModData(square);
        categoryData.gameObj = this.objsRef.get(n3).get(square.rand(isoGridSquare.x, isoGridSquare.y, this.objsRef.get(n3).size()));
        categoryData.alpha = 0.0f;
        categoryData.spawnTime = n;
        if (bl4 && (isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() + 1)) != null && (isoObject = this.validWall(isoGridSquare2, n3 == 1, false)) != null) {
            int n4 = square.rand(isoGridSquare.x, isoGridSquare.y, this.botRef.get(n3).size());
            categoryData.gameObj = this.botRef.get(n3).get(n4);
            CategoryData categoryData2 = new CategoryData();
            categoryData2.gameObj = this.topRef.get(n3).get(n4);
            categoryData2.alpha = 0.0f;
            categoryData2.spawnTime = categoryData.spawnTime;
            categoryData.hasTop = categoryData2;
        }
        return true;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (n < categoryData.spawnTime || categoryData.doNothing) {
            return;
        }
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.objs.size()) {
            ErosionObjOverlay erosionObjOverlay = this.objs.get(categoryData.gameObj);
            float f = categoryData.alpha;
            float f2 = (float)(n - categoryData.spawnTime) / 100.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 != f) {
                IsoGridSquare isoGridSquare2;
                IsoObject isoObject = null;
                IsoObject isoObject2 = this.validWall(isoGridSquare, true, false);
                IsoObject isoObject3 = this.validWall(isoGridSquare, false, false);
                if (isoObject2 != null && isoObject3 != null) {
                    isoObject = isoObject2;
                } else if (isoObject2 != null) {
                    isoObject = isoObject2;
                } else if (isoObject3 != null) {
                    isoObject = isoObject3;
                }
                if (isoObject != null) {
                    int n2 = categoryData.curID;
                    int n3 = 0;
                    int n4 = erosionObjOverlay.setOverlay(isoObject, n2, n3, 0, f2);
                    if (n4 >= 0) {
                        categoryData.alpha = f2;
                        categoryData.curID = n4;
                    }
                } else {
                    categoryData.doNothing = true;
                }
                if (categoryData.hasTop != null && (isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() + 1)) != null) {
                    this.update(isoGridSquare2, square, categoryData.hasTop, chunk, n);
                }
            }
        } else {
            categoryData.doNothing = true;
        }
    }

    @Override
    public void init() {
        int n;
        for (int i = 0; i < 100; ++i) {
            this.spawnChance[i] = i <= 50 ? 100 : 0;
        }
        String string = "d_wallcracks_1_";
        int[] nArray = new int[]{2, 2, 2, 1, 1, 1, 0, 0, 0};
        for (n = 0; n < 3; ++n) {
            this.objsRef.add(new ArrayList());
            this.topRef.add(new ArrayList());
            this.botRef.add(new ArrayList());
        }
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i <= 7; ++i) {
                int n2 = i * 9 + n;
                ErosionObjOverlaySprites erosionObjOverlaySprites = new ErosionObjOverlaySprites(1, "WallCracks");
                erosionObjOverlaySprites.setSprite(0, string + n2, 0);
                this.objs.add(new ErosionObjOverlay(erosionObjOverlaySprites, 60, true));
                this.objsRef.get(nArray[n]).add(this.objs.size() - 1);
                if (i == 0) {
                    this.botRef.get(nArray[n]).add(this.objs.size() - 1);
                    continue;
                }
                if (i != 1) continue;
                this.topRef.get(nArray[n]).add(this.objs.size() - 1);
            }
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;
        public int spawnTime;
        public int curID = -999999;
        public float alpha;
        public CategoryData hasTop;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
            byteBuffer.putShort((short)this.spawnTime);
            byteBuffer.putInt(this.curID);
            byteBuffer.putFloat(this.alpha);
            if (this.hasTop != null) {
                byteBuffer.put((byte)1);
                byteBuffer.put((byte)this.hasTop.gameObj);
                byteBuffer.putShort((short)this.hasTop.spawnTime);
                byteBuffer.putInt(this.hasTop.curID);
                byteBuffer.putFloat(this.hasTop.alpha);
            } else {
                byteBuffer.put((byte)0);
            }
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            boolean bl;
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
            this.spawnTime = byteBuffer.getShort();
            this.curID = byteBuffer.getInt();
            this.alpha = byteBuffer.getFloat();
            boolean bl2 = bl = byteBuffer.get() == 1;
            if (bl) {
                this.hasTop = new CategoryData();
                this.hasTop.gameObj = byteBuffer.get();
                this.hasTop.spawnTime = byteBuffer.getShort();
                this.hasTop.curID = byteBuffer.getInt();
                this.hasTop.alpha = byteBuffer.getFloat();
            }
        }
    }
}

