/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.erosion.ErosionData;
import zombie.erosion.ErosionMain;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObj;
import zombie.erosion.obj.ErosionObjSprites;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;

public final class Flowerbed
extends ErosionCategory {
    private final int[] tileID = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 28, 29, 30, 31};
    private final ArrayList<ErosionObj> objs = new ArrayList();

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        int n = isoGridSquare.getObjects().size();
        for (int i = n - 1; i >= 0; --i) {
            int n2;
            IsoSprite isoSprite = isoGridSquare.getObjects().get(i).getSprite();
            if (isoSprite == null || isoSprite.getName() == null) continue;
            if (isoSprite.getName().startsWith("f_flowerbed_1") && (n2 = Integer.parseInt(isoSprite.getName().replace("f_flowerbed_1_", ""))) <= 23) {
                if (n2 >= 12) {
                    n2 -= 12;
                }
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.hasSpawned = true;
                categoryData.gameObj = n2;
                categoryData.dispSeason = -1;
                ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
                isoGridSquare.getObjects().get(i).setName(erosionObj.name);
                return true;
            }
            if (!isoSprite.getName().startsWith("vegetation_ornamental_01")) continue;
            n2 = Integer.parseInt(isoSprite.getName().replace("vegetation_ornamental_01_", ""));
            for (int j = 0; j < this.tileID.length; ++j) {
                if (this.tileID[j] != n2) continue;
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.hasSpawned = true;
                categoryData.gameObj = j;
                categoryData.dispSeason = -1;
                ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
                isoGridSquare.getObjects().get(i).setName(erosionObj.name);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        return false;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (categoryData.doNothing) {
            return;
        }
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.objs.size()) {
            ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
            boolean bl = false;
            int n2 = 0;
            int n3 = ErosionMain.getInstance().getSeasons().getSeason();
            boolean bl2 = false;
            if (n3 == 5) {
                IsoObject isoObject = erosionObj.getObject(isoGridSquare, false);
                if (isoObject != null) {
                    isoObject.setSprite(ErosionMain.getInstance().getSpriteManager().getSprite("blends_natural_01_64"));
                    isoObject.setName(null);
                }
                this.clearCatModData(square);
            } else {
                this.updateObj(square, data, isoGridSquare, erosionObj, bl, n2, n3, bl2);
            }
        } else {
            this.clearCatModData(square);
        }
    }

    @Override
    public void init() {
        String string = "vegetation_ornamental_01_";
        for (int i = 0; i < this.tileID.length; ++i) {
            ErosionObjSprites erosionObjSprites = new ErosionObjSprites(1, "Flowerbed", false, false, false);
            erosionObjSprites.setBase(0, string + this.tileID[i], 1);
            erosionObjSprites.setBase(0, string + this.tileID[i], 2);
            erosionObjSprites.setBase(0, string + (this.tileID[i] + 16), 4);
            ErosionObj erosionObj = new ErosionObj(erosionObjSprites, 30, 0.0f, 0.0f, false);
            this.objs.add(erosionObj);
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
        }
    }
}

