/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.debug.DebugLog;
import zombie.erosion.ErosionData;
import zombie.erosion.ErosionMain;
import zombie.erosion.ErosionRegions;
import zombie.erosion.obj.ErosionObj;
import zombie.erosion.season.ErosionSeason;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.SpriteDetails.IsoFlagType;

public abstract class ErosionCategory {
    public int ID;
    public ErosionRegions.Region region;
    protected SeasonDisplay[] seasonDisp = new SeasonDisplay[6];

    public ErosionCategory() {
        for (int i = 0; i < 6; ++i) {
            this.seasonDisp[i] = new SeasonDisplay();
        }
    }

    protected Data getCatModData(ErosionData.Square square) {
        for (int i = 0; i < square.regions.size(); ++i) {
            Data data = square.regions.get(i);
            if (data.regionID != this.region.ID || data.categoryID != this.ID) continue;
            return data;
        }
        return null;
    }

    protected Data setCatModData(ErosionData.Square square) {
        Data data = this.getCatModData(square);
        if (data == null) {
            data = this.allocData();
            data.regionID = this.region.ID;
            data.categoryID = this.ID;
            square.regions.add(data);
            if (square.regions.size() > 5) {
                DebugLog.log("> 5 regions on a square");
            }
        }
        return data;
    }

    protected IsoObject validWall(IsoGridSquare isoGridSquare, boolean bl, boolean bl2) {
        if (isoGridSquare == null) {
            return null;
        }
        IsoGridSquare isoGridSquare2 = bl ? isoGridSquare.getTileInDirection(IsoDirections.N) : isoGridSquare.getTileInDirection(IsoDirections.W);
        IsoObject isoObject = null;
        if (isoGridSquare.isWallTo(isoGridSquare2)) {
            if (bl && isoGridSquare.Is(IsoFlagType.cutN) && !isoGridSquare.Is(IsoFlagType.canPathN) || !bl && isoGridSquare.Is(IsoFlagType.cutW) && !isoGridSquare.Is(IsoFlagType.canPathW)) {
                isoObject = isoGridSquare.getWall(bl);
            }
        } else if (bl2 && (isoGridSquare.isWindowBlockedTo(isoGridSquare2) || isoGridSquare.isWindowTo(isoGridSquare2)) && (isoObject = isoGridSquare.getWindowTo(isoGridSquare2)) == null) {
            isoObject = isoGridSquare.getWall(bl);
        }
        if (isoObject != null) {
            if (isoGridSquare.getZ() > 0) {
                String string = isoObject.getSprite().getName();
                if (string != null && !string.contains("roof")) {
                    return isoObject;
                }
                return null;
            }
            return isoObject;
        }
        return null;
    }

    protected float clerp(float f, float f2, float f3) {
        float f4 = (float)(1.0 - Math.cos((double)f * Math.PI)) / 2.0f;
        return f2 * (1.0f - f4) + f3 * f4;
    }

    protected int currentSeason(float f, ErosionObj erosionObj) {
        int n = 0;
        ErosionSeason erosionSeason = ErosionMain.getInstance().getSeasons();
        int n2 = erosionSeason.getSeason();
        float f2 = erosionSeason.getSeasonDay();
        float f3 = erosionSeason.getSeasonDays();
        float f4 = f3 / 2.0f;
        float f5 = f4 * f;
        SeasonDisplay seasonDisplay = this.seasonDisp[n2];
        if (seasonDisplay.split && f2 >= f4 + f5) {
            n = seasonDisplay.season2;
        } else if (seasonDisplay.split && f2 >= f5 || f2 >= f3 * f) {
            n = seasonDisplay.season1;
        } else {
            SeasonDisplay seasonDisplay2 = n2 == 5 ? this.seasonDisp[4] : (n2 == 1 ? this.seasonDisp[5] : (n2 == 2 ? this.seasonDisp[1] : this.seasonDisp[2]));
            n = seasonDisplay2.split ? seasonDisplay2.season2 : seasonDisplay2.season1;
        }
        return n;
    }

    protected boolean currentBloom(float f, ErosionObj erosionObj) {
        boolean bl = false;
        ErosionSeason erosionSeason = ErosionMain.getInstance().getSeasons();
        int n = erosionSeason.getSeason();
        if (erosionObj.hasFlower && n == 2) {
            float f2 = erosionSeason.getSeasonDay();
            float f3 = erosionSeason.getSeasonDays();
            float f4 = f3 / 2.0f;
            float f5 = f4 * f;
            float f6 = f3 - f5;
            float f7 = f2 - f5;
            float f8 = f6 * erosionObj.bloomEnd;
            float f9 = f6 * erosionObj.bloomStart;
            float f10 = (f8 - f9) / 2.0f;
            float f11 = f10 * f;
            f8 = f9 + f10 + f11;
            if (f7 >= (f9 += f11) && f7 <= f8) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateObj(ErosionData.Square square, Data data, IsoGridSquare isoGridSquare, ErosionObj erosionObj, boolean bl, int n, int n2, boolean bl2) {
        if (!data.hasSpawned) {
            if (!erosionObj.placeObject(isoGridSquare, n, bl, n2, bl2)) {
                this.clearCatModData(square);
                return;
            }
            data.hasSpawned = true;
        } else if (data.stage != n || data.dispSeason != n2 || data.dispBloom != bl2) {
            IsoObject isoObject = erosionObj.getObject(isoGridSquare, false);
            if (isoObject == null) {
                this.clearCatModData(square);
                return;
            }
            erosionObj.setStageObject(n, isoObject, n2, bl2);
        }
        data.stage = n;
        data.dispSeason = n2;
        data.dispBloom = bl2;
    }

    protected void clearCatModData(ErosionData.Square square) {
        for (int i = 0; i < square.regions.size(); ++i) {
            Data data = square.regions.get(i);
            if (data.regionID != this.region.ID || data.categoryID != this.ID) continue;
            square.regions.remove(i);
            return;
        }
    }

    public abstract void init();

    public abstract boolean replaceExistingObject(IsoGridSquare var1, ErosionData.Square var2, ErosionData.Chunk var3, boolean var4, boolean var5);

    public abstract boolean validateSpawn(IsoGridSquare var1, ErosionData.Square var2, ErosionData.Chunk var3, boolean var4, boolean var5, boolean var6);

    public abstract void update(IsoGridSquare var1, ErosionData.Square var2, Data var3, ErosionData.Chunk var4, int var5);

    protected abstract Data allocData();

    public static Data loadCategoryData(ByteBuffer byteBuffer, int n) {
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        ErosionCategory erosionCategory = ErosionRegions.getCategory(by, by2);
        Data data = erosionCategory.allocData();
        data.regionID = by;
        data.categoryID = by2;
        data.load(byteBuffer, n);
        return data;
    }

    public abstract void getObjectNames(ArrayList<String> var1);

    protected class SeasonDisplay {
        int season1;
        int season2;
        boolean split;

        protected SeasonDisplay() {
        }
    }

    public static class Data {
        public int regionID;
        public int categoryID;
        public boolean doNothing;
        public boolean hasSpawned;
        public int stage;
        public int dispSeason;
        public boolean dispBloom;

        public void save(ByteBuffer byteBuffer) {
            byte by = 0;
            if (this.doNothing) {
                by = (byte)(by | 1);
            }
            if (this.hasSpawned) {
                by = (byte)(by | 2);
            }
            if (this.dispBloom) {
                by = (byte)(by | 4);
            }
            if (this.stage == 1) {
                by = (byte)(by | 8);
            } else if (this.stage == 2) {
                by = (byte)(by | 0x10);
            } else if (this.stage == 3) {
                by = (byte)(by | 0x20);
            } else if (this.stage == 4) {
                by = (byte)(by | 0x40);
            } else if (this.stage > 4) {
                by = (byte)(by | 0x80);
            }
            byteBuffer.put((byte)this.regionID);
            byteBuffer.put((byte)this.categoryID);
            byteBuffer.put((byte)this.dispSeason);
            byteBuffer.put(by);
            if (this.stage > 4) {
                byteBuffer.put((byte)this.stage);
            }
        }

        public void load(ByteBuffer byteBuffer, int n) {
            this.stage = 0;
            this.dispSeason = byteBuffer.get();
            byte by = byteBuffer.get();
            this.doNothing = (by & 1) != 0;
            this.hasSpawned = (by & 2) != 0;
            boolean bl = this.dispBloom = (by & 4) != 0;
            if ((by & 8) != 0) {
                this.stage = 1;
            } else if ((by & 0x10) != 0) {
                this.stage = 2;
            } else if ((by & 0x20) != 0) {
                this.stage = 3;
            } else if ((by & 0x40) != 0) {
                this.stage = 4;
            } else if ((by & 0x80) != 0) {
                this.stage = byteBuffer.get();
            }
        }
    }
}

