/*
 * Decompiled with CFR 0.152.
 */
package zombie.debug;

import java.util.ArrayDeque;
import java.util.ArrayList;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.iso.IsoCamera;
import zombie.iso.IsoUtils;
import zombie.iso.PlayerCamera;
import zombie.iso.Vector2;

public final class LineDrawer {
    private static final long serialVersionUID = -8792265397633463907L;
    public static int red = 0;
    public static int green = 255;
    public static int blue = 0;
    public static int alpha = 255;
    static int idLayer = -1;
    static final ArrayList<DrawableLine> lines = new ArrayList();
    static final ArrayDeque<DrawableLine> pool = new ArrayDeque();
    private static int layer;
    static final Vector2 tempo;
    static final Vector2 tempo2;

    static void DrawTexturedRect(Texture texture, float f, float f2, float f3, float f4, int n, float f5, float f6, float f7) {
        f = (int)f;
        f2 = (int)f2;
        Vector2 vector22 = new Vector2(f, f2);
        Vector2 vector23 = new Vector2(f + f3, f2);
        Vector2 vector24 = new Vector2(f + f3, f2 + f4);
        Vector2 vector25 = new Vector2(f, f2 + f4);
        Vector2 vector26 = new Vector2(IsoUtils.XToScreen(vector22.x, vector22.y, n, 0), IsoUtils.YToScreen(vector22.x, vector22.y, n, 0));
        Vector2 vector27 = new Vector2(IsoUtils.XToScreen(vector23.x, vector23.y, n, 0), IsoUtils.YToScreen(vector23.x, vector23.y, n, 0));
        Vector2 vector28 = new Vector2(IsoUtils.XToScreen(vector24.x, vector24.y, n, 0), IsoUtils.YToScreen(vector24.x, vector24.y, n, 0));
        Vector2 vector29 = new Vector2(IsoUtils.XToScreen(vector25.x, vector25.y, n, 0), IsoUtils.YToScreen(vector25.x, vector25.y, n, 0));
        PlayerCamera playerCamera = IsoCamera.cameras[IsoPlayer.getPlayerIndex()];
        vector26.x -= playerCamera.OffX;
        vector27.x -= playerCamera.OffX;
        vector28.x -= playerCamera.OffX;
        vector29.x -= playerCamera.OffX;
        vector26.y -= playerCamera.OffY;
        vector27.y -= playerCamera.OffY;
        vector28.y -= playerCamera.OffY;
        vector29.y -= playerCamera.OffY;
        float f8 = -240.0f;
        float f9 = -32.0f;
        vector26.y -= (f8 -= 128.0f);
        vector27.y -= f8;
        vector28.y -= f8;
        vector29.y -= f8;
        vector26.x -= f9;
        vector27.x -= f9;
        vector28.x -= f9;
        vector29.x -= f9;
        SpriteRenderer.instance.renderdebug(texture, vector26.x, vector26.y, vector27.x, vector27.y, vector28.x, vector28.y, vector29.x, vector29.y, f5, f6, f7, 1.0f, f5, f6, f7, 1.0f, f5, f6, f7, 1.0f, f5, f6, f7, 1.0f, null);
    }

    static void DrawIsoLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        tempo.set(f, f2);
        tempo2.set(f3, f4);
        Vector2 vector22 = new Vector2(IsoUtils.XToScreen(LineDrawer.tempo.x, LineDrawer.tempo.y, 0.0f, 0), IsoUtils.YToScreen(LineDrawer.tempo.x, LineDrawer.tempo.y, 0.0f, 0));
        Vector2 vector23 = new Vector2(IsoUtils.XToScreen(LineDrawer.tempo2.x, LineDrawer.tempo2.y, 0.0f, 0), IsoUtils.YToScreen(LineDrawer.tempo2.x, LineDrawer.tempo2.y, 0.0f, 0));
        vector22.x -= IsoCamera.getOffX();
        vector23.x -= IsoCamera.getOffX();
        vector22.y -= IsoCamera.getOffY();
        vector23.y -= IsoCamera.getOffY();
        LineDrawer.drawLine(vector22.x, vector22.y, vector23.x, vector23.y, f5, f6, f7, f8, n);
    }

    public static void DrawIsoRect(float f, float f2, float f3, float f4, int n, float f5, float f6, float f7) {
        LineDrawer.DrawIsoRect(f, f2, f3, f4, n, 0, f5, f6, f7);
    }

    public static void DrawIsoRect(float f, float f2, float f3, float f4, int n, int n2, float f5, float f6, float f7) {
        if (f3 < 0.0f) {
            f3 = -f3;
            f -= f3;
        }
        if (f4 < 0.0f) {
            f4 = -f4;
            f2 -= f4;
        }
        float f8 = IsoUtils.XToScreenExact(f, f2, n, 0);
        float f9 = IsoUtils.YToScreenExact(f, f2, n, 0);
        float f10 = IsoUtils.XToScreenExact(f + f3, f2, n, 0);
        float f11 = IsoUtils.YToScreenExact(f + f3, f2, n, 0);
        float f12 = IsoUtils.XToScreenExact(f + f3, f2 + f4, n, 0);
        float f13 = IsoUtils.YToScreenExact(f + f3, f2 + f4, n, 0);
        float f14 = IsoUtils.XToScreenExact(f, f2 + f4, n, 0);
        float f15 = IsoUtils.YToScreenExact(f, f2 + f4, n, 0);
        float f16 = -n2 * Core.TileScale;
        LineDrawer.drawLine(f8, f9 += f16, f10, f11 += f16, f5, f6, f7);
        LineDrawer.drawLine(f10, f11, f12, f13 += f16, f5, f6, f7);
        LineDrawer.drawLine(f12, f13, f14, f15 += f16, f5, f6, f7);
        LineDrawer.drawLine(f14, f15, f8, f9, f5, f6, f7);
    }

    public static void DrawIsoRectRotated(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        Vector2 vector22 = tempo.setLengthAndDirection(f6, 1.0f);
        Vector2 vector23 = tempo2.set(vector22);
        vector23.tangent();
        vector22.x *= f5 / 2.0f;
        vector22.y *= f5 / 2.0f;
        vector23.x *= f4 / 2.0f;
        vector23.y *= f4 / 2.0f;
        float f11 = f + vector22.x;
        float f12 = f2 + vector22.y;
        float f13 = f - vector22.x;
        float f14 = f2 - vector22.y;
        float f15 = f11 - vector23.x;
        float f16 = f12 - vector23.y;
        float f17 = f11 + vector23.x;
        float f18 = f12 + vector23.y;
        float f19 = f13 - vector23.x;
        float f20 = f14 - vector23.y;
        float f21 = f13 + vector23.x;
        float f22 = f14 + vector23.y;
        int n = 1;
        LineDrawer.DrawIsoLine(f15, f16, f3, f17, f18, f3, f7, f8, f9, f10, n);
        LineDrawer.DrawIsoLine(f15, f16, f3, f19, f20, f3, f7, f8, f9, f10, n);
        LineDrawer.DrawIsoLine(f17, f18, f3, f21, f22, f3, f7, f8, f9, f10, n);
        LineDrawer.DrawIsoLine(f19, f20, f3, f21, f22, f3, f7, f8, f9, f10, n);
    }

    public static void DrawIsoLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n) {
        float f11 = IsoUtils.XToScreenExact(f, f2, f3, 0);
        float f12 = IsoUtils.YToScreenExact(f, f2, f3, 0);
        float f13 = IsoUtils.XToScreenExact(f4, f5, f6, 0);
        float f14 = IsoUtils.YToScreenExact(f4, f5, f6, 0);
        LineDrawer.drawLine(f11, f12, f13, f14, f7, f8, f9, f10, n);
    }

    public static void DrawIsoTransform(float f, float f2, float f3, float f4, float f5, float f6, int n, float f7, float f8, float f9, float f10, int n2) {
        LineDrawer.DrawIsoCircle(f, f2, f3, f6, n, f7, f8, f9, f10);
        LineDrawer.DrawIsoLine(f, f2, f3, f + f4 + f6 / 2.0f, f2 + f5 + f6 / 2.0f, f3, f7, f8, f9, f10, n2);
    }

    public static void DrawIsoCircle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        int n = 16;
        LineDrawer.DrawIsoCircle(f, f2, f3, f4, n, f5, f6, f7, f8);
    }

    public static void DrawIsoCircle(float f, float f2, float f3, float f4, int n, float f5, float f6, float f7, float f8) {
        double d = (double)f + (double)f4 * Math.cos(Math.toRadians(0.0f / (float)n));
        double d2 = (double)f2 + (double)f4 * Math.sin(Math.toRadians(0.0f / (float)n));
        for (int i = 1; i <= n; ++i) {
            double d3 = (double)f + (double)f4 * Math.cos(Math.toRadians((float)i * 360.0f / (float)n));
            double d4 = (double)f2 + (double)f4 * Math.sin(Math.toRadians((float)i * 360.0f / (float)n));
            LineDrawer.addLine((float)d, (float)d2, f3, (float)d3, (float)d4, f3, f5, f6, f7, f8);
            d = d3;
            d2 = d4;
        }
    }

    static void drawLine(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        SpriteRenderer.instance.renderline(null, (int)f, (int)f2, (int)f3, (int)f4, f5, f6, f7, 1.0f);
    }

    public static void drawLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        SpriteRenderer.instance.renderline(null, (int)f, (int)f2, (int)f3, (int)f4, f5, f6, f7, f8);
    }

    public static void drawRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        SpriteRenderer.instance.render(null, f, f2 + (float)n, n, f4 - (float)(n * 2), f5, f6, f7, f8, null);
        SpriteRenderer.instance.render(null, f, f2, f3, n, f5, f6, f7, f8, null);
        SpriteRenderer.instance.render(null, f + f3 - (float)n, f2 + (float)n, 1.0f, f4 - (float)(n * 2), f5, f6, f7, f8, null);
        SpriteRenderer.instance.render(null, f, f2 + f4 - (float)n, f3, n, f5, f6, f7, f8, null);
    }

    public static void drawArc(float f, float f2, float f3, float f4, float f5, float f6, int n, float f7, float f8, float f9, float f10) {
        float f11 = f5 + (float)Math.acos(f6);
        float f12 = f5 - (float)Math.acos(f6);
        float f13 = f + (float)Math.cos(f11) * f4;
        float f14 = f2 + (float)Math.sin(f11) * f4;
        for (int i = 1; i <= n; ++i) {
            float f15 = f11 + (f12 - f11) * (float)i / (float)n;
            float f16 = f + (float)Math.cos(f15) * f4;
            float f17 = f2 + (float)Math.sin(f15) * f4;
            LineDrawer.DrawIsoLine(f13, f14, f3, f16, f17, f3, f7, f8, f9, f10, 1);
            f13 = f16;
            f14 = f17;
        }
    }

    public static void drawCircle(float f, float f2, float f3, int n, float f4, float f5, float f6) {
        double d = (double)f + (double)f3 * Math.cos(Math.toRadians(0.0f / (float)n));
        double d2 = (double)f2 + (double)f3 * Math.sin(Math.toRadians(0.0f / (float)n));
        for (int i = 1; i <= n; ++i) {
            double d3 = (double)f + (double)f3 * Math.cos(Math.toRadians((float)i * 360.0f / (float)n));
            double d4 = (double)f2 + (double)f3 * Math.sin(Math.toRadians((float)i * 360.0f / (float)n));
            LineDrawer.drawLine((float)d, (float)d2, (float)d3, (float)d4, f4, f5, f6, 1.0f, 1);
            d = d3;
            d2 = d4;
        }
    }

    public static void drawDirectionLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n) {
        float f10 = f + (float)Math.cos(f5) * f4;
        float f11 = f2 + (float)Math.sin(f5) * f4;
        LineDrawer.DrawIsoLine(f, f2, f3, f10, f11, f3, f6, f7, f8, f9, n);
    }

    public static void drawDotLines(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n) {
        LineDrawer.drawDirectionLine(f, f2, f3, f4, f5 + (float)Math.acos(f6), f7, f8, f9, f10, n);
        LineDrawer.drawDirectionLine(f, f2, f3, f4, f5 - (float)Math.acos(f6), f7, f8, f9, f10, n);
    }

    public static void addLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        DrawableLine drawableLine = pool.isEmpty() ? new DrawableLine() : pool.pop();
        lines.add(drawableLine.init(f, f2, f3, f4, f5, f6, f7, f8, f9, f10));
    }

    public static void addLine(float f, float f2, float f3, float f4, float f5, float f6, int n, int n2, int n3, String string) {
        LineDrawer.addLine(f, f2, f3, f4, f5, f6, n, n2, n3, string, true);
    }

    public static void addLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, String string, boolean bl) {
        DrawableLine drawableLine = pool.isEmpty() ? new DrawableLine() : pool.pop();
        lines.add(drawableLine.init(f, f2, f3, f4, f5, f6, f7, f8, f9, string, bl));
    }

    public static void addRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        DrawableLine drawableLine = pool.isEmpty() ? new DrawableLine() : pool.pop();
        lines.add(drawableLine.init(f, f2, f3, f + f4, f2 + f5, f3, f6, f7, f8, null, false));
    }

    public static void addRectYOffset(float f, float f2, float f3, float f4, float f5, int n, float f6, float f7, float f8) {
        DrawableLine drawableLine = pool.isEmpty() ? new DrawableLine() : pool.pop();
        lines.add(drawableLine.init(f, f2, f3, f + f4, f2 + f5, f3, f6, f7, f8, null, false));
        drawableLine.yPixelOffset = n;
    }

    public static void clear() {
        if (lines.isEmpty()) {
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            pool.push(lines.get(i));
        }
        lines.clear();
    }

    public void removeLine(String string) {
        for (int i = 0; i < lines.size(); ++i) {
            if (!LineDrawer.lines.get((int)i).name.equals(string)) continue;
            lines.remove(lines.get(i));
            --i;
        }
    }

    public static void render() {
        for (int i = 0; i < lines.size(); ++i) {
            DrawableLine drawableLine = lines.get(i);
            if (!drawableLine.bLine) {
                LineDrawer.DrawIsoRect(drawableLine.xstart, drawableLine.ystart, drawableLine.xend - drawableLine.xstart, drawableLine.yend - drawableLine.ystart, (int)drawableLine.zstart, drawableLine.yPixelOffset, drawableLine.red, drawableLine.green, drawableLine.blue);
                continue;
            }
            LineDrawer.DrawIsoLine(drawableLine.xstart, drawableLine.ystart, drawableLine.zstart, drawableLine.xend, drawableLine.yend, drawableLine.zend, drawableLine.red, drawableLine.green, drawableLine.blue, drawableLine.alpha, 1);
        }
    }

    public static void drawLines() {
        LineDrawer.clear();
    }

    static {
        tempo = new Vector2();
        tempo2 = new Vector2();
    }

    static class DrawableLine {
        public boolean bLine = false;
        String name;
        float red;
        float green;
        float blue;
        float alpha;
        float xstart;
        float ystart;
        float zstart;
        float xend;
        float yend;
        float zend;
        int yPixelOffset;

        DrawableLine() {
        }

        public DrawableLine init(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, String string) {
            this.xstart = f;
            this.ystart = f2;
            this.zstart = f3;
            this.xend = f4;
            this.yend = f5;
            this.zend = f6;
            this.red = f7;
            this.green = f8;
            this.blue = f9;
            this.alpha = 1.0f;
            this.name = string;
            this.yPixelOffset = 0;
            return this;
        }

        public DrawableLine init(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, String string, boolean bl) {
            this.xstart = f;
            this.ystart = f2;
            this.zstart = f3;
            this.xend = f4;
            this.yend = f5;
            this.zend = f6;
            this.red = f7;
            this.green = f8;
            this.blue = f9;
            this.alpha = 1.0f;
            this.name = string;
            this.bLine = bl;
            this.yPixelOffset = 0;
            return this;
        }

        public DrawableLine init(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
            this.xstart = f;
            this.ystart = f2;
            this.zstart = f3;
            this.xend = f4;
            this.yend = f5;
            this.zend = f6;
            this.red = f7;
            this.green = f8;
            this.blue = f9;
            this.alpha = f10;
            this.name = null;
            this.bLine = true;
            this.yPixelOffset = 0;
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof DrawableLine) {
                return ((DrawableLine)object).name.equals(this.name);
            }
            return object.equals(this);
        }
    }
}

