/*
 * Decompiled with CFR 0.152.
 */
package zombie.debug;

import java.io.PrintStream;
import zombie.core.Core;
import zombie.debug.IDebugLogFormatter;
import zombie.debug.LogSeverity;
import zombie.util.StringUtils;

public final class DebugLogStream
extends PrintStream {
    private final PrintStream m_wrappedStream;
    private final PrintStream m_wrappedWarnStream;
    private final PrintStream m_wrappedErrStream;
    private final IDebugLogFormatter m_formatter;
    public static final String s_prefixErr = "ERROR: ";
    public static final String s_prefixWarn = "WARN : ";
    public static final String s_prefixOut = "LOG  : ";
    public static final String s_prefixDebug = "DEBUG: ";
    public static final String s_prefixTrace = "TRACE: ";

    public DebugLogStream(PrintStream printStream, PrintStream printStream2, PrintStream printStream3, IDebugLogFormatter iDebugLogFormatter) {
        super(printStream);
        this.m_wrappedStream = printStream;
        this.m_wrappedWarnStream = printStream2;
        this.m_wrappedErrStream = printStream3;
        this.m_formatter = iDebugLogFormatter;
    }

    private void write(PrintStream printStream, String string) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string);
        if (string2 != null) {
            printStream.print(string2);
        }
    }

    private void writeln(PrintStream printStream, String string) {
        this.writeln(printStream, LogSeverity.General, s_prefixOut, string);
    }

    private void writeln(PrintStream printStream, String string, Object object) {
        this.writeln(printStream, LogSeverity.General, s_prefixOut, string, object);
    }

    private void writeln(PrintStream printStream, LogSeverity logSeverity, String string, String string2) {
        String string3 = this.m_formatter.format(logSeverity, string, "", string2);
        if (string3 != null) {
            printStream.println(string3);
        }
    }

    private void writeln(PrintStream printStream, LogSeverity logSeverity, String string, String string2, Object object) {
        String string3 = this.m_formatter.format(logSeverity, string, "", string2, object);
        if (string3 != null) {
            printStream.println(string3);
        }
    }

    public static String generateCallerPrefix() {
        StackTraceElement stackTraceElement = DebugLogStream.tryGetCallerTraceElement(4);
        if (stackTraceElement == null) {
            return "(UnknownStack)";
        }
        return DebugLogStream.getStackTraceElementString(stackTraceElement, false);
    }

    public static StackTraceElement tryGetCallerTraceElement(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length <= n) {
            return null;
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[n];
        return stackTraceElement;
    }

    public static String getStackTraceElementString(StackTraceElement stackTraceElement, boolean bl) {
        if (stackTraceElement == null) {
            return "(UnknownStack)";
        }
        String string = DebugLogStream.getUnqualifiedClassName(stackTraceElement.getClassName());
        String string2 = stackTraceElement.getMethodName();
        int n = stackTraceElement.getLineNumber();
        Object object = stackTraceElement.isNativeMethod() ? " (Native Method)" : (bl && n > -1 ? " line:" + n : "");
        String string3 = string + "." + string2 + (String)object;
        return string3;
    }

    public static String getTopStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "Null Exception";
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return "No Stack Trace Available";
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[0];
        return DebugLogStream.getStackTraceElementString(stackTraceElement, true);
    }

    public void printStackTrace() {
        this.printStackTrace(0, null);
    }

    public void printStackTrace(String string) {
        this.printStackTrace(0, string);
    }

    public void printStackTrace(int n, String string) {
        if (string != null) {
            this.println(string);
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n2 = n == 0 ? stackTraceElementArray.length : Math.min(n, stackTraceElementArray.length);
        for (int i = 0; i < n2; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            this.println("\t" + stackTraceElement.toString());
        }
    }

    private static String getUnqualifiedClassName(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n > -1 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public void debugln(String string) {
        if (this.m_formatter.isLogEnabled(LogSeverity.General)) {
            String string2 = DebugLogStream.generateCallerPrefix();
            String string3 = this.m_formatter.format(LogSeverity.General, s_prefixDebug, StringUtils.leftJustify(string2, 36) + "> ", "%s", string);
            this.m_wrappedStream.println(string3);
        }
    }

    public void debugln(String string, Object object) {
        if (this.m_formatter.isLogEnabled(LogSeverity.General)) {
            String string2 = DebugLogStream.generateCallerPrefix();
            String string3 = this.m_formatter.format(LogSeverity.General, s_prefixDebug, StringUtils.leftJustify(string2, 36) + "> ", string, object);
            this.m_wrappedStream.println(string3);
        }
    }

    public void debugln(String string, Object object, Object object2) {
        if (this.m_formatter.isLogEnabled(LogSeverity.General)) {
            String string2 = DebugLogStream.generateCallerPrefix();
            String string3 = this.m_formatter.format(LogSeverity.General, s_prefixDebug, StringUtils.leftJustify(string2, 36) + "> ", string, object, object2);
            this.m_wrappedStream.println(string3);
        }
    }

    public void debugln(String string, Object object, Object object2, Object object3) {
        if (this.m_formatter.isLogEnabled(LogSeverity.General)) {
            String string2 = DebugLogStream.generateCallerPrefix();
            String string3 = this.m_formatter.format(LogSeverity.General, s_prefixDebug, StringUtils.leftJustify(string2, 36) + "> ", string, object, object2, object3);
            this.m_wrappedStream.println(string3);
        }
    }

    public void debugln(String string, Object object, Object object2, Object object3, Object object4) {
        if (this.m_formatter.isLogEnabled(LogSeverity.General)) {
            String string2 = DebugLogStream.generateCallerPrefix();
            String string3 = this.m_formatter.format(LogSeverity.General, s_prefixDebug, StringUtils.leftJustify(string2, 36) + "> ", string, object, object2, object3, object4);
            this.m_wrappedStream.println(string3);
        }
    }

    public void debugln(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (this.m_formatter.isLogEnabled(LogSeverity.General)) {
            String string2 = DebugLogStream.generateCallerPrefix();
            String string3 = this.m_formatter.format(LogSeverity.General, s_prefixDebug, StringUtils.leftJustify(string2, 36) + "> ", string, object, object2, object3, object4, object5);
            this.m_wrappedStream.println(string3);
        }
    }

    public void debugln(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (this.m_formatter.isLogEnabled(LogSeverity.General)) {
            String string2 = DebugLogStream.generateCallerPrefix();
            String string3 = this.m_formatter.format(LogSeverity.General, s_prefixDebug, StringUtils.leftJustify(string2, 36) + "> ", string, object, object2, object3, object4, object5, object6);
            this.m_wrappedStream.println(string3);
        }
    }

    @Override
    public void print(boolean bl) {
        this.write(this.m_wrappedStream, bl ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(this.m_wrappedStream, String.valueOf(c));
    }

    @Override
    public void print(int n) {
        this.write(this.m_wrappedStream, String.valueOf(n));
    }

    @Override
    public void print(long l) {
        this.write(this.m_wrappedStream, String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(this.m_wrappedStream, String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(this.m_wrappedStream, String.valueOf(d));
    }

    @Override
    public void print(String string) {
        this.write(this.m_wrappedStream, String.valueOf(string));
    }

    @Override
    public void print(Object object) {
        this.write(this.m_wrappedStream, String.valueOf(object));
    }

    @Override
    public PrintStream printf(String string, Object ... objectArray) {
        this.write(this.m_wrappedStream, String.format(string, objectArray));
        return this;
    }

    @Override
    public void println() {
        this.writeln(this.m_wrappedStream, "");
    }

    @Override
    public void println(boolean bl) {
        this.writeln(this.m_wrappedStream, "%s", String.valueOf(bl));
    }

    @Override
    public void println(char c) {
        this.writeln(this.m_wrappedStream, "%s", String.valueOf(c));
    }

    @Override
    public void println(int n) {
        this.writeln(this.m_wrappedStream, "%s", String.valueOf(n));
    }

    @Override
    public void println(long l) {
        this.writeln(this.m_wrappedStream, "%s", String.valueOf(l));
    }

    @Override
    public void println(float f) {
        this.writeln(this.m_wrappedStream, "%s", String.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.writeln(this.m_wrappedStream, "%s", String.valueOf(d));
    }

    @Override
    public void println(char[] cArray) {
        this.writeln(this.m_wrappedStream, "%s", String.valueOf(cArray));
    }

    @Override
    public void println(String string) {
        this.writeln(this.m_wrappedStream, "%s", string);
    }

    @Override
    public void println(Object object) {
        this.writeln(this.m_wrappedStream, "%s", object);
    }

    public void println(String string, Object object) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2, Object object3) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2, object3);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2, object3, object4);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2, object3, object4, object5);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2, object3, object4, object5, object6);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2, object3, object4, object5, object6, object7);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2, object3, object4, object5, object6, object7, object8);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        String string2 = this.m_formatter.format(LogSeverity.General, s_prefixOut, "", string, object, object2, object3, object4, object5, object6, object7, object8, object9);
        if (string2 != null) {
            this.m_wrappedStream.println(string2);
        }
    }

    public void error(Object object) {
        this.writeln(this.m_wrappedErrStream, LogSeverity.Error, s_prefixErr, DebugLogStream.generateCallerPrefix() + "> " + String.valueOf(object));
    }

    public void error(String string, Object ... objectArray) {
        this.writeln(this.m_wrappedErrStream, LogSeverity.Error, s_prefixErr, DebugLogStream.generateCallerPrefix() + "> " + String.format(string, objectArray));
    }

    public void warn(Object object) {
        this.writeln(this.m_wrappedWarnStream, LogSeverity.Warning, s_prefixWarn, DebugLogStream.generateCallerPrefix() + "> " + String.valueOf(object));
    }

    public void warn(String string, Object ... objectArray) {
        this.writeln(this.m_wrappedWarnStream, LogSeverity.Warning, s_prefixWarn, DebugLogStream.generateCallerPrefix() + "> " + String.format(string, objectArray));
    }

    public void printUnitTest(String string, boolean bl, Object ... objectArray) {
        if (!bl) {
            this.error(string + ", fail", objectArray);
        } else {
            this.println(string + ", pass", objectArray);
        }
    }

    public void printException(Throwable throwable, String string, LogSeverity logSeverity) {
        this.printException(throwable, string, DebugLogStream.generateCallerPrefix(), logSeverity);
    }

    public void printException(Throwable throwable, String string, String string2, LogSeverity logSeverity) {
        boolean bl;
        PrintStream printStream;
        String string3;
        if (throwable == null) {
            this.warn("Null exception passed.");
            return;
        }
        switch (logSeverity) {
            case Trace: 
            case General: {
                string3 = s_prefixOut;
                printStream = this.m_wrappedStream;
                bl = false;
                break;
            }
            case Warning: {
                string3 = s_prefixWarn;
                printStream = this.m_wrappedWarnStream;
                bl = false;
                break;
            }
            default: {
                this.error("Unhandled LogSeverity: %s. Defaulted to Error.", String.valueOf((Object)logSeverity));
            }
            case Error: {
                string3 = s_prefixErr;
                printStream = this.m_wrappedErrStream;
                bl = true;
            }
        }
        if (string != null) {
            this.writeln(printStream, logSeverity, string3, String.format("%s> Exception thrown %s at %s. Message: %s", string2, throwable.toString(), DebugLogStream.getTopStackTraceString(throwable), string));
        } else {
            this.writeln(printStream, logSeverity, string3, String.format("%s> Exception thrown %s at %s.", string2, throwable.toString(), DebugLogStream.getTopStackTraceString(throwable)));
        }
        if (bl) {
            this.error("Stack trace:");
            throwable.printStackTrace(printStream);
        }
    }

    public void noise(String string) {
        String string2;
        String string3;
        if (Core.bDebug && this.m_formatter.isLogSeverityEnabled(LogSeverity.Debug) && (string3 = this.m_formatter.format(LogSeverity.Debug, s_prefixDebug, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", "%s", string)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void noise(String string, Object object) {
        String string2;
        String string3;
        if (Core.bDebug && this.m_formatter.isLogSeverityEnabled(LogSeverity.Debug) && (string3 = this.m_formatter.format(LogSeverity.Debug, s_prefixDebug, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void noise(String string, Object object, Object object2) {
        String string2;
        String string3;
        if (Core.bDebug && this.m_formatter.isLogSeverityEnabled(LogSeverity.Debug) && (string3 = this.m_formatter.format(LogSeverity.Debug, s_prefixDebug, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void noise(String string, Object object, Object object2, Object object3) {
        String string2;
        String string3;
        if (Core.bDebug && this.m_formatter.isLogSeverityEnabled(LogSeverity.Debug) && (string3 = this.m_formatter.format(LogSeverity.Debug, s_prefixDebug, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void noise(String string, Object object, Object object2, Object object3, Object object4) {
        String string2;
        String string3;
        if (Core.bDebug && this.m_formatter.isLogSeverityEnabled(LogSeverity.Debug) && (string3 = this.m_formatter.format(LogSeverity.Debug, s_prefixDebug, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3, object4)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void noise(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        String string2;
        String string3;
        if (Core.bDebug && this.m_formatter.isLogSeverityEnabled(LogSeverity.Debug) && (string3 = this.m_formatter.format(LogSeverity.Debug, s_prefixDebug, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3, object4, object5)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void noise(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string2;
        String string3;
        if (Core.bDebug && this.m_formatter.isLogSeverityEnabled(LogSeverity.Debug) && (string3 = this.m_formatter.format(LogSeverity.Debug, s_prefixDebug, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3, object4, object5, object6)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void trace(String string) {
        String string2;
        String string3;
        if (this.m_formatter.isLogSeverityEnabled(LogSeverity.Trace) && (string3 = this.m_formatter.format(LogSeverity.Trace, s_prefixTrace, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", "%s", string)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void trace(String string, Object object) {
        String string2;
        String string3;
        if (this.m_formatter.isLogSeverityEnabled(LogSeverity.Trace) && (string3 = this.m_formatter.format(LogSeverity.Trace, s_prefixTrace, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void trace(String string, Object object, Object object2) {
        String string2;
        String string3;
        if (this.m_formatter.isLogSeverityEnabled(LogSeverity.Trace) && (string3 = this.m_formatter.format(LogSeverity.Trace, s_prefixTrace, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void trace(String string, Object object, Object object2, Object object3) {
        String string2;
        String string3;
        if (this.m_formatter.isLogSeverityEnabled(LogSeverity.Trace) && (string3 = this.m_formatter.format(LogSeverity.Trace, s_prefixTrace, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void trace(String string, Object object, Object object2, Object object3, Object object4) {
        String string2;
        String string3;
        if (this.m_formatter.isLogSeverityEnabled(LogSeverity.Trace) && (string3 = this.m_formatter.format(LogSeverity.Trace, s_prefixTrace, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3, object4)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void trace(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        String string2;
        String string3;
        if (this.m_formatter.isLogSeverityEnabled(LogSeverity.Trace) && (string3 = this.m_formatter.format(LogSeverity.Trace, s_prefixTrace, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3, object4, object5)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }

    public void trace(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string2;
        String string3;
        if (this.m_formatter.isLogSeverityEnabled(LogSeverity.Trace) && (string3 = this.m_formatter.format(LogSeverity.Trace, s_prefixTrace, StringUtils.leftJustify(string2 = DebugLogStream.generateCallerPrefix(), 36) + "> ", string, object, object2, object3, object4, object5, object6)) != null) {
            this.m_wrappedStream.println(string3);
        }
    }
}

