/*
 * Decompiled with CFR 0.152.
 */
package zombie.debug;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import zombie.GameTime;
import zombie.ZomboidFileSystem;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.core.Core;
import zombie.core.logger.LoggerManager;
import zombie.core.logger.ZLogger;
import zombie.debug.DebugLogStream;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.debug.GeneralErrorDebugLogFormatter;
import zombie.debug.GenericDebugLogFormatter;
import zombie.debug.LogSeverity;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.ui.UIDebugConsole;
import zombie.util.StringUtils;

public final class DebugLog {
    private static final boolean[] m_enabledDebugTypes = new boolean[DebugType.values().length];
    private static final HashMap<DebugType, LogSeverity> logLevels = new HashMap();
    private static boolean s_initialized = false;
    public static boolean printServerTime = false;
    private static final OutputStreamWrapper s_stdout = new OutputStreamWrapper(System.out);
    private static final OutputStreamWrapper s_stderr = new OutputStreamWrapper(System.err);
    private static final PrintStream m_originalOut = new PrintStream(s_stdout, true);
    private static final PrintStream m_originalErr = new PrintStream(s_stderr, true);
    private static final PrintStream GeneralErr = new DebugLogStream(m_originalErr, m_originalErr, m_originalErr, new GeneralErrorDebugLogFormatter());
    private static ZLogger s_logFileLogger;
    public static final DebugLogStream ActionSystem;
    public static final DebugLogStream Animation;
    public static final DebugLogStream Asset;
    public static final DebugLogStream Clothing;
    public static final DebugLogStream Combat;
    public static final DebugLogStream Damage;
    public static final DebugLogStream Death;
    public static final DebugLogStream FileIO;
    public static final DebugLogStream Fireplace;
    public static final DebugLogStream General;
    public static final DebugLogStream Input;
    public static final DebugLogStream IsoRegion;
    public static final DebugLogStream Lua;
    public static final DebugLogStream MapLoading;
    public static final DebugLogStream Mod;
    public static final DebugLogStream Multiplayer;
    public static final DebugLogStream Network;
    public static final DebugLogStream NetworkFileDebug;
    public static final DebugLogStream Packet;
    public static final DebugLogStream Objects;
    public static final DebugLogStream Radio;
    public static final DebugLogStream Recipe;
    public static final DebugLogStream Script;
    public static final DebugLogStream Shader;
    public static final DebugLogStream Sound;
    public static final DebugLogStream Statistic;
    public static final DebugLogStream UnitTests;
    public static final DebugLogStream Vehicle;
    public static final DebugLogStream Voice;
    public static final DebugLogStream Zombie;
    public static final int VERSION = 1;

    private static DebugLogStream createDebugLogStream(DebugType debugType) {
        return new DebugLogStream(m_originalOut, m_originalOut, m_originalErr, new GenericDebugLogFormatter(debugType));
    }

    public static void enableLog(DebugType debugType, LogSeverity logSeverity) {
        DebugLog.setLogEnabled(debugType, true);
        logLevels.put(debugType, logSeverity);
    }

    public static LogSeverity getLogLevel(DebugType debugType) {
        return logLevels.get((Object)debugType);
    }

    public static boolean isLogEnabled(DebugType debugType, LogSeverity logSeverity) {
        return logSeverity.ordinal() >= logLevels.getOrDefault((Object)debugType, LogSeverity.Warning).ordinal();
    }

    public static boolean isLogEnabled(LogSeverity logSeverity, DebugType debugType) {
        return logSeverity.ordinal() >= LogSeverity.Warning.ordinal() || DebugLog.isEnabled(debugType);
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, "%s", string2);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3, Object object4) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3, object4);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3, object4, object5);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3, object4, object5, object6);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3, object4, object5, object6, object7);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3, object4, object5, object6, object7, object8);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3, object4, object5, object6, object7, object8, object9);
        }
        return null;
    }

    public static String formatString(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        if (DebugLog.isLogEnabled(logSeverity, debugType)) {
            return DebugLog.formatStringVarArgs(debugType, logSeverity, string, object, string2, object2, object3, object4, object5, object6, object7, object8, object9, object10);
        }
        return null;
    }

    public static String formatStringVarArgs(DebugType debugType, LogSeverity logSeverity, String string, Object object, String string2, Object ... objectArray) {
        if (!DebugLog.isLogEnabled(logSeverity, debugType)) {
            return null;
        }
        Object object2 = String.valueOf(System.currentTimeMillis());
        if (GameServer.bServer || GameClient.bClient || printServerTime) {
            object2 = (String)object2 + "> " + NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toMillis(GameTime.getServerTime()));
        }
        String string3 = string + StringUtils.leftJustify(debugType.toString(), 12) + ", " + (String)object2 + "> " + object + String.format(string2, objectArray);
        DebugLog.echoToLogFile(string3);
        return string3;
    }

    private static void echoToLogFile(String string) {
        if (s_logFileLogger == null) {
            if (s_initialized) {
                return;
            }
            s_logFileLogger = new ZLogger(GameServer.bServer ? "DebugLog-server" : "DebugLog", false);
        }
        try {
            s_logFileLogger.writeUnsafe(string, null, false);
        }
        catch (Exception exception) {
            m_originalErr.println("Exception thrown writing to log file.");
            m_originalErr.println(exception);
            exception.printStackTrace(m_originalErr);
        }
    }

    public static boolean isEnabled(DebugType debugType) {
        return m_enabledDebugTypes[debugType.ordinal()];
    }

    public static void log(DebugType debugType, String string) {
        String string2 = DebugLog.formatString(debugType, LogSeverity.General, "LOG  : ", "", "%s", string);
        if (string2 != null) {
            m_originalOut.println(string2);
        }
    }

    public static void setLogEnabled(DebugType debugType, boolean bl) {
        DebugLog.m_enabledDebugTypes[debugType.ordinal()] = bl;
    }

    public static void log(Object object) {
        DebugLog.log(DebugType.General, String.valueOf(object));
    }

    public static void log(String string) {
        DebugLog.log(DebugType.General, string);
    }

    public static ArrayList<DebugType> getDebugTypes() {
        ArrayList<DebugType> arrayList = new ArrayList<DebugType>(Arrays.asList(DebugType.values()));
        arrayList.sort((debugType, debugType2) -> String.CASE_INSENSITIVE_ORDER.compare(debugType.name(), debugType2.name()));
        return arrayList;
    }

    public static void save() {
        ArrayList<BooleanConfigOption> arrayList = new ArrayList<BooleanConfigOption>();
        for (DebugType debugType : DebugType.values()) {
            BooleanConfigOption booleanConfigOption = new BooleanConfigOption(debugType.name(), false);
            booleanConfigOption.setValue(DebugLog.isEnabled(debugType));
            arrayList.add(booleanConfigOption);
        }
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "debuglog.ini";
        ConfigFile configFile = new ConfigFile();
        configFile.write(string, 1, arrayList);
    }

    public static void load() {
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "debuglog.ini";
        if (configFile.read(string)) {
            for (int i = 0; i < configFile.getOptions().size(); ++i) {
                ConfigOption configOption = configFile.getOptions().get(i);
                try {
                    DebugLog.setLogEnabled(DebugType.valueOf(configOption.getName()), StringUtils.tryParseBoolean(configOption.getValueAsString()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void setStdOut(OutputStream outputStream) {
        s_stdout.setStream(outputStream);
    }

    public static void setStdErr(OutputStream outputStream) {
        s_stderr.setStream(outputStream);
    }

    public static void init() {
        if (s_initialized) {
            return;
        }
        s_initialized = true;
        DebugLog.setStdOut(System.out);
        DebugLog.setStdErr(System.err);
        System.setOut(General);
        System.setErr(GeneralErr);
        if (!GameServer.bServer) {
            DebugLog.load();
        }
        s_logFileLogger = LoggerManager.getLogger(GameServer.bServer ? "DebugLog-server" : "DebugLog");
    }

    static {
        ActionSystem = DebugLog.createDebugLogStream(DebugType.ActionSystem);
        Animation = DebugLog.createDebugLogStream(DebugType.Animation);
        Asset = DebugLog.createDebugLogStream(DebugType.Asset);
        Clothing = DebugLog.createDebugLogStream(DebugType.Clothing);
        Combat = DebugLog.createDebugLogStream(DebugType.Combat);
        Damage = DebugLog.createDebugLogStream(DebugType.Damage);
        Death = DebugLog.createDebugLogStream(DebugType.Death);
        FileIO = DebugLog.createDebugLogStream(DebugType.FileIO);
        Fireplace = DebugLog.createDebugLogStream(DebugType.Fireplace);
        General = DebugLog.createDebugLogStream(DebugType.General);
        Input = DebugLog.createDebugLogStream(DebugType.Input);
        IsoRegion = DebugLog.createDebugLogStream(DebugType.IsoRegion);
        Lua = DebugLog.createDebugLogStream(DebugType.Lua);
        MapLoading = DebugLog.createDebugLogStream(DebugType.MapLoading);
        Mod = DebugLog.createDebugLogStream(DebugType.Mod);
        Multiplayer = DebugLog.createDebugLogStream(DebugType.Multiplayer);
        Network = DebugLog.createDebugLogStream(DebugType.Network);
        NetworkFileDebug = DebugLog.createDebugLogStream(DebugType.NetworkFileDebug);
        Packet = DebugLog.createDebugLogStream(DebugType.Packet);
        Objects = DebugLog.createDebugLogStream(DebugType.Objects);
        Radio = DebugLog.createDebugLogStream(DebugType.Radio);
        Recipe = DebugLog.createDebugLogStream(DebugType.Recipe);
        Script = DebugLog.createDebugLogStream(DebugType.Script);
        Shader = DebugLog.createDebugLogStream(DebugType.Shader);
        Sound = DebugLog.createDebugLogStream(DebugType.Sound);
        Statistic = DebugLog.createDebugLogStream(DebugType.Statistic);
        UnitTests = DebugLog.createDebugLogStream(DebugType.UnitTests);
        Vehicle = DebugLog.createDebugLogStream(DebugType.Vehicle);
        Voice = DebugLog.createDebugLogStream(DebugType.Voice);
        Zombie = DebugLog.createDebugLogStream(DebugType.Zombie);
        DebugLog.enableLog(DebugType.Checksum, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.Combat, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.General, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.IsoRegion, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.Lua, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.Mod, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.Multiplayer, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.Network, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.Vehicle, LogSeverity.Debug);
        DebugLog.enableLog(DebugType.Voice, LogSeverity.Debug);
        if (GameServer.bServer) {
            DebugLog.enableLog(DebugType.Damage, LogSeverity.Debug);
            DebugLog.enableLog(DebugType.Death, LogSeverity.Debug);
            DebugLog.enableLog(DebugType.Statistic, LogSeverity.Debug);
        }
    }

    private static final class OutputStreamWrapper
    extends FilterOutputStream {
        public OutputStreamWrapper(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            if (Core.bDebug && UIDebugConsole.instance != null && DebugOptions.instance.UIDebugConsoleDebugLog.getValue()) {
                UIDebugConsole.instance.addOutput(byArray, n, n2);
            }
        }

        public void setStream(OutputStream outputStream) {
            this.out = outputStream;
        }
    }
}

