/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.znet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import se.krka.kahlua.vm.KahluaTable;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.core.textures.PNGDecoder;
import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshop;

public class SteamWorkshopItem {
    private String workshopFolder;
    private String PublishedFileId;
    private String title = "";
    private String description = "";
    private String visibility = "public";
    private final ArrayList<String> tags = new ArrayList();
    private String changeNote = "";
    private boolean bHasMod;
    private boolean bHasMap;
    private final ArrayList<String> modIDs = new ArrayList();
    private final ArrayList<String> mapFolders = new ArrayList();
    private static final int VERSION1 = 1;
    private static final int LATEST_VERSION = 1;

    public SteamWorkshopItem(String string) {
        this.workshopFolder = string;
    }

    public String getContentFolder() {
        return this.workshopFolder + File.separator + "Contents";
    }

    public String getFolderName() {
        return new File(this.workshopFolder).getName();
    }

    public void setID(String string) {
        if (string != null && !SteamUtils.isValidSteamID(string)) {
            string = null;
        }
        this.PublishedFileId = string;
    }

    public String getID() {
        return this.PublishedFileId;
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String string) {
        if (string == null) {
            string = "";
        }
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setVisibility(String string) {
        this.visibility = string;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibilityInteger(int n) {
        switch (n) {
            case 0: {
                this.visibility = "public";
                break;
            }
            case 1: {
                this.visibility = "friendsOnly";
                break;
            }
            case 2: {
                this.visibility = "private";
                break;
            }
            case 3: {
                this.visibility = "unlisted";
                break;
            }
            default: {
                this.visibility = "public";
            }
        }
    }

    public int getVisibilityInteger() {
        if ("public".equals(this.visibility)) {
            return 0;
        }
        if ("friendsOnly".equals(this.visibility)) {
            return 1;
        }
        if ("private".equals(this.visibility)) {
            return 2;
        }
        if ("unlisted".equals(this.visibility)) {
            return 3;
        }
        return 0;
    }

    public void setTags(ArrayList<String> arrayList) {
        this.tags.clear();
        this.tags.addAll(arrayList);
    }

    public static ArrayList<String> getAllowedTags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = ZomboidFileSystem.instance.getMediaFile("WorkshopTags.txt");
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).isEmpty()) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        return arrayList;
    }

    public ArrayList<String> getTags() {
        return this.tags;
    }

    public String getSubmitDescription() {
        int n;
        Object object = this.getDescription();
        if (!((String)object).isEmpty()) {
            object = (String)object + "\n\n";
        }
        object = (String)object + "Workshop ID: " + this.getID();
        for (n = 0; n < this.modIDs.size(); ++n) {
            object = (String)object + "\nMod ID: " + this.modIDs.get(n);
        }
        for (n = 0; n < this.mapFolders.size(); ++n) {
            object = (String)object + "\nMap Folder: " + this.mapFolders.get(n);
        }
        return object;
    }

    public String[] getSubmitTags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.tags);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreviewImage() {
        return this.workshopFolder + File.separator + "preview.png";
    }

    public void setChangeNote(String string) {
        if (string == null) {
            string = "";
        }
        this.changeNote = string;
    }

    public String getChangeNote() {
        return this.changeNote;
    }

    public boolean create() {
        return SteamWorkshop.instance.CreateWorkshopItem(this);
    }

    public boolean submitUpdate() {
        return SteamWorkshop.instance.SubmitWorkshopItem(this);
    }

    public boolean getUpdateProgress(KahluaTable kahluaTable) {
        if (kahluaTable == null) {
            throw new NullPointerException("table is null");
        }
        long[] lArray = new long[2];
        if (SteamWorkshop.instance.GetItemUpdateProgress(lArray)) {
            System.out.println(lArray[0] + "/" + lArray[1]);
            kahluaTable.rawset("processed", (Object)lArray[0]);
            kahluaTable.rawset("total", (Object)Math.max(lArray[1], 1L));
            return true;
        }
        return false;
    }

    public int getUpdateProgressTotal() {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateFileTypes(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            block13: {
                Iterator<Path> iterator = directoryStream.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Path path2 = iterator.next();
                    if (Files.isDirectory(path2, new LinkOption[0])) {
                        string = this.validateFileTypes(path2);
                        if (string == null) continue;
                        String string2 = string;
                        return string2;
                    }
                    string = path2.getFileName().toString();
                    if (!(!string.equalsIgnoreCase("pyramid.zip") && (string.endsWith(".exe") || string.endsWith(".dll") || string.endsWith(".bat") || string.endsWith(".app") || string.endsWith(".dylib") || string.endsWith(".sh") || string.endsWith(".so") || string.endsWith(".zip")))) {
                        continue;
                    }
                    break block13;
                }
                return null;
            }
            String string = "FileTypeNotAllowed";
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "IOError";
        }
    }

    private String validateModDotInfo(Path path) {
        String string = null;
        try (FileReader fileReader = new FileReader(path.toFile());
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.startsWith("id=")) continue;
                string = string2.replace("id=", "").trim();
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "MissingModDotInfo";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "IOError";
        }
        if (string == null || string.isEmpty()) {
            return "InvalidModDotInfo";
        }
        this.modIDs.add(string);
        return null;
    }

    private String validateMapDotInfo(Path path) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateMapFolder(Path path) {
        boolean bl = false;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (Files.isDirectory(path2, new LinkOption[0]) || !"map.info".equals(path2.getFileName().toString())) continue;
                String string = this.validateMapDotInfo(path2);
                if (string != null) {
                    String string2 = string;
                    return string2;
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "IOError";
        }
        if (!bl) {
            return "MissingMapDotInfo";
        }
        this.mapFolders.add(path.getFileName().toString());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateMapsFolder(Path path) {
        boolean bl = false;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                String string = this.validateMapFolder(path2);
                if (string != null) {
                    String string2 = string;
                    return string2;
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "IOError";
        }
        if (!bl) {
            return null;
        }
        this.bHasMap = true;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateMediaFolder(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            String string;
            Path path2;
            Iterator<Path> iterator = directoryStream.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!Files.isDirectory(path2 = iterator.next(), new LinkOption[0]) || !"maps".equals(path2.getFileName().toString()) || (string = this.validateMapsFolder(path2)) == null);
            String string2 = string;
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "IOError";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateModFolder(Path path) {
        boolean bl = false;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                String string;
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    if (!"media".equals(path2.getFileName().toString()) || (string = this.validateMediaFolder(path2)) == null) continue;
                    String string2 = string;
                    return string2;
                }
                if (!"mod.info".equals(path2.getFileName().toString())) continue;
                string = this.validateModDotInfo(path2);
                if (string != null) {
                    String string3 = string;
                    return string3;
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "IOError";
        }
        if (bl) return null;
        return "MissingModDotInfo";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateModsFolder(Path path) {
        boolean bl = false;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                String string;
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    string = this.validateModFolder(path2);
                    if (string != null) {
                        String string2 = string;
                        return string2;
                    }
                    bl = true;
                    continue;
                }
                string = "FileNotAllowedInMods";
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "IOError";
        }
        if (!bl) {
            return "EmptyModsFolder";
        }
        this.bHasMod = true;
        return null;
    }

    private String validateBuildingsFolder(Path path) {
        return null;
    }

    private String validateCreativeFolder(Path path) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String validatePreviewImage(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) return "PreviewNotFound";
        if (!Files.isReadable(path)) return "PreviewNotFound";
        if (Files.isDirectory(path, new LinkOption[0])) {
            return "PreviewNotFound";
        }
        if (Files.size(path) > 1024000L) {
            return "PreviewFileSize";
        }
        try (FileInputStream fileInputStream = new FileInputStream(path.toFile());
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            PNGDecoder pNGDecoder = new PNGDecoder(bufferedInputStream, false);
            if (pNGDecoder.getWidth() == 256) {
                if (pNGDecoder.getHeight() == 256) return null;
            }
            String string = "PreviewDimensions";
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "PreviewFormat";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String validateContents() {
        this.bHasMod = false;
        this.bHasMap = false;
        this.modIDs.clear();
        this.mapFolders.clear();
        try {
            Path path = FileSystems.getDefault().getPath(this.getContentFolder(), new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return "MissingContents";
            }
            Path path2 = FileSystems.getDefault().getPath(this.getPreviewImage(), new String[0]);
            String string = this.validatePreviewImage(path2);
            if (string != null) {
                return string;
            }
            boolean bl = false;
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path3 : directoryStream) {
                    if (Files.isDirectory(path3, new LinkOption[0])) {
                        if ("buildings".equals(path3.getFileName().toString())) {
                            string = this.validateBuildingsFolder(path3);
                            if (string != null) {
                                String string2 = string;
                                return string2;
                            }
                        } else if ("creative".equals(path3.getFileName().toString())) {
                            string = this.validateCreativeFolder(path3);
                            if (string != null) {
                                String string3 = string;
                                return string3;
                            }
                        } else {
                            if (!"mods".equals(path3.getFileName().toString())) {
                                String string4 = "FolderNotAllowedInContents";
                                return string4;
                            }
                            string = this.validateModsFolder(path3);
                            if (string != null) {
                                String string5 = string;
                                return string5;
                            }
                        }
                        bl = true;
                        continue;
                    }
                    String string6 = "FileNotAllowedInContents";
                    return string6;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "IOError";
            }
            if (bl) return this.validateFileTypes(path);
            return "EmptyContentsFolder";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "IOError";
        }
    }

    public String getExtendedErrorInfo(String string) {
        if ("FolderNotAllowedInContents".equals(string)) {
            return "buildings/ creative/ mods/";
        }
        if ("FileTypeNotAllowed".equals(string)) {
            return "*.exe *.dll *.bat *.app *.dylib *.sh *.so *.zip";
        }
        return "";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean readWorkshopTxt() {
        String string = this.workshopFolder + File.separator + "workshop.txt";
        if (!new File(string).exists()) {
            return true;
        }
        try (FileReader fileReader = new FileReader(string);){
            boolean bl;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).isEmpty() || string2.startsWith("#") || string2.startsWith("//")) continue;
                    if (string2.startsWith("id=")) {
                        String string3 = string2.replace("id=", "");
                        this.setID(string3);
                        continue;
                    }
                    if (string2.startsWith("description=")) {
                        if (!this.description.isEmpty()) {
                            this.description = this.description + "\n";
                        }
                        this.description = this.description + string2.replace("description=", "");
                        continue;
                    }
                    if (string2.startsWith("tags=")) {
                        this.tags.addAll(Arrays.asList(string2.replace("tags=", "").split(";")));
                        continue;
                    }
                    if (string2.startsWith("title=")) {
                        this.title = string2.replace("title=", "");
                        continue;
                    }
                    if (string2.startsWith("version=") || !string2.startsWith("visibility=")) continue;
                    this.visibility = string2.replace("visibility=", "");
                }
                bl = true;
            }
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeWorkshopTxt() {
        String string = this.workshopFolder + File.separator + "workshop.txt";
        File file = new File(string);
        try {
            void var5_8;
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("version=1");
            bufferedWriter.newLine();
            bufferedWriter.write("id=" + (this.PublishedFileId == null ? "" : this.PublishedFileId));
            bufferedWriter.newLine();
            bufferedWriter.write("title=" + this.title);
            bufferedWriter.newLine();
            String[] object = this.description.split("\n");
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                String string2 = object[i];
                bufferedWriter.write("description=" + string2);
                bufferedWriter.newLine();
            }
            String string3 = "";
            for (n = 0; n < this.tags.size(); ++n) {
                String string4 = (String)var5_8 + this.tags.get(n);
                if (n >= this.tags.size() - 1) continue;
                String string5 = string4 + ";";
            }
            bufferedWriter.write("tags=" + (String)var5_8);
            bufferedWriter.newLine();
            bufferedWriter.write("visibility=" + this.visibility);
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public static enum ItemState {
        None(0),
        Subscribed(1),
        LegacyItem(2),
        Installed(4),
        NeedsUpdate(8),
        Downloading(16),
        DownloadPending(32);

        private final int value;

        private ItemState(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public boolean and(ItemState itemState) {
            return (this.value & itemState.value) != 0;
        }

        public boolean and(long l) {
            return ((long)this.value & l) != 0L;
        }

        public boolean not(long l) {
            return ((long)this.value & l) == 0L;
        }

        public static String toString(long l) {
            if (l == (long)None.getValue()) {
                return "None";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (ItemState itemState : ItemState.values()) {
                if (itemState == None || !itemState.and(l)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(itemState.name());
            }
            return stringBuilder.toString();
        }
    }
}

