/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.znet;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import zombie.Lua.LuaEventManager;
import zombie.core.logger.ExceptionLogger;
import zombie.core.opengl.RenderThread;
import zombie.core.znet.IJoinRequestCallback;
import zombie.core.znet.ZNet;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.network.CoopSlave;
import zombie.network.GameServer;
import zombie.network.ServerWorldDatabase;

public class SteamUtils {
    private static boolean m_steamEnabled;
    private static boolean m_netEnabled;
    private static boolean m_floatingGamepadTextInputVisible;
    private static final BigInteger TWO_64;
    private static final BigInteger MAX_ULONG;
    private static List<IJoinRequestCallback> m_joinRequestCallbacks;
    public static final int k_EGamepadTextInputModeNormal = 0;
    public static final int k_EGamepadTextInputModePassword = 1;
    public static final int k_EGamepadTextInputLineModeSingleLine = 0;
    public static final int k_EGamepadTextInputLineModeMultipleLines = 1;
    public static final int k_EFloatingGamepadTextInputModeSingleLine = 0;
    public static final int k_EFloatingGamepadTextInputModeMultipleLines = 1;
    public static final int k_EFloatingGamepadTextInputModeEmail = 2;
    public static final int k_EFloatingGamepadTextInputModeNumeric = 3;

    private static void loadLibrary(String string) {
        DebugLog.log("Loading " + string + "...");
        System.loadLibrary(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Object object;
        block33: {
            m_steamEnabled = System.getProperty("zomboid.steam") != null && System.getProperty("zomboid.steam").equals("1");
            DebugLog.log("Loading networking libraries...");
            String string = "";
            if ("1".equals(System.getProperty("zomboid.debuglibs.znet"))) {
                DebugLog.log("***** Loading debug versions of libraries");
                string = "d";
            }
            try {
                if (System.getProperty("os.name").contains("OS X")) {
                    if (m_steamEnabled) {
                        SteamUtils.loadLibrary("steam_api");
                        SteamUtils.loadLibrary("RakNet");
                        SteamUtils.loadLibrary("ZNetJNI");
                    } else {
                        SteamUtils.loadLibrary("RakNet");
                        SteamUtils.loadLibrary("ZNetNoSteam");
                    }
                } else if (System.getProperty("os.name").startsWith("Win")) {
                    if (System.getProperty("sun.arch.data.model").equals("64")) {
                        if (m_steamEnabled) {
                            SteamUtils.loadLibrary("steam_api64");
                            SteamUtils.loadLibrary("RakNet64" + string);
                            SteamUtils.loadLibrary("ZNetJNI64" + string);
                        } else {
                            SteamUtils.loadLibrary("RakNet64" + string);
                            SteamUtils.loadLibrary("ZNetNoSteam64" + string);
                        }
                    } else if (m_steamEnabled) {
                        SteamUtils.loadLibrary("steam_api");
                        SteamUtils.loadLibrary("RakNet32" + string);
                        SteamUtils.loadLibrary("ZNetJNI32" + string);
                    } else {
                        SteamUtils.loadLibrary("RakNet32" + string);
                        SteamUtils.loadLibrary("ZNetNoSteam32" + string);
                    }
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    if (m_steamEnabled) {
                        SteamUtils.loadLibrary("steam_api");
                        SteamUtils.loadLibrary("RakNet64");
                        SteamUtils.loadLibrary("ZNetJNI64");
                    } else {
                        SteamUtils.loadLibrary("RakNet64");
                        SteamUtils.loadLibrary("ZNetNoSteam64");
                    }
                } else if (m_steamEnabled) {
                    SteamUtils.loadLibrary("steam_api");
                    SteamUtils.loadLibrary("RakNet32");
                    SteamUtils.loadLibrary("ZNetJNI32");
                } else {
                    SteamUtils.loadLibrary("RakNet32");
                    SteamUtils.loadLibrary("ZNetNoSteam32");
                }
                m_netEnabled = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                m_steamEnabled = false;
                m_netEnabled = false;
                ExceptionLogger.logException(unsatisfiedLinkError);
                if (!System.getProperty("os.name").startsWith("Win")) break block33;
                DebugLog.log("One of the game's DLLs could not be loaded.");
                DebugLog.log("  Your system may be missing a DLL needed by the game's DLL.");
                DebugLog.log("  You may need to install the Microsoft Visual C++ Redistributable 2013.");
                object = new File("../_CommonRedist/vcredist/");
                if (!((File)object).exists()) break block33;
                DebugLog.log("  This file is provided in " + ((File)object).getAbsolutePath());
            }
        }
        String string = System.getProperty("zomboid.znetlog");
        if (m_netEnabled && string != null) {
            try {
                int n = Integer.parseInt(string);
                ZNet.SetLogLevel(n);
            }
            catch (NumberFormatException numberFormatException) {
                ExceptionLogger.logException(numberFormatException);
            }
        }
        if (!m_netEnabled) {
            DebugLog.log("Failed to load networking libraries");
        } else {
            ZNet.init();
            ZNet.SetLogLevel(DebugLog.getLogLevel(DebugType.Network));
            object = RenderThread.m_contextLock;
            synchronized (object) {
                if (!m_steamEnabled) {
                    DebugLog.log("SteamUtils started without Steam");
                } else if (SteamUtils.n_Init(GameServer.bServer)) {
                    DebugLog.log("SteamUtils initialised successfully");
                } else {
                    DebugLog.log("Could not initialise SteamUtils");
                    m_steamEnabled = false;
                }
            }
        }
        m_joinRequestCallbacks = new ArrayList<IJoinRequestCallback>();
    }

    public static void shutdown() {
        if (m_steamEnabled) {
            SteamUtils.n_Shutdown();
        }
    }

    public static void runLoop() {
        if (m_steamEnabled) {
            SteamUtils.n_RunLoop();
        }
    }

    public static boolean isSteamModeEnabled() {
        return m_steamEnabled;
    }

    public static boolean isOverlayEnabled() {
        return m_steamEnabled && SteamUtils.n_IsOverlayEnabled();
    }

    public static String convertSteamIDToString(long l) {
        BigInteger bigInteger = BigInteger.valueOf(l);
        if (bigInteger.signum() < 0) {
            bigInteger.add(TWO_64);
        }
        return bigInteger.toString();
    }

    public static boolean isValidSteamID(String string) {
        try {
            BigInteger bigInteger = new BigInteger(string);
            if (bigInteger.signum() < 0 || bigInteger.compareTo(MAX_ULONG) > 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static long convertStringToSteamID(String string) {
        try {
            BigInteger bigInteger = new BigInteger(string);
            if (bigInteger.signum() < 0 || bigInteger.compareTo(MAX_ULONG) > 0) {
                return -1L;
            }
            return bigInteger.longValue();
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static void addJoinRequestCallback(IJoinRequestCallback iJoinRequestCallback) {
        m_joinRequestCallbacks.add(iJoinRequestCallback);
    }

    public static void removeJoinRequestCallback(IJoinRequestCallback iJoinRequestCallback) {
        m_joinRequestCallbacks.remove(iJoinRequestCallback);
    }

    public static boolean isRunningOnSteamDeck() {
        return SteamUtils.n_IsSteamRunningOnSteamDeck();
    }

    public static boolean showGamepadTextInput(boolean bl, boolean bl2, String string, int n, String string2) {
        return SteamUtils.n_ShowGamepadTextInput(bl ? 1 : 0, bl2 ? 1 : 0, string, n, string2);
    }

    public static boolean showFloatingGamepadTextInput(boolean bl, int n, int n2, int n3, int n4) {
        if (m_floatingGamepadTextInputVisible) {
            return true;
        }
        m_floatingGamepadTextInputVisible = SteamUtils.n_ShowFloatingGamepadTextInput(bl ? 1 : 0, n, n2, n3, n4);
        return m_floatingGamepadTextInputVisible;
    }

    public static boolean isFloatingGamepadTextInputVisible() {
        return m_floatingGamepadTextInputVisible;
    }

    private static native boolean n_Init(boolean var0);

    private static native void n_Shutdown();

    private static native void n_RunLoop();

    private static native boolean n_IsOverlayEnabled();

    private static native boolean n_IsSteamRunningOnSteamDeck();

    private static native boolean n_ShowGamepadTextInput(int var0, int var1, String var2, int var3, String var4);

    private static native boolean n_ShowFloatingGamepadTextInput(int var0, int var1, int var2, int var3, int var4);

    private static void joinRequestCallback(long l, String string) {
        DebugLog.log("Got Join Request");
        for (IJoinRequestCallback iJoinRequestCallback : m_joinRequestCallbacks) {
            iJoinRequestCallback.onJoinRequest(l, string);
        }
        if (string.contains("+connect ")) {
            String string2 = string.substring(9);
            System.setProperty("args.server.connect", string2);
            LuaEventManager.triggerEvent("OnSteamGameJoin");
        }
    }

    private static int clientInitiateConnectionCallback(long l) {
        if (CoopSlave.instance != null) {
            return CoopSlave.instance.isHost(l) || CoopSlave.instance.isInvited(l) ? 0 : 2;
        }
        ServerWorldDatabase.LogonResult logonResult = ServerWorldDatabase.instance.authClient(l);
        return logonResult.bAuthorized ? 0 : 1;
    }

    private static int validateOwnerCallback(long l, long l2) {
        if (CoopSlave.instance != null) {
            return 0;
        }
        ServerWorldDatabase.LogonResult logonResult = ServerWorldDatabase.instance.authOwner(l, l2);
        return logonResult.bAuthorized ? 0 : 1;
    }

    private static void gamepadTextInputDismissedCallback(String string) {
        if (string == null) {
            DebugLog.log("null");
        } else {
            DebugLog.log(string);
        }
    }

    private static void floatingGamepadTextInputDismissedCallback() {
        m_floatingGamepadTextInputVisible = false;
    }

    static {
        m_floatingGamepadTextInputVisible = false;
        TWO_64 = BigInteger.ONE.shiftLeft(64);
        MAX_ULONG = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    }
}

