/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.znet;

import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshop;
import zombie.core.znet.SteamWorkshopItem;
import zombie.debug.DebugLog;

public class SteamUGCDetails {
    private long ID;
    private String title;
    private long timeCreated;
    private long timeUpdated;
    private int fileSize;
    private long[] childIDs;

    public SteamUGCDetails(long l, String string, long l2, long l3, int n, long[] lArray) {
        this.ID = l;
        this.title = string;
        this.timeCreated = l2;
        this.timeUpdated = l3;
        this.fileSize = n;
        this.childIDs = lArray;
    }

    public long getID() {
        return this.ID;
    }

    public String getIDString() {
        return SteamUtils.convertSteamIDToString(this.ID);
    }

    public String getTitle() {
        return this.title;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeUpdated() {
        return this.timeUpdated;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public long[] getChildren() {
        return this.childIDs;
    }

    public int getNumChildren() {
        return this.childIDs == null ? 0 : this.childIDs.length;
    }

    public long getChildID(int n) {
        if (n < 0 || n >= this.getNumChildren()) {
            throw new IndexOutOfBoundsException("invalid child index");
        }
        return this.childIDs[n];
    }

    public String getState() {
        long l = SteamWorkshop.instance.GetItemState(this.ID);
        if (!SteamWorkshopItem.ItemState.Subscribed.and(l)) {
            return "NotSubscribed";
        }
        if (SteamWorkshopItem.ItemState.DownloadPending.and(l)) {
            DebugLog.log(SteamWorkshopItem.ItemState.toString(l) + " ID=" + this.ID);
            return "Downloading";
        }
        if (SteamWorkshopItem.ItemState.NeedsUpdate.and(l)) {
            return "NeedsUpdate";
        }
        if (SteamWorkshopItem.ItemState.Installed.and(l)) {
            return "Installed";
        }
        return "Error";
    }
}

