/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.znet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import zombie.Lua.LuaEventManager;
import zombie.core.textures.Texture;
import zombie.core.znet.SteamFriend;
import zombie.core.znet.SteamUtils;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class SteamFriends {
    public static final int k_EPersonaStateOffline = 0;
    public static final int k_EPersonaStateOnline = 1;
    public static final int k_EPersonaStateBusy = 2;
    public static final int k_EPersonaStateAway = 3;
    public static final int k_EPersonaStateSnooze = 4;
    public static final int k_EPersonaStateLookingToTrade = 5;
    public static final int k_EPersonaStateLookingToPlay = 6;

    public static void init() {
        if (SteamUtils.isSteamModeEnabled()) {
            SteamFriends.n_Init();
        }
    }

    public static void shutdown() {
        if (SteamUtils.isSteamModeEnabled()) {
            SteamFriends.n_Shutdown();
        }
    }

    public static native void n_Init();

    public static native void n_Shutdown();

    public static native String GetPersonaName();

    public static native int GetFriendCount();

    public static native long GetFriendByIndex(int var0);

    public static native String GetFriendPersonaName(long var0);

    public static native int GetFriendPersonaState(long var0);

    public static native boolean InviteUserToGame(long var0, String var2);

    public static native void ActivateGameOverlay(String var0);

    public static native void ActivateGameOverlayToUser(String var0, long var1);

    public static native void ActivateGameOverlayToWebPage(String var0);

    public static native void SetPlayedWith(long var0);

    public static native void UpdateRichPresenceConnectionInfo(String var0, String var1);

    public static List<SteamFriend> GetFriendList() {
        ArrayList<SteamFriend> arrayList = new ArrayList<SteamFriend>();
        int n = SteamFriends.GetFriendCount();
        for (int i = 0; i < n; ++i) {
            long l = SteamFriends.GetFriendByIndex(i);
            String string = SteamFriends.GetFriendPersonaName(l);
            arrayList.add(new SteamFriend(string, l));
        }
        return arrayList;
    }

    public static native int CreateSteamAvatar(long var0, ByteBuffer var2);

    private static void onStatusChangedCallback(long l) {
        if (GameClient.bClient || GameServer.bServer) {
            LuaEventManager.triggerEvent("OnSteamFriendStatusChanged", Long.toString(l));
        }
    }

    private static void onAvatarChangedCallback(long l) {
        Texture.steamAvatarChanged(l);
    }

    private static void onProfileNameChanged(long l) {
    }
}

