/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.znet;

import zombie.core.textures.Texture;
import zombie.core.znet.SteamFriends;
import zombie.core.znet.SteamUtils;

public class SteamFriend {
    private String name = "";
    private long steamID;
    private String steamIDString;

    public SteamFriend() {
    }

    public SteamFriend(String string, long l) {
        this.steamID = l;
        this.steamIDString = SteamUtils.convertSteamIDToString(l);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getSteamID() {
        return this.steamIDString;
    }

    public Texture getAvatar() {
        return Texture.getSteamAvatar(this.steamID);
    }

    public String getState() {
        int n = SteamFriends.GetFriendPersonaState(this.steamID);
        switch (n) {
            case 0: {
                return "Offline";
            }
            case 1: {
                return "Online";
            }
            case 2: {
                return "Busy";
            }
            case 3: {
                return "Away";
            }
            case 4: {
                return "Snooze";
            }
            case 5: {
                return "LookingToTrade";
            }
            case 6: {
                return "LookingToPlay";
            }
        }
        return "Unknown";
    }
}

