/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.io.Serializable;
import java.util.Arrays;

public class IntGrid
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int width;
    private final int height;
    private final int[] value;

    public IntGrid(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.value = new int[n * n2];
    }

    public IntGrid clone() throws CloneNotSupportedException {
        IntGrid intGrid = new IntGrid(this.width, this.height);
        System.arraycopy(this.value, 0, intGrid.value, 0, this.value.length);
        return intGrid;
    }

    public void clear() {
        Arrays.fill(this.value, 0);
    }

    public void fill(int n) {
        Arrays.fill(this.value, n);
    }

    private int getIndex(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return -1;
        }
        return n + n2 * this.width;
    }

    public int getValue(int n, int n2) {
        int n3 = this.getIndex(n, n2);
        if (n3 == -1) {
            return 0;
        }
        return this.value[n3];
    }

    public void setValue(int n, int n2, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 == -1) {
            return;
        }
        this.value[n4] = n3;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }
}

