/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjglx.BufferUtils;
import zombie.core.Core;
import zombie.core.textures.Texture;
import zombie.core.utils.WrappedBuffer;

public class ImageUtils {
    public static boolean USE_MIPMAP = true;

    private ImageUtils() {
    }

    public static void depureTexture(Texture texture, float f) {
        WrappedBuffer wrappedBuffer = texture.getData();
        ByteBuffer byteBuffer = wrappedBuffer.getBuffer();
        byteBuffer.rewind();
        int n = (int)(f * 255.0f);
        long l = texture.getWidthHW() * texture.getHeightHW();
        int n2 = 0;
        while ((long)n2 < l) {
            byteBuffer.mark();
            byteBuffer.get();
            byteBuffer.get();
            byteBuffer.get();
            int n3 = byteBuffer.get();
            int n4 = n3 < 0 ? 256 + n3 : n3;
            if (n4 < n) {
                byteBuffer.reset();
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
            }
            ++n2;
        }
        byteBuffer.flip();
        texture.setData(byteBuffer);
        wrappedBuffer.dispose();
    }

    public static int getNextPowerOfTwo(int n) {
        int n2;
        for (n2 = 2; n2 < n; n2 += n2) {
        }
        return n2;
    }

    public static int getNextPowerOfTwoHW(int n) {
        int n2;
        for (n2 = 2; n2 < n; n2 += n2) {
        }
        return n2;
    }

    public static Texture getScreenShot() {
        Texture texture = new Texture(Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), 0);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(4);
        texture.bind();
        intBuffer.rewind();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)6408, (int)0, (int)0, (int)texture.getWidthHW(), (int)texture.getHeightHW(), (int)0);
        return texture;
    }

    public static ByteBuffer makeTransp(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5) {
        return ImageUtils.makeTransp(byteBuffer, n, n2, n3, 0, n4, n5);
    }

    public static ByteBuffer makeTransp(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int n6) {
        byteBuffer.rewind();
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                byte by = byteBuffer.get();
                byte by2 = byteBuffer.get();
                byte by3 = byteBuffer.get();
                if (by == (byte)n && by2 == (byte)n2 && by3 == (byte)n3) {
                    byteBuffer.put((byte)n4);
                    continue;
                }
                byteBuffer.get();
            }
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static void saveBmpImage(Texture texture, String string) {
        ImageUtils.saveImage(texture, string, "bmp");
    }

    public static void saveImage(Texture texture, String string, String string2) {
        BufferedImage bufferedImage = new BufferedImage(texture.getWidth(), texture.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WrappedBuffer wrappedBuffer = texture.getData();
        ByteBuffer byteBuffer = wrappedBuffer.getBuffer();
        byteBuffer.rewind();
        for (int i = 0; i < texture.getHeightHW() && i < texture.getHeight(); ++i) {
            for (int j = 0; j < texture.getWidthHW(); ++j) {
                if (j >= texture.getWidth()) {
                    byteBuffer.get();
                    byteBuffer.get();
                    byteBuffer.get();
                    byteBuffer.get();
                    continue;
                }
                writableRaster.setPixel(j, texture.getHeight() - 1 - i, new int[]{byteBuffer.get(), byteBuffer.get(), byteBuffer.get()});
                byteBuffer.get();
            }
        }
        wrappedBuffer.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveJpgImage(Texture texture, String string) {
        ImageUtils.saveImage(texture, string, "jpg");
    }

    public static void savePngImage(Texture texture, String string) {
        ImageUtils.saveImage(texture, string, "png");
    }
}

