/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import zombie.iso.IsoGridSquare;

public final class FibonacciHeap<T> {
    private Entry<T> mMin = null;
    private int mSize = 0;
    List<Entry<T>> treeTable = new ArrayList<Entry<T>>(300);
    List<Entry<T>> toVisit = new ArrayList<Entry<T>>(300);

    public void empty() {
        this.mMin = null;
        this.mSize = 0;
    }

    public Entry<T> enqueue(T t, double d) {
        this.checkPriority(d);
        Entry<T> entry = new Entry<T>(t, d);
        this.mMin = FibonacciHeap.mergeLists(this.mMin, entry);
        ++this.mSize;
        return entry;
    }

    public Entry<T> min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Heap is empty.");
        }
        return this.mMin;
    }

    public boolean isEmpty() {
        return this.mMin == null;
    }

    public int size() {
        return this.mSize;
    }

    public static <T> FibonacciHeap<T> merge(FibonacciHeap<T> fibonacciHeap, FibonacciHeap<T> fibonacciHeap2) {
        FibonacciHeap<T> fibonacciHeap3 = new FibonacciHeap<T>();
        fibonacciHeap3.mMin = FibonacciHeap.mergeLists(fibonacciHeap.mMin, fibonacciHeap2.mMin);
        fibonacciHeap3.mSize = fibonacciHeap.mSize + fibonacciHeap2.mSize;
        fibonacciHeap2.mSize = 0;
        fibonacciHeap.mSize = 0;
        fibonacciHeap.mMin = null;
        fibonacciHeap2.mMin = null;
        return fibonacciHeap3;
    }

    /*
     * WARNING - void declaration
     */
    public Entry<T> dequeueMin() {
        Object object;
        if (this.isEmpty()) {
            throw new NoSuchElementException("Heap is empty.");
        }
        --this.mSize;
        Entry<T> entry = this.mMin;
        if (this.mMin.mNext == this.mMin) {
            this.mMin = null;
        } else {
            this.mMin.mPrev.mNext = this.mMin.mNext;
            this.mMin.mNext.mPrev = this.mMin.mPrev;
            this.mMin = this.mMin.mNext;
        }
        if (entry.mChild != null) {
            object = entry.mChild;
            do {
                ((Entry)object).mParent = null;
            } while ((object = ((Entry)object).mNext) != entry.mChild);
        }
        this.mMin = FibonacciHeap.mergeLists(this.mMin, entry.mChild);
        if (this.mMin == null) {
            return entry;
        }
        this.treeTable.clear();
        this.toVisit.clear();
        object = this.mMin;
        while (this.toVisit.isEmpty() || this.toVisit.get(0) != object) {
            this.toVisit.add((Entry<T>)object);
            object = ((Entry)object).mNext;
        }
        for (Entry entry2 : this.toVisit) {
            void entry22;
            while (true) {
                if (entry22.mDegree >= this.treeTable.size()) {
                    this.treeTable.add(null);
                    continue;
                }
                if (this.treeTable.get(entry22.mDegree) == null) break;
                Entry<T> entry3 = this.treeTable.get(entry22.mDegree);
                this.treeTable.set(entry22.mDegree, null);
                Entry<T> entry4 = entry3.mPriority < entry22.mPriority ? entry3 : entry22;
                Entry<T> entry5 = entry3.mPriority < entry22.mPriority ? entry22 : entry3;
                entry5.mNext.mPrev = entry5.mPrev;
                entry5.mPrev.mNext = entry5.mNext;
                entry5.mPrev = entry5;
                entry5.mNext = entry5.mPrev;
                entry4.mChild = FibonacciHeap.mergeLists(entry4.mChild, entry5);
                entry5.mParent = entry4;
                entry5.mIsMarked = false;
                ++entry4.mDegree;
                Entry<T> entry6 = entry4;
            }
            this.treeTable.set(entry22.mDegree, (Entry<T>)entry22);
            if (!(entry22.mPriority <= this.mMin.mPriority)) continue;
            this.mMin = entry22;
        }
        return entry;
    }

    public void decreaseKey(Entry<T> entry, double d) {
        this.checkPriority(d);
        if (d > entry.mPriority) {
            throw new IllegalArgumentException("New priority exceeds old.");
        }
        this.decreaseKeyUnchecked(entry, d);
    }

    public void delete(Entry<T> entry) {
        this.decreaseKeyUnchecked(entry, Double.NEGATIVE_INFINITY);
        this.dequeueMin();
    }

    public void delete(int n, IsoGridSquare isoGridSquare) {
    }

    private void checkPriority(double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException(d + " is invalid.");
        }
    }

    private static <T> Entry<T> mergeLists(Entry<T> entry, Entry<T> entry2) {
        if (entry == null && entry2 == null) {
            return null;
        }
        if (entry != null && entry2 == null) {
            return entry;
        }
        if (entry == null && entry2 != null) {
            return entry2;
        }
        Entry entry3 = entry.mNext;
        entry.mNext = entry2.mNext;
        entry.mNext.mPrev = entry;
        entry2.mNext = entry3;
        entry2.mNext.mPrev = entry2;
        return entry.mPriority < entry2.mPriority ? entry : entry2;
    }

    private void decreaseKeyUnchecked(Entry<T> entry, double d) {
        entry.mPriority = d;
        if (entry.mParent != null && entry.mPriority <= entry.mParent.mPriority) {
            this.cutNode(entry);
        }
        if (entry.mPriority <= this.mMin.mPriority) {
            this.mMin = entry;
        }
    }

    private void decreaseKeyUncheckedNode(Entry<IsoGridSquare> entry, double d) {
        entry.mPriority = d;
        if (entry.mParent != null && entry.mPriority <= entry.mParent.mPriority) {
            this.cutNodeNode(entry);
        }
        if (entry.mPriority <= this.mMin.mPriority) {
            this.mMin = entry;
        }
    }

    private void cutNode(Entry<T> entry) {
        entry.mIsMarked = false;
        if (entry.mParent == null) {
            return;
        }
        if (entry.mNext != entry) {
            entry.mNext.mPrev = entry.mPrev;
            entry.mPrev.mNext = entry.mNext;
        }
        if (entry.mParent.mChild == entry) {
            entry.mParent.mChild = entry.mNext != entry ? entry.mNext : null;
        }
        --entry.mParent.mDegree;
        entry.mNext = entry;
        entry.mPrev = entry.mNext;
        this.mMin = FibonacciHeap.mergeLists(this.mMin, entry);
        if (entry.mParent.mIsMarked) {
            this.cutNode(entry.mParent);
        } else {
            entry.mParent.mIsMarked = true;
        }
        entry.mParent = null;
    }

    private void cutNodeNode(Entry<IsoGridSquare> entry) {
        entry.mIsMarked = false;
        if (entry.mParent == null) {
            return;
        }
        if (entry.mNext != entry) {
            entry.mNext.mPrev = entry.mPrev;
            entry.mPrev.mNext = entry.mNext;
        }
        if (entry.mParent.mChild == entry) {
            entry.mParent.mChild = entry.mNext != entry ? entry.mNext : null;
        }
        --entry.mParent.mDegree;
        entry.mNext = entry;
        entry.mPrev = entry.mNext;
        this.mMin = FibonacciHeap.mergeLists(this.mMin, entry);
        if (entry.mParent.mIsMarked) {
            this.cutNode(entry.mParent);
        } else {
            entry.mParent.mIsMarked = true;
        }
        entry.mParent = null;
    }

    public static final class Entry<T> {
        private int mDegree = 0;
        private boolean mIsMarked = false;
        private Entry<T> mNext = this.mPrev = this;
        private Entry<T> mPrev;
        private Entry<T> mParent;
        private Entry<T> mChild;
        private T mElem;
        private double mPriority;

        public T getValue() {
            return this.mElem;
        }

        public void setValue(T t) {
            this.mElem = t;
        }

        public double getPriority() {
            return this.mPriority;
        }

        private Entry(T t, double d) {
            this.mElem = t;
            this.mPriority = d;
        }
    }
}

