/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BooleanGrid
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int width;
    private final int height;
    private final int bitWidth;
    private final int[] value;

    public BooleanGrid(int n, int n2) {
        this.bitWidth = n;
        this.width = n / 32 + (n % 32 != 0 ? 1 : 0);
        this.height = n2;
        this.value = new int[this.width * this.height];
    }

    public BooleanGrid clone() throws CloneNotSupportedException {
        BooleanGrid booleanGrid = new BooleanGrid(this.bitWidth, this.height);
        System.arraycopy(this.value, 0, booleanGrid.value, 0, this.value.length);
        return booleanGrid;
    }

    public void copy(BooleanGrid booleanGrid) {
        if (booleanGrid.bitWidth != this.bitWidth || booleanGrid.height != this.height) {
            throw new IllegalArgumentException("src must be same size as this: " + booleanGrid + " cannot be copied into " + this);
        }
        System.arraycopy(booleanGrid.value, 0, this.value, 0, booleanGrid.value.length);
    }

    public void clear() {
        Arrays.fill(this.value, 0);
    }

    public void fill() {
        Arrays.fill(this.value, -1);
    }

    private int getIndex(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return -1;
        }
        return n + n2 * this.width;
    }

    public boolean getValue(int n, int n2) {
        if (n >= this.bitWidth || n < 0 || n2 >= this.height || n2 < 0) {
            return false;
        }
        int n3 = n / 32;
        int n4 = 1 << (n & 0x1F);
        int n5 = this.getIndex(n3, n2);
        if (n5 == -1) {
            return false;
        }
        int n6 = this.value[n5];
        return (n6 & n4) != 0;
    }

    public void setValue(int n, int n2, boolean bl) {
        if (n >= this.bitWidth || n < 0 || n2 >= this.height || n2 < 0) {
            return;
        }
        int n3 = n / 32;
        int n4 = 1 << (n & 0x1F);
        int n5 = this.getIndex(n3, n2);
        if (n5 == -1) {
            return;
        }
        if (bl) {
            int n6 = n5;
            this.value[n6] = this.value[n6] | n4;
        } else {
            int n7 = n5;
            this.value[n7] = this.value[n7] & ~n4;
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public String toString() {
        return "BooleanGrid [width=" + this.width + ", height=" + this.height + ", bitWidth=" + this.bitWidth + "]";
    }

    public void LoadFromByteBuffer(ByteBuffer byteBuffer) {
        int n = this.width * this.height;
        for (int i = 0; i < n; ++i) {
            this.value[i] = byteBuffer.getInt();
        }
    }

    public void PutToByteBuffer(ByteBuffer byteBuffer) {
        int n = this.width * this.height;
        for (int i = 0; i < n; ++i) {
            byteBuffer.putInt(this.value[i]);
        }
    }
}

