/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import zombie.core.Core;
import zombie.core.math.PZMath;

public class Bits {
    public static final boolean ENABLED = true;
    public static final int BIT_0 = 0;
    public static final int BIT_1 = 1;
    public static final int BIT_2 = 2;
    public static final int BIT_3 = 4;
    public static final int BIT_4 = 8;
    public static final int BIT_5 = 16;
    public static final int BIT_6 = 32;
    public static final int BIT_7 = 64;
    public static final int BIT_BYTE_MAX = 64;
    public static final int BIT_8 = 128;
    public static final int BIT_9 = 256;
    public static final int BIT_10 = 512;
    public static final int BIT_11 = 1024;
    public static final int BIT_12 = 2048;
    public static final int BIT_13 = 4096;
    public static final int BIT_14 = 8192;
    public static final int BIT_15 = 16384;
    public static final int BIT_SHORT_MAX = 16384;
    public static final int BIT_16 = 32768;
    public static final int BIT_17 = 65536;
    public static final int BIT_18 = 131072;
    public static final int BIT_19 = 262144;
    public static final int BIT_20 = 524288;
    public static final int BIT_21 = 0x100000;
    public static final int BIT_22 = 0x200000;
    public static final int BIT_23 = 0x400000;
    public static final int BIT_24 = 0x800000;
    public static final int BIT_25 = 0x1000000;
    public static final int BIT_26 = 0x2000000;
    public static final int BIT_27 = 0x4000000;
    public static final int BIT_28 = 0x8000000;
    public static final int BIT_29 = 0x10000000;
    public static final int BIT_30 = 0x20000000;
    public static final int BIT_31 = 0x40000000;
    public static final int BIT_INT_MAX = 0x40000000;
    public static final long BIT_32 = 0x80000000L;
    public static final long BIT_33 = 0x100000000L;
    public static final long BIT_34 = 0x200000000L;
    public static final long BIT_35 = 0x400000000L;
    public static final long BIT_36 = 0x800000000L;
    public static final long BIT_37 = 0x1000000000L;
    public static final long BIT_38 = 0x2000000000L;
    public static final long BIT_39 = 0x4000000000L;
    public static final long BIT_40 = 0x8000000000L;
    public static final long BIT_41 = 0x10000000000L;
    public static final long BIT_42 = 0x20000000000L;
    public static final long BIT_43 = 0x40000000000L;
    public static final long BIT_44 = 0x80000000000L;
    public static final long BIT_45 = 0x100000000000L;
    public static final long BIT_46 = 0x200000000000L;
    public static final long BIT_47 = 0x400000000000L;
    public static final long BIT_48 = 0x800000000000L;
    public static final long BIT_49 = 0x1000000000000L;
    public static final long BIT_50 = 0x2000000000000L;
    public static final long BIT_51 = 0x4000000000000L;
    public static final long BIT_52 = 0x8000000000000L;
    public static final long BIT_53 = 0x10000000000000L;
    public static final long BIT_54 = 0x20000000000000L;
    public static final long BIT_55 = 0x40000000000000L;
    public static final long BIT_56 = 0x80000000000000L;
    public static final long BIT_57 = 0x100000000000000L;
    public static final long BIT_58 = 0x200000000000000L;
    public static final long BIT_59 = 0x400000000000000L;
    public static final long BIT_60 = 0x800000000000000L;
    public static final long BIT_61 = 0x1000000000000000L;
    public static final long BIT_62 = 0x2000000000000000L;
    public static final long BIT_63 = 0x4000000000000000L;
    public static final long BIT_LONG_MAX = 0x4000000000000000L;
    private static StringBuilder sb = new StringBuilder();

    public static byte packFloatUnitToByte(float f) {
        if (f < 0.0f || f > 1.0f) {
            if (Core.bDebug) {
                throw new RuntimeException("UtilsIO Cannot pack float units out of the range 0.0 to 1.0");
            }
            f = PZMath.clamp(f, 0.0f, 1.0f);
        }
        return (byte)(f * 255.0f + -128.0f);
    }

    public static float unpackByteToFloatUnit(byte by) {
        return (float)(by - -128) / 255.0f;
    }

    public static byte addFlags(byte by, int n) {
        if (n < 0 || n > 64) {
            throw new RuntimeException("Cannot add flags, exceeding byte bounds or negative number flags. (" + n + ")");
        }
        by = (byte)(by | n);
        return by;
    }

    public static byte addFlags(byte by, long l) {
        if (l < 0L || l > 64L) {
            throw new RuntimeException("Cannot add flags, exceeding byte bounds or negative number flags. (" + l + ")");
        }
        by = (byte)((long)by | l);
        return by;
    }

    public static short addFlags(short s, int n) {
        if (n < 0 || n > 16384) {
            throw new RuntimeException("Cannot add flags, exceeding short bounds or negative number flags. (" + n + ")");
        }
        s = (short)(s | n);
        return s;
    }

    public static short addFlags(short s, long l) {
        if (l < 0L || l > 16384L) {
            throw new RuntimeException("Cannot add flags, exceeding short bounds or negative number flags. (" + l + ")");
        }
        s = (short)((long)s | l);
        return s;
    }

    public static int addFlags(int n, int n2) {
        if (n2 < 0 || n2 > 0x40000000) {
            throw new RuntimeException("Cannot add flags, exceeding short bounds or negative number flags. (" + n2 + ")");
        }
        return n |= n2;
    }

    public static int addFlags(int n, long l) {
        if (l < 0L || l > 0x40000000L) {
            throw new RuntimeException("Cannot add flags, exceeding integer bounds or negative number flags. (" + l + ")");
        }
        n = (int)((long)n | l);
        return n;
    }

    public static long addFlags(long l, int n) {
        if (n < 0 || (long)n > 0x4000000000000000L) {
            throw new RuntimeException("Cannot add flags, exceeding long bounds or negative number flags. (" + n + ")");
        }
        return l |= (long)n;
    }

    public static long addFlags(long l, long l2) {
        if (l2 < 0L || l2 > 0x4000000000000000L) {
            throw new RuntimeException("Cannot add flags, exceeding long bounds or negative number flags. (" + l2 + ")");
        }
        return l |= l2;
    }

    public static boolean hasFlags(byte by, int n) {
        return Bits.checkFlags(by, n, 64, CompareOption.ContainsAll);
    }

    public static boolean hasFlags(byte by, long l) {
        return Bits.checkFlags((long)by, l, 64L, CompareOption.ContainsAll);
    }

    public static boolean hasEitherFlags(byte by, int n) {
        return Bits.checkFlags(by, n, 64, CompareOption.HasEither);
    }

    public static boolean hasEitherFlags(byte by, long l) {
        return Bits.checkFlags((long)by, l, 64L, CompareOption.HasEither);
    }

    public static boolean notHasFlags(byte by, int n) {
        return Bits.checkFlags(by, n, 64, CompareOption.NotHas);
    }

    public static boolean notHasFlags(byte by, long l) {
        return Bits.checkFlags((long)by, l, 64L, CompareOption.NotHas);
    }

    public static boolean hasFlags(short s, int n) {
        return Bits.checkFlags(s, n, 16384, CompareOption.ContainsAll);
    }

    public static boolean hasFlags(short s, long l) {
        return Bits.checkFlags((long)s, l, 16384L, CompareOption.ContainsAll);
    }

    public static boolean hasEitherFlags(short s, int n) {
        return Bits.checkFlags(s, n, 16384, CompareOption.HasEither);
    }

    public static boolean hasEitherFlags(short s, long l) {
        return Bits.checkFlags((long)s, l, 16384L, CompareOption.HasEither);
    }

    public static boolean notHasFlags(short s, int n) {
        return Bits.checkFlags(s, n, 16384, CompareOption.NotHas);
    }

    public static boolean notHasFlags(short s, long l) {
        return Bits.checkFlags((long)s, l, 16384L, CompareOption.NotHas);
    }

    public static boolean hasFlags(int n, int n2) {
        return Bits.checkFlags(n, n2, 0x40000000, CompareOption.ContainsAll);
    }

    public static boolean hasFlags(int n, long l) {
        return Bits.checkFlags((long)n, l, 0x40000000L, CompareOption.ContainsAll);
    }

    public static boolean hasEitherFlags(int n, int n2) {
        return Bits.checkFlags(n, n2, 0x40000000, CompareOption.HasEither);
    }

    public static boolean hasEitherFlags(int n, long l) {
        return Bits.checkFlags((long)n, l, 0x40000000L, CompareOption.HasEither);
    }

    public static boolean notHasFlags(int n, int n2) {
        return Bits.checkFlags(n, n2, 0x40000000, CompareOption.NotHas);
    }

    public static boolean notHasFlags(int n, long l) {
        return Bits.checkFlags((long)n, l, 0x40000000L, CompareOption.NotHas);
    }

    public static boolean hasFlags(long l, int n) {
        return Bits.checkFlags(l, (long)n, 0x4000000000000000L, CompareOption.ContainsAll);
    }

    public static boolean hasFlags(long l, long l2) {
        return Bits.checkFlags(l, l2, 0x4000000000000000L, CompareOption.ContainsAll);
    }

    public static boolean hasEitherFlags(long l, int n) {
        return Bits.checkFlags(l, (long)n, 0x4000000000000000L, CompareOption.HasEither);
    }

    public static boolean hasEitherFlags(long l, long l2) {
        return Bits.checkFlags(l, l2, 0x4000000000000000L, CompareOption.HasEither);
    }

    public static boolean notHasFlags(long l, int n) {
        return Bits.checkFlags(l, (long)n, 0x4000000000000000L, CompareOption.NotHas);
    }

    public static boolean notHasFlags(long l, long l2) {
        return Bits.checkFlags(l, l2, 0x4000000000000000L, CompareOption.NotHas);
    }

    public static boolean checkFlags(int n, int n2, int n3, CompareOption compareOption) {
        if (n2 < 0 || n2 > n3) {
            throw new RuntimeException("Cannot check for flags, exceeding byte bounds or negative number flags. (" + n2 + ")");
        }
        if (compareOption == CompareOption.ContainsAll) {
            return (n & n2) == n2;
        }
        if (compareOption == CompareOption.HasEither) {
            return (n & n2) != 0;
        }
        if (compareOption == CompareOption.NotHas) {
            return (n & n2) == 0;
        }
        throw new RuntimeException("No valid compare option.");
    }

    public static boolean checkFlags(long l, long l2, long l3, CompareOption compareOption) {
        if (l2 < 0L || l2 > l3) {
            throw new RuntimeException("Cannot check for flags, exceeding byte bounds or negative number flags. (" + l2 + ")");
        }
        if (compareOption == CompareOption.ContainsAll) {
            return (l & l2) == l2;
        }
        if (compareOption == CompareOption.HasEither) {
            return (l & l2) != 0L;
        }
        if (compareOption == CompareOption.NotHas) {
            return (l & l2) == 0L;
        }
        throw new RuntimeException("No valid compare option.");
    }

    public static int getLen(byte by) {
        return 1;
    }

    public static int getLen(short s) {
        return 2;
    }

    public static int getLen(int n) {
        return 4;
    }

    public static int getLen(long l) {
        return 8;
    }

    private static void clearStringBuilder() {
        if (sb.length() > 0) {
            sb.delete(0, sb.length());
        }
    }

    public static String getBitsString(byte by) {
        return Bits.getBitsString(by, 8);
    }

    public static String getBitsString(short s) {
        return Bits.getBitsString(s, 16);
    }

    public static String getBitsString(int n) {
        return Bits.getBitsString(n, 32);
    }

    public static String getBitsString(long l) {
        return Bits.getBitsString(l, 64);
    }

    private static String getBitsString(long l, int n) {
        Bits.clearStringBuilder();
        if (l != 0L) {
            sb.append("Bits(" + (n - 1) + "): ");
            long l2 = 1L;
            for (int i = 1; i < n; ++i) {
                sb.append("[" + i + "]");
                if ((l & l2) == l2) {
                    sb.append("1");
                } else {
                    sb.append("0");
                }
                if (i < n - 1) {
                    sb.append(" ");
                }
                l2 *= 2L;
            }
        } else {
            sb.append("No bits saved, 0x0.");
        }
        return sb.toString();
    }

    public static enum CompareOption {
        ContainsAll,
        HasEither,
        NotHas;

    }
}

