/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL21;
import org.lwjgl.system.MemoryUtil;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.ZomboidFileSystem;
import zombie.asset.Asset;
import zombie.asset.AssetManager;
import zombie.asset.AssetPath;
import zombie.asset.AssetType;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.bucket.BucketManager;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.textures.AlphaColorIndex;
import zombie.core.textures.ImageData;
import zombie.core.textures.Mask;
import zombie.core.textures.PNGSize;
import zombie.core.textures.SmartTexture;
import zombie.core.textures.TextureAssetManager;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureID;
import zombie.core.textures.TextureIDAssetManager;
import zombie.core.textures.TexturePackPage;
import zombie.core.utils.BooleanGrid;
import zombie.core.utils.ImageUtils;
import zombie.core.utils.WrappedBuffer;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.fileSystem.FileSystem;
import zombie.interfaces.IDestroyable;
import zombie.interfaces.ITexture;
import zombie.iso.Vector2;
import zombie.iso.objects.ObjectRenderEffects;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.util.StringUtils;
import zombie.util.Type;

public class Texture
extends Asset
implements IDestroyable,
ITexture,
Serializable {
    public static final HashSet<String> nullTextures = new HashSet();
    private static final long serialVersionUID = 7472363451408935314L;
    private static final ObjectRenderEffects objRen = ObjectRenderEffects.alloc();
    public static int BindCount = 0;
    public static boolean bDoingQuad = false;
    public static float lr;
    public static float lg;
    public static float lb;
    public static float la;
    public static int lastlastTextureID;
    public static int totalTextureID;
    private static Texture white;
    private static Texture errorTexture;
    private static Texture mipmap;
    public static int lastTextureID;
    public static boolean WarnFailFindTexture;
    private static final HashMap<String, Texture> textures;
    private static final HashMap<String, Texture> s_sharedTextureTable;
    private static final HashMap<Long, Texture> steamAvatarMap;
    public boolean flip = false;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public boolean bindAlways = false;
    public float xEnd = 1.0f;
    public float yEnd = 1.0f;
    public float xStart = 0.0f;
    public float yStart = 0.0f;
    protected TextureID dataid;
    protected Mask mask;
    protected String name;
    protected boolean solid;
    protected int width;
    protected int height;
    protected int heightOrig;
    protected int widthOrig;
    private int realWidth = 0;
    private int realHeight = 0;
    private boolean destroyed = false;
    private Texture splitIconTex;
    private int splitX = -1;
    private int splitY;
    private int splitW;
    private int splitH;
    protected FileSystem.SubTexture subTexture;
    public TextureAssetParams assetParams;
    private static final ThreadLocal<PNGSize> pngSize;
    public static final AssetType ASSET_TYPE;

    public Texture(AssetPath assetPath, AssetManager assetManager, TextureAssetParams textureAssetParams) {
        super(assetPath, assetManager);
        Object object;
        this.assetParams = textureAssetParams;
        String string = this.name = assetPath == null ? null : assetPath.getPath();
        if (textureAssetParams != null && textureAssetParams.subTexture != null) {
            object = textureAssetParams.subTexture;
            this.splitX = ((FileSystem.SubTexture)object).m_info.x;
            this.splitY = ((FileSystem.SubTexture)object).m_info.y;
            this.splitW = ((FileSystem.SubTexture)object).m_info.w;
            this.splitH = ((FileSystem.SubTexture)object).m_info.h;
            this.width = this.splitW;
            this.height = this.splitH;
            this.offsetX = ((FileSystem.SubTexture)object).m_info.ox;
            this.offsetY = ((FileSystem.SubTexture)object).m_info.oy;
            this.widthOrig = ((FileSystem.SubTexture)object).m_info.fx;
            this.heightOrig = ((FileSystem.SubTexture)object).m_info.fy;
            this.name = ((FileSystem.SubTexture)object).m_info.name;
            this.subTexture = object;
        }
        object = new TextureID.TextureIDAssetParams();
        if (this.assetParams == null || this.assetParams.subTexture == null) {
            ((TextureID.TextureIDAssetParams)object).flags = this.assetParams == null ? ((TextureID.TextureIDAssetParams)object).flags | (TextureID.bUseCompressionOption ? 4 : 0) : this.assetParams.flags;
            this.dataid = (TextureID)this.getAssetManager().getOwner().get(TextureID.ASSET_TYPE).load(this.getPath(), (AssetManager.AssetParams)object);
        } else {
            ((TextureID.TextureIDAssetParams)object).subTexture = this.assetParams.subTexture;
            String string2 = ((TextureID.TextureIDAssetParams)object).subTexture.m_pack_name;
            String string3 = ((TextureID.TextureIDAssetParams)object).subTexture.m_page_name;
            FileSystem fileSystem = this.getAssetManager().getOwner().getFileSystem();
            ((TextureID.TextureIDAssetParams)object).flags = fileSystem.getTexturePackFlags(string2);
            ((TextureID.TextureIDAssetParams)object).flags = ((TextureID.TextureIDAssetParams)object).flags | (fileSystem.getTexturePackAlpha(string2, string3) ? 8 : 0);
            AssetPath assetPath2 = new AssetPath("@pack@/" + string2 + "/" + string3);
            this.dataid = (TextureID)TextureIDAssetManager.instance.load(assetPath2, (AssetManager.AssetParams)object);
        }
        this.onCreated(Asset.State.EMPTY);
        if (this.dataid != null) {
            this.addDependency(this.dataid);
        }
    }

    public Texture(TextureID textureID, String string) {
        super(null, TextureAssetManager.instance);
        this.dataid = textureID;
        ++this.dataid.referenceCount;
        if (textureID.isReady()) {
            this.solid = this.dataid.solid;
            this.width = textureID.width;
            this.height = textureID.height;
            this.xEnd = (float)this.width / (float)textureID.widthHW;
            this.yEnd = (float)this.height / (float)textureID.heightHW;
        } else assert (false);
        this.name = string;
        this.assetParams = null;
        this.onCreated(textureID.getState());
        this.addDependency(textureID);
    }

    public Texture(String string) throws Exception {
        this(new TextureID(string), string);
        this.setUseAlphaChannel(true);
    }

    public Texture(String string, BufferedInputStream bufferedInputStream, boolean bl, PZFileformat pZFileformat) {
        this(new TextureID(bufferedInputStream, string, bl, pZFileformat), string);
        if (bl && this.dataid.mask != null) {
            this.createMask(this.dataid.mask);
            this.dataid.mask = null;
            this.dataid.data = null;
        }
    }

    public Texture(String string, BufferedInputStream bufferedInputStream, boolean bl) throws Exception {
        this(new TextureID(bufferedInputStream, string, bl), string);
        if (bl) {
            this.createMask(this.dataid.mask);
            this.dataid.mask = null;
            this.dataid.data = null;
        }
    }

    public Texture(String string, boolean bl, boolean bl2) throws Exception {
        this(new TextureID(string), string);
        this.setUseAlphaChannel(bl2);
        if (bl) {
            this.dataid.data = null;
        }
    }

    public Texture(String string, String string2) {
        this(new TextureID(string, string2), string);
        this.setUseAlphaChannel(true);
    }

    public Texture(String string, int[] nArray) {
        this(new TextureID(string, nArray), string);
        if (string.contains("drag")) {
            boolean bl = false;
        }
        this.setUseAlphaChannel(true);
    }

    public Texture(String string, boolean bl) throws Exception {
        this(new TextureID(string), string);
        this.setUseAlphaChannel(bl);
    }

    public Texture(int n, int n2, String string, int n3) {
        this(new TextureID(n, n2, n3), string);
    }

    public Texture(int n, int n2, int n3) {
        this(new TextureID(n, n2, n3), null);
    }

    public Texture(String string, int n, int n2, int n3) throws Exception {
        this(new TextureID(string, n, n2, n3), string);
    }

    public Texture(Texture texture) {
        this(texture.dataid, texture.name + "(copy)");
        this.width = texture.width;
        this.height = texture.height;
        this.name = texture.name;
        this.xStart = texture.xStart;
        this.yStart = texture.yStart;
        this.xEnd = texture.xEnd;
        this.yEnd = texture.yEnd;
        this.solid = texture.solid;
    }

    public Texture() {
        super(null, TextureAssetManager.instance);
        this.assetParams = null;
        this.onCreated(Asset.State.EMPTY);
    }

    public static String processFilePath(String string) {
        string = string.replaceAll("\\\\", "/");
        return string;
    }

    public static void bindNone() {
        IndieGL.glDisable(3553);
        lastTextureID = -1;
        --BindCount;
    }

    public static Texture getWhite() {
        if (white == null) {
            white = new Texture(32, 32, "white", 0);
            RenderThread.invokeOnRenderContext(() -> {
                lastTextureID = white.getID();
                GL11.glBindTexture((int)3553, (int)lastTextureID);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(Texture.white.width * Texture.white.height * 4));
                for (int i = 0; i < Texture.white.width * Texture.white.height * 4; ++i) {
                    byteBuffer.put((byte)-1);
                }
                byteBuffer.flip();
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)Texture.white.width, (int)Texture.white.height, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                MemoryUtil.memFree((Buffer)byteBuffer);
            });
            s_sharedTextureTable.put("white.png", white);
            s_sharedTextureTable.put("media/white.png", white);
            s_sharedTextureTable.put("media/ui/white.png", white);
        }
        return white;
    }

    public static Texture getErrorTexture() {
        if (errorTexture == null) {
            errorTexture = new Texture(32, 32, "EngineErrorTexture", 0);
            RenderThread.invokeOnRenderContext(() -> {
                boolean bl;
                lastTextureID = errorTexture.getID();
                GL11.glBindTexture((int)3553, (int)lastTextureID);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                int n = 4;
                ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(Texture.errorTexture.width * Texture.errorTexture.height * n));
                byteBuffer.position(Texture.errorTexture.width * Texture.errorTexture.height * n);
                int n2 = Texture.errorTexture.width * n;
                boolean bl2 = bl = true;
                int n3 = 8;
                int n4 = Texture.errorTexture.width / n3;
                for (int i = 0; i < n3 * n3; ++i) {
                    int n5 = i / n3;
                    int n6 = i % n3;
                    if (n5 > 0 && n6 == 0) {
                        bl2 = bl = !bl;
                    }
                    int n7 = bl2 ? -16776961 : -1;
                    bl2 = !bl2;
                    for (int j = 0; j < n4; ++j) {
                        for (int k = 0; k < n4; ++k) {
                            byteBuffer.putInt((n5 * n4 + j) * n2 + (n6 * n4 + k) * n, n7);
                        }
                    }
                }
                byteBuffer.flip();
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)Texture.errorTexture.width, (int)Texture.errorTexture.height, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                MemoryUtil.memFree((Buffer)byteBuffer);
            });
            s_sharedTextureTable.put("EngineErrorTexture.png", errorTexture);
        }
        return errorTexture;
    }

    private static void initEngineMipmapTextureLevel(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(n2 * n3 * 4));
        MemoryUtil.memSet((ByteBuffer)byteBuffer, (int)255);
        for (int i = 0; i < n2 * n3; ++i) {
            byteBuffer.put((byte)(n4 & 0xFF));
            byteBuffer.put((byte)(n5 & 0xFF));
            byteBuffer.put((byte)(n6 & 0xFF));
            byteBuffer.put((byte)(n7 & 0xFF));
        }
        byteBuffer.flip();
        GL11.glTexImage2D((int)3553, (int)n, (int)6408, (int)n2, (int)n3, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
        MemoryUtil.memFree((Buffer)byteBuffer);
    }

    public static Texture getEngineMipmapTexture() {
        if (mipmap == null) {
            mipmap = new Texture(256, 256, "EngineMipmapTexture", 0);
            Texture.mipmap.dataid.setMinFilter(9984);
            RenderThread.invokeOnRenderContext(() -> {
                lastTextureID = mipmap.getID();
                GL11.glBindTexture((int)3553, (int)lastTextureID);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexParameteri((int)3553, (int)33085, (int)6);
                Texture.initEngineMipmapTextureLevel(0, Texture.mipmap.width, Texture.mipmap.height, 255, 0, 0, 255);
                Texture.initEngineMipmapTextureLevel(1, Texture.mipmap.width / 2, Texture.mipmap.height / 2, 0, 255, 0, 255);
                Texture.initEngineMipmapTextureLevel(2, Texture.mipmap.width / 4, Texture.mipmap.height / 4, 0, 0, 255, 255);
                Texture.initEngineMipmapTextureLevel(3, Texture.mipmap.width / 8, Texture.mipmap.height / 8, 255, 255, 0, 255);
                Texture.initEngineMipmapTextureLevel(4, Texture.mipmap.width / 16, Texture.mipmap.height / 16, 255, 0, 255, 255);
                Texture.initEngineMipmapTextureLevel(5, Texture.mipmap.width / 32, Texture.mipmap.height / 32, 0, 0, 0, 255);
                Texture.initEngineMipmapTextureLevel(6, Texture.mipmap.width / 64, Texture.mipmap.height / 64, 255, 255, 255, 255);
            });
        }
        return mipmap;
    }

    public static void clearTextures() {
        textures.clear();
    }

    public static Texture getSharedTexture(String string) {
        int n = 0;
        return Texture.getSharedTexture(string, n |= TextureID.bUseCompression ? 4 : 0);
    }

    public static Texture getSharedTexture(String string, int n) {
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return null;
        }
        try {
            return Texture.getSharedTextureInternal(string, n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Texture trygetTexture(String string) {
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return null;
        }
        Texture texture = Texture.getSharedTexture(string);
        if (texture == null) {
            String string2 = "media/textures/" + string;
            if (!string.endsWith(".png")) {
                string2 = string2 + ".png";
            }
            if ((texture = s_sharedTextureTable.get(string2)) != null) {
                return texture;
            }
            String string3 = ZomboidFileSystem.instance.getString(string2);
            if (!string3.equals(string2)) {
                int n = 0;
                int n2 = TextureID.bUseCompression ? 4 : 0;
                TextureAssetParams textureAssetParams = new TextureAssetParams();
                textureAssetParams.flags = n |= n2;
                texture = (Texture)TextureAssetManager.instance.load(new AssetPath(string3), textureAssetParams);
                BucketManager.Shared().AddTexture(string2, texture);
                Texture.setSharedTextureInternal(string2, texture);
            }
        }
        return texture;
    }

    private static void onTextureFileChanged(String string) {
        DebugLog.General.println("Texture.onTextureFileChanged> " + string);
    }

    public static void onTexturePacksChanged() {
        nullTextures.clear();
        s_sharedTextureTable.clear();
    }

    private static void setSharedTextureInternal(String string, Texture texture) {
        s_sharedTextureTable.put(string, texture);
    }

    private static Texture getSharedTextureInternal(String string, int n) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return null;
        }
        if (nullTextures.contains(string)) {
            return null;
        }
        Texture texture = s_sharedTextureTable.get(string);
        if (texture != null) {
            return texture;
        }
        if (!string.endsWith(".txt")) {
            object3 = string;
            if (((String)object3).endsWith(".pcx") || ((String)object3).endsWith(".png")) {
                object3 = ((String)object3).substring(0, string.lastIndexOf("."));
            }
            if ((object2 = TexturePackPage.getTexture((String)(object3 = ((String)object3).substring(string.lastIndexOf("/") + 1)))) != null) {
                Texture.setSharedTextureInternal(string, (Texture)object2);
                return object2;
            }
            object = (FileSystem.SubTexture)GameWindow.texturePackTextures.get(object3);
            if (object != null) {
                TextureAssetParams textureAssetParams = new TextureAssetParams();
                textureAssetParams.subTexture = object;
                String string2 = "@pack/" + ((FileSystem.SubTexture)object).m_pack_name + "/" + ((FileSystem.SubTexture)object).m_page_name + "/" + ((FileSystem.SubTexture)object).m_info.name;
                Texture texture2 = (Texture)TextureAssetManager.instance.load(new AssetPath(string2), textureAssetParams);
                if (texture2 == null) {
                    nullTextures.add(string);
                } else {
                    Texture.setSharedTextureInternal(string, texture2);
                }
                return texture2;
            }
        }
        if (TexturePackPage.subTextureMap.containsKey(string)) {
            return TexturePackPage.subTextureMap.get(string);
        }
        object3 = (FileSystem.SubTexture)GameWindow.texturePackTextures.get(string);
        if (object3 != null) {
            object2 = new TextureAssetParams();
            ((TextureAssetParams)object2).subTexture = object3;
            object = "@pack/" + ((FileSystem.SubTexture)object3).m_pack_name + "/" + ((FileSystem.SubTexture)object3).m_page_name + "/" + ((FileSystem.SubTexture)object3).m_info.name;
            Texture texture3 = (Texture)TextureAssetManager.instance.load(new AssetPath((String)object), (AssetManager.AssetParams)object2);
            if (texture3 == null) {
                nullTextures.add(string);
            } else {
                Texture.setSharedTextureInternal(string, texture3);
            }
            return texture3;
        }
        if (BucketManager.Shared().HasTexture(string)) {
            object2 = BucketManager.Shared().getTexture(string);
            Texture.setSharedTextureInternal(string, (Texture)object2);
            return object2;
        }
        if (StringUtils.endsWithIgnoreCase(string, ".pcx")) {
            nullTextures.add(string);
            return null;
        }
        if (string.lastIndexOf(46) == -1) {
            nullTextures.add(string);
            return null;
        }
        object2 = ZomboidFileSystem.instance.getString(string);
        boolean bl2 = bl = object2 != string;
        if (!bl && !new File((String)object2).exists()) {
            nullTextures.add(string);
            return null;
        }
        TextureAssetParams textureAssetParams = new TextureAssetParams();
        textureAssetParams.flags = n;
        Texture texture4 = (Texture)TextureAssetManager.instance.load(new AssetPath((String)object2), textureAssetParams);
        BucketManager.Shared().AddTexture(string, texture4);
        Texture.setSharedTextureInternal(string, texture4);
        return texture4;
    }

    public static Texture getSharedTexture(String string, String string2) {
        if (BucketManager.Shared().HasTexture(string + string2)) {
            return BucketManager.Shared().getTexture(string + string2);
        }
        Texture texture = new Texture(string, string2);
        BucketManager.Shared().AddTexture(string + string2, texture);
        return texture;
    }

    public static Texture getSharedTexture(String string, int[] nArray, String string2) {
        if (BucketManager.Shared().HasTexture(string + string2)) {
            return BucketManager.Shared().getTexture(string + string2);
        }
        Texture texture = new Texture(string, nArray);
        BucketManager.Shared().AddTexture(string + string2, texture);
        return texture;
    }

    public static Texture getTexture(String string) {
        Object object;
        if (!string.contains(".txt")) {
            object = string;
            object = ((String)object).replace(".png", "");
            object = ((String)object).replace(".pcx", "");
            Texture texture = TexturePackPage.getTexture((String)(object = ((String)object).substring(string.lastIndexOf("/") + 1)));
            if (texture != null) {
                return texture;
            }
        }
        if (BucketManager.Active().HasTexture(string)) {
            return BucketManager.Active().getTexture(string);
        }
        try {
            object = new Texture(string);
            BucketManager.Active().AddTexture(string, (Texture)object);
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Texture getSteamAvatar(long l) {
        if (steamAvatarMap.containsKey(l)) {
            return steamAvatarMap.get(l);
        }
        TextureID textureID = TextureID.createSteamAvatar(l);
        if (textureID == null) {
            return null;
        }
        Texture texture = new Texture(textureID, "SteamAvatar" + SteamUtils.convertSteamIDToString(l));
        steamAvatarMap.put(l, texture);
        return texture;
    }

    public static void steamAvatarChanged(long l) {
        Texture texture = steamAvatarMap.get(l);
        if (texture != null) {
            steamAvatarMap.remove(l);
        }
    }

    public static void forgetTexture(String string) {
        BucketManager.Shared().forgetTexture(string);
        s_sharedTextureTable.remove(string);
    }

    public static void reload(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Texture texture = s_sharedTextureTable.get(string);
        if (texture == null && (texture = Type.tryCastTo((Asset)TextureAssetManager.instance.getAssetTable().get(string), Texture.class)) == null) {
            return;
        }
        texture.reloadFromFile(string);
    }

    public static int[] flipPixels(int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[n * n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray2[(n2 - i - 1) * n + j] = nArray[i * n + j];
                }
            }
        }
        return nArray2;
    }

    public void reloadFromFile(String string) {
        if (this.dataid != null) {
            TextureID.TextureIDAssetParams textureIDAssetParams = new TextureID.TextureIDAssetParams();
            textureIDAssetParams.flags = this.dataid.flags;
            this.dataid.getAssetManager().reload(this.dataid, textureIDAssetParams);
            return;
        }
        if (string == null || string.isEmpty()) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            ImageData imageData2 = new ImageData(file.getAbsolutePath());
            if (imageData2.getWidthHW() != this.getWidthHW() || imageData2.getHeightHW() != this.getHeightHW()) {
                return;
            }
            RenderThread.invokeOnRenderContext(imageData2, imageData -> {
                lastTextureID = this.dataid.id;
                GL11.glBindTexture((int)3553, (int)lastTextureID);
                int n = 6408;
                GL11.glTexImage2D((int)3553, (int)0, (int)n, (int)this.getWidthHW(), (int)this.getHeightHW(), (int)0, (int)6408, (int)5121, (ByteBuffer)imageData.getData().getBuffer());
            });
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable, string);
        }
    }

    @Override
    public void bind() {
        this.bind(3553);
    }

    @Override
    public void bind(int n) {
        if (this.isDestroyed() || !this.isValid() || !this.isReady()) {
            Texture.getErrorTexture().bind(n);
            return;
        }
        if (this.bindAlways) {
            this.dataid.bindalways();
        } else {
            this.dataid.bind();
        }
    }

    public void copyMaskRegion(Texture texture, int n, int n2, int n3, int n4) {
        if (texture.getMask() == null) {
            return;
        }
        new Mask(texture, this, n, n2, n3, n4);
    }

    public void createMask() {
        new Mask(this);
    }

    public void createMask(boolean[] blArray) {
        new Mask((ITexture)this, blArray);
    }

    public void createMask(BooleanGrid booleanGrid) {
        new Mask((ITexture)this, booleanGrid);
    }

    public void createMask(WrappedBuffer wrappedBuffer) {
        new Mask(this, wrappedBuffer);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        if (this.dataid != null && --this.dataid.referenceCount == 0) {
            if (lastTextureID == this.dataid.id) {
                lastTextureID = -1;
            }
            this.dataid.destroy();
        }
        this.destroyed = true;
    }

    public boolean equals(Texture texture) {
        return texture.xStart == this.xStart && texture.xEnd == this.xEnd && texture.yStart == this.yStart && texture.yEnd == this.yEnd && texture.width == this.width && texture.height == this.height && texture.solid == this.solid && (this.dataid == null || texture.dataid == null || texture.dataid.pathFileName == null || this.dataid.pathFileName == null || texture.dataid.pathFileName.equals(this.dataid.pathFileName));
    }

    @Override
    public WrappedBuffer getData() {
        return this.dataid.getData();
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        this.dataid.setData(byteBuffer);
    }

    @Override
    public int getHeight() {
        if (!this.isReady() && this.height <= 0 && !(this instanceof SmartTexture)) {
            this.syncReadSize();
        }
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    @Override
    public int getHeightHW() {
        if (!this.isReady() && this.height <= 0 && !(this instanceof SmartTexture)) {
            this.syncReadSize();
        }
        return this.dataid.heightHW;
    }

    public int getHeightOrig() {
        if (this.heightOrig == 0) {
            return this.getHeight();
        }
        return this.heightOrig;
    }

    @Override
    public int getID() {
        return this.dataid.id;
    }

    @Override
    public Mask getMask() {
        return this.mask;
    }

    @Override
    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            return;
        }
        if (string.equals(this.name)) {
            if (!textures.containsKey(string)) {
                textures.put(string, this);
            }
            return;
        }
        if (textures.containsKey(string)) {
            // empty if block
        }
        if (textures.containsKey(this.name)) {
            textures.remove(this.name);
        }
        this.name = string;
        textures.put(string, this);
    }

    public TextureID getTextureId() {
        return this.dataid;
    }

    public boolean getUseAlphaChannel() {
        return !this.solid;
    }

    public void setUseAlphaChannel(boolean bl) {
        this.solid = !bl;
        this.dataid.solid = this.solid;
    }

    @Override
    public int getWidth() {
        if (!this.isReady() && this.width <= 0 && !(this instanceof SmartTexture)) {
            this.syncReadSize();
        }
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    @Override
    public int getWidthHW() {
        if (!this.isReady() && this.width <= 0 && !(this instanceof SmartTexture)) {
            this.syncReadSize();
        }
        return this.dataid.widthHW;
    }

    public int getWidthOrig() {
        if (this.widthOrig == 0) {
            return this.getWidth();
        }
        return this.widthOrig;
    }

    @Override
    public float getXEnd() {
        return this.xEnd;
    }

    @Override
    public float getXStart() {
        return this.xStart;
    }

    @Override
    public float getYEnd() {
        return this.yEnd;
    }

    @Override
    public float getYStart() {
        return this.yStart;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int n) {
        this.offsetY = n;
    }

    public boolean isCollisionable() {
        return this.mask != null;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isSolid() {
        return this.solid;
    }

    public boolean isValid() {
        return this.dataid != null;
    }

    @Override
    public void makeTransp(int n, int n2, int n3) {
        this.setAlphaForeach(n, n2, n3, 0);
    }

    public void render(float f, float f2, float f3, float f4) {
        this.render(f, f2, f3, f4, 1.0f, 1.0f, 1.0f, 1.0f, null);
    }

    public void render(float f, float f2) {
        this.render(f, f2, this.width, this.height, 1.0f, 1.0f, 1.0f, 1.0f, null);
    }

    public void render(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        SpriteRenderer.instance.render(this, f += this.offsetX, f2 += this.offsetY, f3, f4, f5, f6, f7, f8, consumer);
    }

    public void render(ObjectRenderEffects objectRenderEffects, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        float f9 = this.offsetX + f;
        float f10 = this.offsetY + f2;
        Texture.objRen.x1 = (double)f9 + objectRenderEffects.x1 * (double)f3;
        Texture.objRen.y1 = (double)f10 + objectRenderEffects.y1 * (double)f4;
        Texture.objRen.x2 = (double)(f9 + f3) + objectRenderEffects.x2 * (double)f3;
        Texture.objRen.y2 = (double)f10 + objectRenderEffects.y2 * (double)f4;
        Texture.objRen.x3 = (double)(f9 + f3) + objectRenderEffects.x3 * (double)f3;
        Texture.objRen.y3 = (double)(f10 + f4) + objectRenderEffects.y3 * (double)f4;
        Texture.objRen.x4 = (double)f9 + objectRenderEffects.x4 * (double)f3;
        Texture.objRen.y4 = (double)(f10 + f4) + objectRenderEffects.y4 * (double)f4;
        SpriteRenderer.instance.render(this, Texture.objRen.x1, Texture.objRen.y1, Texture.objRen.x2, Texture.objRen.y2, Texture.objRen.x3, Texture.objRen.y3, Texture.objRen.x4, Texture.objRen.y4, f5, f6, f7, f8, consumer);
    }

    public void rendershader2(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, float f5, float f6, float f7, float f8) {
        if (f8 == 0.0f) {
            return;
        }
        float f9 = (float)n / (float)this.getWidthHW();
        float f10 = (float)n2 / (float)this.getHeightHW();
        float f11 = (float)(n + n3) / (float)this.getWidthHW();
        float f12 = (float)(n2 + n4) / (float)this.getHeightHW();
        if (this.flip) {
            float f13 = f11;
            f11 = f9;
            f9 = f13;
            f += (float)this.widthOrig - this.offsetX - (float)this.width;
            f2 += this.offsetY;
        } else {
            f += this.offsetX;
            f2 += this.offsetY;
        }
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        if (f8 > 1.0f) {
            f8 = 1.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f7 < 0.0f) {
            f7 = 0.0f;
        }
        if (f8 < 0.0f) {
            f8 = 0.0f;
        }
        if (f + f3 <= 0.0f) {
            return;
        }
        if (f2 + f4 <= 0.0f) {
            return;
        }
        if (f >= (float)Core.getInstance().getScreenWidth()) {
            return;
        }
        if (f2 >= (float)Core.getInstance().getScreenHeight()) {
            return;
        }
        lr = f5;
        lg = f6;
        lb = f7;
        la = f8;
        SpriteRenderer.instance.render(this, f, f2, f3, f4, f5, f6, f7, f8, f9, f12, f11, f12, f11, f10, f9, f10);
    }

    public void renderdiamond(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        SpriteRenderer.instance.render(null, f, f2, f + f3 / 2.0f, f2 - f4 / 2.0f, f + f3, f2, f + f3 / 2.0f, f2 + f4 / 2.0f, n, n2, n3, n4);
    }

    public void renderwallnw(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, int n5, int n6) {
        lr = -1.0f;
        lg = -1.0f;
        lb = -1.0f;
        la = -1.0f;
        if (this.flip) {
            f += (float)this.widthOrig - this.offsetX - (float)this.width;
            f2 += this.offsetY;
        } else {
            f += this.offsetX;
            f2 += this.offsetY;
        }
        int n7 = Core.TileScale;
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.LightingOldDebug.getValue()) {
            n4 = -65536;
            n2 = -65536;
            n3 = -65536;
            n = -65536;
        }
        float f5 = f - f3 / 2.0f - 0.0f;
        float f6 = f2 - (float)(96 * n7) + f4 / 2.0f - 1.0f - 0.0f;
        float f7 = f + 0.0f;
        float f8 = f2 - (float)(96 * n7) - 2.0f - 0.0f;
        float f9 = f + 0.0f;
        float f10 = f2 + 4.0f + 0.0f;
        float f11 = f - f3 / 2.0f - 0.0f;
        float f12 = f2 + f4 / 2.0f + 4.0f + 0.0f;
        SpriteRenderer.instance.render(this, f5, f6, f7, f8, f9, f10, f11, f12, n4, n3, n, n2);
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.LightingOldDebug.getValue()) {
            n6 = -256;
            n5 = -256;
            n3 = -256;
            n = -256;
        }
        f5 = f - 0.0f;
        f6 = f2 - (float)(96 * n7) - 0.0f;
        f7 = f + f3 / 2.0f + 0.0f;
        f8 = f2 - (float)(96 * n7) + f4 / 2.0f - 0.0f;
        f9 = f + f3 / 2.0f + 0.0f;
        f10 = f2 + f4 / 2.0f + 5.0f + 0.0f;
        f11 = f - 0.0f;
        f12 = f2 + 5.0f + 0.0f;
        SpriteRenderer.instance.render(this, f5, f6, f7, f8, f9, f10, f11, f12, n3, n6, n5, n);
    }

    public void renderwallw(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        lr = -1.0f;
        lg = -1.0f;
        lb = -1.0f;
        la = -1.0f;
        if (this.flip) {
            f += (float)this.widthOrig - this.offsetX - (float)this.width;
            f2 += this.offsetY;
        } else {
            f += this.offsetX;
            f2 += this.offsetY;
        }
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.LightingOldDebug.getValue()) {
            n2 = -16711936;
            n = -16711936;
            n4 = -16728064;
            n3 = -16728064;
        }
        int n5 = Core.TileScale;
        float f5 = f - f3 / 2.0f - 0.0f;
        float f6 = f2 - (float)(96 * n5) + f4 / 2.0f - 1.0f - 0.0f;
        float f7 = f + (float)n5 + 0.0f;
        float f8 = f2 - (float)(96 * n5) - 3.0f - 0.0f;
        float f9 = f + (float)n5 + 0.0f;
        float f10 = f2 + 3.0f + 0.0f;
        float f11 = f - f3 / 2.0f - 0.0f;
        float f12 = f2 + f4 / 2.0f + 4.0f + 0.0f;
        SpriteRenderer.instance.render(this, f5, f6, f7, f8, f9, f10, f11, f12, n4, n3, n, n2);
    }

    public void renderwalln(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        lr = -1.0f;
        lg = -1.0f;
        lb = -1.0f;
        la = -1.0f;
        if (this.flip) {
            f += (float)this.widthOrig - this.offsetX - (float)this.width;
            f2 += this.offsetY;
        } else {
            f += this.offsetX;
            f2 += this.offsetY;
        }
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.LightingOldDebug.getValue()) {
            n2 = -16776961;
            n = -16776961;
            n4 = -16777024;
            n3 = -16777024;
        }
        int n5 = Core.TileScale;
        float f5 = f - 6.0f - 0.0f;
        float f6 = f2 - (float)(96 * n5) - 3.0f - 0.0f;
        float f7 = f + f3 / 2.0f + 0.0f;
        float f8 = f2 - (float)(96 * n5) + f4 / 2.0f - 0.0f;
        float f9 = f + f3 / 2.0f + 0.0f;
        float f10 = f2 + f4 / 2.0f + 5.0f + 0.0f;
        float f11 = f - 6.0f - 0.0f;
        float f12 = f2 + 2.0f + 0.0f;
        SpriteRenderer.instance.render(this, f5, f6, f7, f8, f9, f10, f11, f12, n3, n4, n2, n);
    }

    public void renderstrip(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, Consumer<TextureDraw> consumer) {
        try {
            if (f4 <= 0.0f) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            float f5 = this.getXStart();
            float f6 = this.getYStart();
            float f7 = this.getXEnd();
            float f8 = this.getYEnd();
            if (this.flip) {
                float f9 = f7;
                f7 = f5;
                f5 = f9;
                n = (int)((float)n + ((float)this.widthOrig - this.offsetX - (float)this.width));
                n2 = (int)((float)n2 + this.offsetY);
            } else {
                n = (int)((float)n + this.offsetX);
                n2 = (int)((float)n2 + this.offsetY);
            }
            SpriteRenderer.instance.renderi(this, n, n2, n3, n4, f, f2, f3, f4, consumer);
        }
        catch (Exception exception) {
            bDoingQuad = false;
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    @Override
    public void setAlphaForeach(int n, int n2, int n3, int n4) {
        Object object;
        ImageData imageData = this.getTextureId().getImageData();
        if (imageData != null) {
            imageData.makeTransp((byte)n, (byte)n2, (byte)n3, (byte)n4);
        } else {
            object = this.getData();
            this.setData(ImageUtils.makeTransp(((WrappedBuffer)object).getBuffer(), n, n2, n3, n4, this.getWidthHW(), this.getHeightHW()));
            ((WrappedBuffer)object).dispose();
        }
        object = new AlphaColorIndex(n, n2, n3, n4);
        if (this.dataid.alphaList == null) {
            this.dataid.alphaList = new ArrayList();
        }
        if (!this.dataid.alphaList.contains(object)) {
            this.dataid.alphaList.add((AlphaColorIndex)object);
        }
    }

    public void setCustomizedTexture() {
        this.dataid.pathFileName = null;
    }

    public void setNameOnly(String string) {
        this.name = string;
    }

    @Override
    public void setRegion(int n, int n2, int n3, int n4) {
        if (n < 0 || n > this.getWidthHW()) {
            return;
        }
        if (n2 < 0 || n2 > this.getHeightHW()) {
            return;
        }
        if (n3 <= 0) {
            return;
        }
        if (n4 <= 0) {
            return;
        }
        if (n3 + n > this.getWidthHW()) {
            n3 = this.getWidthHW() - n;
        }
        if (n4 > this.getHeightHW()) {
            n4 = this.getHeightHW() - n2;
        }
        this.xStart = (float)n / (float)this.getWidthHW();
        this.yStart = (float)n2 / (float)this.getHeightHW();
        this.xEnd = (float)(n + n3) / (float)this.getWidthHW();
        this.yEnd = (float)(n2 + n4) / (float)this.getHeightHW();
        this.width = n3;
        this.height = n4;
    }

    public Texture splitIcon() {
        if (this.splitIconTex == null) {
            if (!this.dataid.isReady()) {
                this.splitIconTex = new Texture();
                this.splitIconTex.name = this.name + "_Icon";
                this.splitIconTex.dataid = this.dataid;
                ++this.splitIconTex.dataid.referenceCount;
                this.splitIconTex.splitX = this.splitX;
                this.splitIconTex.splitY = this.splitY;
                this.splitIconTex.splitW = this.splitW;
                this.splitIconTex.splitH = this.splitH;
                this.splitIconTex.width = this.width;
                this.splitIconTex.height = this.height;
                this.splitIconTex.offsetX = 0.0f;
                this.splitIconTex.offsetY = 0.0f;
                this.splitIconTex.widthOrig = 0;
                this.splitIconTex.heightOrig = 0;
                this.splitIconTex.addDependency(this.dataid);
                Texture.setSharedTextureInternal(this.splitIconTex.name, this.splitIconTex);
                return this.splitIconTex;
            }
            this.splitIconTex = new Texture(this.getTextureId(), this.name + "_Icon");
            float f = this.xStart * (float)this.getWidthHW();
            float f2 = this.yStart * (float)this.getHeightHW();
            float f3 = this.xEnd * (float)this.getWidthHW() - f;
            float f4 = this.yEnd * (float)this.getHeightHW() - f2;
            this.splitIconTex.setRegion((int)f, (int)f2, (int)f3, (int)f4);
            this.splitIconTex.offsetX = 0.0f;
            this.splitIconTex.offsetY = 0.0f;
            Texture.setSharedTextureInternal(this.name + "_Icon", this.splitIconTex);
        }
        return this.splitIconTex;
    }

    public Texture split(int n, int n2, int n3, int n4) {
        Texture texture = new Texture(this.getTextureId(), this.name + "_" + n + "_" + n2);
        this.splitX = n;
        this.splitY = n2;
        this.splitW = n3;
        this.splitH = n4;
        if (this.getTextureId().isReady()) {
            texture.setRegion(n, n2, n3, n4);
        } else assert (false);
        return texture;
    }

    public Texture split(String string, int n, int n2, int n3, int n4) {
        Texture texture = new Texture(this.getTextureId(), string);
        texture.setRegion(n, n2, n3, n4);
        return texture;
    }

    public Texture[] split(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Texture[] textureArray = new Texture[n3 * n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                textureArray[j + i * n4] = new Texture(this.getTextureId(), this.name + "_" + n3 + "_" + n4);
                textureArray[j + i * n4].setRegion(n + j * n5 + n7 * j, n2 + i * n6 + n8 * i, n5, n6);
                textureArray[j + i * n4].copyMaskRegion(this, n + j * n5 + n7 * j, n2 + i * n6 + n8 * i, n5, n6);
            }
        }
        return textureArray;
    }

    public Texture[][] split2D(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return null;
        }
        Texture[][] textureArray = new Texture[nArray.length][nArray2.length];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < nArray2.length; ++i) {
            f2 += f;
            f = (float)nArray2[i] / (float)this.getHeightHW();
            f3 = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f4 = (float)nArray[j] / (float)this.getWidthHW();
                Texture texture = new Texture(this);
                textureArray[j][i] = texture;
                Texture texture2 = texture;
                texture2.width = nArray[j];
                texture2.height = nArray2[i];
                texture2.xStart = f3;
                texture2.xEnd = f3 += f4;
                texture2.yStart = f2;
                texture2.yEnd = f2 + f;
            }
        }
        return textureArray;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ name:\"" + this.name + "\", w:" + this.getWidth() + ", h:" + this.getHeight() + " }";
    }

    public void saveMask(String string) {
        this.mask.save(string);
    }

    public void saveToZomboidDirectory(String string) {
        if (StringUtils.containsDoubleDot(string)) {
            return;
        }
        String string2 = ZomboidFileSystem.instance.getCacheDirSub(string);
        RenderThread.invokeOnRenderContext(() -> this.saveOnRenderThread(string2));
    }

    public void saveToCurrentSavefileDirectory(String string) {
        if (StringUtils.containsDoubleDot(string)) {
            return;
        }
        String string2 = ZomboidFileSystem.instance.getFileNameInCurrentSave(string);
        RenderThread.invokeOnRenderContext(() -> this.saveOnRenderThread(string2));
    }

    public void saveOnRenderThread(String string) {
        if (this.getID() == -1) {
            throw new IllegalStateException("texture hasn't been uploaded to the GPU");
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL13.glActiveTexture((int)33984);
        GL11.glEnable((int)3553);
        this.bind();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getWidthHW();
        int n4 = this.getHeightHW();
        int n5 = 4;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(n3 * n4 * n5));
        GL21.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
        int[] nArray = new int[n * n2];
        int n6 = (int)PZMath.floor(this.getXStart() * (float)n3);
        int n7 = (int)PZMath.floor(this.getYStart() * (float)n4);
        for (int i = 0; i < nArray.length; ++i) {
            int n8 = n6 + i % n;
            int n9 = n7 + i / n;
            int n10 = (n8 + n9 * n3) * n5;
            nArray[i] = (byteBuffer.get(n10 + 3) & 0xFF) << 24 | (byteBuffer.get(n10) & 0xFF) << 16 | (byteBuffer.get(n10 + 1) & 0xFF) << 8 | (byteBuffer.get(n10 + 2) & 0xFF) << 0;
        }
        MemoryUtil.memFree((Buffer)byteBuffer);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        try {
            File file = new File(string);
            file.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            ExceptionLogger.logException(iOException);
        }
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
    }

    public void loadMaskRegion(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        this.mask = new Mask();
        this.mask.mask = new BooleanGrid(this.width, this.height);
        this.mask.mask.LoadFromByteBuffer(byteBuffer);
    }

    public void saveMaskRegion(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        this.mask.mask.PutToByteBuffer(byteBuffer);
    }

    public int getRealWidth() {
        return this.realWidth;
    }

    public void setRealWidth(int n) {
        this.realWidth = n;
    }

    public int getRealHeight() {
        return this.realHeight;
    }

    public void setRealHeight(int n) {
        this.realHeight = n;
    }

    public Vector2 getUVScale(Vector2 vector22) {
        vector22.set(1.0f, 1.0f);
        if (this.dataid == null) {
            return vector22;
        }
        if (this.dataid.heightHW != this.dataid.height || this.dataid.widthHW != this.dataid.width) {
            vector22.x = (float)this.dataid.width / (float)this.dataid.widthHW;
            vector22.y = (float)this.dataid.height / (float)this.dataid.heightHW;
        }
        return vector22;
    }

    private void syncReadSize() {
        PNGSize pNGSize = pngSize.get();
        pNGSize.readSize(this.name);
        this.width = pNGSize.width;
        this.height = pNGSize.height;
    }

    @Override
    public AssetType getType() {
        return ASSET_TYPE;
    }

    @Override
    public void onBeforeReady() {
        if (this.assetParams != null) {
            this.assetParams.subTexture = null;
            this.assetParams = null;
        }
        this.solid = this.dataid.solid;
        if (this.splitX == -1) {
            this.width = this.dataid.width;
            this.height = this.dataid.height;
            this.xEnd = (float)this.width / (float)this.dataid.widthHW;
            this.yEnd = (float)this.height / (float)this.dataid.heightHW;
            if (this.dataid.mask != null) {
                this.createMask(this.dataid.mask);
            }
        } else {
            this.setRegion(this.splitX, this.splitY, this.splitW, this.splitH);
            if (this.dataid.mask != null) {
                this.mask = new Mask(this.dataid.mask, this.dataid.width, this.dataid.height, this.splitX, this.splitY, this.splitW, this.splitH);
            }
        }
    }

    public static void collectAllIcons(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        for (Map.Entry<String, Texture> entry : s_sharedTextureTable.entrySet()) {
            if (!entry.getKey().startsWith("media/ui/Container_") && !entry.getKey().startsWith("Item_")) continue;
            String string = "";
            if (entry.getKey().startsWith("Item_")) {
                string = entry.getKey().replaceFirst("Item_", "");
            } else if (entry.getKey().startsWith("media/ui/Container_")) {
                string = entry.getKey().replaceFirst("media/ui/Container_", "");
                string = string.replaceAll("\\.png", "");
                DebugLog.log("Adding " + string.toLowerCase() + ", value = " + entry.getKey());
            }
            hashMap.put(string.toLowerCase(), string);
            hashMap2.put(string.toLowerCase(), entry.getKey());
        }
    }

    static {
        lastlastTextureID = -2;
        totalTextureID = 0;
        white = null;
        errorTexture = null;
        mipmap = null;
        lastTextureID = -1;
        WarnFailFindTexture = true;
        textures = new HashMap();
        s_sharedTextureTable = new HashMap();
        steamAvatarMap = new HashMap();
        pngSize = ThreadLocal.withInitial(PNGSize::new);
        ASSET_TYPE = new AssetType("Texture");
    }

    public static final class TextureAssetParams
    extends AssetManager.AssetParams {
        int flags = 0;
        FileSystem.SubTexture subTexture;
    }

    public static enum PZFileformat {
        PNG,
        DDS;

    }
}

