/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL11;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.CharacterSmartTexture;
import zombie.core.Core;
import zombie.core.ImmutableColor;
import zombie.core.logger.ExceptionLogger;
import zombie.core.opengl.SmartShader;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.CharacterMask;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureCombiner;
import zombie.core.textures.TextureCombinerCommand;
import zombie.core.textures.TextureCombinerShaderParam;
import zombie.core.utils.WrappedBuffer;
import zombie.debug.DebugLog;
import zombie.util.Lambda;
import zombie.util.list.PZArrayUtil;

public class SmartTexture
extends Texture {
    public final ArrayList<TextureCombinerCommand> commands = new ArrayList();
    public Texture result;
    private boolean dirty = true;
    private static SmartShader hue;
    private static SmartShader tint;
    private static SmartShader masked;
    private static SmartShader dirtMask;
    private final HashMap<Integer, ArrayList<Integer>> categoryMap = new HashMap();
    private static SmartShader bodyMask;
    private static SmartShader bodyMaskTint;
    private static SmartShader bodyMaskHue;
    private static final ArrayList<TextureCombinerShaderParam> bodyMaskParams;
    private static SmartShader addHole;
    private static final ArrayList<TextureCombinerShaderParam> addHoleParams;
    private static SmartShader removeHole;
    private static final ArrayList<TextureCombinerShaderParam> removeHoleParams;
    private static SmartShader blit;

    public SmartTexture() {
        this.name = "SmartTexture";
    }

    void addToCat(int n) {
        ArrayList<Object> arrayList = null;
        if (!this.categoryMap.containsKey(n)) {
            arrayList = new ArrayList();
            this.categoryMap.put(n, arrayList);
        } else {
            arrayList = this.categoryMap.get(n);
        }
        arrayList.add(this.commands.size());
    }

    public TextureCombinerCommand getFirstFromCategory(int n) {
        if (!this.categoryMap.containsKey(n)) {
            return null;
        }
        return this.commands.get(this.categoryMap.get(n).get(0));
    }

    public void addOverlayPatches(String string, String string2, int n) {
        if (blit == null) {
            this.create();
        }
        this.addToCat(n);
        ArrayList<TextureCombinerShaderParam> arrayList = new ArrayList<TextureCombinerShaderParam>();
        this.add(string, blit, string2, arrayList, 770, 771);
    }

    public void addOverlay(String string, String string2, float f, int n) {
        if (masked == null) {
            this.create();
        }
        this.addToCat(n);
        ArrayList<TextureCombinerShaderParam> arrayList = new ArrayList<TextureCombinerShaderParam>();
        arrayList.add(new TextureCombinerShaderParam("intensity", f));
        arrayList.add(new TextureCombinerShaderParam("bloodDark", 0.5f, 0.5f));
        this.addSeparate(string, masked, string2, arrayList, 774, 771, 772, 771);
    }

    public void addDirtOverlay(String string, String string2, float f, int n) {
        if (dirtMask == null) {
            this.create();
        }
        this.addToCat(n);
        ArrayList<TextureCombinerShaderParam> arrayList = new ArrayList<TextureCombinerShaderParam>();
        arrayList.add(new TextureCombinerShaderParam("intensity", f));
        this.addSeparate(string, dirtMask, string2, arrayList, 774, 771, 772, 771);
    }

    public void addOverlay(String string) {
        if (tint == null) {
            this.create();
        }
        this.addSeparate(string, 774, 771, 772, 771);
    }

    public void addRect(String string, int n, int n2, int n3, int n4) {
        this.commands.add(TextureCombinerCommand.get().init(SmartTexture.getTextureWithFlags(string), n, n2, n3, n4));
        this.dirty = true;
    }

    @Override
    public void destroy() {
        if (this.result != null) {
            TextureCombiner.instance.releaseTexture(this.result);
        }
        this.clear();
        this.dirty = false;
    }

    public void addTint(String string, int n, float f, float f2, float f3) {
        this.addTint(SmartTexture.getTextureWithFlags(string), n, f, f2, f3);
    }

    public void addTint(Texture texture, int n, float f, float f2, float f3) {
        if (tint == null) {
            this.create();
        }
        this.addToCat(n);
        ArrayList<TextureCombinerShaderParam> arrayList = new ArrayList<TextureCombinerShaderParam>();
        arrayList.add(new TextureCombinerShaderParam("R", f));
        arrayList.add(new TextureCombinerShaderParam("G", f2));
        arrayList.add(new TextureCombinerShaderParam("B", f3));
        this.add(texture, tint, arrayList);
    }

    public void addHue(String string, int n, float f) {
        this.addHue(SmartTexture.getTextureWithFlags(string), n, f);
    }

    public void addHue(Texture texture, int n, float f) {
        if (hue == null) {
            this.create();
        }
        this.addToCat(n);
        ArrayList<TextureCombinerShaderParam> arrayList = new ArrayList<TextureCombinerShaderParam>();
        arrayList.add(new TextureCombinerShaderParam("HueChange", f));
        this.add(texture, hue, arrayList);
    }

    public Texture addHole(BloodBodyPartType bloodBodyPartType) {
        String string = "media/textures/HoleTextures/" + CharacterSmartTexture.MaskFiles[bloodBodyPartType.index()] + ".png";
        if (addHole == null) {
            this.create();
        }
        this.addToCat(CharacterSmartTexture.ClothingItemCategory);
        this.calculate();
        Texture texture = this.result;
        this.clear();
        this.result = null;
        this.commands.add(TextureCombinerCommand.get().initSeparate(texture, addHole, addHoleParams, SmartTexture.getTextureWithFlags(string), 770, 0, 1, 771));
        this.dirty = true;
        return texture;
    }

    public void removeHole(String string, BloodBodyPartType bloodBodyPartType) {
        String string2 = "media/textures/HoleTextures/" + CharacterSmartTexture.MaskFiles[bloodBodyPartType.index()] + ".png";
        this.removeHole(SmartTexture.getTextureWithFlags(string), SmartTexture.getTextureWithFlags(string2), bloodBodyPartType);
    }

    public void removeHole(Texture texture, BloodBodyPartType bloodBodyPartType) {
        String string = "media/textures/HoleTextures/" + CharacterSmartTexture.MaskFiles[bloodBodyPartType.index()] + ".png";
        this.removeHole(texture, SmartTexture.getTextureWithFlags(string), bloodBodyPartType);
    }

    public void removeHole(Texture texture, Texture texture2, BloodBodyPartType bloodBodyPartType) {
        if (removeHole == null) {
            this.create();
        }
        this.addToCat(CharacterSmartTexture.ClothingItemCategory);
        this.commands.add(TextureCombinerCommand.get().init(texture, removeHole, removeHoleParams, texture2, 770, 771));
        this.dirty = true;
    }

    public void mask(String string, String string2, int n) {
        this.mask(SmartTexture.getTextureWithFlags(string), SmartTexture.getTextureWithFlags(string2), n);
    }

    public void mask(Texture texture, Texture texture2, int n) {
        if (bodyMask == null) {
            this.create();
        }
        this.addToCat(n);
        this.commands.add(TextureCombinerCommand.get().init(texture, bodyMask, bodyMaskParams, texture2, 770, 771));
        this.dirty = true;
    }

    public void maskHue(String string, String string2, int n, float f) {
        this.maskHue(SmartTexture.getTextureWithFlags(string), SmartTexture.getTextureWithFlags(string2), n, f);
    }

    public void maskHue(Texture texture, Texture texture2, int n, float f) {
        if (bodyMask == null) {
            this.create();
        }
        this.addToCat(n);
        ArrayList<TextureCombinerShaderParam> arrayList = new ArrayList<TextureCombinerShaderParam>();
        arrayList.add(new TextureCombinerShaderParam("HueChange", f));
        this.commands.add(TextureCombinerCommand.get().init(texture, bodyMaskHue, arrayList, texture2, 770, 771));
        this.dirty = true;
    }

    public void maskTint(String string, String string2, int n, float f, float f2, float f3) {
        this.maskTint(SmartTexture.getTextureWithFlags(string), SmartTexture.getTextureWithFlags(string2), n, f, f2, f3);
    }

    public void maskTint(Texture texture, Texture texture2, int n, float f, float f2, float f3) {
        if (bodyMask == null) {
            this.create();
        }
        this.addToCat(n);
        ArrayList<TextureCombinerShaderParam> arrayList = new ArrayList<TextureCombinerShaderParam>();
        arrayList.add(new TextureCombinerShaderParam("R", f));
        arrayList.add(new TextureCombinerShaderParam("G", f2));
        arrayList.add(new TextureCombinerShaderParam("B", f3));
        this.commands.add(TextureCombinerCommand.get().init(texture, bodyMaskTint, arrayList, texture2, 770, 771));
        this.dirty = true;
    }

    public void addMaskedTexture(CharacterMask characterMask, String string, String string2, int n, ImmutableColor immutableColor, float f) {
        SmartTexture.addMaskedTexture(this, characterMask, string, SmartTexture.getTextureWithFlags(string2), n, immutableColor, f);
    }

    public void addMaskedTexture(CharacterMask characterMask, String string, Texture texture, int n, ImmutableColor immutableColor, float f) {
        SmartTexture.addMaskedTexture(this, characterMask, string, texture, n, immutableColor, f);
    }

    private static void addMaskFlags(SmartTexture smartTexture2, CharacterMask characterMask, String string2, Texture texture2, int n2) {
        Consumer<CharacterMask.Part> consumer = Lambda.consumer(smartTexture2, string2, texture2, n2, (part, smartTexture, string, texture, n) -> smartTexture.mask((Texture)texture, SmartTexture.getTextureWithFlags(string + "/" + part + ".png"), (int)n));
        characterMask.forEachVisible(consumer);
    }

    private static void addMaskFlagsHue(SmartTexture smartTexture2, CharacterMask characterMask, String string2, Texture texture2, int n2, float f2) {
        Consumer<CharacterMask.Part> consumer = Lambda.consumer(smartTexture2, string2, texture2, n2, Float.valueOf(f2), (part, smartTexture, string, texture, n, f) -> smartTexture.maskHue((Texture)texture, SmartTexture.getTextureWithFlags(string + "/" + part + ".png"), (int)n, f.floatValue()));
        characterMask.forEachVisible(consumer);
    }

    private static void addMaskFlagsTint(SmartTexture smartTexture2, CharacterMask characterMask, String string2, Texture texture2, int n2, ImmutableColor immutableColor2) {
        Consumer<CharacterMask.Part> consumer = Lambda.consumer(smartTexture2, string2, texture2, n2, immutableColor2, (part, smartTexture, string, texture, n, immutableColor) -> smartTexture.maskTint((Texture)texture, SmartTexture.getTextureWithFlags(string + "/" + part + ".png"), (int)n, immutableColor.r, immutableColor.g, immutableColor.b));
        characterMask.forEachVisible(consumer);
    }

    private static void addMaskedTexture(SmartTexture smartTexture, CharacterMask characterMask, String string, Texture texture, int n, ImmutableColor immutableColor, float f) {
        if (characterMask.isNothingVisible()) {
            return;
        }
        if (characterMask.isAllVisible()) {
            if (!ImmutableColor.white.equals(immutableColor)) {
                smartTexture.addTint(texture, n, immutableColor.r, immutableColor.g, immutableColor.b);
            } else if (f < -1.0E-4f || f > 1.0E-4f) {
                smartTexture.addHue(texture, n, f);
            } else {
                smartTexture.add(texture);
            }
            return;
        }
        if (!ImmutableColor.white.equals(immutableColor)) {
            SmartTexture.addMaskFlagsTint(smartTexture, characterMask, string, texture, n, immutableColor);
        } else if (f < -1.0E-4f || f > 1.0E-4f) {
            SmartTexture.addMaskFlagsHue(smartTexture, characterMask, string, texture, n, f);
        } else {
            SmartTexture.addMaskFlags(smartTexture, characterMask, string, texture, n);
        }
    }

    public void addTexture(String string, int n, ImmutableColor immutableColor, float f) {
        SmartTexture.addTexture(this, string, n, immutableColor, f);
    }

    private static void addTexture(SmartTexture smartTexture, String string, int n, ImmutableColor immutableColor, float f) {
        if (!ImmutableColor.white.equals(immutableColor)) {
            smartTexture.addTint(string, n, immutableColor.r, immutableColor.g, immutableColor.b);
        } else if (f < -1.0E-4f || f > 1.0E-4f) {
            smartTexture.addHue(string, n, f);
        } else {
            smartTexture.add(string);
        }
    }

    private void create() {
        tint = new SmartShader("hueChange");
        hue = new SmartShader("hueChange");
        masked = new SmartShader("overlayMask");
        dirtMask = new SmartShader("dirtMask");
        bodyMask = new SmartShader("bodyMask");
        bodyMaskHue = new SmartShader("bodyMaskHue");
        bodyMaskTint = new SmartShader("bodyMaskTint");
        addHole = new SmartShader("addHole");
        removeHole = new SmartShader("removeHole");
        blit = new SmartShader("blit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WrappedBuffer getData() {
        SmartTexture smartTexture = this;
        synchronized (smartTexture) {
            if (this.dirty) {
                this.calculate();
            }
            return this.result.dataid.getData();
        }
    }

    @Override
    public synchronized void bind() {
        if (this.dirty) {
            this.calculate();
        }
        this.result.bind(3553);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getID() {
        SmartTexture smartTexture = this;
        synchronized (smartTexture) {
            if (this.dirty) {
                this.calculate();
            }
        }
        return this.result.dataid.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate() {
        SmartTexture smartTexture = this;
        synchronized (smartTexture) {
            if (Core.bDebug) {
                GL11.glGetError();
            }
            try {
                this.result = TextureCombiner.instance.combine(this.commands);
            }
            catch (Exception exception) {
                DebugLog.General.error(exception.getClass().getSimpleName() + " encountered while combining texture.");
                DebugLog.General.error("Intended width : " + TextureCombiner.getResultingWidth(this.commands));
                DebugLog.General.error("Intended height: " + TextureCombiner.getResultingHeight(this.commands));
                DebugLog.General.error("");
                DebugLog.General.error("Commands list: " + PZArrayUtil.arrayToString(this.commands));
                DebugLog.General.error("");
                DebugLog.General.error("Stack trace: ");
                ExceptionLogger.logException(exception);
                DebugLog.General.error("This SmartTexture will no longer be valid.");
                this.width = -1;
                this.height = -1;
                this.dirty = false;
                return;
            }
            this.width = this.result.width;
            this.height = this.result.height;
            this.dirty = false;
        }
    }

    public void clear() {
        TextureCombinerCommand.pool.release((List<TextureCombinerCommand>)this.commands);
        this.commands.clear();
        this.categoryMap.clear();
        this.dirty = false;
    }

    public void add(String string) {
        this.add(SmartTexture.getTextureWithFlags(string));
    }

    public void add(Texture texture) {
        if (blit == null) {
            this.create();
        }
        this.commands.add(TextureCombinerCommand.get().init(texture, blit));
        this.dirty = true;
    }

    public void add(String string, SmartShader smartShader, ArrayList<TextureCombinerShaderParam> arrayList) {
        this.add(SmartTexture.getTextureWithFlags(string), smartShader, arrayList);
    }

    public void add(Texture texture, SmartShader smartShader, ArrayList<TextureCombinerShaderParam> arrayList) {
        this.commands.add(TextureCombinerCommand.get().init(texture, smartShader, arrayList));
        this.dirty = true;
    }

    public void add(String string, SmartShader smartShader, String string2, int n, int n2) {
        this.add(SmartTexture.getTextureWithFlags(string), smartShader, SmartTexture.getTextureWithFlags(string2), n, n2);
    }

    public void add(Texture texture, SmartShader smartShader, Texture texture2, int n, int n2) {
        this.commands.add(TextureCombinerCommand.get().init(texture, smartShader, texture2, n, n2));
        this.dirty = true;
    }

    public void add(String string, int n, int n2) {
        this.add(SmartTexture.getTextureWithFlags(string), n, n2);
    }

    public void add(Texture texture, int n, int n2) {
        this.addSeparate(texture, n, n2, 1, 771);
    }

    public void addSeparate(String string, int n, int n2, int n3, int n4) {
        this.addSeparate(SmartTexture.getTextureWithFlags(string), n, n2, n3, n4);
    }

    public void addSeparate(Texture texture, int n, int n2, int n3, int n4) {
        this.commands.add(TextureCombinerCommand.get().initSeparate(texture, n, n2, n3, n4));
        this.dirty = true;
    }

    public void add(String string, SmartShader smartShader, String string2, ArrayList<TextureCombinerShaderParam> arrayList, int n, int n2) {
        this.add(SmartTexture.getTextureWithFlags(string), smartShader, SmartTexture.getTextureWithFlags(string2), arrayList, n, n2);
    }

    public void add(Texture texture, SmartShader smartShader, Texture texture2, ArrayList<TextureCombinerShaderParam> arrayList, int n, int n2) {
        this.addSeparate(texture, smartShader, texture2, arrayList, n, n2, 1, 771);
    }

    public void addSeparate(String string, SmartShader smartShader, String string2, ArrayList<TextureCombinerShaderParam> arrayList, int n, int n2, int n3, int n4) {
        this.addSeparate(SmartTexture.getTextureWithFlags(string), smartShader, SmartTexture.getTextureWithFlags(string2), arrayList, n, n2, n3, n4);
    }

    public void addSeparate(Texture texture, SmartShader smartShader, Texture texture2, ArrayList<TextureCombinerShaderParam> arrayList, int n, int n2, int n3, int n4) {
        this.commands.add(TextureCombinerCommand.get().initSeparate(texture, smartShader, arrayList, texture2, n, n2, n3, n4));
        this.dirty = true;
    }

    private static Texture getTextureWithFlags(String string) {
        return Texture.getSharedTexture(string, ModelManager.instance.getTextureFlags());
    }

    @Override
    public void saveOnRenderThread(String string) {
        if (this.dirty) {
            this.calculate();
        }
        this.result.saveOnRenderThread(string);
    }

    protected void setDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isEmpty() {
        return this.result == null ? true : this.result.isEmpty();
    }

    @Override
    public boolean isFailure() {
        return this.result == null ? false : this.result.isFailure();
    }

    @Override
    public boolean isReady() {
        return this.result == null ? false : this.result.isReady();
    }

    static {
        bodyMaskParams = new ArrayList();
        addHoleParams = new ArrayList();
        removeHoleParams = new ArrayList();
    }
}

