/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import zombie.GameWindow;
import zombie.debug.DebugLog;

public class Pcx {
    public static HashMap<String, Pcx> Cache = new HashMap();
    public byte[] imageData;
    public int imageWidth;
    public int imageHeight;
    public int[] palette;
    public int[] pic;

    public Pcx(String string) {
    }

    public Pcx(URL uRL) {
    }

    public Pcx(String string, int[] nArray) {
    }

    public Pcx(String string, String string2) {
    }

    public Image getImage() {
        int[] nArray = new int[this.imageWidth * this.imageHeight];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                nArray[n++] = 0xFF000000 | (this.imageData[n2++] & 0xFF) << 16 | (this.imageData[n2++] & 0xFF) << 8 | this.imageData[n2++] & 0xFF;
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth));
    }

    int loadPCX(URL uRL) {
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2 + 1];
            byArray[n2] = 0;
            for (n = 0; n < n2; ++n) {
                byArray[n] = (byte)inputStream.read();
            }
            inputStream.close();
            byte[] byArray2 = byArray;
            if (n2 == -1) {
                return -1;
            }
            pcx_t pcx_t2 = new pcx_t(byArray2);
            byArray2 = pcx_t2.data;
            if (pcx_t2.manufacturer != '\n' || pcx_t2.version != '\u0005' || pcx_t2.encoding != '\u0001' || pcx_t2.bits_per_pixel != '\b' || pcx_t2.xmax >= 640 || pcx_t2.ymax >= 480) {
                DebugLog.log("Bad pcx file " + uRL);
                return -1;
            }
            this.palette = new int[768];
            for (n = 0; n < 768; ++n) {
                if (n2 - 128 - 768 + n >= pcx_t2.data.length) continue;
                this.palette[n] = pcx_t2.data[n2 - 128 - 768 + n] & 0xFF;
            }
            this.imageWidth = pcx_t2.xmax + 1;
            this.imageHeight = pcx_t2.ymax + 1;
            int[] nArray = new int[(pcx_t2.ymax + 1) * (pcx_t2.xmax + 1)];
            this.pic = nArray;
            int[] nArray2 = nArray;
            n = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 <= pcx_t2.ymax) {
                int n5 = 0;
                while (n5 <= pcx_t2.xmax) {
                    int n6;
                    byte by;
                    if (((by = byArray2[n3++]) & 0xC0) == 192) {
                        n6 = by & 0x3F;
                        by = byArray2[n3++];
                    } else {
                        n6 = 1;
                    }
                    while (n6-- > 0) {
                        nArray2[n + n5++] = by & 0xFF;
                    }
                }
                ++n4;
                n += pcx_t2.xmax + 1;
            }
            if (this.pic == null || this.palette == null) {
                return -1;
            }
            this.imageData = new byte[(this.imageWidth + 1) * (this.imageHeight + 1) * 3];
            for (int i = 0; i < this.imageWidth * this.imageHeight; ++i) {
                this.imageData[i * 3] = (byte)this.palette[this.pic[i] * 3];
                this.imageData[i * 3 + 1] = (byte)this.palette[this.pic[i] * 3 + 1];
                this.imageData[i * 3 + 2] = (byte)this.palette[this.pic[i] * 3 + 2];
            }
            return 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    int loadPCXminusPal(String string) {
        try {
            int n;
            if (Cache.containsKey(string)) {
                Pcx pcx = Cache.get(string);
                this.imageWidth = pcx.imageWidth;
                this.imageHeight = pcx.imageHeight;
                this.imageData = new byte[(pcx.imageWidth + 1) * (pcx.imageHeight + 1) * 3];
                for (int i = 0; i < pcx.imageWidth * pcx.imageHeight; ++i) {
                    this.imageData[i * 3] = (byte)this.palette[pcx.pic[i] * 3];
                    this.imageData[i * 3 + 1] = (byte)this.palette[pcx.pic[i] * 3 + 1];
                    this.imageData[i * 3 + 2] = (byte)this.palette[pcx.pic[i] * 3 + 2];
                }
                return 1;
            }
            InputStream inputStream = GameWindow.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                return 0;
            }
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2 + 1];
            byArray[n2] = 0;
            for (n = 0; n < n2; ++n) {
                byArray[n] = (byte)inputStream.read();
            }
            inputStream.close();
            byte[] byArray2 = byArray;
            if (n2 == -1) {
                return -1;
            }
            pcx_t pcx_t2 = new pcx_t(byArray2);
            byArray2 = pcx_t2.data;
            if (pcx_t2.manufacturer != '\n' || pcx_t2.version != '\u0005' || pcx_t2.encoding != '\u0001' || pcx_t2.bits_per_pixel != '\b' || pcx_t2.xmax >= 640 || pcx_t2.ymax >= 480) {
                DebugLog.log("Bad pcx file " + string);
                return -1;
            }
            this.imageWidth = pcx_t2.xmax + 1;
            this.imageHeight = pcx_t2.ymax + 1;
            int[] nArray = new int[(pcx_t2.ymax + 1) * (pcx_t2.xmax + 1)];
            this.pic = nArray;
            int[] nArray2 = nArray;
            n = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 <= pcx_t2.ymax) {
                int n5 = 0;
                while (n5 <= pcx_t2.xmax) {
                    int n6;
                    byte by;
                    if (((by = byArray2[n3++]) & 0xC0) == 192) {
                        n6 = by & 0x3F;
                        by = byArray2[n3++];
                    } else {
                        n6 = 1;
                    }
                    while (n6-- > 0) {
                        nArray2[n + n5++] = by & 0xFF;
                    }
                }
                ++n4;
                n += pcx_t2.xmax + 1;
            }
            if (this.pic == null || this.palette == null) {
                return -1;
            }
            this.imageData = new byte[(this.imageWidth + 1) * (this.imageHeight + 1) * 3];
            for (int i = 0; i < this.imageWidth * this.imageHeight; ++i) {
                this.imageData[i * 3] = (byte)this.palette[this.pic[i] * 3];
                this.imageData[i * 3 + 1] = (byte)this.palette[this.pic[i] * 3 + 1];
                this.imageData[i * 3 + 2] = (byte)this.palette[this.pic[i] * 3 + 2];
            }
            Cache.put(string, this);
            return 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    int loadPCXpal(String string) {
        try {
            int n;
            InputStream inputStream = GameWindow.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                return 1;
            }
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2 + 1];
            byArray[n2] = 0;
            for (n = 0; n < n2; ++n) {
                byArray[n] = (byte)inputStream.read();
            }
            inputStream.close();
            byte[] byArray2 = byArray;
            if (n2 == -1) {
                return -1;
            }
            pcx_t pcx_t2 = new pcx_t(byArray2);
            byArray2 = pcx_t2.data;
            if (pcx_t2.manufacturer != '\n' || pcx_t2.version != '\u0005' || pcx_t2.encoding != '\u0001' || pcx_t2.bits_per_pixel != '\b' || pcx_t2.xmax >= 640 || pcx_t2.ymax >= 480) {
                DebugLog.log("Bad pcx file " + string);
                return -1;
            }
            this.palette = new int[768];
            for (n = 0; n < 768; ++n) {
                if (n2 - 128 - 768 + n >= pcx_t2.data.length) continue;
                this.palette[n] = pcx_t2.data[n2 - 128 - 768 + n] & 0xFF;
            }
            this.imageWidth = pcx_t2.xmax + 1;
            this.imageHeight = pcx_t2.ymax + 1;
            int[] nArray = new int[(pcx_t2.ymax + 1) * (pcx_t2.xmax + 1)];
            this.pic = nArray;
            int[] nArray2 = nArray;
            n = 0;
            boolean bl = false;
            if (this.pic == null || this.palette == null) {
                return -1;
            }
            return 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    private void loadPCXpal(int[] nArray) {
        this.palette = nArray;
    }

    class pcx_t {
        char bits_per_pixel;
        short bytes_per_line;
        char color_planes;
        byte[] data;
        char encoding;
        byte[] filler = new byte[58];
        short hres;
        short vres;
        char manufacturer;
        int[] palette = new int[48];
        short palette_type;
        char reserved;
        char version;
        short xmin;
        short ymin;
        short xmax;
        short ymax;

        pcx_t(byte[] byArray) {
            int n;
            this.manufacturer = (char)byArray[0];
            this.version = (char)byArray[1];
            this.encoding = (char)byArray[2];
            this.bits_per_pixel = (char)byArray[3];
            this.xmin = (short)(byArray[4] + (byArray[5] << 8) & 0xFF);
            this.ymin = (short)(byArray[6] + (byArray[7] << 8) & 0xFF);
            this.xmax = (short)(byArray[8] + (byArray[9] << 8) & 0xFF);
            this.ymax = (short)(byArray[10] + (byArray[11] << 8) & 0xFF);
            this.hres = (short)(byArray[12] + (byArray[13] << 8) & 0xFF);
            this.vres = (short)(byArray[14] + (byArray[15] << 8) & 0xFF);
            for (n = 0; n < 48; ++n) {
                this.palette[n] = byArray[16 + n] & 0xFF;
            }
            this.reserved = (char)byArray[64];
            this.color_planes = (char)byArray[65];
            this.bytes_per_line = (short)(byArray[66] + (byArray[67] << 8) & 0xFF);
            this.palette_type = (short)(byArray[68] + (byArray[69] << 8) & 0xFF);
            for (n = 0; n < 58; ++n) {
                this.filler[n] = byArray[70 + n];
            }
            this.data = new byte[byArray.length - 128];
            for (n = 0; n < byArray.length - 128; ++n) {
                this.data[n] = byArray[128 + n];
            }
        }
    }
}

