/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.nio.ByteBuffer;
import zombie.core.utils.DirectBufferAllocator;
import zombie.core.utils.WrappedBuffer;

public final class MipMapLevel {
    public final int width;
    public final int height;
    public final WrappedBuffer data;

    public MipMapLevel(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.data = DirectBufferAllocator.allocate(n * n2 * 4);
    }

    public MipMapLevel(int n, int n2, WrappedBuffer wrappedBuffer) {
        this.width = n;
        this.height = n2;
        this.data = wrappedBuffer;
    }

    public void dispose() {
        if (this.data != null) {
            this.data.dispose();
        }
    }

    public boolean isDisposed() {
        return this.data != null && this.data.isDisposed();
    }

    public void rewind() {
        if (this.data != null) {
            this.data.getBuffer().rewind();
        }
    }

    public ByteBuffer getBuffer() {
        if (this.data == null) {
            return null;
        }
        return this.data.getBuffer();
    }

    public int getDataSize() {
        return this.width * this.height * 4;
    }
}

