/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import com.evildevil.engines.bubble.texture.DDSLoader;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import zombie.ZomboidFileSystem;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.textures.MipMapLevel;
import zombie.core.textures.PNGDecoder;
import zombie.core.textures.Pcx;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureID;
import zombie.core.utils.BooleanGrid;
import zombie.core.utils.DirectBufferAllocator;
import zombie.core.utils.ImageUtils;
import zombie.core.utils.WrappedBuffer;
import zombie.core.znet.SteamFriends;
import zombie.debug.DebugOptions;
import zombie.util.list.PZArrayUtil;

public final class ImageData
implements Serializable {
    private static final long serialVersionUID = -7893392091273534932L;
    public MipMapLevel data;
    private MipMapLevel[] mipMaps;
    private int height;
    private int heightHW;
    private boolean solid = true;
    private int width;
    private int widthHW;
    private int mipMapCount = -1;
    public boolean alphaPaddingDone = false;
    public boolean bPreserveTransparentColor = false;
    public BooleanGrid mask;
    private static final int BufferSize = 0x4000000;
    static final DDSLoader dds = new DDSLoader();
    public int id = -1;
    public static final int MIP_LEVEL_IDX_OFFSET = 0;
    private static final ThreadLocal<L_generateMipMaps> TL_generateMipMaps = ThreadLocal.withInitial(L_generateMipMaps::new);
    private static final ThreadLocal<L_performAlphaPadding> TL_performAlphaPadding = ThreadLocal.withInitial(L_performAlphaPadding::new);

    public ImageData(TextureID textureID, WrappedBuffer wrappedBuffer) {
        this.data = new MipMapLevel(textureID.widthHW, textureID.heightHW, wrappedBuffer);
        this.width = textureID.width;
        this.widthHW = textureID.widthHW;
        this.height = textureID.height;
        this.heightHW = textureID.heightHW;
        this.solid = textureID.solid;
    }

    public ImageData(String string) throws Exception {
        if (string.contains(".txt")) {
            string = string.replace(".txt", ".png");
        }
        string = Texture.processFilePath(string);
        string = ZomboidFileSystem.instance.getString(string);
        try (FileInputStream fileInputStream = new FileInputStream(string);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            int n;
            int n2;
            PNGDecoder pNGDecoder = new PNGDecoder(bufferedInputStream, false);
            this.width = pNGDecoder.getWidth();
            this.height = pNGDecoder.getHeight();
            this.widthHW = ImageUtils.getNextPowerOfTwoHW(this.width);
            this.heightHW = ImageUtils.getNextPowerOfTwoHW(this.height);
            this.data = new MipMapLevel(this.widthHW, this.heightHW);
            ByteBuffer byteBuffer = this.data.getBuffer();
            byteBuffer.rewind();
            int n3 = this.widthHW * 4;
            if (this.width != this.widthHW) {
                for (n2 = this.width * 4; n2 < this.widthHW * 4; ++n2) {
                    for (n = 0; n < this.heightHW; ++n) {
                        byteBuffer.put(n2 + n * n3, (byte)0);
                    }
                }
            }
            if (this.height != this.heightHW) {
                for (n2 = this.height; n2 < this.heightHW; ++n2) {
                    for (n = 0; n < this.width * 4; ++n) {
                        byteBuffer.put(n + n2 * n3, (byte)0);
                    }
                }
            }
            pNGDecoder.decode(this.data.getBuffer(), n3, PNGDecoder.Format.RGBA);
        }
        catch (Exception exception) {
            this.dispose();
            this.height = -1;
            this.width = -1;
        }
    }

    public ImageData(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.widthHW = ImageUtils.getNextPowerOfTwoHW(n);
        this.heightHW = ImageUtils.getNextPowerOfTwoHW(n2);
        this.data = new MipMapLevel(this.widthHW, this.heightHW);
    }

    public ImageData(int n, int n2, WrappedBuffer wrappedBuffer) {
        this.width = n;
        this.height = n2;
        this.widthHW = ImageUtils.getNextPowerOfTwoHW(n);
        this.heightHW = ImageUtils.getNextPowerOfTwoHW(n2);
        this.data = new MipMapLevel(this.widthHW, this.heightHW, wrappedBuffer);
    }

    ImageData(String string, String string2) {
        Pcx pcx = new Pcx(string, string2);
        this.width = pcx.imageWidth;
        this.height = pcx.imageHeight;
        this.widthHW = ImageUtils.getNextPowerOfTwoHW(this.width);
        this.heightHW = ImageUtils.getNextPowerOfTwoHW(this.height);
        this.data = new MipMapLevel(this.widthHW, this.heightHW);
        this.setData(pcx);
        this.makeTransp((byte)pcx.palette[762], (byte)pcx.palette[763], (byte)pcx.palette[764], (byte)0);
    }

    ImageData(String string, int[] nArray) {
        Pcx pcx = new Pcx(string, nArray);
        this.width = pcx.imageWidth;
        this.height = pcx.imageHeight;
        this.widthHW = ImageUtils.getNextPowerOfTwoHW(this.width);
        this.heightHW = ImageUtils.getNextPowerOfTwoHW(this.height);
        this.data = new MipMapLevel(this.widthHW, this.heightHW);
        this.setData(pcx);
        this.makeTransp((byte)pcx.palette[762], (byte)pcx.palette[763], (byte)pcx.palette[764], (byte)0);
    }

    public ImageData(BufferedInputStream bufferedInputStream, boolean bl, Texture.PZFileformat pZFileformat) {
        if (pZFileformat == Texture.PZFileformat.DDS) {
            RenderThread.invokeOnRenderContext(() -> {
                this.id = dds.loadDDSFile(bufferedInputStream);
            });
            this.width = DDSLoader.lastWid;
            this.height = DDSLoader.lastHei;
            this.widthHW = ImageUtils.getNextPowerOfTwoHW(this.width);
            this.heightHW = ImageUtils.getNextPowerOfTwoHW(this.height);
        }
    }

    public ImageData(InputStream inputStream, boolean bl) throws Exception {
        Object var3_3 = null;
        PNGDecoder pNGDecoder = new PNGDecoder(inputStream, bl);
        this.width = pNGDecoder.getWidth();
        this.height = pNGDecoder.getHeight();
        this.widthHW = ImageUtils.getNextPowerOfTwoHW(this.width);
        this.heightHW = ImageUtils.getNextPowerOfTwoHW(this.height);
        this.data = new MipMapLevel(this.widthHW, this.heightHW);
        this.data.rewind();
        pNGDecoder.decode(this.data.getBuffer(), 4 * this.widthHW, PNGDecoder.Format.RGBA);
        if (bl) {
            this.mask = pNGDecoder.mask;
        }
    }

    public static ImageData createSteamAvatar(long l) {
        WrappedBuffer wrappedBuffer = DirectBufferAllocator.allocate(65536);
        int n = SteamFriends.CreateSteamAvatar(l, wrappedBuffer.getBuffer());
        if (n <= 0) {
            return null;
        }
        int n2 = wrappedBuffer.getBuffer().position() / (n * 4);
        wrappedBuffer.getBuffer().flip();
        ImageData imageData = new ImageData(n, n2, wrappedBuffer);
        return imageData;
    }

    public MipMapLevel getData() {
        if (this.data == null) {
            this.data = new MipMapLevel(this.widthHW, this.heightHW, DirectBufferAllocator.allocate(0x4000000));
        }
        this.data.rewind();
        return this.data;
    }

    public void makeTransp(byte by, byte by2, byte by3) {
        this.makeTransp(by, by2, by3, (byte)0);
    }

    public void makeTransp(byte by, byte by2, byte by3, byte by4) {
        this.solid = false;
        ByteBuffer byteBuffer = this.data.getBuffer();
        byteBuffer.rewind();
        int n = this.widthHW * 4;
        for (int i = 0; i < this.heightHW; ++i) {
            int n2 = byteBuffer.position();
            for (int j = 0; j < this.widthHW; ++j) {
                byte by5 = byteBuffer.get();
                byte by6 = byteBuffer.get();
                byte by7 = byteBuffer.get();
                if (by5 == by && by6 == by2 && by7 == by3) {
                    byteBuffer.put(by4);
                } else {
                    byteBuffer.get();
                }
                if (j != this.width) continue;
                byteBuffer.position(n2 + n);
                break;
            }
            if (i == this.height) break;
        }
        byteBuffer.rewind();
    }

    public void setData(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.setData(bufferedImage.getData());
        }
    }

    public void setData(Raster raster) {
        if (raster == null) {
            new Exception().printStackTrace();
            return;
        }
        this.width = raster.getWidth();
        this.height = raster.getHeight();
        if (this.width > this.widthHW || this.height > this.heightHW) {
            new Exception().printStackTrace();
            return;
        }
        int[] nArray = raster.getPixels(0, 0, this.width, this.height, (int[])null);
        ByteBuffer byteBuffer = this.data.getBuffer();
        byteBuffer.rewind();
        int n = 0;
        int n2 = byteBuffer.position();
        int n3 = this.widthHW * 4;
        for (int i = 0; i < nArray.length; ++i) {
            if (++n > this.width) {
                byteBuffer.position(n2 + n3);
                n2 = byteBuffer.position();
                n = 1;
            }
            byteBuffer.put((byte)nArray[i]);
            byteBuffer.put((byte)nArray[++i]);
            byteBuffer.put((byte)nArray[++i]);
            byteBuffer.put((byte)nArray[++i]);
        }
        byteBuffer.rewind();
        this.solid = false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data = new MipMapLevel(this.widthHW, this.heightHW);
        ByteBuffer byteBuffer = this.data.getBuffer();
        for (int i = 0; i < this.widthHW * this.heightHW; ++i) {
            byteBuffer.put(objectInputStream.readByte()).put(objectInputStream.readByte()).put(objectInputStream.readByte()).put(objectInputStream.readByte());
        }
        byteBuffer.flip();
    }

    private void setData(Pcx pcx) {
        this.width = pcx.imageWidth;
        this.height = pcx.imageHeight;
        if (this.width > this.widthHW || this.height > this.heightHW) {
            new Exception().printStackTrace();
            return;
        }
        ByteBuffer byteBuffer = this.data.getBuffer();
        byteBuffer.rewind();
        int n = 0;
        int n2 = byteBuffer.position();
        int n3 = this.widthHW * 4;
        for (int i = 0; i < this.heightHW * this.widthHW * 3; ++i) {
            if (++n > this.width) {
                n2 = byteBuffer.position();
                n = 1;
            }
            byteBuffer.put(pcx.imageData[i]);
            byteBuffer.put(pcx.imageData[++i]);
            byteBuffer.put(pcx.imageData[++i]);
            byteBuffer.put((byte)-1);
        }
        byteBuffer.rewind();
        this.solid = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ByteBuffer byteBuffer = this.data.getBuffer();
        byteBuffer.rewind();
        for (int i = 0; i < this.widthHW * this.heightHW; ++i) {
            objectOutputStream.writeByte(byteBuffer.get());
            objectOutputStream.writeByte(byteBuffer.get());
            objectOutputStream.writeByte(byteBuffer.get());
            objectOutputStream.writeByte(byteBuffer.get());
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeightHW() {
        return this.heightHW;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthHW() {
        return this.widthHW;
    }

    public int getMipMapCount() {
        if (this.data == null) {
            return 0;
        }
        if (this.mipMapCount < 0) {
            this.mipMapCount = ImageData.calculateNumMips(this.widthHW, this.heightHW);
        }
        return this.mipMapCount;
    }

    public MipMapLevel getMipMapData(int n) {
        if (this.data != null && !this.alphaPaddingDone) {
            this.performAlphaPadding();
        }
        if (n == 0) {
            return this.getData();
        }
        if (this.mipMaps == null) {
            this.generateMipMaps();
        }
        int n2 = n - 1;
        MipMapLevel mipMapLevel = this.mipMaps[n2];
        mipMapLevel.rewind();
        return mipMapLevel;
    }

    public void initMipMaps() {
        int n = this.getMipMapCount();
        int n2 = PZMath.min(0, n - 1);
        int n3 = n;
        for (int i = n2; i < n3; ++i) {
            MipMapLevel mipMapLevel = this.getMipMapData(i);
        }
    }

    public void dispose() {
        if (this.data != null) {
            this.data.dispose();
            this.data = null;
        }
        if (this.mipMaps != null) {
            for (int i = 0; i < this.mipMaps.length; ++i) {
                this.mipMaps[i].dispose();
                this.mipMaps[i] = null;
            }
            this.mipMaps = null;
        }
    }

    private void generateMipMaps() {
        this.mipMapCount = ImageData.calculateNumMips(this.widthHW, this.heightHW);
        int n = this.mipMapCount - 1;
        this.mipMaps = new MipMapLevel[n];
        MipMapLevel mipMapLevel = this.getData();
        int n2 = this.widthHW;
        int n3 = this.heightHW;
        MipMapLevel mipMapLevel2 = mipMapLevel;
        int n4 = n2;
        int n5 = n3;
        int n6 = ImageData.getNextMipDimension(n4);
        int n7 = ImageData.getNextMipDimension(n5);
        for (int i = 0; i < n; ++i) {
            MipMapLevel mipMapLevel3 = new MipMapLevel(n6, n7);
            if (i < 2) {
                this.scaleMipLevelMaxAlpha(mipMapLevel2, mipMapLevel3, i);
            } else {
                this.scaleMipLevelAverage(mipMapLevel2, mipMapLevel3, i);
            }
            this.performAlphaPadding(mipMapLevel3);
            this.mipMaps[i] = mipMapLevel3;
            mipMapLevel2 = mipMapLevel3;
            n6 = ImageData.getNextMipDimension(n6);
            n7 = ImageData.getNextMipDimension(n7);
        }
    }

    private void scaleMipLevelMaxAlpha(MipMapLevel mipMapLevel, MipMapLevel mipMapLevel2, int n) {
        L_generateMipMaps l_generateMipMaps = TL_generateMipMaps.get();
        ByteBuffer byteBuffer = mipMapLevel2.getBuffer();
        byteBuffer.rewind();
        int n2 = mipMapLevel.width;
        int n3 = mipMapLevel.height;
        ByteBuffer byteBuffer2 = mipMapLevel.getBuffer();
        int n4 = mipMapLevel2.width;
        int n5 = mipMapLevel2.height;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6;
                int[] nArray = l_generateMipMaps.pixelBytes;
                int[] nArray2 = l_generateMipMaps.originalPixel;
                int[] nArray3 = l_generateMipMaps.resultPixelBytes;
                ImageData.getPixelClamped(byteBuffer2, n2, n3, j * 2, i * 2, nArray2);
                if (this.bPreserveTransparentColor || nArray2[3] > 0) {
                    PZArrayUtil.arrayCopy(nArray3, nArray2, 0, 4);
                    n6 = 1;
                } else {
                    PZArrayUtil.arraySet(nArray3, 0);
                    n6 = 0;
                }
                n6 += this.sampleNeighborPixelDiscard(byteBuffer2, n2, n3, j * 2 + 1, i * 2, nArray, nArray3);
                n6 += this.sampleNeighborPixelDiscard(byteBuffer2, n2, n3, j * 2, i * 2 + 1, nArray, nArray3);
                if ((n6 += this.sampleNeighborPixelDiscard(byteBuffer2, n2, n3, j * 2 + 1, i * 2 + 1, nArray, nArray3)) > 0) {
                    nArray3[0] = nArray3[0] / n6;
                    nArray3[1] = nArray3[1] / n6;
                    nArray3[2] = nArray3[2] / n6;
                    nArray3[3] = nArray3[3] / n6;
                    if (DebugOptions.instance.IsoSprite.WorldMipmapColors.getValue()) {
                        ImageData.setMipmapDebugColors(n, nArray3);
                    }
                }
                ImageData.setPixel(byteBuffer, n4, n5, j, i, nArray3);
            }
        }
    }

    private void scaleMipLevelAverage(MipMapLevel mipMapLevel, MipMapLevel mipMapLevel2, int n) {
        L_generateMipMaps l_generateMipMaps = TL_generateMipMaps.get();
        ByteBuffer byteBuffer = mipMapLevel2.getBuffer();
        byteBuffer.rewind();
        int n2 = mipMapLevel.width;
        int n3 = mipMapLevel.height;
        ByteBuffer byteBuffer2 = mipMapLevel.getBuffer();
        int n4 = mipMapLevel2.width;
        int n5 = mipMapLevel2.height;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int[] nArray = l_generateMipMaps.resultPixelBytes;
                int n6 = 1;
                ImageData.getPixelClamped(byteBuffer2, n2, n3, j * 2, i * 2, nArray);
                n6 += ImageData.getPixelDiscard(byteBuffer2, n2, n3, j * 2 + 1, i * 2, nArray);
                n6 += ImageData.getPixelDiscard(byteBuffer2, n2, n3, j * 2, i * 2 + 1, nArray);
                nArray[0] = nArray[0] / (n6 += ImageData.getPixelDiscard(byteBuffer2, n2, n3, j * 2 + 1, i * 2 + 1, nArray));
                nArray[1] = nArray[1] / n6;
                nArray[2] = nArray[2] / n6;
                nArray[3] = nArray[3] / n6;
                if (nArray[3] != 0 && DebugOptions.instance.IsoSprite.WorldMipmapColors.getValue()) {
                    ImageData.setMipmapDebugColors(n, nArray);
                }
                ImageData.setPixel(byteBuffer, n4, n5, j, i, nArray);
            }
        }
    }

    public static int calculateNumMips(int n, int n2) {
        int n3 = ImageData.calculateNumMips(n);
        int n4 = ImageData.calculateNumMips(n2);
        return PZMath.max(n3, n4);
    }

    private static int calculateNumMips(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 > 0) {
            n3 >>= 1;
            ++n2;
        }
        return n2;
    }

    private void performAlphaPadding() {
        MipMapLevel mipMapLevel = this.data;
        if (mipMapLevel == null || mipMapLevel.data == null) {
            return;
        }
        this.performAlphaPadding(mipMapLevel);
        this.alphaPaddingDone = true;
    }

    private void performAlphaPadding(MipMapLevel mipMapLevel) {
        L_performAlphaPadding l_performAlphaPadding = TL_performAlphaPadding.get();
        ByteBuffer byteBuffer = mipMapLevel.getBuffer();
        int n = mipMapLevel.width;
        int n2 = mipMapLevel.height;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = (i * n + j) * 4;
                int n4 = byteBuffer.get(n3 + 3) & 0xFF;
                if (n4 == 255 || n4 != 0) continue;
                int[] nArray = ImageData.getPixelClamped(byteBuffer, n, n2, j, i, l_performAlphaPadding.pixelRGBA);
                int[] nArray2 = l_performAlphaPadding.newPixelRGBA;
                PZArrayUtil.arraySet(nArray2, 0);
                nArray2[3] = nArray[3];
                int n5 = 0;
                n5 += this.sampleNeighborPixelDiscard(byteBuffer, n, n2, j - 1, i, l_performAlphaPadding.pixelRGBA_neighbor, nArray2);
                n5 += this.sampleNeighborPixelDiscard(byteBuffer, n, n2, j, i - 1, l_performAlphaPadding.pixelRGBA_neighbor, nArray2);
                n5 += this.sampleNeighborPixelDiscard(byteBuffer, n, n2, j - 1, i - 1, l_performAlphaPadding.pixelRGBA_neighbor, nArray2);
                n5 += this.sampleNeighborPixelDiscard(byteBuffer, n, n2, j + 1, i, l_performAlphaPadding.pixelRGBA_neighbor, nArray2);
                n5 += this.sampleNeighborPixelDiscard(byteBuffer, n, n2, j, i + 1, l_performAlphaPadding.pixelRGBA_neighbor, nArray2);
                if ((n5 += this.sampleNeighborPixelDiscard(byteBuffer, n, n2, j + 1, i + 1, l_performAlphaPadding.pixelRGBA_neighbor, nArray2)) <= 0) continue;
                nArray2[0] = nArray2[0] / n5;
                nArray2[1] = nArray2[1] / n5;
                nArray2[2] = nArray2[2] / n5;
                nArray2[3] = nArray[3];
                ImageData.setPixel(byteBuffer, n, n2, j, i, nArray2);
            }
        }
    }

    private int sampleNeighborPixelDiscard(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
            return 0;
        }
        ImageData.getPixelClamped(byteBuffer, n, n2, n3, n4, nArray);
        if (nArray[3] > 0) {
            nArray2[0] = nArray2[0] + nArray[0];
            nArray2[1] = nArray2[1] + nArray[1];
            nArray2[2] = nArray2[2] + nArray[2];
            nArray2[3] = nArray2[3] + nArray[3];
            return 1;
        }
        return 0;
    }

    public static int getPixelDiscard(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
            return 0;
        }
        int n5 = (n3 + n4 * n) * 4;
        nArray[0] = nArray[0] + (byteBuffer.get(n5) & 0xFF);
        nArray[1] = nArray[1] + (byteBuffer.get(n5 + 1) & 0xFF);
        nArray[2] = nArray[2] + (byteBuffer.get(n5 + 2) & 0xFF);
        nArray[3] = nArray[3] + (byteBuffer.get(n5 + 3) & 0xFF);
        return 1;
    }

    public static int[] getPixelClamped(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int[] nArray) {
        n3 = PZMath.clamp(n3, 0, n - 1);
        n4 = PZMath.clamp(n4, 0, n2 - 1);
        int n5 = (n3 + n4 * n) * 4;
        nArray[0] = byteBuffer.get(n5) & 0xFF;
        nArray[1] = byteBuffer.get(n5 + 1) & 0xFF;
        nArray[2] = byteBuffer.get(n5 + 2) & 0xFF;
        nArray[3] = byteBuffer.get(n5 + 3) & 0xFF;
        return nArray;
    }

    public static void setPixel(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = (n3 + n4 * n) * 4;
        byteBuffer.put(n5, (byte)(nArray[0] & 0xFF));
        byteBuffer.put(n5 + 1, (byte)(nArray[1] & 0xFF));
        byteBuffer.put(n5 + 2, (byte)(nArray[2] & 0xFF));
        byteBuffer.put(n5 + 3, (byte)(nArray[3] & 0xFF));
    }

    public static int getNextMipDimension(int n) {
        if (n > 1) {
            n >>= 1;
        }
        return n;
    }

    private static void setMipmapDebugColors(int n, int[] nArray) {
        switch (n) {
            case 0: {
                nArray[0] = 255;
                nArray[1] = 0;
                nArray[2] = 0;
                break;
            }
            case 1: {
                nArray[0] = 0;
                nArray[1] = 255;
                nArray[2] = 0;
                break;
            }
            case 2: {
                nArray[0] = 0;
                nArray[1] = 0;
                nArray[2] = 255;
                break;
            }
            case 3: {
                nArray[0] = 255;
                nArray[1] = 255;
                nArray[2] = 0;
                break;
            }
            case 4: {
                nArray[0] = 255;
                nArray[1] = 0;
                nArray[2] = 255;
                break;
            }
            case 5: {
                nArray[0] = 0;
                nArray[1] = 0;
                nArray[2] = 0;
                break;
            }
            case 6: {
                nArray[0] = 255;
                nArray[1] = 255;
                nArray[2] = 255;
                break;
            }
            case 7: {
                nArray[0] = 128;
                nArray[1] = 128;
                nArray[2] = 128;
            }
        }
    }

    private static final class L_generateMipMaps {
        final int[] pixelBytes = new int[4];
        final int[] originalPixel = new int[4];
        final int[] resultPixelBytes = new int[4];

        private L_generateMipMaps() {
        }
    }

    static final class L_performAlphaPadding {
        final int[] pixelRGBA = new int[4];
        final int[] newPixelRGBA = new int[4];
        final int[] pixelRGBA_neighbor = new int[4];

        L_performAlphaPadding() {
        }
    }
}

