/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import zombie.core.Color;
import zombie.core.ImmutableColor;

public final class ColorInfo {
    public float a = 1.0f;
    public float b = 1.0f;
    public float g = 1.0f;
    public float r = 1.0f;

    public ColorInfo() {
        this.r = 1.0f;
        this.g = 1.0f;
        this.b = 1.0f;
        this.a = 1.0f;
    }

    public ColorInfo(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
    }

    public ColorInfo set(ColorInfo colorInfo) {
        this.r = colorInfo.r;
        this.g = colorInfo.g;
        this.b = colorInfo.b;
        this.a = colorInfo.a;
        return this;
    }

    public ColorInfo set(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
        return this;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public Color toColor() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public ImmutableColor toImmutableColor() {
        return new ImmutableColor(this.r, this.g, this.b, this.a);
    }

    public float getA() {
        return this.a;
    }

    public void desaturate(float f) {
        float f2 = this.r * 0.3086f + this.g * 0.6094f + this.b * 0.082f;
        this.r = f2 * f + this.r * (1.0f - f);
        this.g = f2 * f + this.g * (1.0f - f);
        this.b = f2 * f + this.b * (1.0f - f);
    }

    public void interp(ColorInfo colorInfo, float f, ColorInfo colorInfo2) {
        float f2 = colorInfo.r - this.r;
        float f3 = colorInfo.g - this.g;
        float f4 = colorInfo.b - this.b;
        float f5 = colorInfo.a - this.a;
        colorInfo2.r = this.r + (f2 *= f);
        colorInfo2.g = this.g + (f3 *= f);
        colorInfo2.b = this.b + (f4 *= f);
        colorInfo2.a = this.a + (f5 *= f);
    }

    public String toString() {
        return "Color (" + this.r + "," + this.g + "," + this.b + "," + this.a + ")";
    }
}

