/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.stash;

import java.util.ArrayList;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import zombie.core.Translator;
import zombie.core.stash.StashAnnotation;
import zombie.core.stash.StashBuilding;
import zombie.core.stash.StashContainer;
import zombie.core.stash.StashSystem;
import zombie.debug.DebugLog;
import zombie.scripting.ScriptManager;

public final class Stash {
    public String name;
    public String type;
    public String item;
    public String customName;
    public int buildingX;
    public int buildingY;
    public String spawnTable;
    public ArrayList<StashAnnotation> annotations;
    public boolean spawnOnlyOnZed;
    public int minDayToSpawn = -1;
    public int maxDayToSpawn = -1;
    public int minTrapToSpawn = -1;
    public int maxTrapToSpawn = -1;
    public int zombies;
    public ArrayList<StashContainer> containers;
    public int barricades;

    public Stash(String string) {
        this.name = string;
    }

    public void load(KahluaTableImpl kahluaTableImpl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.type = kahluaTableImpl.rawgetStr("type");
        this.item = kahluaTableImpl.rawgetStr("item");
        StashBuilding stashBuilding = new StashBuilding(this.name, kahluaTableImpl.rawgetInt("buildingX"), kahluaTableImpl.rawgetInt("buildingY"));
        StashSystem.possibleStashes.add(stashBuilding);
        this.buildingX = stashBuilding.buildingX;
        this.buildingY = stashBuilding.buildingY;
        this.spawnTable = kahluaTableImpl.rawgetStr("spawnTable");
        this.customName = Translator.getText(kahluaTableImpl.rawgetStr("customName"));
        this.zombies = kahluaTableImpl.rawgetInt("zombies");
        this.barricades = kahluaTableImpl.rawgetInt("barricades");
        this.spawnOnlyOnZed = kahluaTableImpl.rawgetBool("spawnOnlyOnZed");
        String string = kahluaTableImpl.rawgetStr("daysToSpawn");
        if (string != null) {
            object5 = string.split("-");
            if (((String[])object5).length == 2) {
                this.minDayToSpawn = Integer.parseInt((String)object5[0]);
                this.maxDayToSpawn = Integer.parseInt((String)object5[1]);
            } else {
                this.minDayToSpawn = Integer.parseInt((String)object5[0]);
            }
        }
        if ((object5 = kahluaTableImpl.rawgetStr("traps")) != null) {
            object4 = ((String)object5).split("-");
            if (((String[])object4).length == 2) {
                this.minTrapToSpawn = Integer.parseInt(object4[0]);
                this.maxTrapToSpawn = Integer.parseInt((String)object4[1]);
            } else {
                this.maxTrapToSpawn = this.minTrapToSpawn = Integer.parseInt(object4[0]);
            }
        }
        if ((object4 = (KahluaTable)kahluaTableImpl.rawget("containers")) != null) {
            this.containers = new ArrayList();
            object3 = object4.iterator();
            while (object3.advance()) {
                object2 = (KahluaTableImpl)object3.getValue();
                object = new StashContainer(((KahluaTableImpl)object2).rawgetStr("room"), ((KahluaTableImpl)object2).rawgetStr("containerSprite"), ((KahluaTableImpl)object2).rawgetStr("containerType"));
                ((StashContainer)object).contX = ((KahluaTableImpl)object2).rawgetInt("contX");
                ((StashContainer)object).contY = ((KahluaTableImpl)object2).rawgetInt("contY");
                ((StashContainer)object).contZ = ((KahluaTableImpl)object2).rawgetInt("contZ");
                ((StashContainer)object).containerItem = ((KahluaTableImpl)object2).rawgetStr("containerItem");
                if (((StashContainer)object).containerItem != null && ScriptManager.instance.getItem(((StashContainer)object).containerItem) == null) {
                    DebugLog.General.error("Stash containerItem \"%s\" doesn't exist.", ((StashContainer)object).containerItem);
                }
                this.containers.add((StashContainer)object);
            }
        }
        if ("Map".equals(this.type) && (object3 = (KahluaTableImpl)kahluaTableImpl.rawget("annotations")) != null) {
            this.annotations = new ArrayList();
            object2 = object3.iterator();
            while (object2.advance()) {
                object = (KahluaTable)object2.getValue();
                StashAnnotation stashAnnotation = new StashAnnotation();
                stashAnnotation.fromLua((KahluaTable)object);
                this.annotations.add(stashAnnotation);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getItem() {
        return this.item;
    }

    public int getBuildingX() {
        return this.buildingX;
    }

    public int getBuildingY() {
        return this.buildingY;
    }
}

