/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.visual;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.visual.ItemVisual;

public final class ItemVisuals
extends ArrayList<ItemVisual> {
    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putShort((short)this.size());
        for (int i = 0; i < this.size(); ++i) {
            ((ItemVisual)this.get(i)).save(byteBuffer);
        }
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.clear();
        int n2 = byteBuffer.getShort();
        for (int i = 0; i < n2; ++i) {
            ItemVisual itemVisual = new ItemVisual();
            itemVisual.load(byteBuffer, n);
            this.add(itemVisual);
        }
    }

    public ItemVisual findHat() {
        for (int i = 0; i < this.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)this.get(i);
            ClothingItem clothingItem = itemVisual.getClothingItem();
            if (clothingItem == null || !clothingItem.isHat()) continue;
            return itemVisual;
        }
        return null;
    }

    public ItemVisual findMask() {
        for (int i = 0; i < this.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)this.get(i);
            ClothingItem clothingItem = itemVisual.getClothingItem();
            if (clothingItem == null || !clothingItem.isMask()) continue;
            return itemVisual;
        }
        return null;
    }
}

