/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.visual;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import zombie.GameWindow;
import zombie.characterTextures.BloodBodyPartType;
import zombie.core.ImmutableColor;
import zombie.core.skinnedmodel.model.CharacterMask;
import zombie.core.skinnedmodel.population.ClothingDecals;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemReference;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;

public final class ItemVisual {
    private String m_fullType;
    private String m_clothingItemName;
    private String m_alternateModelName;
    public static final float NULL_HUE = Float.POSITIVE_INFINITY;
    public float m_Hue = Float.POSITIVE_INFINITY;
    public ImmutableColor m_Tint = null;
    public int m_BaseTexture = -1;
    public int m_TextureChoice = -1;
    public String m_Decal = null;
    private byte[] blood;
    private byte[] dirt;
    private byte[] holes;
    private byte[] basicPatches;
    private byte[] denimPatches;
    private byte[] leatherPatches;
    private InventoryItem inventoryItem = null;
    private static final int LASTSTAND_VERSION1 = 1;
    private static final int LASTSTAND_VERSION = 1;

    public ItemVisual() {
    }

    public ItemVisual(ItemVisual itemVisual) {
        this.copyFrom(itemVisual);
    }

    public void setItemType(String string) {
        Objects.requireNonNull(string);
        assert (string.contains("."));
        this.m_fullType = string;
    }

    public String getItemType() {
        return this.m_fullType;
    }

    public void setAlternateModelName(String string) {
        this.m_alternateModelName = string;
    }

    public String getAlternateModelName() {
        return this.m_alternateModelName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ m_clothingItemName:\"" + this.m_clothingItemName + "\"}";
    }

    public String getClothingItemName() {
        return this.m_clothingItemName;
    }

    public void setClothingItemName(String string) {
        this.m_clothingItemName = string;
    }

    public Item getScriptItem() {
        if (StringUtils.isNullOrWhitespace(this.m_fullType)) {
            return null;
        }
        return ScriptManager.instance.getItem(this.m_fullType);
    }

    public ClothingItem getClothingItem() {
        Item item = this.getScriptItem();
        if (item == null) {
            return null;
        }
        if (!StringUtils.isNullOrWhitespace(this.m_alternateModelName)) {
            if ("LeftHand".equalsIgnoreCase(this.m_alternateModelName)) {
                return item.replaceSecondHand.clothingItem;
            }
            if ("RightHand".equalsIgnoreCase(this.m_alternateModelName)) {
                return item.replacePrimaryHand.clothingItem;
            }
        }
        return item.getClothingItemAsset();
    }

    public void getClothingItemCombinedMask(CharacterMask characterMask) {
        ClothingItem.tryGetCombinedMask(this.getClothingItem(), characterMask);
    }

    public void setHue(float f) {
        f = Math.max(f, -1.0f);
        this.m_Hue = f = Math.min(f, 1.0f);
    }

    public float getHue(ClothingItem clothingItem) {
        if (clothingItem.m_AllowRandomHue) {
            if (this.m_Hue == Float.POSITIVE_INFINITY) {
                this.m_Hue = (float)OutfitRNG.Next(200) / 100.0f - 1.0f;
            }
            return this.m_Hue;
        }
        this.m_Hue = 0.0f;
        return 0.0f;
    }

    public void setTint(ImmutableColor immutableColor) {
        this.m_Tint = immutableColor;
    }

    public ImmutableColor getTint(ClothingItem clothingItem) {
        if (clothingItem.m_AllowRandomTint) {
            if (this.m_Tint == null) {
                this.m_Tint = OutfitRNG.randomImmutableColor();
            }
            return this.m_Tint;
        }
        this.m_Tint = ImmutableColor.white;
        return this.m_Tint;
    }

    public ImmutableColor getTint() {
        return this.m_Tint;
    }

    public String getBaseTexture(ClothingItem clothingItem) {
        if (clothingItem.m_BaseTextures.isEmpty()) {
            this.m_BaseTexture = -1;
            return null;
        }
        if (this.m_BaseTexture < 0 || this.m_BaseTexture >= clothingItem.m_BaseTextures.size()) {
            this.m_BaseTexture = OutfitRNG.Next(clothingItem.m_BaseTextures.size());
        }
        return clothingItem.m_BaseTextures.get(this.m_BaseTexture);
    }

    public String getTextureChoice(ClothingItem clothingItem) {
        if (clothingItem.textureChoices.isEmpty()) {
            this.m_TextureChoice = -1;
            return null;
        }
        if (this.m_TextureChoice < 0 || this.m_TextureChoice >= clothingItem.textureChoices.size()) {
            this.m_TextureChoice = OutfitRNG.Next(clothingItem.textureChoices.size());
        }
        return clothingItem.textureChoices.get(this.m_TextureChoice);
    }

    public void setDecal(String string) {
        this.m_Decal = string;
    }

    public String getDecal(ClothingItem clothingItem) {
        if (StringUtils.isNullOrWhitespace(clothingItem.m_DecalGroup)) {
            this.m_Decal = null;
            return null;
        }
        if (this.m_Decal == null) {
            this.m_Decal = ClothingDecals.instance.getRandomDecal(clothingItem.m_DecalGroup);
        }
        return this.m_Decal;
    }

    public void pickUninitializedValues(ClothingItem clothingItem) {
        if (clothingItem == null || !clothingItem.isReady()) {
            return;
        }
        this.getHue(clothingItem);
        this.getTint(clothingItem);
        this.getBaseTexture(clothingItem);
        this.getTextureChoice(clothingItem);
        this.getDecal(clothingItem);
    }

    public void synchWithOutfit(ClothingItemReference clothingItemReference) {
        ClothingItem clothingItem = clothingItemReference.getClothingItem();
        this.m_clothingItemName = clothingItem.m_Name;
        this.m_Hue = clothingItemReference.RandomData.m_Hue;
        this.m_Tint = clothingItemReference.RandomData.m_Tint;
        this.m_BaseTexture = clothingItem.m_BaseTextures.indexOf(clothingItemReference.RandomData.m_BaseTexture);
        this.m_TextureChoice = clothingItem.textureChoices.indexOf(clothingItemReference.RandomData.m_TextureChoice);
        this.m_Decal = clothingItemReference.RandomData.m_Decal;
    }

    public void clear() {
        this.m_fullType = null;
        this.m_clothingItemName = null;
        this.m_alternateModelName = null;
        this.m_Hue = Float.POSITIVE_INFINITY;
        this.m_Tint = null;
        this.m_BaseTexture = -1;
        this.m_TextureChoice = -1;
        this.m_Decal = null;
        if (this.blood != null) {
            Arrays.fill(this.blood, (byte)0);
        }
        if (this.dirt != null) {
            Arrays.fill(this.dirt, (byte)0);
        }
        if (this.holes != null) {
            Arrays.fill(this.holes, (byte)0);
        }
        if (this.basicPatches != null) {
            Arrays.fill(this.basicPatches, (byte)0);
        }
        if (this.denimPatches != null) {
            Arrays.fill(this.denimPatches, (byte)0);
        }
        if (this.leatherPatches != null) {
            Arrays.fill(this.leatherPatches, (byte)0);
        }
    }

    public void copyFrom(ItemVisual itemVisual) {
        if (itemVisual == null) {
            this.clear();
            return;
        }
        ClothingItem clothingItem = itemVisual.getClothingItem();
        if (clothingItem != null) {
            itemVisual.pickUninitializedValues(clothingItem);
        }
        this.m_fullType = itemVisual.m_fullType;
        this.m_clothingItemName = itemVisual.m_clothingItemName;
        this.m_alternateModelName = itemVisual.m_alternateModelName;
        this.m_Hue = itemVisual.m_Hue;
        this.m_Tint = itemVisual.m_Tint;
        this.m_BaseTexture = itemVisual.m_BaseTexture;
        this.m_TextureChoice = itemVisual.m_TextureChoice;
        this.m_Decal = itemVisual.m_Decal;
        this.copyBlood(itemVisual);
        this.copyHoles(itemVisual);
        this.copyPatches(itemVisual);
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        int n;
        byte by = 0;
        if (this.m_Tint != null) {
            by = (byte)(by | 1);
        }
        if (this.m_BaseTexture != -1) {
            by = (byte)(by | 2);
        }
        if (this.m_TextureChoice != -1) {
            by = (byte)(by | 4);
        }
        if (this.m_Hue != Float.POSITIVE_INFINITY) {
            by = (byte)(by | 8);
        }
        if (!StringUtils.isNullOrWhitespace(this.m_Decal)) {
            by = (byte)(by | 0x10);
        }
        byteBuffer.put(by);
        GameWindow.WriteString(byteBuffer, this.m_fullType);
        GameWindow.WriteString(byteBuffer, this.m_alternateModelName);
        GameWindow.WriteString(byteBuffer, this.m_clothingItemName);
        if (this.m_Tint != null) {
            byteBuffer.put(this.m_Tint.getRedByte());
            byteBuffer.put(this.m_Tint.getGreenByte());
            byteBuffer.put(this.m_Tint.getBlueByte());
        }
        if (this.m_BaseTexture != -1) {
            byteBuffer.put((byte)this.m_BaseTexture);
        }
        if (this.m_TextureChoice != -1) {
            byteBuffer.put((byte)this.m_TextureChoice);
        }
        if (this.m_Hue != Float.POSITIVE_INFINITY) {
            byteBuffer.putFloat(this.m_Hue);
        }
        if (!StringUtils.isNullOrWhitespace(this.m_Decal)) {
            GameWindow.WriteString(byteBuffer, this.m_Decal);
        }
        if (this.blood != null) {
            byteBuffer.put((byte)this.blood.length);
            for (n = 0; n < this.blood.length; ++n) {
                byteBuffer.put(this.blood[n]);
            }
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.dirt != null) {
            byteBuffer.put((byte)this.dirt.length);
            for (n = 0; n < this.dirt.length; ++n) {
                byteBuffer.put(this.dirt[n]);
            }
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.holes != null) {
            byteBuffer.put((byte)this.holes.length);
            for (n = 0; n < this.holes.length; ++n) {
                byteBuffer.put(this.holes[n]);
            }
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.basicPatches != null) {
            byteBuffer.put((byte)this.basicPatches.length);
            for (n = 0; n < this.basicPatches.length; ++n) {
                byteBuffer.put(this.basicPatches[n]);
            }
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.denimPatches != null) {
            byteBuffer.put((byte)this.denimPatches.length);
            for (n = 0; n < this.denimPatches.length; ++n) {
                byteBuffer.put(this.denimPatches[n]);
            }
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.leatherPatches != null) {
            byteBuffer.put((byte)this.leatherPatches.length);
            for (n = 0; n < this.leatherPatches.length; ++n) {
                byteBuffer.put(this.leatherPatches[n]);
            }
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = byteBuffer.get() & 0xFF;
        if (n >= 164) {
            this.m_fullType = GameWindow.ReadString(byteBuffer);
            this.m_alternateModelName = GameWindow.ReadString(byteBuffer);
        }
        this.m_clothingItemName = GameWindow.ReadString(byteBuffer);
        if (n < 164) {
            this.m_fullType = ScriptManager.instance.getItemTypeForClothingItem(this.m_clothingItemName);
        }
        if ((n5 & 1) != 0) {
            n4 = byteBuffer.get() & 0xFF;
            n3 = byteBuffer.get() & 0xFF;
            n2 = byteBuffer.get() & 0xFF;
            this.m_Tint = new ImmutableColor(n4, n3, n2);
        }
        if ((n5 & 2) != 0) {
            this.m_BaseTexture = byteBuffer.get();
        }
        if ((n5 & 4) != 0) {
            this.m_TextureChoice = byteBuffer.get();
        }
        if (n >= 146) {
            if ((n5 & 8) != 0) {
                this.m_Hue = byteBuffer.getFloat();
            }
            if ((n5 & 0x10) != 0) {
                this.m_Decal = GameWindow.ReadString(byteBuffer);
            }
        }
        if ((n4 = (int)byteBuffer.get()) > 0 && this.blood == null) {
            this.blood = new byte[BloodBodyPartType.MAX.index()];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = byteBuffer.get();
            if (n3 >= this.blood.length) continue;
            this.blood[n3] = n2;
        }
        if (n >= 163) {
            n4 = byteBuffer.get();
            if (n4 > 0 && this.dirt == null) {
                this.dirt = new byte[BloodBodyPartType.MAX.index()];
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = byteBuffer.get();
                if (n3 >= this.dirt.length) continue;
                this.dirt[n3] = n2;
            }
        }
        if ((n4 = (int)byteBuffer.get()) > 0 && this.holes == null) {
            this.holes = new byte[BloodBodyPartType.MAX.index()];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = byteBuffer.get();
            if (n3 >= this.holes.length) continue;
            this.holes[n3] = n2;
        }
        if (n >= 154) {
            n4 = byteBuffer.get();
            if (n4 > 0 && this.basicPatches == null) {
                this.basicPatches = new byte[BloodBodyPartType.MAX.index()];
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = byteBuffer.get();
                if (n3 >= this.basicPatches.length) continue;
                this.basicPatches[n3] = n2;
            }
        }
        if (n >= 155) {
            n4 = byteBuffer.get();
            if (n4 > 0 && this.denimPatches == null) {
                this.denimPatches = new byte[BloodBodyPartType.MAX.index()];
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = byteBuffer.get();
                if (n3 >= this.denimPatches.length) continue;
                this.denimPatches[n3] = n2;
            }
            n4 = byteBuffer.get();
            if (n4 > 0 && this.leatherPatches == null) {
                this.leatherPatches = new byte[BloodBodyPartType.MAX.index()];
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = byteBuffer.get();
                if (n3 >= this.leatherPatches.length) continue;
                this.leatherPatches[n3] = n2;
            }
        }
    }

    public void setDenimPatch(BloodBodyPartType bloodBodyPartType) {
        if (this.denimPatches == null) {
            this.denimPatches = new byte[BloodBodyPartType.MAX.index()];
        }
        this.denimPatches[bloodBodyPartType.index()] = -1;
    }

    public float getDenimPatch(BloodBodyPartType bloodBodyPartType) {
        if (this.denimPatches == null) {
            return 0.0f;
        }
        return (float)(this.denimPatches[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public void setLeatherPatch(BloodBodyPartType bloodBodyPartType) {
        if (this.leatherPatches == null) {
            this.leatherPatches = new byte[BloodBodyPartType.MAX.index()];
        }
        this.leatherPatches[bloodBodyPartType.index()] = -1;
    }

    public float getLeatherPatch(BloodBodyPartType bloodBodyPartType) {
        if (this.leatherPatches == null) {
            return 0.0f;
        }
        return (float)(this.leatherPatches[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public void setBasicPatch(BloodBodyPartType bloodBodyPartType) {
        if (this.basicPatches == null) {
            this.basicPatches = new byte[BloodBodyPartType.MAX.index()];
        }
        this.basicPatches[bloodBodyPartType.index()] = -1;
    }

    public float getBasicPatch(BloodBodyPartType bloodBodyPartType) {
        if (this.basicPatches == null) {
            return 0.0f;
        }
        return (float)(this.basicPatches[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public int getBasicPatchesNumber() {
        if (this.basicPatches == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.basicPatches.length; ++i) {
            if (this.basicPatches[i] == 0) continue;
            ++n;
        }
        return n;
    }

    public void setHole(BloodBodyPartType bloodBodyPartType) {
        if (this.holes == null) {
            this.holes = new byte[BloodBodyPartType.MAX.index()];
        }
        this.holes[bloodBodyPartType.index()] = -1;
    }

    public float getHole(BloodBodyPartType bloodBodyPartType) {
        if (this.holes == null) {
            return 0.0f;
        }
        return (float)(this.holes[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public int getHolesNumber() {
        if (this.holes == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.holes.length; ++i) {
            if (this.holes[i] == 0) continue;
            ++n;
        }
        return n;
    }

    public void setBlood(BloodBodyPartType bloodBodyPartType, float f) {
        if (this.blood == null) {
            this.blood = new byte[BloodBodyPartType.MAX.index()];
        }
        f = Math.max(0.0f, Math.min(1.0f, f));
        this.blood[bloodBodyPartType.index()] = (byte)(f * 255.0f);
    }

    public float getBlood(BloodBodyPartType bloodBodyPartType) {
        if (this.blood == null) {
            return 0.0f;
        }
        return (float)(this.blood[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public float getDirt(BloodBodyPartType bloodBodyPartType) {
        if (this.dirt == null) {
            return 0.0f;
        }
        return (float)(this.dirt[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public void setDirt(BloodBodyPartType bloodBodyPartType, float f) {
        if (this.dirt == null) {
            this.dirt = new byte[BloodBodyPartType.MAX.index()];
        }
        f = Math.max(0.0f, Math.min(1.0f, f));
        this.dirt[bloodBodyPartType.index()] = (byte)(f * 255.0f);
    }

    public void copyBlood(ItemVisual itemVisual) {
        if (itemVisual.blood != null) {
            if (this.blood == null) {
                this.blood = new byte[BloodBodyPartType.MAX.index()];
            }
            System.arraycopy(itemVisual.blood, 0, this.blood, 0, this.blood.length);
        } else if (this.blood != null) {
            Arrays.fill(this.blood, (byte)0);
        }
    }

    public void copyDirt(ItemVisual itemVisual) {
        if (itemVisual.dirt != null) {
            if (this.dirt == null) {
                this.dirt = new byte[BloodBodyPartType.MAX.index()];
            }
            System.arraycopy(itemVisual.dirt, 0, this.dirt, 0, this.dirt.length);
        } else if (this.dirt != null) {
            Arrays.fill(this.dirt, (byte)0);
        }
    }

    public void copyHoles(ItemVisual itemVisual) {
        if (itemVisual.holes != null) {
            if (this.holes == null) {
                this.holes = new byte[BloodBodyPartType.MAX.index()];
            }
            System.arraycopy(itemVisual.holes, 0, this.holes, 0, this.holes.length);
        } else if (this.holes != null) {
            Arrays.fill(this.holes, (byte)0);
        }
    }

    public void copyPatches(ItemVisual itemVisual) {
        if (itemVisual.basicPatches != null) {
            if (this.basicPatches == null) {
                this.basicPatches = new byte[BloodBodyPartType.MAX.index()];
            }
            System.arraycopy(itemVisual.basicPatches, 0, this.basicPatches, 0, this.basicPatches.length);
        } else if (this.basicPatches != null) {
            Arrays.fill(this.basicPatches, (byte)0);
        }
        if (itemVisual.denimPatches != null) {
            if (this.denimPatches == null) {
                this.denimPatches = new byte[BloodBodyPartType.MAX.index()];
            }
            System.arraycopy(itemVisual.denimPatches, 0, this.denimPatches, 0, this.denimPatches.length);
        } else if (this.denimPatches != null) {
            Arrays.fill(this.denimPatches, (byte)0);
        }
        if (itemVisual.leatherPatches != null) {
            if (this.leatherPatches == null) {
                this.leatherPatches = new byte[BloodBodyPartType.MAX.index()];
            }
            System.arraycopy(itemVisual.leatherPatches, 0, this.leatherPatches, 0, this.leatherPatches.length);
        } else if (this.leatherPatches != null) {
            Arrays.fill(this.leatherPatches, (byte)0);
        }
    }

    public void removeHole(int n) {
        if (this.holes != null) {
            this.holes[n] = 0;
        }
    }

    public void removePatch(int n) {
        if (this.basicPatches != null) {
            this.basicPatches[n] = 0;
        }
        if (this.denimPatches != null) {
            this.denimPatches[n] = 0;
        }
        if (this.leatherPatches != null) {
            this.leatherPatches[n] = 0;
        }
    }

    public void removeBlood() {
        if (this.blood != null) {
            Arrays.fill(this.blood, (byte)0);
        }
    }

    public void removeDirt() {
        if (this.dirt != null) {
            Arrays.fill(this.dirt, (byte)0);
        }
    }

    public float getTotalBlood() {
        float f = 0.0f;
        if (this.blood != null) {
            for (int i = 0; i < this.blood.length; ++i) {
                f += (float)(this.blood[i] & 0xFF) / 255.0f;
            }
        }
        return f;
    }

    public InventoryItem getInventoryItem() {
        return this.inventoryItem;
    }

    public void setInventoryItem(InventoryItem inventoryItem) {
        this.inventoryItem = inventoryItem;
    }

    public void setBaseTexture(int n) {
        this.m_BaseTexture = n;
    }

    public int getBaseTexture() {
        return this.m_BaseTexture;
    }

    public void setTextureChoice(int n) {
        this.m_TextureChoice = n;
    }

    public int getTextureChoice() {
        return this.m_TextureChoice;
    }

    private static StringBuilder toString(ImmutableColor immutableColor, StringBuilder stringBuilder) {
        stringBuilder.append(immutableColor.getRedByte() & 0xFF);
        stringBuilder.append(",");
        stringBuilder.append(immutableColor.getGreenByte() & 0xFF);
        stringBuilder.append(",");
        stringBuilder.append(immutableColor.getBlueByte() & 0xFF);
        return stringBuilder;
    }

    private static ImmutableColor colorFromString(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length == 3) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                return new ImmutableColor((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getLastStandString() {
        String string;
        float f;
        int n;
        Item item = this.getScriptItem();
        if (item == null) {
            return null;
        }
        ClothingItem clothingItem = this.getClothingItem();
        if (clothingItem == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("version=");
        stringBuilder.append(1);
        stringBuilder.append(";");
        stringBuilder.append("type=");
        stringBuilder.append(this.inventoryItem.getFullType());
        stringBuilder.append(";");
        ImmutableColor immutableColor = this.getTint(clothingItem);
        stringBuilder.append("tint=");
        ItemVisual.toString(immutableColor, stringBuilder);
        stringBuilder.append(";");
        int n2 = this.getBaseTexture();
        if (n2 != -1) {
            stringBuilder.append("baseTexture=");
            stringBuilder.append(n2);
            stringBuilder.append(";");
        }
        if ((n = this.getTextureChoice()) != -1) {
            stringBuilder.append("textureChoice=");
            stringBuilder.append(n);
            stringBuilder.append(";");
        }
        if ((f = this.getHue(clothingItem)) != 0.0f) {
            stringBuilder.append("hue=");
            stringBuilder.append(f);
            stringBuilder.append(";");
        }
        if (!StringUtils.isNullOrWhitespace(string = this.getDecal(clothingItem))) {
            stringBuilder.append("decal=");
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public static InventoryItem createLastStandItem(String string) {
        if (StringUtils.isNullOrWhitespace(string = string.trim()) || !string.startsWith("version=")) {
            return null;
        }
        InventoryItem inventoryItem = null;
        ItemVisual itemVisual = null;
        int n = -1;
        String[] stringArray = string.split(";");
        if (stringArray.length < 2 || !stringArray[1].trim().startsWith("type=")) {
            return null;
        }
        block24: for (int i = 0; i < stringArray.length; ++i) {
            int n2 = stringArray[i].indexOf(61);
            if (n2 == -1) continue;
            String string2 = stringArray[i].substring(0, n2).trim();
            String string3 = stringArray[i].substring(n2 + 1).trim();
            switch (string2) {
                case "version": {
                    n = Integer.parseInt(string3);
                    if (n >= 1 && n <= 1) continue block24;
                    return null;
                }
                case "baseTexture": {
                    try {
                        itemVisual.setBaseTexture(Integer.parseInt(string3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block24;
                }
                case "decal": {
                    if (StringUtils.isNullOrWhitespace(string3)) continue block24;
                    itemVisual.setDecal(string3);
                    continue block24;
                }
                case "hue": {
                    try {
                        itemVisual.setHue(Float.parseFloat(string3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block24;
                }
                case "textureChoice": {
                    try {
                        itemVisual.setTextureChoice(Integer.parseInt(string3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block24;
                }
                case "tint": {
                    ImmutableColor immutableColor = ItemVisual.colorFromString(string3);
                    if (immutableColor == null) continue block24;
                    itemVisual.setTint(immutableColor);
                    continue block24;
                }
                case "type": {
                    inventoryItem = InventoryItemFactory.CreateItem(string3);
                    if (inventoryItem == null) {
                        return null;
                    }
                    itemVisual = inventoryItem.getVisual();
                    if (itemVisual != null) continue block24;
                    return null;
                }
            }
        }
        return inventoryItem;
    }
}

