/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.visual;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import zombie.GameWindow;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.HairOutfitDefinitions;
import zombie.characters.SurvivorDesc;
import zombie.characters.WornItems.BodyLocation;
import zombie.characters.WornItems.BodyLocationGroup;
import zombie.characters.WornItems.BodyLocations;
import zombie.core.ImmutableColor;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.CharacterMask;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemReference;
import zombie.core.skinnedmodel.population.DefaultClothing;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.population.PopTemplateManager;
import zombie.core.skinnedmodel.visual.BaseVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoWorld;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.ModelScript;
import zombie.util.StringUtils;
import zombie.util.Type;

public final class HumanVisual
extends BaseVisual {
    private final IHumanVisual owner;
    private ImmutableColor skinColor = ImmutableColor.white;
    private int skinTexture = -1;
    private String skinTextureName = null;
    public int zombieRotStage = -1;
    private ImmutableColor hairColor;
    private ImmutableColor beardColor;
    private ImmutableColor naturalHairColor;
    private ImmutableColor naturalBeardColor;
    private String hairModel;
    private String beardModel;
    private int bodyHair = -1;
    private final byte[] blood = new byte[BloodBodyPartType.MAX.index()];
    private final byte[] dirt = new byte[BloodBodyPartType.MAX.index()];
    private final byte[] holes = new byte[BloodBodyPartType.MAX.index()];
    private final ItemVisuals bodyVisuals = new ItemVisuals();
    private Outfit outfit = null;
    private String nonAttachedHair = null;
    private Model forceModel = null;
    private String forceModelScript = null;
    private static final ArrayList<String> itemVisualLocations = new ArrayList();
    private static final int LASTSTAND_VERSION1 = 1;
    private static final int LASTSTAND_VERSION = 1;

    public HumanVisual(IHumanVisual iHumanVisual) {
        this.owner = iHumanVisual;
        Arrays.fill(this.blood, (byte)0);
        Arrays.fill(this.dirt, (byte)0);
        Arrays.fill(this.holes, (byte)0);
    }

    public boolean isFemale() {
        return this.owner.isFemale();
    }

    public boolean isZombie() {
        return this.owner.isZombie();
    }

    public boolean isSkeleton() {
        return this.owner.isSkeleton();
    }

    public void setSkinColor(ImmutableColor immutableColor) {
        this.skinColor = immutableColor;
    }

    public ImmutableColor getSkinColor() {
        if (this.skinColor == null) {
            this.skinColor = new ImmutableColor(SurvivorDesc.getRandomSkinColor());
        }
        return this.skinColor;
    }

    public void setBodyHairIndex(int n) {
        this.bodyHair = n;
    }

    public int getBodyHairIndex() {
        return this.bodyHair;
    }

    public void setSkinTextureIndex(int n) {
        this.skinTexture = n;
    }

    public int getSkinTextureIndex() {
        return this.skinTexture;
    }

    public void setSkinTextureName(String string) {
        this.skinTextureName = string;
    }

    public float lerp(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 >= 1.0f) {
            f3 = 1.0f;
        }
        float f4 = f2 - f;
        float f5 = f4 * f3;
        return f + f5;
    }

    public int pickRandomZombieRotStage() {
        int n = Math.max((int)IsoWorld.instance.getWorldAgeDays(), 0);
        float f = 20.0f;
        float f2 = 90.0f;
        float f3 = 100.0f;
        float f4 = 20.0f;
        float f5 = 10.0f;
        float f6 = 30.0f;
        if (n >= 180) {
            f4 = 0.0f;
            f6 = 10.0f;
        }
        float f7 = (float)n - f;
        float f8 = f7 / (f2 - f);
        float f9 = this.lerp(f3, f4, f8);
        float f10 = this.lerp(f5, f6, f8);
        float f11 = OutfitRNG.Next(100);
        if (f11 < f9) {
            return 1;
        }
        if (f11 < f10 + f9) {
            return 2;
        }
        return 3;
    }

    public String getSkinTexture() {
        ArrayList<String> arrayList;
        if (this.skinTextureName != null) {
            return this.skinTextureName;
        }
        String string = "";
        ArrayList<String> arrayList2 = arrayList = this.owner.isFemale() ? PopTemplateManager.instance.m_FemaleSkins : PopTemplateManager.instance.m_MaleSkins;
        if (this.owner.isZombie() && this.owner.isSkeleton()) {
            arrayList = this.owner.isFemale() ? PopTemplateManager.instance.m_SkeletonFemaleSkins_Zombie : PopTemplateManager.instance.m_SkeletonMaleSkins_Zombie;
        } else if (this.owner.isZombie()) {
            if (this.zombieRotStage < 1 || this.zombieRotStage > 3) {
                this.zombieRotStage = this.pickRandomZombieRotStage();
            }
            switch (this.zombieRotStage) {
                case 1: {
                    arrayList = this.owner.isFemale() ? PopTemplateManager.instance.m_FemaleSkins_Zombie1 : PopTemplateManager.instance.m_MaleSkins_Zombie1;
                    break;
                }
                case 2: {
                    arrayList = this.owner.isFemale() ? PopTemplateManager.instance.m_FemaleSkins_Zombie2 : PopTemplateManager.instance.m_MaleSkins_Zombie2;
                    break;
                }
                case 3: {
                    arrayList = this.owner.isFemale() ? PopTemplateManager.instance.m_FemaleSkins_Zombie3 : PopTemplateManager.instance.m_MaleSkins_Zombie3;
                }
            }
        } else if (!this.owner.isFemale()) {
            String string2 = string = !this.owner.isZombie() && this.bodyHair >= 0 ? "a" : "";
        }
        if (this.skinTexture == arrayList.size()) {
            --this.skinTexture;
        } else if (this.skinTexture < 0 || this.skinTexture > arrayList.size()) {
            this.skinTexture = OutfitRNG.Next(arrayList.size());
        }
        return arrayList.get(this.skinTexture) + string;
    }

    public void setHairColor(ImmutableColor immutableColor) {
        this.hairColor = immutableColor;
    }

    public ImmutableColor getHairColor() {
        if (this.hairColor == null) {
            this.hairColor = HairOutfitDefinitions.instance.getRandomHaircutColor(this.outfit != null ? this.outfit.m_Name : null);
        }
        return this.hairColor;
    }

    public void setBeardColor(ImmutableColor immutableColor) {
        this.beardColor = immutableColor;
    }

    public ImmutableColor getBeardColor() {
        if (this.beardColor == null) {
            this.beardColor = this.getHairColor();
        }
        return this.beardColor;
    }

    public void setNaturalHairColor(ImmutableColor immutableColor) {
        this.naturalHairColor = immutableColor;
    }

    public ImmutableColor getNaturalHairColor() {
        if (this.naturalHairColor == null) {
            this.naturalHairColor = this.getHairColor();
        }
        return this.naturalHairColor;
    }

    public void setNaturalBeardColor(ImmutableColor immutableColor) {
        this.naturalBeardColor = immutableColor;
    }

    public ImmutableColor getNaturalBeardColor() {
        if (this.naturalBeardColor == null) {
            this.naturalBeardColor = this.getNaturalHairColor();
        }
        return this.naturalBeardColor;
    }

    public void setHairModel(String string) {
        this.hairModel = string;
    }

    public String getHairModel() {
        if (this.owner.isFemale()) {
            if (HairStyles.instance.FindFemaleStyle(this.hairModel) == null) {
                this.hairModel = HairStyles.instance.getRandomFemaleStyle(this.outfit != null ? this.outfit.m_Name : null);
            }
        } else if (HairStyles.instance.FindMaleStyle(this.hairModel) == null) {
            this.hairModel = HairStyles.instance.getRandomMaleStyle(this.outfit != null ? this.outfit.m_Name : null);
        }
        return this.hairModel;
    }

    public void setBeardModel(String string) {
        this.beardModel = string;
    }

    public String getBeardModel() {
        if (this.owner.isFemale()) {
            this.beardModel = null;
        } else if (BeardStyles.instance.FindStyle(this.beardModel) == null) {
            this.beardModel = BeardStyles.instance.getRandomStyle(this.outfit != null ? this.outfit.m_Name : null);
        }
        return this.beardModel;
    }

    public void setBlood(BloodBodyPartType bloodBodyPartType, float f) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        this.blood[bloodBodyPartType.index()] = (byte)(f * 255.0f);
    }

    public float getBlood(BloodBodyPartType bloodBodyPartType) {
        return (float)(this.blood[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public void setDirt(BloodBodyPartType bloodBodyPartType, float f) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        this.dirt[bloodBodyPartType.index()] = (byte)(f * 255.0f);
    }

    public float getDirt(BloodBodyPartType bloodBodyPartType) {
        return (float)(this.dirt[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public void setHole(BloodBodyPartType bloodBodyPartType) {
        this.holes[bloodBodyPartType.index()] = -1;
    }

    public float getHole(BloodBodyPartType bloodBodyPartType) {
        return (float)(this.holes[bloodBodyPartType.index()] & 0xFF) / 255.0f;
    }

    public void removeBlood() {
        Arrays.fill(this.blood, (byte)0);
    }

    public void removeDirt() {
        Arrays.fill(this.dirt, (byte)0);
    }

    public void randomBlood() {
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            this.setBlood(BloodBodyPartType.FromIndex(i), OutfitRNG.Next(0.0f, 1.0f));
        }
    }

    public void randomDirt() {
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            this.setDirt(BloodBodyPartType.FromIndex(i), OutfitRNG.Next(0.0f, 1.0f));
        }
    }

    public float getTotalBlood() {
        float f = 0.0f;
        for (int i = 0; i < this.blood.length; ++i) {
            f += (float)(this.blood[i] & 0xFF) / 255.0f;
        }
        return f;
    }

    @Override
    public void clear() {
        this.skinColor = ImmutableColor.white;
        this.skinTexture = -1;
        this.skinTextureName = null;
        this.zombieRotStage = -1;
        this.hairColor = null;
        this.beardColor = null;
        this.naturalHairColor = null;
        this.naturalBeardColor = null;
        this.hairModel = null;
        this.nonAttachedHair = null;
        this.beardModel = null;
        this.bodyHair = -1;
        Arrays.fill(this.blood, (byte)0);
        Arrays.fill(this.dirt, (byte)0);
        Arrays.fill(this.holes, (byte)0);
        this.bodyVisuals.clear();
        this.forceModel = null;
        this.forceModelScript = null;
    }

    @Override
    public void copyFrom(BaseVisual baseVisual) {
        if (baseVisual == null) {
            this.clear();
            return;
        }
        HumanVisual humanVisual = Type.tryCastTo(baseVisual, HumanVisual.class);
        if (humanVisual == null) {
            throw new IllegalArgumentException("expected HumanVisual, got " + baseVisual);
        }
        humanVisual.getHairColor();
        humanVisual.getNaturalHairColor();
        humanVisual.getNaturalBeardColor();
        humanVisual.getHairModel();
        humanVisual.getBeardModel();
        humanVisual.getSkinTexture();
        this.skinColor = humanVisual.skinColor;
        this.skinTexture = humanVisual.skinTexture;
        this.skinTextureName = humanVisual.skinTextureName;
        this.zombieRotStage = humanVisual.zombieRotStage;
        this.hairColor = humanVisual.hairColor;
        this.beardColor = humanVisual.beardColor;
        this.naturalHairColor = humanVisual.naturalHairColor;
        this.naturalBeardColor = humanVisual.naturalBeardColor;
        this.hairModel = humanVisual.hairModel;
        this.nonAttachedHair = humanVisual.nonAttachedHair;
        this.beardModel = humanVisual.beardModel;
        this.bodyHair = humanVisual.bodyHair;
        this.outfit = humanVisual.outfit;
        System.arraycopy(humanVisual.blood, 0, this.blood, 0, this.blood.length);
        System.arraycopy(humanVisual.dirt, 0, this.dirt, 0, this.dirt.length);
        System.arraycopy(humanVisual.holes, 0, this.holes, 0, this.holes.length);
        this.bodyVisuals.clear();
        this.bodyVisuals.addAll(humanVisual.bodyVisuals);
        this.forceModel = humanVisual.forceModel;
        this.forceModelScript = humanVisual.forceModelScript;
    }

    @Override
    public void save(ByteBuffer byteBuffer) throws IOException {
        byte by;
        byte by2 = 0;
        if (this.hairColor != null) {
            by2 = (byte)(by2 | 4);
        }
        if (this.beardColor != null) {
            by2 = (byte)(by2 | 2);
        }
        if (this.skinColor != null) {
            by2 = (byte)(by2 | 8);
        }
        if (this.beardModel != null) {
            by2 = (byte)(by2 | 0x10);
        }
        if (this.hairModel != null) {
            by2 = (byte)(by2 | 0x20);
        }
        if (this.skinTextureName != null) {
            by2 = (byte)(by2 | 0x40);
        }
        byteBuffer.put(by2);
        if (this.hairColor != null) {
            byteBuffer.put(this.hairColor.getRedByte());
            byteBuffer.put(this.hairColor.getGreenByte());
            byteBuffer.put(this.hairColor.getBlueByte());
        }
        if (this.beardColor != null) {
            byteBuffer.put(this.beardColor.getRedByte());
            byteBuffer.put(this.beardColor.getGreenByte());
            byteBuffer.put(this.beardColor.getBlueByte());
        }
        if (this.skinColor != null) {
            byteBuffer.put(this.skinColor.getRedByte());
            byteBuffer.put(this.skinColor.getGreenByte());
            byteBuffer.put(this.skinColor.getBlueByte());
        }
        byteBuffer.put((byte)this.bodyHair);
        byteBuffer.put((byte)this.skinTexture);
        byteBuffer.put((byte)this.zombieRotStage);
        if (this.skinTextureName != null) {
            GameWindow.WriteString(byteBuffer, this.skinTextureName);
        }
        if (this.beardModel != null) {
            GameWindow.WriteString(byteBuffer, this.beardModel);
        }
        if (this.hairModel != null) {
            GameWindow.WriteString(byteBuffer, this.hairModel);
        }
        byteBuffer.put((byte)this.blood.length);
        for (by = 0; by < this.blood.length; ++by) {
            byteBuffer.put(this.blood[by]);
        }
        byteBuffer.put((byte)this.dirt.length);
        for (by = 0; by < this.dirt.length; ++by) {
            byteBuffer.put(this.dirt[by]);
        }
        byteBuffer.put((byte)this.holes.length);
        for (by = 0; by < this.holes.length; ++by) {
            byteBuffer.put(this.holes[by]);
        }
        byteBuffer.put((byte)this.bodyVisuals.size());
        for (by = 0; by < this.bodyVisuals.size(); ++by) {
            ItemVisual itemVisual = (ItemVisual)this.bodyVisuals.get(by);
            itemVisual.save(byteBuffer);
        }
        GameWindow.WriteString(byteBuffer, this.getNonAttachedHair());
        by = 0;
        if (this.naturalHairColor != null) {
            by = (byte)(by | 4);
        }
        if (this.naturalBeardColor != null) {
            by = (byte)(by | 2);
        }
        byteBuffer.put(by);
        if (this.naturalHairColor != null) {
            byteBuffer.put(this.naturalHairColor.getRedByte());
            byteBuffer.put(this.naturalHairColor.getGreenByte());
            byteBuffer.put(this.naturalHairColor.getBlueByte());
        }
        if (this.naturalBeardColor != null) {
            byteBuffer.put(this.naturalBeardColor.getRedByte());
            byteBuffer.put(this.naturalBeardColor.getGreenByte());
            byteBuffer.put(this.naturalBeardColor.getBlueByte());
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        this.clear();
        int n5 = byteBuffer.get() & 0xFF;
        if ((n5 & 4) != 0) {
            n4 = byteBuffer.get() & 0xFF;
            n3 = byteBuffer.get() & 0xFF;
            n2 = byteBuffer.get() & 0xFF;
            this.hairColor = new ImmutableColor(n4, n3, n2);
        }
        if ((n5 & 2) != 0) {
            n4 = byteBuffer.get() & 0xFF;
            n3 = byteBuffer.get() & 0xFF;
            n2 = byteBuffer.get() & 0xFF;
            this.beardColor = new ImmutableColor(n4, n3, n2);
        }
        if ((n5 & 8) != 0) {
            n4 = byteBuffer.get() & 0xFF;
            n3 = byteBuffer.get() & 0xFF;
            n2 = byteBuffer.get() & 0xFF;
            this.skinColor = new ImmutableColor(n4, n3, n2);
        }
        this.bodyHair = byteBuffer.get();
        this.skinTexture = byteBuffer.get();
        if (n >= 156) {
            this.zombieRotStage = byteBuffer.get();
        }
        if ((n5 & 0x40) != 0) {
            this.skinTextureName = GameWindow.ReadString(byteBuffer);
        }
        if ((n5 & 0x10) != 0) {
            this.beardModel = GameWindow.ReadString(byteBuffer);
        }
        if ((n5 & 0x20) != 0) {
            this.hairModel = GameWindow.ReadString(byteBuffer);
        }
        n4 = byteBuffer.get();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = byteBuffer.get();
            if (n3 >= this.blood.length) continue;
            this.blood[n3] = n2;
        }
        if (n >= 163) {
            n4 = byteBuffer.get();
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = byteBuffer.get();
                if (n3 >= this.dirt.length) continue;
                this.dirt[n3] = n2;
            }
        }
        n4 = byteBuffer.get();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = byteBuffer.get();
            if (n3 >= this.holes.length) continue;
            this.holes[n3] = n2;
        }
        n4 = byteBuffer.get();
        for (n3 = 0; n3 < n4; ++n3) {
            ItemVisual itemVisual = new ItemVisual();
            itemVisual.load(byteBuffer, n);
            this.bodyVisuals.add(itemVisual);
        }
        this.setNonAttachedHair(GameWindow.ReadString(byteBuffer));
        if (n >= 187) {
            int n6;
            int n7;
            n3 = byteBuffer.get() & 0xFF;
            if ((n3 & 4) != 0) {
                n2 = byteBuffer.get() & 0xFF;
                n7 = byteBuffer.get() & 0xFF;
                n6 = byteBuffer.get() & 0xFF;
                this.naturalHairColor = new ImmutableColor(n2, n7, n6);
            }
            if ((n3 & 2) != 0) {
                n2 = byteBuffer.get() & 0xFF;
                n7 = byteBuffer.get() & 0xFF;
                n6 = byteBuffer.get() & 0xFF;
                this.naturalBeardColor = new ImmutableColor(n2, n7, n6);
            }
        }
    }

    @Override
    public Model getModel() {
        if (this.forceModel != null) {
            return this.forceModel;
        }
        if (this.isSkeleton()) {
            return this.isFemale() ? ModelManager.instance.m_skeletonFemaleModel : ModelManager.instance.m_skeletonMaleModel;
        }
        return this.isFemale() ? ModelManager.instance.m_femaleModel : ModelManager.instance.m_maleModel;
    }

    @Override
    public ModelScript getModelScript() {
        if (this.forceModelScript != null) {
            return ScriptManager.instance.getModelScript(this.forceModelScript);
        }
        return ScriptManager.instance.getModelScript(this.isFemale() ? "FemaleBody" : "MaleBody");
    }

    public static CharacterMask GetMask(ItemVisuals itemVisuals) {
        CharacterMask characterMask = new CharacterMask();
        for (int i = itemVisuals.size() - 1; i >= 0; --i) {
            ((ItemVisual)itemVisuals.get(i)).getClothingItemCombinedMask(characterMask);
        }
        return characterMask;
    }

    public void synchWithOutfit(Outfit outfit) {
        if (outfit == null) {
            return;
        }
        this.beardColor = this.hairColor = outfit.RandomData.m_hairColor;
        this.hairModel = this.owner.isFemale() ? outfit.RandomData.m_femaleHairName : outfit.RandomData.m_maleHairName;
        this.beardModel = this.owner.isFemale() ? null : outfit.RandomData.m_beardName;
        this.getSkinTexture();
    }

    @Override
    public void dressInNamedOutfit(String string, ItemVisuals itemVisuals) {
        Outfit outfit;
        itemVisuals.clear();
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        Outfit outfit2 = outfit = this.owner.isFemale() ? OutfitManager.instance.FindFemaleOutfit(string) : OutfitManager.instance.FindMaleOutfit(string);
        if (outfit == null) {
            return;
        }
        Outfit outfit3 = outfit.clone();
        outfit3.Randomize();
        this.dressInOutfit(outfit3, itemVisuals);
    }

    public void dressInClothingItem(String string, ItemVisuals itemVisuals) {
        this.dressInClothingItem(string, itemVisuals, true);
    }

    public void dressInClothingItem(String string, ItemVisuals itemVisuals, boolean bl) {
        ClothingItem clothingItem;
        if (bl) {
            this.clear();
            itemVisuals.clear();
        }
        if ((clothingItem = OutfitManager.instance.getClothingItem(string)) == null) {
            return;
        }
        Outfit outfit = new Outfit();
        ClothingItemReference clothingItemReference = new ClothingItemReference();
        clothingItemReference.itemGUID = string;
        outfit.m_items.add(clothingItemReference);
        outfit.m_Pants = false;
        outfit.m_Top = false;
        outfit.Randomize();
        this.dressInOutfit(outfit, itemVisuals);
    }

    private void dressInOutfit(Outfit outfit, ItemVisuals itemVisuals) {
        String string;
        this.setOutfit(outfit);
        this.getItemVisualLocations(itemVisuals, itemVisualLocations);
        if (outfit.m_Pants) {
            string = outfit.m_AllowPantsHue ? DefaultClothing.instance.pickPantsHue() : (outfit.m_AllowPantsTint ? DefaultClothing.instance.pickPantsTint() : DefaultClothing.instance.pickPantsTexture());
            this.addClothingItem(itemVisuals, itemVisualLocations, string, null);
        }
        if (outfit.m_Top && outfit.RandomData.m_hasTop) {
            string = outfit.RandomData.m_hasTShirt ? (outfit.RandomData.m_hasTShirtDecal && outfit.GetMask().isTorsoVisible() && outfit.m_AllowTShirtDecal ? (outfit.m_AllowTopTint ? DefaultClothing.instance.pickTShirtDecalTint() : DefaultClothing.instance.pickTShirtDecalTexture()) : (outfit.m_AllowTopTint ? DefaultClothing.instance.pickTShirtTint() : DefaultClothing.instance.pickTShirtTexture())) : (outfit.m_AllowTopTint ? DefaultClothing.instance.pickVestTint() : DefaultClothing.instance.pickVestTexture());
            this.addClothingItem(itemVisuals, itemVisualLocations, string, null);
        }
        for (int i = 0; i < outfit.m_items.size(); ++i) {
            ClothingItemReference clothingItemReference = outfit.m_items.get(i);
            ClothingItem clothingItem = clothingItemReference.getClothingItem();
            if (clothingItem == null || !clothingItem.isReady()) continue;
            this.addClothingItem(itemVisuals, itemVisualLocations, clothingItem.m_Name, clothingItemReference);
        }
        outfit.m_Pants = false;
        outfit.m_Top = false;
        outfit.RandomData.m_topTexture = null;
        outfit.RandomData.m_pantsTexture = null;
    }

    public ItemVisuals getBodyVisuals() {
        return this.bodyVisuals;
    }

    public ItemVisual addBodyVisual(String string) {
        return this.addBodyVisualFromClothingItemName(string);
    }

    public ItemVisual addBodyVisualFromItemType(String string) {
        Item item = ScriptManager.instance.getItem(string);
        if (item == null || StringUtils.isNullOrWhitespace(item.getClothingItem())) {
            return null;
        }
        return this.addBodyVisualFromClothingItemName(item.getClothingItem());
    }

    public ItemVisual addBodyVisualFromClothingItemName(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        Item item = ScriptManager.instance.getItemForClothingItem(string);
        if (item == null) {
            return null;
        }
        ClothingItem clothingItem = item.getClothingItemAsset();
        if (clothingItem == null) {
            return null;
        }
        for (int i = 0; i < this.bodyVisuals.size(); ++i) {
            if (!((ItemVisual)this.bodyVisuals.get(i)).getClothingItemName().equals(string)) continue;
            return null;
        }
        ClothingItemReference clothingItemReference = new ClothingItemReference();
        clothingItemReference.itemGUID = clothingItem.m_GUID;
        clothingItemReference.randomize();
        ItemVisual itemVisual = new ItemVisual();
        itemVisual.setItemType(item.getFullName());
        itemVisual.synchWithOutfit(clothingItemReference);
        this.bodyVisuals.add(itemVisual);
        return itemVisual;
    }

    public ItemVisual removeBodyVisualFromItemType(String string) {
        for (int i = 0; i < this.bodyVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)this.bodyVisuals.get(i);
            if (!itemVisual.getItemType().equals(string)) continue;
            this.bodyVisuals.remove(i);
            return itemVisual;
        }
        return null;
    }

    public boolean hasBodyVisualFromItemType(String string) {
        for (int i = 0; i < this.bodyVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)this.bodyVisuals.get(i);
            if (!itemVisual.getItemType().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void getItemVisualLocations(ItemVisuals itemVisuals, ArrayList<String> arrayList) {
        arrayList.clear();
        for (int i = 0; i < itemVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)itemVisuals.get(i);
            Item item = itemVisual.getScriptItem();
            if (item == null) {
                arrayList.add(null);
                continue;
            }
            String string = item.getBodyLocation();
            if (StringUtils.isNullOrWhitespace(string)) {
                string = item.CanBeEquipped;
            }
            arrayList.add(string);
        }
    }

    public ItemVisual addClothingItem(ItemVisuals itemVisuals, Item item) {
        if (item == null) {
            return null;
        }
        ClothingItem clothingItem = item.getClothingItemAsset();
        if (clothingItem == null) {
            return null;
        }
        if (!clothingItem.isReady()) {
            return null;
        }
        this.getItemVisualLocations(itemVisuals, itemVisualLocations);
        return this.addClothingItem(itemVisuals, itemVisualLocations, clothingItem.m_Name, null);
    }

    private ItemVisual addClothingItem(ItemVisuals itemVisuals, ArrayList<String> arrayList, String string, ClothingItemReference clothingItemReference) {
        int n;
        assert (itemVisuals.size() == arrayList.size());
        if (clothingItemReference != null && !clothingItemReference.RandomData.m_Active) {
            return null;
        }
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        Item item = ScriptManager.instance.getItemForClothingItem(string);
        if (item == null) {
            if (DebugLog.isEnabled(DebugType.Clothing)) {
                DebugLog.Clothing.warn("Could not find item type for %s", string);
            }
            return null;
        }
        ClothingItem clothingItem = item.getClothingItemAsset();
        if (clothingItem == null) {
            return null;
        }
        if (!clothingItem.isReady()) {
            return null;
        }
        String string2 = item.getBodyLocation();
        if (StringUtils.isNullOrWhitespace(string2)) {
            string2 = item.CanBeEquipped;
        }
        if (StringUtils.isNullOrWhitespace(string2)) {
            return null;
        }
        if (clothingItemReference == null) {
            clothingItemReference = new ClothingItemReference();
            clothingItemReference.itemGUID = clothingItem.m_GUID;
            clothingItemReference.randomize();
        }
        if (!clothingItemReference.RandomData.m_Active) {
            return null;
        }
        BodyLocationGroup bodyLocationGroup = BodyLocations.getGroup("Human");
        BodyLocation bodyLocation = bodyLocationGroup.getLocation(string2);
        if (bodyLocation == null) {
            DebugLog.General.error("The game can't found location '" + string2 + "' for the item '" + item.name + "'");
            return null;
        }
        if (!bodyLocation.isMultiItem() && (n = arrayList.indexOf(string2)) != -1) {
            itemVisuals.remove(n);
            arrayList.remove(n);
        }
        for (n = 0; n < itemVisuals.size(); ++n) {
            if (!bodyLocationGroup.isExclusive(string2, arrayList.get(n))) continue;
            itemVisuals.remove(n);
            arrayList.remove(n);
            --n;
        }
        assert (itemVisuals.size() == arrayList.size());
        n = bodyLocationGroup.indexOf(string2);
        int n2 = itemVisuals.size();
        for (int i = 0; i < itemVisuals.size(); ++i) {
            if (bodyLocationGroup.indexOf(arrayList.get(i)) <= n) continue;
            n2 = i;
            break;
        }
        ItemVisual itemVisual = new ItemVisual();
        itemVisual.setItemType(item.getFullName());
        itemVisual.synchWithOutfit(clothingItemReference);
        itemVisuals.add(n2, itemVisual);
        arrayList.add(n2, string2);
        return itemVisual;
    }

    public Outfit getOutfit() {
        return this.outfit;
    }

    public void setOutfit(Outfit outfit) {
        this.outfit = outfit;
    }

    public String getNonAttachedHair() {
        return this.nonAttachedHair;
    }

    public void setNonAttachedHair(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            string = null;
        }
        this.nonAttachedHair = string;
    }

    public void setForceModel(Model model) {
        this.forceModel = model;
    }

    public void setForceModelScript(String string) {
        this.forceModelScript = string;
    }

    private static StringBuilder toString(ImmutableColor immutableColor, StringBuilder stringBuilder) {
        stringBuilder.append(immutableColor.getRedByte() & 0xFF);
        stringBuilder.append(",");
        stringBuilder.append(immutableColor.getGreenByte() & 0xFF);
        stringBuilder.append(",");
        stringBuilder.append(immutableColor.getBlueByte() & 0xFF);
        return stringBuilder;
    }

    private static ImmutableColor colorFromString(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length == 3) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                return new ImmutableColor((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getLastStandString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("version=");
        stringBuilder.append(1);
        stringBuilder.append(";");
        if (this.getHairColor() != null) {
            stringBuilder.append("hairColor=");
            HumanVisual.toString(this.getHairColor(), stringBuilder);
            stringBuilder.append(";");
        }
        if (this.getBeardColor() != null) {
            stringBuilder.append("beardColor=");
            HumanVisual.toString(this.getBeardColor(), stringBuilder);
            stringBuilder.append(";");
        }
        if (this.getNaturalHairColor() != null) {
            stringBuilder.append("naturalHairColor=");
            HumanVisual.toString(this.getNaturalHairColor(), stringBuilder);
            stringBuilder.append(";");
        }
        if (this.getNaturalBeardColor() != null) {
            stringBuilder.append("naturalBeardColor=");
            HumanVisual.toString(this.getNaturalBeardColor(), stringBuilder);
            stringBuilder.append(";");
        }
        if (this.getSkinColor() != null) {
            stringBuilder.append("skinColor=");
            HumanVisual.toString(this.getSkinColor(), stringBuilder);
            stringBuilder.append(";");
        }
        stringBuilder.append("bodyHair=");
        stringBuilder.append(this.getBodyHairIndex());
        stringBuilder.append(";");
        stringBuilder.append("skinTexture=");
        stringBuilder.append(this.getSkinTextureIndex());
        stringBuilder.append(";");
        if (this.getSkinTexture() != null) {
            stringBuilder.append("skinTextureName=");
            stringBuilder.append(this.getSkinTexture());
            stringBuilder.append(";");
        }
        if (this.getHairModel() != null) {
            stringBuilder.append("hairModel=");
            stringBuilder.append(this.getHairModel());
            stringBuilder.append(";");
        }
        if (this.getBeardModel() != null) {
            stringBuilder.append("beardModel=");
            stringBuilder.append(this.getBeardModel());
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public boolean loadLastStandString(String string) {
        if (StringUtils.isNullOrWhitespace(string = string.trim()) || !string.startsWith("version=")) {
            return false;
        }
        int n = -1;
        String[] stringArray = string.split(";");
        block30: for (int i = 0; i < stringArray.length; ++i) {
            int n2 = stringArray[i].indexOf(61);
            if (n2 == -1) continue;
            String string2 = stringArray[i].substring(0, n2).trim();
            String string3 = stringArray[i].substring(n2 + 1).trim();
            switch (string2) {
                case "version": {
                    n = Integer.parseInt(string3);
                    if (n >= 1 && n <= 1) continue block30;
                    return false;
                }
                case "beardColor": {
                    ImmutableColor immutableColor = HumanVisual.colorFromString(string3);
                    if (immutableColor == null) continue block30;
                    this.setBeardColor(immutableColor);
                    continue block30;
                }
                case "naturalBeardColor": {
                    ImmutableColor immutableColor = HumanVisual.colorFromString(string3);
                    if (immutableColor == null) continue block30;
                    this.setNaturalBeardColor(immutableColor);
                    continue block30;
                }
                case "beardModel": {
                    this.setBeardModel(string3);
                    continue block30;
                }
                case "bodyHair": {
                    try {
                        this.setBodyHairIndex(Integer.parseInt(string3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block30;
                }
                case "hairColor": {
                    ImmutableColor immutableColor = HumanVisual.colorFromString(string3);
                    if (immutableColor == null) continue block30;
                    this.setHairColor(immutableColor);
                    continue block30;
                }
                case "naturalHairColor": {
                    ImmutableColor immutableColor = HumanVisual.colorFromString(string3);
                    if (immutableColor == null) continue block30;
                    this.setNaturalHairColor(immutableColor);
                    continue block30;
                }
                case "hairModel": {
                    this.setHairModel(string3);
                    continue block30;
                }
                case "skinColor": {
                    ImmutableColor immutableColor = HumanVisual.colorFromString(string3);
                    if (immutableColor == null) continue block30;
                    this.setSkinColor(immutableColor);
                    continue block30;
                }
                case "skinTexture": {
                    try {
                        this.setSkinTextureIndex(Integer.parseInt(string3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block30;
                }
                case "skinTextureName": {
                    this.setSkinTextureName(string3);
                }
            }
        }
        return true;
    }
}

