/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.shader;

import java.nio.FloatBuffer;
import org.joml.Math;
import org.joml.Vector4f;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjglx.BufferUtils;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.ShaderProgram;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.model.ModelSlotRenderData;
import zombie.core.textures.SmartTexture;
import zombie.core.textures.Texture;
import zombie.debug.DebugOptions;
import zombie.iso.IsoMovingObject;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.vehicles.BaseVehicle;

public final class Shader {
    private int HueChange;
    private int LightingAmount;
    private int MirrorXID;
    private int TransformMatrixID = 0;
    final String name;
    private final ShaderProgram m_shaderProgram;
    private int MatrixID = 0;
    private int Light0Direction;
    private int Light0Colour;
    private int Light1Direction;
    private int Light1Colour;
    private int Light2Direction;
    private int Light2Colour;
    private int Light3Direction;
    private int Light3Colour;
    private int Light4Direction;
    private int Light4Colour;
    private int TintColour;
    private int Texture0;
    private int TexturePainColor;
    private int TextureRust;
    private int TextureRustA;
    private int TextureMask;
    private int TextureLights;
    private int TextureDamage1Overlay;
    private int TextureDamage1Shell;
    private int TextureDamage2Overlay;
    private int TextureDamage2Shell;
    private int TextureUninstall1;
    private int TextureUninstall2;
    private int TextureLightsEnables1;
    private int TextureLightsEnables2;
    private int TextureDamage1Enables1;
    private int TextureDamage1Enables2;
    private int TextureDamage2Enables1;
    private int TextureDamage2Enables2;
    private int MatBlood1Enables1;
    private int MatBlood1Enables2;
    private int MatBlood2Enables1;
    private int MatBlood2Enables2;
    private int Alpha;
    private int TextureReflectionA;
    private int TextureReflectionB;
    private int ReflectionParam;
    public int BoneIndicesAttrib;
    public int BoneWeightsAttrib;
    private int UVScale;
    final boolean bStatic;
    private static FloatBuffer floatBuffer;
    private static final int MAX_BONES = 64;
    private static final Vector3f tempVec3f;
    private final FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(16);

    public Shader(String string, boolean bl) {
        this.name = string;
        this.m_shaderProgram = ShaderProgram.createShaderProgram(string, bl, false);
        this.m_shaderProgram.addCompileListener(this::onProgramCompiled);
        this.bStatic = bl;
        this.compile();
    }

    public boolean isStatic() {
        return this.bStatic;
    }

    public ShaderProgram getShaderProgram() {
        return this.m_shaderProgram;
    }

    private void onProgramCompiled(ShaderProgram shaderProgram) {
        this.Start();
        int n = this.m_shaderProgram.getShaderID();
        if (!this.bStatic) {
            this.MatrixID = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"MatrixPalette");
        } else {
            this.TransformMatrixID = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"transform");
        }
        this.HueChange = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"HueChange");
        this.LightingAmount = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"LightingAmount");
        this.Light0Colour = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light0Colour");
        this.Light0Direction = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light0Direction");
        this.Light1Colour = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light1Colour");
        this.Light1Direction = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light1Direction");
        this.Light2Colour = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light2Colour");
        this.Light2Direction = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light2Direction");
        this.Light3Colour = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light3Colour");
        this.Light3Direction = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light3Direction");
        this.Light4Colour = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light4Colour");
        this.Light4Direction = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light4Direction");
        this.TintColour = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TintColour");
        this.Texture0 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Texture0");
        this.TexturePainColor = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TexturePainColor");
        this.TextureRust = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureRust");
        this.TextureMask = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureMask");
        this.TextureLights = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureLights");
        this.TextureDamage1Overlay = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage1Overlay");
        this.TextureDamage1Shell = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage1Shell");
        this.TextureDamage2Overlay = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage2Overlay");
        this.TextureDamage2Shell = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage2Shell");
        this.TextureRustA = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureRustA");
        this.TextureUninstall1 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureUninstall1");
        this.TextureUninstall2 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureUninstall2");
        this.TextureLightsEnables1 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureLightsEnables1");
        this.TextureLightsEnables2 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureLightsEnables2");
        this.TextureDamage1Enables1 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage1Enables1");
        this.TextureDamage1Enables2 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage1Enables2");
        this.TextureDamage2Enables1 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage2Enables1");
        this.TextureDamage2Enables2 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureDamage2Enables2");
        this.MatBlood1Enables1 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"MatBlood1Enables1");
        this.MatBlood1Enables2 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"MatBlood1Enables2");
        this.MatBlood2Enables1 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"MatBlood2Enables1");
        this.MatBlood2Enables2 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"MatBlood2Enables2");
        this.Alpha = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Alpha");
        this.TextureReflectionA = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureReflectionA");
        this.TextureReflectionB = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureReflectionB");
        this.ReflectionParam = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"ReflectionParam");
        this.UVScale = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"UVScale");
        this.m_shaderProgram.setSamplerUnit("Texture", 0);
        if (this.Texture0 != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.Texture0, (int)0);
        }
        if (this.TextureRust != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureRust, (int)1);
        }
        if (this.TextureMask != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureMask, (int)2);
        }
        if (this.TextureLights != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureLights, (int)3);
        }
        if (this.TextureDamage1Overlay != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureDamage1Overlay, (int)4);
        }
        if (this.TextureDamage1Shell != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureDamage1Shell, (int)5);
        }
        if (this.TextureDamage2Overlay != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureDamage2Overlay, (int)6);
        }
        if (this.TextureDamage2Shell != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureDamage2Shell, (int)7);
        }
        if (this.TextureReflectionA != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureReflectionA, (int)8);
        }
        if (this.TextureReflectionB != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.TextureReflectionB, (int)9);
        }
        this.MirrorXID = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"MirrorX");
        this.BoneIndicesAttrib = GL20.glGetAttribLocation((int)n, (CharSequence)"boneIndices");
        this.BoneWeightsAttrib = GL20.glGetAttribLocation((int)n, (CharSequence)"boneWeights");
        this.End();
    }

    private void compile() {
        this.m_shaderProgram.compile();
    }

    public void setTexture(Texture texture, String string, int n) {
        this.m_shaderProgram.setValue(string, texture, n);
    }

    private void setUVScale(float f, float f2) {
        if (this.UVScale > 0) {
            this.m_shaderProgram.setVector2(this.UVScale, f, f2);
        }
    }

    public int getID() {
        return this.m_shaderProgram.getShaderID();
    }

    public void Start() {
        this.m_shaderProgram.Start();
    }

    public void End() {
        this.m_shaderProgram.End();
    }

    public void startCharacter(ModelSlotRenderData modelSlotRenderData, ModelInstanceRenderData modelInstanceRenderData) {
        Texture texture;
        if (this.bStatic) {
            this.setTransformMatrix(modelInstanceRenderData.xfrm, true);
        } else {
            this.setMatrixPalette(modelInstanceRenderData.matrixPalette);
        }
        float f = modelSlotRenderData.ambientR * 0.45f;
        float f2 = modelSlotRenderData.ambientG * 0.45f;
        float f3 = modelSlotRenderData.ambientB * 0.45f;
        this.setLights(modelSlotRenderData, 5);
        Texture texture2 = texture = modelInstanceRenderData.tex != null ? modelInstanceRenderData.tex : modelInstanceRenderData.model.tex;
        if (DebugOptions.instance.IsoSprite.CharacterMipmapColors.getValue()) {
            Texture texture3;
            Texture texture4 = texture3 = texture instanceof SmartTexture ? ((SmartTexture)texture).result : texture;
            if (texture3 != null && texture3.getTextureId() != null && texture3.getTextureId().hasMipMaps()) {
                texture = Texture.getEngineMipmapTexture();
            }
        }
        this.setTexture(texture, "Texture", 0);
        this.setDepthBias(modelInstanceRenderData.depthBias / 50.0f);
        this.setAmbient(f, f2, f3);
        this.setLightingAmount(1.0f);
        this.setHueShift(modelInstanceRenderData.hue);
        this.setTint(modelInstanceRenderData.tintR, modelInstanceRenderData.tintG, modelInstanceRenderData.tintB);
        this.setAlpha(modelSlotRenderData.alpha);
    }

    private void setLights(ModelSlotRenderData modelSlotRenderData, int n) {
        for (int i = 0; i < n; ++i) {
            ModelInstance.EffectLight effectLight = modelSlotRenderData.effectLights[i];
            if (GameServer.bServer && ServerGUI.isCreated()) {
                effectLight.b = 1.0f;
                effectLight.g = 1.0f;
                effectLight.r = 1.0f;
            }
            this.setLight(i, effectLight.x, effectLight.y, effectLight.z, effectLight.r, effectLight.g, effectLight.b, effectLight.radius, modelSlotRenderData.animPlayerAngle, modelSlotRenderData.x, modelSlotRenderData.y, modelSlotRenderData.z, modelSlotRenderData.object);
        }
    }

    public void updateAlpha(IsoGameCharacter isoGameCharacter, int n) {
        if (isoGameCharacter != null) {
            this.setAlpha(isoGameCharacter.getAlpha(n));
        }
    }

    public void setAlpha(float f) {
        ARBShaderObjects.glUniform1fARB((int)this.Alpha, (float)f);
    }

    public void updateParams() {
    }

    public void setMatrixPalette(Matrix4f[] matrix4fArray) {
        if (this.bStatic) {
            return;
        }
        if (floatBuffer == null) {
            floatBuffer = BufferUtils.createFloatBuffer(1024);
        }
        floatBuffer.clear();
        for (Matrix4f matrix4f : matrix4fArray) {
            matrix4f.store(floatBuffer);
        }
        floatBuffer.flip();
        ARBShaderObjects.glUniformMatrix4fvARB((int)this.MatrixID, (boolean)true, (FloatBuffer)floatBuffer);
    }

    public void setMatrixPalette(FloatBuffer floatBuffer) {
        this.setMatrixPalette(floatBuffer, true);
    }

    public void setMatrixPalette(FloatBuffer floatBuffer, boolean bl) {
        if (this.bStatic) {
            return;
        }
        ARBShaderObjects.glUniformMatrix4fvARB((int)this.MatrixID, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public void setMatrixPalette(org.joml.Matrix4f[] matrix4fArray) {
        if (this.bStatic) {
            return;
        }
        if (floatBuffer == null) {
            floatBuffer = BufferUtils.createFloatBuffer(1024);
        }
        floatBuffer.clear();
        for (org.joml.Matrix4f matrix4f : matrix4fArray) {
            matrix4f.get(floatBuffer);
            floatBuffer.position(floatBuffer.position() + 16);
        }
        floatBuffer.flip();
        ARBShaderObjects.glUniformMatrix4fvARB((int)this.MatrixID, (boolean)true, (FloatBuffer)floatBuffer);
    }

    public void setTint(float f, float f2, float f3) {
        ARBShaderObjects.glUniform3fARB((int)this.TintColour, (float)f, (float)f2, (float)f3);
    }

    public void setTextureRustA(float f) {
        ARBShaderObjects.glUniform1fARB((int)this.TextureRustA, (float)f);
    }

    public void setTexturePainColor(float f, float f2, float f3, float f4) {
        ARBShaderObjects.glUniform4fARB((int)this.TexturePainColor, (float)f, (float)f2, (float)f3, (float)f4);
    }

    public void setTexturePainColor(org.joml.Vector3f vector3f, float f) {
        ARBShaderObjects.glUniform4fARB((int)this.TexturePainColor, (float)vector3f.x(), (float)vector3f.y(), (float)vector3f.z(), (float)f);
    }

    public void setTexturePainColor(Vector4f vector4f) {
        ARBShaderObjects.glUniform4fARB((int)this.TexturePainColor, (float)vector4f.x(), (float)vector4f.y(), (float)vector4f.z(), (float)vector4f.w());
    }

    public void setReflectionParam(float f, float f2, float f3) {
        ARBShaderObjects.glUniform3fARB((int)this.ReflectionParam, (float)f, (float)f2, (float)f3);
    }

    public void setTextureUninstall1(float[] fArray) {
        this.setMatrix(this.TextureUninstall1, fArray);
    }

    public void setTextureUninstall2(float[] fArray) {
        this.setMatrix(this.TextureUninstall2, fArray);
    }

    public void setTextureLightsEnables1(float[] fArray) {
        this.setMatrix(this.TextureLightsEnables1, fArray);
    }

    public void setTextureLightsEnables2(float[] fArray) {
        this.setMatrix(this.TextureLightsEnables2, fArray);
    }

    public void setTextureDamage1Enables1(float[] fArray) {
        this.setMatrix(this.TextureDamage1Enables1, fArray);
    }

    public void setTextureDamage1Enables2(float[] fArray) {
        this.setMatrix(this.TextureDamage1Enables2, fArray);
    }

    public void setTextureDamage2Enables1(float[] fArray) {
        this.setMatrix(this.TextureDamage2Enables1, fArray);
    }

    public void setTextureDamage2Enables2(float[] fArray) {
        this.setMatrix(this.TextureDamage2Enables2, fArray);
    }

    public void setMatrixBlood1(float[] fArray, float[] fArray2) {
        if (this.MatBlood1Enables1 == -1 || this.MatBlood1Enables2 == -1) {
            return;
        }
        this.setMatrix(this.MatBlood1Enables1, fArray);
        this.setMatrix(this.MatBlood1Enables2, fArray2);
    }

    public void setMatrixBlood2(float[] fArray, float[] fArray2) {
        if (this.MatBlood2Enables1 == -1 || this.MatBlood2Enables2 == -1) {
            return;
        }
        this.setMatrix(this.MatBlood2Enables1, fArray);
        this.setMatrix(this.MatBlood2Enables2, fArray2);
    }

    public void setShaderAlpha(float f) {
        ARBShaderObjects.glUniform1fARB((int)this.Alpha, (float)f);
    }

    public void setLight(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, ModelInstance modelInstance) {
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        IsoMovingObject isoMovingObject = modelInstance.object;
        if (isoMovingObject != null) {
            f9 = isoMovingObject.x;
            f10 = isoMovingObject.y;
            f11 = isoMovingObject.z;
        }
        this.setLight(n, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, isoMovingObject);
    }

    public void setLight(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, IsoMovingObject isoMovingObject) {
        float f12;
        float f13;
        PZGLUtil.checkGLError(true);
        int n2 = this.Light0Direction;
        int n3 = this.Light0Colour;
        if (n == 1) {
            n2 = this.Light1Direction;
            n3 = this.Light1Colour;
        }
        if (n == 2) {
            n2 = this.Light2Direction;
            n3 = this.Light2Colour;
        }
        if (n == 3) {
            n2 = this.Light3Direction;
            n3 = this.Light3Colour;
        }
        if (n == 4) {
            n2 = this.Light4Direction;
            n3 = this.Light4Colour;
        }
        if (f4 + f5 + f6 == 0.0f || f7 <= 0.0f) {
            this.doVector3(n2, 0.0f, 1.0f, 0.0f);
            this.doVector3(n3, 0.0f, 0.0f, 0.0f);
            return;
        }
        Vector3f vector3f = tempVec3f;
        if (!Float.isNaN(f8)) {
            vector3f.set(f, f2, f3);
            vector3f.x -= f9;
            vector3f.y -= f10;
            vector3f.z -= f11;
        } else {
            vector3f.set(f, f2, f3);
        }
        float f14 = vector3f.length();
        if (f14 < 1.0E-4f) {
            vector3f.set(0.0f, 0.0f, 1.0f);
        } else {
            vector3f.normalise();
        }
        if (!Float.isNaN(f8)) {
            f13 = -f8;
            f12 = vector3f.x;
            float f15 = vector3f.y;
            vector3f.x = f12 * Math.cos(f13) - f15 * Math.sin(f13);
            vector3f.y = f12 * Math.sin(f13) + f15 * Math.cos(f13);
        }
        f13 = vector3f.y;
        vector3f.y = vector3f.z;
        vector3f.z = f13;
        if (vector3f.length() < 1.0E-4f) {
            vector3f.set(0.0f, 1.0f, 0.0f);
        }
        vector3f.normalise();
        f12 = 1.0f - f14 / f7;
        if (f12 < 0.0f) {
            f12 = 0.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        f4 *= f12;
        f5 *= f12;
        f6 *= f12;
        f4 = PZMath.clamp(f4, 0.0f, 1.0f);
        f5 = PZMath.clamp(f5, 0.0f, 1.0f);
        f6 = PZMath.clamp(f6, 0.0f, 1.0f);
        if (isoMovingObject instanceof BaseVehicle) {
            this.doVector3(n2, -vector3f.x, vector3f.y, vector3f.z);
        } else {
            this.doVector3(n2, -vector3f.x, vector3f.y, vector3f.z);
        }
        if (isoMovingObject instanceof IsoPlayer) {
            boolean bl = false;
        }
        this.doVector3(n3, f4, f5, f6);
        PZGLUtil.checkGLErrorThrow("Shader.setLightInternal.", new Object[0]);
    }

    private void doVector3(int n, float f, float f2, float f3) {
        this.m_shaderProgram.setVector3(n, f, f2, f3);
    }

    public void setHueShift(float f) {
        if (this.HueChange > 0) {
            this.m_shaderProgram.setValue("HueChange", f);
        }
    }

    public void setLightingAmount(float f) {
        if (this.LightingAmount > 0) {
            this.m_shaderProgram.setValue("LightingAmount", f);
        }
    }

    public void setDepthBias(float f) {
        this.m_shaderProgram.setValue("DepthBias", f / 300.0f);
    }

    public void setAmbient(float f) {
        this.m_shaderProgram.setVector3("AmbientColour", f, f, f);
    }

    public void setAmbient(float f, float f2, float f3) {
        this.m_shaderProgram.setVector3("AmbientColour", f, f2, f3);
    }

    public void setTransformMatrix(Matrix4f matrix4f, boolean bl) {
        if (floatBuffer == null) {
            floatBuffer = BufferUtils.createFloatBuffer(1024);
        }
        floatBuffer.clear();
        matrix4f.store(floatBuffer);
        floatBuffer.flip();
        ARBShaderObjects.glUniformMatrix4fvARB((int)this.TransformMatrixID, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public void setTransformMatrix(org.joml.Matrix4f matrix4f, boolean bl) {
        this.floatBuffer2.clear();
        matrix4f.get(this.floatBuffer2);
        this.floatBuffer2.position(16);
        this.floatBuffer2.flip();
        ARBShaderObjects.glUniformMatrix4fvARB((int)this.TransformMatrixID, (boolean)bl, (FloatBuffer)this.floatBuffer2);
    }

    public void setMatrix(int n, org.joml.Matrix4f matrix4f) {
        this.floatBuffer2.clear();
        matrix4f.get(this.floatBuffer2);
        this.floatBuffer2.position(16);
        this.floatBuffer2.flip();
        ARBShaderObjects.glUniformMatrix4fvARB((int)n, (boolean)true, (FloatBuffer)this.floatBuffer2);
    }

    public void setMatrix(int n, float[] fArray) {
        this.floatBuffer2.clear();
        this.floatBuffer2.put(fArray);
        this.floatBuffer2.flip();
        ARBShaderObjects.glUniformMatrix4fvARB((int)n, (boolean)true, (FloatBuffer)this.floatBuffer2);
    }

    public boolean isVehicleShader() {
        return this.TextureRust != -1;
    }

    static {
        tempVec3f = new Vector3f();
    }
}

