/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.runtime;

import java.util.List;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.runtime.IRuntimeAnimationCommand;
import zombie.core.skinnedmodel.runtime.KeyframeUtil;
import zombie.scripting.ScriptParser;

public final class CopyFrames
implements IRuntimeAnimationCommand {
    protected int m_frame;
    protected int m_FPS = 30;
    protected String m_source;
    protected int m_sourceFrame1;
    protected int m_sourceFrame2;
    protected int m_sourceFPS = 30;

    @Override
    public void parse(ScriptParser.Block block) {
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("source".equalsIgnoreCase(string)) {
                this.m_source = string2;
                continue;
            }
            if ("frame".equalsIgnoreCase(string)) {
                this.m_frame = PZMath.tryParseInt(string2, 1);
                continue;
            }
            if ("sourceFrame1".equalsIgnoreCase(string)) {
                this.m_sourceFrame1 = PZMath.tryParseInt(string2, 1);
                continue;
            }
            if (!"sourceFrame2".equalsIgnoreCase(string)) continue;
            this.m_sourceFrame2 = PZMath.tryParseInt(string2, 1);
        }
    }

    @Override
    public void exec(List<Keyframe> list) {
        AnimationClip animationClip = ModelManager.instance.getAnimationClip(this.m_source);
        for (int i = 0; i < 60; ++i) {
            Keyframe[] keyframeArray = animationClip.getBoneFramesAt(i);
            if (keyframeArray.length == 0) continue;
            for (int j = this.m_sourceFrame1; j <= this.m_sourceFrame2; ++j) {
                Keyframe keyframe = keyframeArray[0];
                Keyframe keyframe2 = new Keyframe();
                keyframe2.Bone = keyframe.Bone;
                keyframe2.BoneName = keyframe.BoneName;
                keyframe2.Time = (float)(this.m_frame - 1 + (j - this.m_sourceFrame1)) / (float)this.m_FPS;
                keyframe2.Position = KeyframeUtil.GetKeyFramePosition(keyframeArray, (float)(j - 1) / (float)this.m_sourceFPS, animationClip.Duration);
                keyframe2.Rotation = KeyframeUtil.GetKeyFrameRotation(keyframeArray, (float)(j - 1) / (float)this.m_sourceFPS, animationClip.Duration);
                keyframe2.Scale = keyframe.Scale;
                list.add(keyframe2);
            }
        }
    }
}

