/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.util.ArrayList;
import java.util.Locale;
import zombie.characters.IsoGameCharacter;
import zombie.characters.WornItems.BodyLocationGroup;
import zombie.core.ImmutableColor;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.CharacterMask;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.population.BeardStyle;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.HairStyle;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.ItemManager;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;

public class PopTemplateManager {
    public static final PopTemplateManager instance = new PopTemplateManager();
    public final ArrayList<String> m_MaleSkins = new ArrayList();
    public final ArrayList<String> m_FemaleSkins = new ArrayList();
    public final ArrayList<String> m_MaleSkins_Zombie1 = new ArrayList();
    public final ArrayList<String> m_FemaleSkins_Zombie1 = new ArrayList();
    public final ArrayList<String> m_MaleSkins_Zombie2 = new ArrayList();
    public final ArrayList<String> m_FemaleSkins_Zombie2 = new ArrayList();
    public final ArrayList<String> m_MaleSkins_Zombie3 = new ArrayList();
    public final ArrayList<String> m_FemaleSkins_Zombie3 = new ArrayList();
    public final ArrayList<String> m_SkeletonMaleSkins_Zombie = new ArrayList();
    public final ArrayList<String> m_SkeletonFemaleSkins_Zombie = new ArrayList();
    public static final int SKELETON_BURNED_SKIN_INDEX = 0;
    public static final int SKELETON_NORMAL_SKIN_INDEX = 1;
    public static final int SKELETON_MUSCLE_SKIN_INDEX = 2;

    public void init() {
        int n;
        ItemManager.init();
        for (n = 1; n <= 5; ++n) {
            this.m_MaleSkins.add("MaleBody0" + n);
        }
        for (n = 1; n <= 5; ++n) {
            this.m_FemaleSkins.add("FemaleBody0" + n);
        }
        for (n = 1; n <= 4; ++n) {
            this.m_MaleSkins_Zombie1.add("M_ZedBody0" + n + "_level1");
            this.m_FemaleSkins_Zombie1.add("F_ZedBody0" + n + "_level1");
            this.m_MaleSkins_Zombie2.add("M_ZedBody0" + n + "_level2");
            this.m_FemaleSkins_Zombie2.add("F_ZedBody0" + n + "_level2");
            this.m_MaleSkins_Zombie3.add("M_ZedBody0" + n + "_level3");
            this.m_FemaleSkins_Zombie3.add("F_ZedBody0" + n + "_level3");
        }
        this.m_SkeletonMaleSkins_Zombie.add("SkeletonBurned");
        this.m_SkeletonMaleSkins_Zombie.add("Skeleton");
        this.m_SkeletonMaleSkins_Zombie.add("SkeletonMuscle");
        this.m_SkeletonFemaleSkins_Zombie.add("SkeletonBurned");
        this.m_SkeletonFemaleSkins_Zombie.add("Skeleton");
        this.m_SkeletonFemaleSkins_Zombie.add("SkeletonMuscle");
    }

    public ModelInstance addClothingItem(IsoGameCharacter isoGameCharacter, ModelManager.ModelSlot modelSlot, ItemVisual itemVisual, ClothingItem clothingItem) {
        String string = clothingItem.getModel(isoGameCharacter.isFemale());
        if (StringUtils.isNullOrWhitespace(string)) {
            if (DebugLog.isEnabled(DebugType.Clothing)) {
                DebugLog.Clothing.debugln("No model specified by item: " + clothingItem.m_Name);
            }
            return null;
        }
        string = this.processModelFileName(string);
        String string2 = itemVisual.getTextureChoice(clothingItem);
        ImmutableColor immutableColor = itemVisual.getTint(clothingItem);
        float f = itemVisual.getHue(clothingItem);
        String string3 = clothingItem.m_AttachBone;
        String string4 = clothingItem.m_Shader;
        ModelInstance modelInstance = string3 != null && string3.length() > 0 ? ModelManager.instance.newStaticInstance(modelSlot, string, string2, string3, string4) : ModelManager.instance.newAdditionalModelInstance(string, string2, isoGameCharacter, modelSlot.model.AnimPlayer, string4);
        if (modelInstance == null) {
            return null;
        }
        this.postProcessNewItemInstance(modelInstance, modelSlot, immutableColor);
        modelInstance.setItemVisual(itemVisual);
        return modelInstance;
    }

    private void addHeadHairItem(IsoGameCharacter isoGameCharacter, ModelManager.ModelSlot modelSlot, String string, String string2, ImmutableColor immutableColor) {
        if (StringUtils.isNullOrWhitespace(string)) {
            if (DebugLog.isEnabled(DebugType.Clothing)) {
                DebugLog.Clothing.warn("No model specified.");
            }
            return;
        }
        ModelInstance modelInstance = ModelManager.instance.newAdditionalModelInstance(string = this.processModelFileName(string), string2, isoGameCharacter, modelSlot.model.AnimPlayer, null);
        if (modelInstance == null) {
            return;
        }
        this.postProcessNewItemInstance(modelInstance, modelSlot, immutableColor);
    }

    private void addHeadHair(IsoGameCharacter isoGameCharacter, ModelManager.ModelSlot modelSlot, HumanVisual humanVisual, ItemVisual itemVisual, boolean bl) {
        ImmutableColor immutableColor = humanVisual.getHairColor();
        if (bl) {
            immutableColor = humanVisual.getBeardColor();
        }
        if (isoGameCharacter.isFemale()) {
            if (!bl) {
                HairStyle hairStyle = HairStyles.instance.FindFemaleStyle(humanVisual.getHairModel());
                if (hairStyle != null && itemVisual != null && itemVisual.getClothingItem() != null) {
                    hairStyle = HairStyles.instance.getAlternateForHat(hairStyle, itemVisual.getClothingItem().m_HatCategory);
                }
                if (hairStyle != null && hairStyle.isValid()) {
                    if (DebugLog.isEnabled(DebugType.Clothing)) {
                        DebugLog.Clothing.debugln("  Adding female hair: " + hairStyle.name);
                    }
                    this.addHeadHairItem(isoGameCharacter, modelSlot, hairStyle.model, hairStyle.texture, immutableColor);
                }
            }
        } else if (!bl) {
            HairStyle hairStyle = HairStyles.instance.FindMaleStyle(humanVisual.getHairModel());
            if (hairStyle != null && itemVisual != null && itemVisual.getClothingItem() != null) {
                hairStyle = HairStyles.instance.getAlternateForHat(hairStyle, itemVisual.getClothingItem().m_HatCategory);
            }
            if (hairStyle != null && hairStyle.isValid()) {
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.debugln("  Adding male hair: " + hairStyle.name);
                }
                this.addHeadHairItem(isoGameCharacter, modelSlot, hairStyle.model, hairStyle.texture, immutableColor);
            }
        } else {
            BeardStyle beardStyle = BeardStyles.instance.FindStyle(humanVisual.getBeardModel());
            if (beardStyle != null && beardStyle.isValid()) {
                if (itemVisual != null && itemVisual.getClothingItem() != null && !StringUtils.isNullOrEmpty(itemVisual.getClothingItem().m_HatCategory) && itemVisual.getClothingItem().m_HatCategory.contains("nobeard")) {
                    return;
                }
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.debugln("  Adding beard: " + beardStyle.name);
                }
                this.addHeadHairItem(isoGameCharacter, modelSlot, beardStyle.model, beardStyle.texture, immutableColor);
            }
        }
    }

    public void populateCharacterModelSlot(IsoGameCharacter isoGameCharacter, ModelManager.ModelSlot modelSlot) {
        ClothingItem clothingItem;
        ItemVisual itemVisual;
        int n;
        if (!(isoGameCharacter instanceof IHumanVisual)) {
            DebugLog.Clothing.warn("Supplied character is not an IHumanVisual. Ignored. " + isoGameCharacter);
            return;
        }
        HumanVisual humanVisual = ((IHumanVisual)((Object)isoGameCharacter)).getHumanVisual();
        ItemVisuals itemVisuals = new ItemVisuals();
        isoGameCharacter.getItemVisuals(itemVisuals);
        CharacterMask characterMask = HumanVisual.GetMask(itemVisuals);
        if (DebugLog.isEnabled(DebugType.Clothing)) {
            DebugLog.Clothing.debugln("characterType:" + isoGameCharacter.getClass().getName() + ", name:" + isoGameCharacter.getName());
        }
        if (characterMask.isPartVisible(CharacterMask.Part.Head)) {
            this.addHeadHair(isoGameCharacter, modelSlot, humanVisual, itemVisuals.findHat(), false);
            this.addHeadHair(isoGameCharacter, modelSlot, humanVisual, itemVisuals.findMask(), true);
        }
        for (n = itemVisuals.size() - 1; n >= 0; --n) {
            itemVisual = (ItemVisual)itemVisuals.get(n);
            clothingItem = itemVisual.getClothingItem();
            if (clothingItem == null) {
                if (!DebugLog.isEnabled(DebugType.Clothing)) continue;
                DebugLog.Clothing.warn("ClothingItem not found for ItemVisual:" + itemVisual);
                continue;
            }
            if (this.isItemModelHidden(isoGameCharacter.getBodyLocationGroup(), itemVisuals, itemVisual)) continue;
            this.addClothingItem(isoGameCharacter, modelSlot, itemVisual, clothingItem);
        }
        for (n = humanVisual.getBodyVisuals().size() - 1; n >= 0; --n) {
            itemVisual = (ItemVisual)humanVisual.getBodyVisuals().get(n);
            clothingItem = itemVisual.getClothingItem();
            if (clothingItem == null) {
                if (!DebugLog.isEnabled(DebugType.Clothing)) continue;
                DebugLog.Clothing.warn("ClothingItem not found for ItemVisual:" + itemVisual);
                continue;
            }
            this.addClothingItem(isoGameCharacter, modelSlot, itemVisual, clothingItem);
        }
        isoGameCharacter.postUpdateModelTextures();
        isoGameCharacter.updateSpeedModifiers();
    }

    public boolean isItemModelHidden(BodyLocationGroup bodyLocationGroup, ItemVisuals itemVisuals, ItemVisual itemVisual) {
        Item item = itemVisual.getScriptItem();
        if (item == null || bodyLocationGroup.getLocation(item.getBodyLocation()) == null) {
            return false;
        }
        for (int i = 0; i < itemVisuals.size(); ++i) {
            Item item2;
            if (itemVisuals.get(i) == itemVisual || (item2 = ((ItemVisual)itemVisuals.get(i)).getScriptItem()) == null || bodyLocationGroup.getLocation(item2.getBodyLocation()) == null || !bodyLocationGroup.isHideModel(item2.getBodyLocation(), item.getBodyLocation())) continue;
            return true;
        }
        return false;
    }

    private String processModelFileName(String string) {
        string = string.replaceAll("\\\\", "/");
        string = string.toLowerCase(Locale.ENGLISH);
        return string;
    }

    private void postProcessNewItemInstance(ModelInstance modelInstance, ModelManager.ModelSlot modelSlot, ImmutableColor immutableColor) {
        modelInstance.depthBias = 0.0f;
        modelInstance.matrixModel = modelSlot.model;
        modelInstance.tintR = immutableColor.r;
        modelInstance.tintG = immutableColor.g;
        modelInstance.tintB = immutableColor.b;
        modelInstance.parent = modelSlot.model;
        modelInstance.AnimPlayer = modelSlot.model.AnimPlayer;
        modelSlot.model.sub.add(0, modelInstance);
        modelSlot.sub.add(0, modelInstance);
        modelInstance.setOwner(modelSlot);
    }
}

