/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import zombie.ZomboidFileSystem;
import zombie.characters.HairOutfitDefinitions;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.population.HairStyle;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.gameStates.ChooseGameInfo;

@XmlRootElement
public class HairStyles {
    @XmlElement(name="male")
    public final ArrayList<HairStyle> m_MaleStyles = new ArrayList();
    @XmlElement(name="female")
    public final ArrayList<HairStyle> m_FemaleStyles = new ArrayList();
    @XmlTransient
    public static HairStyles instance;

    public static void init() {
        instance = HairStyles.Parse(ZomboidFileSystem.instance.base.getAbsolutePath() + File.separator + ZomboidFileSystem.processFilePath("media/hairStyles/hairStyles.xml", File.separatorChar));
        if (instance == null) {
            return;
        }
        for (String string : ZomboidFileSystem.instance.getModIDs()) {
            int n;
            HairStyle hairStyle;
            String string2;
            HairStyles hairStyles;
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
            if (mod == null || (hairStyles = HairStyles.Parse((string2 = ZomboidFileSystem.instance.getModDir(string)) + File.separator + ZomboidFileSystem.processFilePath("media/hairStyles/hairStyles.xml", File.separatorChar))) == null) continue;
            for (HairStyle hairStyle2 : hairStyles.m_FemaleStyles) {
                hairStyle = instance.FindFemaleStyle(hairStyle2.name);
                if (hairStyle == null) {
                    HairStyles.instance.m_FemaleStyles.add(hairStyle2);
                    continue;
                }
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.println("mod \"%s\" overrides hair \"%s\"", string, hairStyle2.name);
                }
                n = HairStyles.instance.m_FemaleStyles.indexOf(hairStyle);
                HairStyles.instance.m_FemaleStyles.set(n, hairStyle2);
            }
            for (HairStyle hairStyle2 : hairStyles.m_MaleStyles) {
                hairStyle = instance.FindMaleStyle(hairStyle2.name);
                if (hairStyle == null) {
                    HairStyles.instance.m_MaleStyles.add(hairStyle2);
                    continue;
                }
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.println("mod \"%s\" overrides hair \"%s\"", string, hairStyle2.name);
                }
                n = HairStyles.instance.m_MaleStyles.indexOf(hairStyle);
                HairStyles.instance.m_MaleStyles.set(n, hairStyle2);
            }
        }
    }

    public static void Reset() {
        if (instance == null) {
            return;
        }
        HairStyles.instance.m_FemaleStyles.clear();
        HairStyles.instance.m_MaleStyles.clear();
        instance = null;
    }

    public static HairStyles Parse(String string) {
        try {
            return HairStyles.parse(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | JAXBException throwable) {
            ExceptionLogger.logException(throwable);
        }
        return null;
    }

    public static HairStyles parse(String string) throws JAXBException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{HairStyles.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            HairStyles hairStyles = (HairStyles)unmarshaller.unmarshal((InputStream)fileInputStream);
            return hairStyles;
        }
    }

    public HairStyle FindMaleStyle(String string) {
        return this.FindStyle(this.m_MaleStyles, string);
    }

    public HairStyle FindFemaleStyle(String string) {
        return this.FindStyle(this.m_FemaleStyles, string);
    }

    private HairStyle FindStyle(ArrayList<HairStyle> arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            HairStyle hairStyle = arrayList.get(i);
            if (hairStyle.name.equalsIgnoreCase(string)) {
                return hairStyle;
            }
            if (!"".equals(string) || !hairStyle.name.equalsIgnoreCase("bald")) continue;
            return hairStyle;
        }
        return null;
    }

    public String getRandomMaleStyle(String string) {
        return HairOutfitDefinitions.instance.getRandomHaircut(string, this.m_MaleStyles);
    }

    public String getRandomFemaleStyle(String string) {
        return HairOutfitDefinitions.instance.getRandomHaircut(string, this.m_FemaleStyles);
    }

    public HairStyle getAlternateForHat(HairStyle hairStyle, String string) {
        if ("nohair".equalsIgnoreCase(string) || "nohairnobeard".equalsIgnoreCase(string)) {
            return null;
        }
        if (this.m_FemaleStyles.contains(hairStyle)) {
            return this.FindFemaleStyle(hairStyle.getAlternate(string));
        }
        if (this.m_MaleStyles.contains(hairStyle)) {
            return this.FindMaleStyle(hairStyle.getAlternate(string));
        }
        return hairStyle;
    }

    public ArrayList<HairStyle> getAllMaleStyles() {
        return this.m_MaleStyles;
    }

    public ArrayList<HairStyle> getAllFemaleStyles() {
        return this.m_FemaleStyles;
    }
}

