/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlTransient;
import zombie.core.ImmutableColor;
import zombie.core.skinnedmodel.population.ClothingDecals;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public class ClothingItemReference
implements Cloneable {
    public float probability = 1.0f;
    public String itemGUID;
    public ArrayList<ClothingItemReference> subItems = new ArrayList();
    public boolean bRandomized = false;
    @XmlTransient
    public boolean m_Immutable = false;
    @XmlTransient
    public final RandomData RandomData = new RandomData();

    public void setModID(String string) {
        this.itemGUID = string + "-" + this.itemGUID;
        for (ClothingItemReference clothingItemReference : this.subItems) {
            clothingItemReference.setModID(string);
        }
    }

    public ClothingItem getClothingItem() {
        String string = this.itemGUID;
        if (!this.bRandomized) {
            throw new RuntimeException("not randomized yet");
        }
        if (this.RandomData.m_PickedItemRef != null) {
            string = this.RandomData.m_PickedItemRef.itemGUID;
        }
        return OutfitManager.instance.getClothingItem(string);
    }

    public void randomize() {
        if (this.m_Immutable) {
            throw new RuntimeException("trying to randomize an immutable ClothingItemReference");
        }
        this.RandomData.reset();
        for (int i = 0; i < this.subItems.size(); ++i) {
            ClothingItemReference clothingItemReference = this.subItems.get(i);
            clothingItemReference.randomize();
        }
        this.RandomData.m_PickedItemRef = this.pickRandomItemInternal();
        this.bRandomized = true;
        ClothingItem clothingItem = this.getClothingItem();
        if (clothingItem == null) {
            this.RandomData.m_Active = false;
            return;
        }
        boolean bl = this.RandomData.m_Active = OutfitRNG.Next(0.0f, 1.0f) <= this.probability;
        if (clothingItem.m_AllowRandomHue) {
            this.RandomData.m_Hue = (float)OutfitRNG.Next(200) / 100.0f - 1.0f;
        }
        this.RandomData.m_Tint = clothingItem.m_AllowRandomTint ? OutfitRNG.randomImmutableColor() : ImmutableColor.white;
        this.RandomData.m_BaseTexture = OutfitRNG.pickRandom(clothingItem.m_BaseTextures);
        this.RandomData.m_TextureChoice = OutfitRNG.pickRandom(clothingItem.textureChoices);
        if (!StringUtils.isNullOrWhitespace(clothingItem.m_DecalGroup)) {
            this.RandomData.m_Decal = ClothingDecals.instance.getRandomDecal(clothingItem.m_DecalGroup);
        }
    }

    private ClothingItemReference pickRandomItemInternal() {
        if (this.subItems.isEmpty()) {
            return this;
        }
        int n = OutfitRNG.Next(this.subItems.size() + 1);
        if (n == 0) {
            return this;
        }
        ClothingItemReference clothingItemReference = this.subItems.get(n - 1);
        return clothingItemReference.RandomData.m_PickedItemRef;
    }

    public ClothingItemReference clone() {
        try {
            ClothingItemReference clothingItemReference = new ClothingItemReference();
            clothingItemReference.probability = this.probability;
            clothingItemReference.itemGUID = this.itemGUID;
            PZArrayUtil.copy(clothingItemReference.subItems, this.subItems, ClothingItemReference::clone);
            return clothingItemReference;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("ClothingItemReference clone failed.", cloneNotSupportedException);
        }
    }

    public static class RandomData {
        public boolean m_Active = true;
        public float m_Hue = 0.0f;
        public ImmutableColor m_Tint = ImmutableColor.white;
        public String m_BaseTexture;
        public ClothingItemReference m_PickedItemRef;
        public String m_TextureChoice;
        public String m_Decal;

        public void reset() {
            this.m_Active = true;
            this.m_Hue = 0.0f;
            this.m_Tint = ImmutableColor.white;
            this.m_BaseTexture = null;
            this.m_PickedItemRef = null;
            this.m_TextureChoice = null;
            this.m_Decal = null;
        }
    }
}

